/*
 * target.c - manages target of selection
 */

#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tablet.h"
#include "resource.h"

/*
 * windows to use
 */

static  HWND    hwndFrame  = NULLHANDLE ;
static  HWND    hwndClient = NULLHANDLE ;
static  HWND    hwndEntry  = NULLHANDLE ;

/*
 * target to send
 */
 
static  USHORT  targetType = IDM_INTERN ;
static  UCHAR   targetName[256] = { 0 } ;
static  UCHAR   targetBuff[256] = { 0 } ;

static  HWND    targetFrame  = NULLHANDLE ;
static  HWND    targetClient = NULLHANDLE ;

/*
 * targetInit - start target management
 */

BOOL    targetInit(HWND hwnd)
{
    hwndClient = hwnd ;
    hwndFrame = WinQueryWindow(hwnd, QW_PARENT) ;
    
    /*
     * create entry field to hold target
     */

    hwndEntry = WinCreateWindow(
                hwndClient,
		WC_ENTRYFIELD,
		"",
		(ES_MARGIN | ES_CENTER | ES_AUTOSCROLL),
		0, 0, 0, 0,
		hwndClient,
		HWND_TOP,
		IDW_ENTRY,
		NULL,
		NULL) ;

    if (hwndEntry == NULLHANDLE) {
        return FALSE ;
    }
    WinSendMsg(hwndEntry, EM_SETTEXTLIMIT, MPFROMSHORT(128), NULL) ;

    return TRUE ;
}

/*
 * targetDone - finish target management
 */

void    targetDone(HWND hwnd)
{
    if (hwndEntry != NULLHANDLE) {
        WinDestroyWindow(hwndEntry) ;
	hwndEntry = NULLHANDLE ;
    }
}

/*
 * targetPlace - move target holder to new location
 */

void    targetPlace(SHORT cx, SHORT cy, SHORT height)
{
    WinSetWindowPos(hwndEntry, HWND_TOP,
        0, (cy - height), cx, height,
	(SWP_MOVE | SWP_SIZE | SWP_ZORDER | SWP_ACTIVATE | SWP_SHOW)) ;
}

/*
 * targetChange - set target of the operation
 */

void    targetChange(SHORT target, HWND frame, HWND client)
{
    UCHAR   buff[256] ;
    
    /*
     * save current information
     */
     
    if (targetType == IDM_INTERN && target != IDM_INTERN) {
        WinQueryWindowText(hwndEntry, 256, targetBuff) ;
    }

    /*
     * chnage to new target
     */
     
    if (target == IDM_WINDOW) {
        if (frame == NULLHANDLE || client == NULLHANDLE) {
	    return ;
	}
        if (WinQueryWindowText(frame, 512, buff) <= 0) {
	    sprintf(buff, "ID %08x", client) ;
	}
	sprintf(targetName, "EBhE [%s] ", buff) ;
	WinSetWindowText(hwndEntry, targetName) ;
	WinSendMsg(hwndEntry, EM_SETREADONLY, MPFROMSHORT(TRUE), NULL) ;
        targetType = IDM_WINDOW ;
	targetFrame  = frame  ;
	targetClient = client ;
    } else if (target == IDM_CLIPBD) {
        WinSetWindowText(hwndEntry, "ڃNbv{[h") ;
	WinSendMsg(hwndEntry, EM_SETREADONLY, MPFROMSHORT(TRUE), NULL) ;
	targetType = IDM_CLIPBD ;
    } else {
        WinSetWindowText(hwndEntry, targetBuff) ;
	WinSendMsg(hwndEntry, EM_SETREADONLY, MPFROMSHORT(FALSE), NULL) ;
	targetType = IDM_INTERN ;
    }
} 

/*
 * track mouse to select target window
 */

static  BOOL        trackFlag = FALSE ;
static  HPOINTER    trackPtr = NULLHANDLE ;
static  POINTL      trackPos = { 0 } ;

void    targetTrackStart(HWND hwnd)
{
    if (trackFlag) {
        return ;
    }
    if (trackPtr == NULLHANDLE) {
        trackPtr = WinLoadPointer(HWND_DESKTOP, NULLHANDLE, ID_POINTER) ;
    }
    trackFlag = TRUE ;
    WinQueryPointerPos(HWND_DESKTOP, &trackPos) ;
    WinSetCapture(HWND_DESKTOP, hwnd) ;
    WinSetPointer(HWND_DESKTOP, trackPtr) ;
}

BOOL    targetTrackTrace(HWND hwnd, SHORT x, SHORT y)
{
    if (trackFlag == FALSE) {
        return FALSE ;
    }
    trackPos.x = (LONG) x ;
    trackPos.y = (LONG) y ;
    WinMapWindowPoints(hwnd, HWND_DESKTOP, &trackPos, 1) ;
    WinSetPointer(HWND_DESKTOP, trackPtr) ;
    return TRUE ;
}

BOOL    targetTrackDone(HWND hwnd)
{
    HWND    frame, client ;
    
    if (trackFlag == FALSE) {
        return FALSE ;
    }
    WinSetCapture(HWND_DESKTOP, NULLHANDLE) ;
    
    frame  = WinWindowFromPoint(HWND_DESKTOP, &trackPos, FALSE) ;
    client = WinWindowFromPoint(HWND_DESKTOP, &trackPos, TRUE)  ;
    
    if (frame != WinQueryWindow(hwnd, QW_PARENT)) {
        targetChange(IDM_WINDOW, frame, client) ;
    }
    trackFlag = FALSE ;
    return TRUE ;
}

/*
 * send char to target
 */

static  void    sendToWindow(PUCHAR pch)
{
    USHORT  code ;
    
    if (targetClient == NULLHANDLE) {
        return ;
    }
    
    code = pch[1] << 8 | pch[0] ;
    
    WinPostMsg(targetClient, WM_CHAR,
            MPFROMSH2CH(KC_CHAR, 1, 0), MPFROM2SHORT(code, 0)) ;
    WinPostMsg(targetClient, WM_CHAR,
            MPFROMSH2CH((KC_KEYUP | KC_LONEKEY), 1, 0), MPFROMSHORT(0)) ;
}

static  void    sendToClipbd(PUCHAR pch)
{
    PUCHAR  shm ;
    HAB     hab = WinQueryAnchorBlock(targetFrame) ;
    
    if (DosAllocSharedMem((PPVOID) &shm, NULL, 16,
            OBJ_GIVEABLE | OBJ_TILE | PAG_COMMIT | PAG_READ | PAG_WRITE) != 0) {
        return ;
    }
    shm[0] = pch[0] ;
    shm[1] = pch[1] ;
    shm[2] = '\0'   ;
    
    WinOpenClipbrd(hab)  ;
    WinEmptyClipbrd(hab) ;
    WinSetClipbrdData(hab, (ULONG) shm, CF_TEXT, CFI_POINTER) ;
    WinCloseClipbrd(hab) ;
}

static  void    sendToField(PUCHAR pch)
{
#if 1
    USHORT  code ;
    
    if (hwndEntry == NULLHANDLE) {
        return ;
    }

    code = pch[1] << 8 | pch[0] ;
    
    WinPostMsg(hwndEntry, WM_CHAR,
            MPFROMSH2CH(KC_CHAR, 1, 0), MPFROM2SHORT(code, 0)) ;
    WinPostMsg(hwndEntry, WM_CHAR,
            MPFROMSH2CH((KC_KEYUP | KC_LONEKEY), 1, 0), MPFROMSHORT(0)) ;
#endif
#if 0
    LONG    len ;
    
    if ((len = WinQueryWindowText(hwndEntry, 256, targetBuff)) > 250) {
        return ;
    }
    targetBuff[len + 0] = pch[0] ;
    targetBuff[len + 1] = pch[1] ;
    targetBuff[len + 2] = '\0'   ;
    WinSetWindowText(hwndEntry, targetBuff) ;
#endif
}

void    targetSendChar(PUCHAR pch)
{
    switch (targetType) {
        case IDM_WINDOW : sendToWindow(pch) ; break ;
        case IDM_CLIPBD : sendToClipbd(pch) ; break ;
        default         : sendToField(pch)  ; break ;
    }
}

/*
 * editing target data on entry field
 */

void    targetEdit(SHORT op)
{
    if (targetType != IDM_INTERN) {
        return ;
    }
    
    switch (op) {
    case IDM_CLEAR :
        WinSendMsg(hwndEntry, EM_CLEAR, NULL, NULL) ;
	break ;
    case IDM_COPY  :
        WinSendMsg(hwndEntry, EM_COPY, NULL, NULL) ;
	break ;
    case IDM_CUT   :
        WinSendMsg(hwndEntry, EM_CUT, NULL, NULL) ;
	break ;
    }
}

/*
 * query on target
 */

SHORT   targetQueryType(void)
{
    return targetType ;
}

SHORT   targetQuerySelection(void)
{
    MPARAM  mp = WinSendMsg(hwndEntry, EM_QUERYSEL, NULL, NULL) ;
    SHORT   top = SHORT1FROMMP(mp) ;
    SHORT   bot = SHORT2FROMMP(mp) ;
    
    return (bot - top) ;
}
