/*
 * main.c - entry of 'tablet' program
 */

#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tablet.h"

/*
 * Program Path, Name and Profile
 */

UCHAR   ProgramPath[CCHMAXPATH] ;
UCHAR   ProgramName[CCHMAXPATH] ;
UCHAR   ProfilePath[CCHMAXPATH] ;

/*
 * myname - parses Program Path, Name and Profile
 */

static  void    myname(PSZ me)
{
    PUCHAR  p, last ;
    APIRET  stat ;
    BOOL    lkup = TRUE ;

    /*
     * full path name of program
     */

    for (p = me, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last != NULL) {
        strcpy(ProgramPath, me) ;
    } else if (DosSearchPath(7, "PATH", me, ProgramPath, CCHMAXPATH) != 0) {
        strcpy(ProgramPath, me) ;
    }
    
    /*
     * base name of program (as profile key)
     */

    for (p = ProgramPath, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last == NULL) {
        strcpy(ProgramName, ProgramPath) ;
    } else {
        strcpy(ProgramName, &last[1]) ;
    }
    if ((p = strrchr(ProgramName, '.')) != NULL) {
        *p = '\0' ;
    }

    /*
     * name of Profile
     */

    strcpy(ProfilePath, ProgramPath) ;

    if ((p = strrchr(ProfilePath, '.')) == NULL) {
        strcat(ProfilePath, ".ini") ;
    } else {
        strcpy(p, ".ini") ;
    }

#ifdef  DEBUG
    printf("ProgramPath <%s>\n", ProgramPath) ;
    printf("ProgramName <%s>\n", ProgramName) ;
    printf("ProfilePath <%s>\n", ProfilePath) ;
#endif
}

/*
 * notify error
 */

void    errMessage(PSZ msg)
{
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msg, ProgramName, 0, MB_OK) ;
}

/*
 * m a i n  - program start here
 */

int     main(int ac, char *av[])
{
    int     i    ;
    HAB     hab  ;
    HMQ     hmq  ;
    QMSG    qmsg ;
    PUCHAR  tn   ;
    TABLPTR tp   ;
    SWP     swp  ;
    UCHAR   fnt[128] ;
    ULONG   clr[2]   ;

    _wildcard(&ac, &av) ;
    myname(av[0]) ;

    hab = WinInitialize(0) ;
    hmq = WinCreateMsgQueue(hab, 0) ;
    
    memset(&swp, 0, sizeof(swp)) ;
    memset(fnt,  0, sizeof(fnt)) ;
    clr[0] = 0x00000000 ;
    clr[1] = 0x00ffffff ;

    profileRead(hab, &swp, fnt, clr) ;
    
    /*
     * parse command line arguments
     */
    
    tn = NULL ;

    for (i = 1 ; i < ac ; i++) {
        if (stricmp(av[i], "-c") == 0) {
	    swp.fl = 0 ;
        } else if (stricmp(av[i], "-w") == 0) {
	    if ((i + 1) < ac) {
	        swp.cx = atoi(av[i+=1]) ;
		swp.fl |= SWP_SIZE ;
	    }
	} else if (stricmp(av[i], "-h") == 0) {
	    if ((i + 1) < ac) {
	        swp.cy = atoi(av[i+=1]) ;
		swp.fl |= SWP_SIZE ;
	    }
	} else if (stricmp(av[i], "-x") == 0) {
	    if ((i + 1) < ac) {
	        swp.x = atoi(av[i+=1]) ;
		swp.fl |= SWP_MOVE ;
	    }
	} else if (stricmp(av[i], "-y") == 0) {
	    if ((i + 1) < ac) {
	        swp.y = atoi(av[i+=1]) ;
		swp.fl |= SWP_MOVE ;
	    }
	} else if (stricmp(av[i], "-i") == 0) {
	    if ((i + 1) < ac) {
	        tn = av[i] ;
	    }
        } else if (stricmp(av[i], "-f") == 0) {
	    if ((i + 1) < ac) {
	        strcpy(fnt, av[i]) ;
	    }
	} else {
	    tableLoad(av[i]) ;
	}
    }

    if (tn != NULL) {
        tp = tableName(tn) ;
    } else {
        tp = tableOpen()   ;
    }
    if (tp == NULL) {
        errMessage("e[uw肳Ă܂") ;
        WinDestroyMsgQueue(hmq) ;
	WinTerminate(hab) ;
	return 1 ;
    }
    
    /*
     * create window
     */

    if (winCreate(hab, tp, &swp, fnt, clr) != TRUE) {     
        errMessage("EBhE̐Ɏs܂") ;
        winDestroy() ;
        tableDone()  ;
        WinDestroyMsgQueue(hmq) ;
	WinTerminate(hab) ;
	return 2 ;
    }
    
    /*
     * start window processing
     */

    while (WinGetMsg(hab, &qmsg, 0L, 0, 0)) {
        WinDispatchMsg(hab, &qmsg) ;
    }

    /*
     * dispose resources
     */

    winDestroy() ;
    tableDone() ;
    
    WinDestroyMsgQueue(hmq) ;
    WinTerminate(hab) ;

    return 0 ;
}
