/*
 * Decompiled with CFR 0.152.
 */
package util.ui.textcomponentpopup;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;

public class TextComponentPopupEventQueue
extends EventQueue {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TextComponentPopupEventQueue.class);

    @Override
    protected void dispatchEvent(AWTEvent event) {
        MouseEvent me;
        try {
            if (event instanceof MouseEvent && (me = (MouseEvent)event).getButton() != 0 && me.getID() == 500 && MainFrame.getInstance().getProgramTableScrollPane().getProgramTable().stopAutoScroll()) {
                return;
            }
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            super.dispatchEvent(event);
        }
        catch (Throwable e) {
            return;
        }
        if (!(event instanceof MouseEvent)) {
            return;
        }
        me = (MouseEvent)event;
        if (!me.isPopupTrigger() || me.getComponent() == null) {
            return;
        }
        Component comp = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
        if (!(comp instanceof JTextComponent)) {
            return;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        JTextComponent tc = (JTextComponent)comp;
        JPopupMenu menu = new JPopupMenu();
        TextComponentPopupEventQueue.addStandardContextMenu(tc, menu);
        Point pt = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), tc);
        menu.show(tc, pt.x, pt.y);
    }

    public static void addStandardContextMenu(JTextComponent tc, JPopupMenu menu) {
        if (menu.getSubElements().length > 0) {
            menu.addSeparator();
        }
        menu.add(new CutAction(tc));
        menu.add(new CopyAction(tc));
        menu.add(new PasteAction(tc));
        menu.add(new DeleteAction(tc));
        menu.addSeparator();
        menu.add(new SelectAllAction(tc));
    }

    private static class SelectAllAction
    extends AbstractAction {
        JTextComponent comp;

        public SelectAllAction(JTextComponent comp) {
            super(mLocalizer.msg("selectAll", "Select All"));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.selectAll();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEnabled() && this.comp.getText().length() > 0;
        }
    }

    private static class CopyAction
    extends AbstractAction {
        JTextComponent comp;

        public CopyAction(JTextComponent comp) {
            super(mLocalizer.msg("copy", "Copy"), TVBrowserIcons.copy(16));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.copy();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEnabled() && this.comp.getSelectedText() != null && !(this.comp instanceof JPasswordField);
        }
    }

    private static class DeleteAction
    extends AbstractAction {
        JTextComponent comp;

        public DeleteAction(JTextComponent comp) {
            super(Localizer.getLocalization("i18n_delete"), TVBrowserIcons.delete(16));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.replaceSelection(null);
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEditable() && this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }

    private static class PasteAction
    extends AbstractAction {
        JTextComponent comp;

        public PasteAction(JTextComponent comp) {
            super(mLocalizer.msg("paste", "Paste"), IconLoader.getInstance().getIconFromTheme("actions", "edit-paste"));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.paste();
        }

        @Override
        public boolean isEnabled() {
            if (this.comp.isEditable() && this.comp.isEnabled()) {
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                return contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            }
            return false;
        }
    }

    private static class CutAction
    extends AbstractAction {
        JTextComponent comp;

        public CutAction(JTextComponent comp) {
            super(mLocalizer.msg("cut", "Cut"));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.cut();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEditable() && this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }
}

