/*
 * Decompiled with CFR 0.152.
 */
package util.ui.customizableitems;

import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.ui.settings.channel.ChannelJList;
import util.ui.DragAndDropMouseListener;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.TabLayout;
import util.ui.UiUtilities;
import util.ui.customizableitems.CustomizableItemsPanel;

public class SortableItemList
extends JPanel
implements ActionListener,
ListDropAction {
    protected JButton mUpBt = new JButton(TVBrowserIcons.up(22));
    protected JButton mDownBt;
    protected JButton mTopBtn;
    protected JButton mBottomBtn;
    protected JList mList;
    protected JLabel mTitleLb;
    protected DefaultListModel mListModel;
    protected JPanel mBtnPanel;
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(CustomizableItemsPanel.class);

    public SortableItemList() {
        this("");
    }

    public SortableItemList(String title) {
        this(title, new Object[0]);
    }

    public SortableItemList(String title, Object[] objects) {
        this(title, objects, new JList());
    }

    public SortableItemList(ChannelJList list) {
        this("", new Object[0], list);
    }

    public SortableItemList(String title, Object[] objects, JList list) {
        String msg = mLocalizer.msg("tooltip.up", "Move selected rows up");
        this.mUpBt.setToolTipText(msg);
        this.mUpBt.addActionListener(this);
        this.mDownBt = new JButton(TVBrowserIcons.down(22));
        msg = mLocalizer.msg("tooltip.down", "Move selected rows down");
        this.mDownBt.setToolTipText(msg);
        this.mDownBt.addActionListener(this);
        this.mTopBtn = new JButton(TVBrowserIcons.top(22));
        msg = mLocalizer.msg("tooltip.top", "Move selected rows to top");
        this.mTopBtn.setToolTipText(msg);
        this.mTopBtn.addActionListener(this);
        this.mBottomBtn = new JButton(TVBrowserIcons.bottom(22));
        msg = mLocalizer.msg("tooltip.bottom", "Move selected rows to bottom");
        this.mBottomBtn.setToolTipText(msg);
        this.mBottomBtn.addActionListener(this);
        this.mList = list;
        this.mListModel = new DefaultListModel();
        this.mList.setModel(this.mListModel);
        for (Object object : objects) {
            this.mListModel.addElement(object);
        }
        this.mList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SortableItemList.this.updateBtns();
            }
        });
        ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mList, this.mList, this);
        new DragAndDropMouseListener(this.mList, this.mList, this, dnDHandler);
        this.mTitleLb = new JLabel(title);
        this.mBtnPanel = new JPanel();
        this.mBtnPanel.setBorder(BorderFactory.createEmptyBorder(0, Sizes.dialogUnitXAsPixel(3, this.mBtnPanel), 0, 0));
        this.mBtnPanel.setLayout(new TabLayout(1));
        this.mBtnPanel.add(this.mTopBtn);
        this.mBtnPanel.add(this.mUpBt);
        this.mBtnPanel.add(this.mDownBt);
        this.mBtnPanel.add(this.mBottomBtn);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mTitleLb, "North");
        this.add((Component)new JScrollPane(this.mList), "Center");
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)this.mBtnPanel, "North");
        this.add((Component)p1, "East");
        this.updateBtns();
    }

    public void addButton(Component comp) {
        this.mBtnPanel.add(comp);
    }

    private void updateBtns() {
        this.mUpBt.setEnabled(this.mList.getSelectedIndex() > 0);
        this.mDownBt.setEnabled(this.mList.getSelectedIndex() < this.mListModel.size() - 1);
        this.mTopBtn.setEnabled(this.mUpBt.isEnabled());
        this.mBottomBtn.setEnabled(this.mDownBt.isEnabled());
    }

    public void setTitle(String title) {
        this.mTitleLb.setText(title);
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.mList.setCellRenderer(renderer);
    }

    public JList getList() {
        return this.mList;
    }

    public void addElement(Object o) {
        this.mListModel.addElement(o);
    }

    public void addElement(int inx, Object o) {
        this.mListModel.add(inx, o);
    }

    public void removeElementAt(int inx) {
        this.mListModel.removeElementAt(inx);
    }

    public void removeElement(Object o) {
        this.mListModel.removeElement(o);
    }

    public void removeAllElements() {
        this.mListModel.removeAllElements();
    }

    public boolean contains(Object o) {
        return this.mListModel.contains(o);
    }

    public Object[] getItems() {
        return this.mListModel.toArray();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o == this.mUpBt) {
            UiUtilities.moveSelectedItems(this.mList, -1);
            if (this.mUpBt.isEnabled()) {
                this.mUpBt.requestFocusInWindow();
            }
        } else if (o == this.mDownBt) {
            UiUtilities.moveSelectedItems(this.mList, 1);
            if (this.mDownBt.isEnabled()) {
                this.mDownBt.requestFocusInWindow();
            }
        } else if (o == this.mTopBtn) {
            UiUtilities.moveSelectedItems(this.mList, -10000);
            if (this.mTopBtn.isEnabled()) {
                this.mTopBtn.requestFocusInWindow();
            }
        } else if (o == this.mBottomBtn) {
            UiUtilities.moveSelectedItems(this.mList, 10000);
            if (this.mBottomBtn.isEnabled()) {
                this.mBottomBtn.requestFocusInWindow();
            }
        }
    }

    public JButton getUpButton() {
        return this.mUpBt;
    }

    public JButton getDownButton() {
        return this.mDownBt;
    }

    public JButton getTopButton() {
        return this.mTopBtn;
    }

    public JButton getBottomButton() {
        return this.mBottomBtn;
    }

    @Override
    public void drop(JList source, JList target, int rows, boolean move) {
        UiUtilities.moveSelectedItems(target, rows, true);
    }
}

