/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import util.ui.ProgramList;

public class ProgramRangeSelectionPanel
extends JPanel {
    private ProgramList mProgramList;

    public static ProgramRangeSelectionPanel createPanel(Program program, short additonalProgramCount) {
        return new ProgramRangeSelectionPanel(program, additonalProgramCount);
    }

    private ProgramRangeSelectionPanel(Program p, short additionalProgramCount) {
        Program prog;
        this.setLayout(new FormLayout("default:grow", "fill:default:grow"));
        DefaultListSelectionModel m = new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.clearSelection();
                super.setSelectionInterval(0, index1);
            }

            @Override
            public void removeSelectionInterval(int index0, int index1) {
                super.removeSelectionInterval(Math.max(1, index0), Math.max(1, this.getMaxSelectionIndex()));
            }

            @Override
            public void addSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(0, index1);
            }
        };
        DefaultListModel<Program> model = new DefaultListModel<Program>();
        this.mProgramList = new ProgramList((ListModel)model);
        this.mProgramList.setSelectionMode(1);
        this.mProgramList.setSelectionModel(m);
        devplugin.Date programDate = p.getDate();
        Channel programChannel = p.getChannel();
        Iterator<Program> channelDayProgram = Plugin.getPluginManager().getChannelDayProgram(programDate, programChannel);
        while (channelDayProgram.hasNext() && model.size() <= additionalProgramCount) {
            prog = channelDayProgram.next();
            if (!prog.equals(p) && (model.isEmpty() || model.size() > additionalProgramCount)) continue;
            model.addElement(prog);
        }
        if (model.size() <= additionalProgramCount) {
            programDate = programDate.addDays(1);
            channelDayProgram = Plugin.getPluginManager().getChannelDayProgram(programDate, programChannel);
            if (channelDayProgram != null) {
                while (channelDayProgram.hasNext() && model.size() <= additionalProgramCount) {
                    prog = channelDayProgram.next();
                    if (model.size() > additionalProgramCount || prog.getLength() <= 0) continue;
                    model.addElement(prog);
                }
            }
        }
        this.mProgramList.setSelectedIndex(0);
        JScrollPane scrollPane = new JScrollPane(this.mProgramList);
        scrollPane.setPreferredSize(new Dimension(300, 350));
        this.add((Component)scrollPane, new CellConstraints().xy(1, 1));
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.mProgramList.addListSelectionListener(listener);
    }

    public void setEndDate(Date endDate) {
        int lastSelectedIndex = 0;
        int i = 1;
        while (i < this.mProgramList.getModel().getSize()) {
            Program prog = (Program)this.mProgramList.getModel().getElementAt(i);
            Calendar progDate = prog.getDate().getCalendar();
            progDate.set(11, prog.getHours());
            progDate.set(12, prog.getMinutes());
            if (prog.getLength() <= 0) {
                progDate.add(12, 1);
            } else {
                progDate.add(12, prog.getLength());
            }
            progDate.set(13, 0);
            if (progDate.getTime().compareTo(endDate) > 0) break;
            lastSelectedIndex = i++;
        }
        this.mProgramList.setSelectedIndex(lastSelectedIndex);
    }
}

