/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.ui.settings.MarkingsSettingsTab;
import tvbrowser.ui.settings.SettingsDialog;
import util.ui.EnhancedPanelBuilder;
import util.ui.Localizer;
import util.ui.MarkPriorityComboBoxRenderer;
import util.ui.UiUtilities;

public final class DefaultMarkingPrioritySelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(DefaultMarkingPrioritySelectionPanel.class);
    private JComboBox[] mPrioritySelection;
    private JEditorPane mHelpLabel;
    private JComponent mSeparator;
    private JComponent[] mLabel;

    private DefaultMarkingPrioritySelectionPanel(int priority, boolean showTitle, boolean withDefaultDialogBorder) {
        this(priority, LOCALIZER.msg("color", "Highlighting color"), showTitle, true, withDefaultDialogBorder);
    }

    private DefaultMarkingPrioritySelectionPanel(int priority, String label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        this(new int[]{priority}, new String[]{label}, showTitle, showHelpLabel, withDefaultDialogBorder);
    }

    private DefaultMarkingPrioritySelectionPanel(int[] priority, String[] label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("5dlu,pref,5dlu,pref,0dlu:grow");
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(layout, (JPanel)this);
        int choosersToDraw = Math.min(priority.length, label.length);
        if (withDefaultDialogBorder) {
            pb.border(Borders.DIALOG);
        }
        this.mLabel = new JComponent[choosersToDraw];
        this.mPrioritySelection = new JComboBox[choosersToDraw];
        if (showTitle) {
            pb.addRow();
            this.mSeparator = pb.addSeparator(DefaultMarkingPrioritySelectionPanel.getTitle(), cc.xyw(1, pb.getRowCount(), 5));
        }
        for (int i = 0; i < choosersToDraw; ++i) {
            pb.addRow();
            this.mLabel[i] = pb.addLabel(label[i], cc.xy(2, pb.getRowCount()));
            this.mPrioritySelection[i] = new JComboBox<String>(DefaultMarkingPrioritySelectionPanel.getMarkingColorNames(true));
            this.mPrioritySelection[i].setSelectedIndex(priority[i] + 1);
            this.mPrioritySelection[i].setRenderer(new MarkPriorityComboBoxRenderer(this.mPrioritySelection[i].getRenderer()));
            pb.add((Component)this.mPrioritySelection[i], cc.xy(4, pb.getRowCount()));
        }
        if (showHelpLabel) {
            this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The selected higlighting color is only shown if the program is higlighted by this plugin only or if the other higlightings have a lower or the same priority. The higlighting colors of the priorities can be changed in the <a href=\"#link\">higlighting settings</a>."), new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        SettingsDialog.getInstance().showSettingsTab("#programpanelmarking");
                    }
                }
            });
            pb.addGrowingRow();
            pb.addRow();
            pb.add((Component)this.mHelpLabel, cc.xyw(2, pb.getRowCount(), 4));
        }
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(int priority, boolean showTitle, boolean withDefaultDialogBorder) {
        return new DefaultMarkingPrioritySelectionPanel(priority, showTitle, withDefaultDialogBorder);
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(int priority, String label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        return new DefaultMarkingPrioritySelectionPanel(priority, label, showTitle, showHelpLabel, withDefaultDialogBorder);
    }

    public static DefaultMarkingPrioritySelectionPanel createPanel(int[] priority, String[] label, boolean showTitle, boolean showHelpLabel, boolean withDefaultDialogBorder) {
        return new DefaultMarkingPrioritySelectionPanel(priority, label, showTitle, showHelpLabel, withDefaultDialogBorder);
    }

    public int getSelectedPriority() {
        return this.mPrioritySelection[0].getSelectedIndex() - 1;
    }

    public int getSelectedPriority(int index) {
        return this.mPrioritySelection[index].getSelectedIndex() - 1;
    }

    public int[] getSelectedPriorities() {
        int[] prios = new int[this.mPrioritySelection.length];
        for (int i = 0; i < this.mPrioritySelection.length; ++i) {
            prios[i] = this.getSelectedPriority(i);
        }
        return prios;
    }

    public static String getTitle() {
        return LOCALIZER.msg("title", "Highlighting");
    }

    public static String[] getMarkingColorNames(boolean withNoMarkPriority) {
        if (withNoMarkPriority) {
            return new String[]{MarkingsSettingsTab.mLocalizer.msg("color.noPriority", "Don't highlight"), MarkingsSettingsTab.mLocalizer.msg("color.minPriority", "1. Color (minimum priority)"), MarkingsSettingsTab.mLocalizer.msg("color.lowerMediumPriority", "2. Color (lower medium priority)"), MarkingsSettingsTab.mLocalizer.msg("color.mediumPriority", "3. Color (Medium priority)"), MarkingsSettingsTab.mLocalizer.msg("color.higherMediumPriority", "4. Color (higher medium priority)"), MarkingsSettingsTab.mLocalizer.msg("color.maxPriority", "5. Color (maximum priority)")};
        }
        return new String[]{MarkingsSettingsTab.mLocalizer.msg("color.minPriority", "1. Color (minimum priority)"), MarkingsSettingsTab.mLocalizer.msg("color.lowerMediumPriority", "2. Color (lower medium priority)"), MarkingsSettingsTab.mLocalizer.msg("color.mediumPriority", "3. Color (Medium priority)"), MarkingsSettingsTab.mLocalizer.msg("color.higherMediumPriority", "4. Color (higher medium priority)"), MarkingsSettingsTab.mLocalizer.msg("color.maxPriority", "5. Color (maximum priority)")};
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mSeparator != null) {
            this.mSeparator.setEnabled(enabled);
        }
        if (this.mHelpLabel != null) {
            this.mHelpLabel.setEnabled(enabled);
        }
        for (int i = 0; i < this.mLabel.length; ++i) {
            this.mLabel[i].setEnabled(enabled);
            this.mPrioritySelection[i].setEnabled(enabled);
        }
    }
}

