/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.Channel;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.Settings;
import util.misc.SoftReferenceCache;
import util.ui.TVBrowserIcons;
import util.ui.TimeFormatter;
import util.ui.UiUtilities;

public class ChannelLabel
extends JLabel {
    private static SoftReferenceCache<Channel, Icon> ICONCACHE = new SoftReferenceCache();
    static Icon DEFAULT_ICON = UiUtilities.createChannelIcon(TVBrowserIcons.defaultChannelLogo());
    private boolean mChannelIconsVisible;
    private boolean mTextIsVisible;
    private boolean mShowDefaultValues;
    private boolean mShowCountry;
    private boolean mShowService;
    private boolean mShowJointChannelInfo;
    private boolean mShowTimeLimitation;
    private boolean mShowSortNumber;
    private Channel mChannel;
    private static TimeFormatter mTimeFormatter;

    public ChannelLabel() {
        this(Settings.propShowChannelIconsInChannellist.getBoolean(), Settings.propShowChannelNamesInChannellist.getBoolean(), false, false, false, false, Settings.propShowSortNumberInProgramLists.getBoolean());
    }

    public ChannelLabel(boolean channelIconsVisible) {
        this(channelIconsVisible, true, false);
    }

    public ChannelLabel(boolean channelIconsVisible, boolean textIsVisible) {
        this(channelIconsVisible, textIsVisible, false);
    }

    public ChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues) {
        this(channelIconsVisible, textIsVisible, showDefaultValues, false);
    }

    public ChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry) {
        this(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, false);
    }

    public ChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry, boolean showJoinedChannelInfo) {
        this(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, false);
    }

    public ChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry, boolean showJoinedChannelInfo, boolean showTimeLimitation) {
        this(channelIconsVisible, textIsVisible, showDefaultValues, showCountry, showJoinedChannelInfo, showTimeLimitation, Settings.propShowSortNumberInProgramLists.getBoolean());
    }

    public ChannelLabel(boolean channelIconsVisible, boolean textIsVisible, boolean showDefaultValues, boolean showCountry, boolean showJoinedChannelInfo, boolean showTimeLimitation, boolean showSortNumber) {
        this.mChannelIconsVisible = channelIconsVisible;
        this.mTextIsVisible = textIsVisible;
        this.mShowDefaultValues = showDefaultValues;
        this.mShowCountry = showCountry;
        this.mShowJointChannelInfo = showJoinedChannelInfo;
        this.mShowTimeLimitation = showTimeLimitation;
        this.mShowSortNumber = showSortNumber;
    }

    public ChannelLabel(Channel channel) {
        this(channel, Settings.propShowChannelIconsInChannellist.getBoolean(), Settings.propShowChannelNamesInChannellist.getBoolean());
    }

    public ChannelLabel(Channel channel, boolean channelIconsVisible, boolean textIsVisible) {
        this(channelIconsVisible, textIsVisible);
        this.setChannel(channel);
    }

    public ChannelLabel(Channel channel, boolean channelIconsVisible) {
        this(channel, channelIconsVisible, Settings.propShowChannelNamesInChannellist.getBoolean());
    }

    public void setChannel(Channel channel) {
        this.mChannel = channel;
        if (this.mChannelIconsVisible) {
            this.setChannelIcon(channel, this.mShowJointChannelInfo && channel.getJointChannel() != null ? channel.getJointChannelIcon() : (this.mShowDefaultValues ? channel.getDefaultIcon() : channel.getIcon()));
        }
        if (this.mTextIsVisible) {
            StringBuilder text = new StringBuilder(this.mShowJointChannelInfo && channel.getJointChannel() != null ? channel.getJointChannelName() : (this.mShowDefaultValues ? channel.getDefaultName() : channel.getName()));
            if (this.mShowCountry || this.mShowService || this.mShowTimeLimitation) {
                text.append(" (");
            }
            if (this.mShowCountry) {
                text.append(channel.getBaseCountry());
            }
            if (this.mShowService && !(channel instanceof DummyChannel)) {
                if (this.mShowCountry) {
                    text.append(", ");
                }
                text.append(channel.getDataServiceProxy().getInfo().getName());
            }
            if (this.mShowTimeLimitation) {
                if (this.mShowService || this.mShowCountry) {
                    text.append(", ");
                }
                if (mTimeFormatter == null) {
                    mTimeFormatter = new TimeFormatter(Settings.getTimePattern());
                }
                text.append(mTimeFormatter.formatTime(channel.getStartTimeLimit() / 60, channel.getStartTimeLimit() % 60)).append("-").append(mTimeFormatter.formatTime(channel.getEndTimeLimit() / 60, channel.getEndTimeLimit() % 60));
            }
            if (this.mShowCountry || this.mShowService || this.mShowTimeLimitation) {
                text.append(")");
            }
            if (this.mShowSortNumber && channel.getSortNumber().trim().length() > 0) {
                text.insert(0, channel.getSortNumber().trim() + ". ");
            }
            this.setText(text.toString());
        } else if (this.mShowSortNumber && channel.getSortNumber().trim().length() > 0) {
            this.setText(channel.getSortNumber().trim() + ". ");
        }
        this.setMinimumSize(new Dimension(42, 22));
        this.setToolTipText(channel.getName());
    }

    @Override
    public void setMinimumSize(Dimension dim) {
        super.setMinimumSize(dim);
        Dimension current = this.getSize();
        if (current.width < dim.width) {
            current.width = dim.width;
        }
        if (current.height < dim.height) {
            current.height = dim.height;
        }
        this.setSize(current);
    }

    @Override
    public void setIcon(Icon ic) {
    }

    private void setChannelIcon(Channel channel, Icon icon) {
        Icon cached = null;
        if (icon != null && !this.mShowJointChannelInfo) {
            cached = ICONCACHE.get(channel);
        }
        if (cached != null) {
            super.setIcon(cached);
        } else {
            if (!this.mChannelIconsVisible) {
                return;
            }
            if (icon == null) {
                super.setIcon(this.getDefaultIcon());
            } else {
                ImageIcon resizedIcon = UiUtilities.createChannelIcon(icon);
                if (channel.getJointChannel() == null && !(channel instanceof DummyChannel)) {
                    ICONCACHE.put(channel, resizedIcon);
                }
                super.setIcon(resizedIcon);
            }
        }
    }

    private Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }

    public void setShowCountry(boolean showCountry) {
        this.mShowCountry = showCountry;
    }

    public void setShowService(boolean showService) {
        this.mShowService = showService;
    }

    public void setShowTimeLimitation(boolean showTimeLimitation) {
        this.mShowTimeLimitation = showTimeLimitation;
    }

    public static void clearIconCache() {
        ICONCACHE.clear();
    }

    public Channel getChannel() {
        return this.mChannel;
    }

    public void setEnabled(boolean enabled, boolean selected) {
        if (!selected) {
            this.setEnabled(enabled);
        } else {
            this.setEnabled(true);
        }
    }
}

