/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StreamReaderThread
extends Thread {
    private InputStream mInput;
    private boolean mSaveOutput;
    private StringBuffer mOutput;
    private String mEncoding;

    public StreamReaderThread(InputStream stream, boolean save) {
        this(stream, save, null);
    }

    public StreamReaderThread(InputStream stream, boolean save, String encoding) {
        super("Stream reader");
        this.mInput = stream;
        this.mSaveOutput = save;
        this.mOutput = new StringBuffer();
        this.mEncoding = encoding;
    }

    @Override
    public void run() {
        try {
            String line;
            BufferedReader reader = this.mEncoding != null ? new BufferedReader(new InputStreamReader(this.mInput, this.mEncoding)) : new BufferedReader(new InputStreamReader(this.mInput));
            while ((line = reader.readLine()) != null) {
                if (!this.mSaveOutput) continue;
                this.mOutput.append(line).append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public String getOutput() {
        return this.mOutput.toString();
    }

    protected String getOutputString() {
        return this.mOutput.toString();
    }
}

