/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IniFileReader {
    private HashMap<String, HashMap<String, String>> mSections;

    public IniFileReader(File iniFile) throws IOException {
        this.readIni(new BufferedInputStream(new FileInputStream(iniFile)));
    }

    public IniFileReader(InputStream stream) throws IOException {
        this.readIni(stream);
    }

    private void readIni(InputStream stream) throws IOException {
        String str;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        this.mSections = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern section = Pattern.compile("^\\[.*\\]\\w*");
        Pattern keyvalue = Pattern.compile("^.*=.*\\w*");
        while ((str = reader.readLine()) != null) {
            if (section.matcher(str).matches()) {
                str = str.trim();
                str = str.substring(1, str.length() - 1);
                map = new HashMap();
                this.mSections.put(str, map);
                continue;
            }
            if (!keyvalue.matcher(str).matches()) continue;
            String key = StringUtils.substringBefore(str, "=");
            String value = StringUtils.substringAfter(str, "=");
            map.put(key, value);
        }
    }

    public HashMap<String, String> getSection(String section) {
        return this.mSections.get(section);
    }

    public String[] getAllSections() {
        ArrayList<String> list = new ArrayList<String>(this.mSections.keySet());
        return list.toArray(new String[list.size()]);
    }
}

