/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import devplugin.Plugin;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.activation.UnsupportedDataTypeException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import util.ui.TimeFormatter;

public class IOUtilities {
    private static final Logger mLog = Logger.getLogger(IOUtilities.class.getName());
    private static final Calendar CALENDAR = Calendar.getInstance();
    private static final TimeFormatter TIME_FORMATTER = new TimeFormatter();

    public static void download(URL url, File targetFile) throws IOException {
        IOUtilities.download(url, targetFile, Settings.propDefaultNetworkConnectionTimeout.getInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(URL url, File targetFile, int timeout) throws IOException {
        mLog.info("Downloading '" + url + "' to '" + targetFile.getAbsolutePath() + "' timeout: " + timeout);
        boolean result = false;
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(IOUtilities.getStream(url, true, timeout), 16384);
            if (stream == null) {
                throw new IOException("Can't connect to '" + url + "'!");
            }
            result = IOUtilities.saveStream(stream, targetFile, timeout + 2000);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException exc) {}
        }
        return result;
    }

    public static boolean saveStream(InputStream stream, File targetFile) throws IOException {
        return IOUtilities.saveStream(stream, targetFile, Settings.propDefaultNetworkConnectionTimeout.getInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveStream(InputStream stream, File targetFile, int timeout) throws IOException {
        FilterOutputStream out = null;
        boolean result = false;
        try {
            out = new BufferedOutputStream(new FileOutputStream(targetFile), 16384);
            result = IOUtilities.pipeStreams(stream, out, timeout);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException exc) {}
        }
        return result;
    }

    public static InputStream getStream(URL page, boolean followRedirects) throws IOException {
        return IOUtilities.getStream(page, followRedirects, Settings.propDefaultNetworkConnectionTimeout.getInt());
    }

    public static InputStream getStream(URL page, boolean followRedirects, int timeout) throws IOException {
        return IOUtilities.getStream(page, followRedirects, timeout, null, null);
    }

    public static InputStream getStream(URL page, boolean followRedirects, final int timeout, String userName, String userPassword) throws IOException {
        URLConnection conn = page.openConnection();
        if (userName != null && userPassword != null) {
            String password = userName + ":" + userPassword;
            String encodedPassword = new String(Base64.encodeBase64(password.getBytes()));
            conn.setRequestProperty("Authorization", "Basic " + encodedPassword);
        }
        if (timeout > 0) {
            conn.setReadTimeout(timeout);
        }
        if (followRedirects && conn instanceof HttpURLConnection) {
            boolean redirect;
            final HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            final AtomicInteger response = new AtomicInteger(408);
            final AtomicReference<Object> possibleException = new AtomicReference<Object>(null);
            Thread resonseThread = new Thread("GET RESPONSE CODE THREAD"){

                @Override
                public void run() {
                    try {
                        int responseCode = hconn.getResponseCode();
                        response.set(responseCode);
                    }
                    catch (IOException e) {
                        possibleException.set(e);
                    }
                }
            };
            resonseThread.start();
            Thread wait = new Thread("GET RESPONSE CODE THREAD WAITING THREAD"){

                @Override
                public void run() {
                    int count = 0;
                    while (response.get() == 408 && count++ < timeout / 100 && possibleException.get() == null) {
                        try {
                            2.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            wait.start();
            try {
                wait.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (possibleException.get() != null) {
                throw (IOException)possibleException.get();
            }
            if (response.get() == 408) {
                throw new ConnectException("Connection timeout '" + timeout + "' reached.");
            }
            boolean bl = redirect = response.get() >= 300 && response.get() <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                if (loc == null) {
                    throw new FileNotFoundException("URL points to a redirect without target location: " + page);
                }
                page = loc.startsWith("http") ? new URL(loc) : new URL(page, loc);
                return IOUtilities.getStream(page, followRedirects, timeout, userName, userPassword);
            }
        }
        InputStream in = conn.getInputStream();
        return in;
    }

    public static InputStream getStream(URL page) throws IOException {
        return IOUtilities.getStream(page, true, Settings.propDefaultNetworkConnectionTimeout.getInt());
    }

    public static InputStream getStream(URL page, int timeout) throws IOException {
        return IOUtilities.getStream(page, true, timeout);
    }

    public static byte[] loadFileFromHttpServer(URL url) throws IOException {
        return IOUtilities.loadFileFromHttpServer(url, Settings.propDefaultNetworkConnectionTimeout.getInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileFromHttpServer(URL url, int timeout) throws IOException {
        InputStream in = null;
        try {
            in = IOUtilities.getStream(url, timeout);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtilities.pipeStreams(in, out);
            out.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static boolean pipeStreams(InputStream from, OutputStream to) throws IOException {
        return IOUtilities.pipeStreams(from, to, Settings.propDefaultNetworkConnectionTimeout.getInt());
    }

    public static boolean pipeStreams(final InputStream from, final OutputStream to, final int timeout) throws IOException {
        final AtomicBoolean wasSaved = new AtomicBoolean(false);
        final AtomicReference<Object> possibleException = new AtomicReference<Object>(null);
        final AtomicInteger count = new AtomicInteger(0);
        new Thread("PIPE STREAM THREAD"){

            @Override
            public void run() {
                byte[] buffer = new byte[10240];
                try {
                    int len;
                    while ((len = from.read(buffer)) != -1) {
                        to.write(buffer, 0, len);
                        count.set(0);
                    }
                    wasSaved.set(true);
                }
                catch (IOException e) {
                    possibleException.set(e);
                }
            }
        }.start();
        Thread wait = new Thread("PIPE STREAM WAITING THREAD"){

            @Override
            public void run() {
                while (!wasSaved.get() && count.getAndIncrement() < timeout / 100 && possibleException.get() == null) {
                    try {
                        4.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        wait.start();
        try {
            wait.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (possibleException.get() != null) {
            throw (IOException)possibleException.get();
        }
        return wasSaved.get();
    }

    public static void pipe(Reader reader, Writer writer) throws IOException {
        int len;
        char[] buffer = new char[10240];
        while ((len = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, len);
        }
    }

    private static void copyFile(File src, File targetDir, boolean onlyNew) throws IOException {
        File destFile = new File(targetDir, src.getName());
        IOUtilities.copy(src, destFile, onlyNew);
    }

    private static File createDirectory(File targetDir, String dirName) throws IOException {
        File f = new File(targetDir.getAbsolutePath() + "/" + dirName);
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Could not create directory '" + f.getAbsolutePath() + "'");
        }
        return f;
    }

    public static void copy(File[] src, File targetDir) throws IOException {
        IOUtilities.copy(src, targetDir, false);
    }

    public static void copy(File[] src, File targetDir, boolean onlyNew) throws IOException {
        IOUtilities.copy(targetDir, src, targetDir, onlyNew);
    }

    private static void copy(File firstTargetDir, File[] src, File targetDir, boolean onlyNew) throws IOException {
        if (src == null) {
            return;
        }
        for (int i = 0; i < src.length; ++i) {
            if (src[i].isDirectory() && !src[i].equals(targetDir) && !src[i].equals(firstTargetDir)) {
                File newDir = IOUtilities.createDirectory(targetDir, src[i].getName());
                IOUtilities.copy(firstTargetDir, src[i].listFiles(), newDir, onlyNew);
                continue;
            }
            IOUtilities.copyFile(src[i], targetDir, onlyNew);
        }
    }

    public static void copy(File src, File target) throws IOException {
        IOUtilities.copy(src, target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File target, boolean onlyNew) throws IOException {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            FileOutputStream outFile = new FileOutputStream(target);
            in = new BufferedInputStream(new FileInputStream(src), 16384);
            out = new BufferedOutputStream(outFile, 16384);
            if (!onlyNew || target.length() < 1L || src.lastModified() > target.lastModified()) {
                outFile.getChannel().truncate(0L);
                IOUtilities.pipeStreams(in, out);
            }
            in.close();
            out.close();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException exc) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static void deleteDirectory(File dir2) throws IOException {
        if (!dir2.exists()) {
            return;
        }
        if (!dir2.isDirectory()) {
            throw new IOException("File is not a directory: " + dir2.getAbsolutePath());
        }
        File[] fileArr = dir2.listFiles();
        if (fileArr != null) {
            for (int i = 0; i < fileArr.length; ++i) {
                if (fileArr[i].isDirectory()) {
                    IOUtilities.deleteDirectory(fileArr[i]);
                    continue;
                }
                if (fileArr[i].delete()) continue;
                throw new IOException("Can't delete file: " + fileArr[i].getAbsolutePath());
            }
        }
        if (!dir2.delete()) {
            throw new IOException("Can't delete directory: " + dir2.getAbsolutePath());
        }
    }

    public static byte[] loadFileFromJar(String fileName, Class srcClass) throws IOException {
        int len;
        InputStream in;
        if (fileName == null) {
            throw new IllegalArgumentException("fileName == null");
        }
        if (StringUtils.isEmpty(fileName)) {
            throw new IllegalArgumentException("fileName is empty");
        }
        if (srcClass == null) {
            in = new FileInputStream(fileName);
        } else {
            if (fileName.charAt(0) != '/' && fileName.charAt(0) != '\\') {
                fileName = "/" + fileName;
            }
            in = srcClass.getResourceAsStream(fileName);
        }
        if (in == null) {
            throw new IOException("Resource not found: '" + fileName + "'");
        }
        byte[] buffer = new byte[10240];
        byte[] data = new byte[]{};
        while ((len = in.read(buffer)) != -1) {
            byte[] oldData = data;
            data = new byte[oldData.length + len];
            System.arraycopy(oldData, 0, data, 0, oldData.length);
            System.arraycopy(buffer, 0, data, oldData.length, len);
        }
        in.close();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File srcFile, String entryName, File targetFile) throws IOException {
        mLog.info("Unzipping '" + entryName + "' from '" + srcFile.getAbsolutePath() + "' to '" + targetFile.getAbsolutePath() + "'");
        InputStream stream = null;
        try {
            ZipFile zipFile = new ZipFile(srcFile);
            ZipEntry entry = new ZipEntry(entryName);
            stream = zipFile.getInputStream(entry);
            if (stream == null) {
                throw new IOException("Can't unzip '" + entryName + "' from '" + srcFile.getAbsolutePath() + "'!");
            }
            IOUtilities.saveStream(stream, targetFile);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ungzip(File srcFile, File targetFile) throws IOException {
        mLog.info("Ungzipping '" + srcFile.getAbsolutePath() + "' to '" + targetFile.getAbsolutePath() + "'");
        BufferedInputStream stream = null;
        InputStream gzipStream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(srcFile), 16384);
            gzipStream = IOUtilities.openSaveGZipInputStream(stream);
            IOUtilities.saveStream(gzipStream, targetFile);
        }
        finally {
            try {
                if (gzipStream != null) {
                    gzipStream.close();
                }
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException exc) {}
        }
    }

    public static void append(StringBuffer buffer, int number, int minChars) {
        String asString = Integer.toString(number);
        for (int i = asString.length(); i < minChars; ++i) {
            buffer.append('0');
        }
        buffer.append(asString);
    }

    public static String replace(String original, String pattern, String str) {
        StringBuffer buffer = new StringBuffer(original);
        IOUtilities.replace(buffer, pattern, str);
        return buffer.toString();
    }

    public static void replace(StringBuffer buffer, String pattern, String str) {
        int patternIdx;
        int offset = 0;
        do {
            if ((patternIdx = buffer.indexOf(pattern, offset)) != -1) {
                buffer.replace(patternIdx, patternIdx + pattern.length(), str);
            }
            offset = patternIdx + str.length();
        } while (patternIdx != -1);
    }

    public static void clear(StringBuffer buffer) {
        buffer.delete(0, buffer.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinutesAfterMidnight() {
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.setTimeInMillis(System.currentTimeMillis());
            return CALENDAR.get(11) * 60 + CALENDAR.get(12);
        }
    }

    public static String timeToString(int minutesAfterMidnight) {
        int hours = (minutesAfterMidnight %= 1440) / 60;
        int minutes = minutesAfterMidnight % 60;
        return TIME_FORMATTER.formatTime(hours, minutes);
    }

    public static String xorEncode(String text, long seed) {
        Random rnd = new Random(seed);
        char[] charArr = new char[text.length()];
        for (int i = 0; i < charArr.length; ++i) {
            charArr[i] = (char)(text.charAt(i) ^ rnd.nextInt());
        }
        return new String(charArr);
    }

    public static String xorDecode(String text, long seed) {
        return IOUtilities.xorEncode(text, seed);
    }

    public static byte[] readBinaryData(InputStream stream, int length) throws IOException {
        int len;
        byte[] data = new byte[length];
        for (int offset = 0; offset < length; offset += len) {
            len = stream.read(data, offset, length - offset);
            if (len != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        return data;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            return null;
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static boolean writeImageIconToFile(ImageIcon icon, String imageType, File targetFile) {
        try {
            BufferedImage iconimage = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 2);
            Graphics2D g2 = iconimage.createGraphics();
            icon.paintIcon(null, g2, 0, 0);
            g2.dispose();
            ImageIO.write((RenderedImage)iconimage, imageType, targetFile);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static ImageIcon readImageIconFromFile(File srcFile) {
        try {
            return new ImageIcon(ImageIO.read(srcFile));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InputStream openSaveGZipInputStream(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        bis.mark(64);
        try {
            GZIPInputStream result = new GZIPInputStream(bis);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            bis.reset();
            return bis;
        }
    }

    public static int encodeMultipleEpisodeNumersToSingleFieldValue(int[] episodeNumbers) throws UnsupportedDataTypeException {
        if (episodeNumbers.length == 1) {
            return episodeNumbers[0];
        }
        if (episodeNumbers.length == 2) {
            int encoded = episodeNumbers[0] & 0x3FFF;
            int diff = (episodeNumbers[1] & Short.MAX_VALUE) << 14;
            encoded |= diff;
            return encoded |= 0x20000000;
        }
        if (episodeNumbers.length > 2 && episodeNumbers.length <= 5 && episodeNumbers[0] <= 16384) {
            int encoded = episodeNumbers[0] & 0x3FFF;
            int andMask = 255;
            int shiftMask = 8;
            int encodingMask = 0x40000000;
            int diffTest = 128;
            if (episodeNumbers.length == 4) {
                andMask = 31;
                shiftMask = 5;
                encodingMask = Integer.MIN_VALUE;
                diffTest = 16;
            } else if (episodeNumbers.length == 5) {
                andMask = 15;
                shiftMask = 4;
                encodingMask = -1073741824;
                diffTest = 8;
            }
            for (int i = 1; i < episodeNumbers.length; ++i) {
                int diff = episodeNumbers[i] - episodeNumbers[i - 1];
                int diffAbs = Math.abs(diff);
                if (diff == 0 || diffAbs > diffTest) {
                    throw new UnsupportedDataTypeException("Episode difference not in range.");
                }
                --diffAbs;
                if (diff < 0) {
                    diffAbs |= 1 << shiftMask - 1;
                }
                diff = (diffAbs & andMask) << 14 + (i - 1) * shiftMask;
                encoded |= diff;
            }
            return encoded | encodingMask;
        }
        throw new UnsupportedDataTypeException("Array size not in range or first value to big.");
    }

    public static Integer[] decodeSingleFieldValueToMultipleEpisodeNumers(int fieldValue) {
        int encodingMask = fieldValue >> 30 & 3;
        if (encodingMask == 0) {
            if ((fieldValue >> 29 & 1) == 1) {
                int first = fieldValue & 0x3FFF;
                int second = fieldValue >> 14 & Short.MAX_VALUE;
                return new Integer[]{first, second};
            }
            return new Integer[]{fieldValue};
        }
        int andMask = 255;
        int valueMask = 127;
        int shiftMask = 8;
        int num = 2;
        if (encodingMask == 2) {
            andMask = 31;
            valueMask = 15;
            shiftMask = 5;
            num = 3;
        } else if (encodingMask == 3) {
            andMask = 15;
            valueMask = 7;
            shiftMask = 4;
            num = 4;
        }
        int last = fieldValue & 0x3FFF;
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        valueList.add(last);
        for (int i = 0; i < num; ++i) {
            int testValue = fieldValue >> 14 + i * shiftMask & andMask;
            int absValue = (testValue & valueMask) + 1;
            if ((testValue >> shiftMask - 1 & 1) == 1) {
                absValue *= -1;
            }
            valueList.add(last += absValue);
        }
        return valueList.toArray(new Integer[valueList.size()]);
    }

    public static String decodeSingleFieldValueToMultipleEpisodeString(int fieldValue) {
        Integer[] episodes = IOUtilities.decodeSingleFieldValueToMultipleEpisodeNumers(fieldValue);
        StringBuilder epis = new StringBuilder();
        Integer[] arr$ = episodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int episode = arr$[i$];
            epis.append(episode).append("|");
        }
        if (epis.length() > 0) {
            epis.deleteCharAt(epis.length() - 1);
        }
        return epis.toString();
    }

    public static String checkForRelativePath(String path) {
        if (path != null && (path.contains("\\") || path.contains("/"))) {
            int i;
            File audioPath = new File(path);
            String[] homeParts = Plugin.getPluginManager().getTvBrowserSettings().getTvBrowserUserHome().replace("\\", "/").split("/");
            String[] pathParts = audioPath.getParent().replace("\\", "/").split("/");
            for (i = 0; homeParts.length > i && pathParts.length > i && homeParts[i].equals(pathParts[i]); ++i) {
            }
            if (i > 0) {
                int j;
                StringBuilder relativeValue = new StringBuilder();
                if (i < homeParts.length) {
                    for (j = i; j < homeParts.length; ++j) {
                        relativeValue.append("../");
                    }
                } else {
                    relativeValue.append("./");
                }
                for (j = i; j < pathParts.length; ++j) {
                    relativeValue.append(pathParts[j]).append("/");
                }
                relativeValue.append(audioPath.getName());
                return relativeValue.toString();
            }
        }
        return path;
    }

    public static String translateRelativePath(String path) {
        if (path != null && (path.startsWith("..") || path.startsWith("."))) {
            if (path.startsWith("./")) {
                path = path.substring(2);
            }
            String[] pathParts = path.replace("\\", "/").split("/");
            String[] homeParts = Plugin.getPluginManager().getTvBrowserSettings().getTvBrowserUserHome().replace("\\", "/").split("/");
            int homePartsToUse = homeParts.length;
            int i = 0;
            while (i < pathParts.length && pathParts[i].equals("..")) {
                ++i;
                --homePartsToUse;
            }
            if (homePartsToUse >= 0 && pathParts.length > i) {
                int j;
                StringBuilder pathToUse = new StringBuilder();
                for (j = 0; j < homePartsToUse; ++j) {
                    pathToUse.append(homeParts[j]).append("/");
                }
                for (j = i; j < pathParts.length; ++j) {
                    pathToUse.append(pathParts[j]).append("/");
                }
                if (pathToUse.length() > 1 && pathToUse.toString().endsWith("/")) {
                    pathToUse.deleteCharAt(pathToUse.length() - 1);
                    path = pathToUse.toString();
                }
            }
        }
        return path;
    }

    public static final void close(Closeable toClose) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

