/*
 * Decompiled with CFR 0.152.
 */
package util.exc;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorWindow;
import util.exc.TvBrowserException;
import util.ui.Localizer;
import util.ui.UIThreadRunner;

public class ErrorHandler {
    public static final int SHOW_OK = 0;
    public static final int SHOW_YES_NO = 1;
    public static final int OK_PRESSED = 1;
    public static final int YES_PRESSED = 2;
    public static final int NO_PRESSED = 3;
    private static final Logger mLog = Logger.getLogger(ErrorHandler.class.getName());
    static final Localizer mLocalizer = Localizer.getLocalizerFor(ErrorHandler.class);
    static final Icon ERROR_ICON = UIManager.getIcon("OptionPane.errorIcon");
    static JFrame mParent;

    public static void setFrame(JFrame parentFrame) {
        mParent = parentFrame;
    }

    public static void handle(TvBrowserException tvExc) {
        ErrorHandler.handle(tvExc.getLocalizedMessage(), tvExc);
    }

    public static void handle(final String msg, final Throwable throwable) {
        mLog.log(Level.SEVERE, msg, throwable);
        try {
            if (!MainFrame.isStarting()) {
                UIThreadRunner.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ErrorWindow errorWindow = new ErrorWindow(mParent, msg, throwable);
                        errorWindow.centerAndShow();
                    }
                });
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static int handle(String msg, Throwable thr, int messageType) {
        mLog.log(Level.SEVERE, msg, thr);
        if (!MainFrame.isStarting()) {
            ErrorWindow errwin = new ErrorWindow(mParent, msg, thr, messageType);
            errwin.centerAndShow();
            return errwin.getReturnValue();
        }
        return 3;
    }
}

