/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.tray;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import util.misc.JavaVersion;
import util.misc.OperatingSystem;
import util.ui.UiUtilities;

public class Java6Tray {
    private static final Logger mLog = Logger.getLogger(Java6Tray.class.getName());
    private SystemTray mSystemTray;
    private TrayIcon mTrayIcon;
    private JPopupMenu mPopupMenu;
    private ActionListener mLeftClickListener;
    private ActionListener mLeftDoubleClickListener;
    private ActionListener mRightClickListener;
    private JDialog mTrayParent;
    private static Java6Tray mInstance;

    private Java6Tray() {
        mInstance = this;
    }

    public static Java6Tray create() {
        if (mInstance == null) {
            new Java6Tray();
        }
        return mInstance;
    }

    public void addLeftClickAction(ActionListener listener) {
        this.mLeftClickListener = listener;
    }

    public void addLeftDoubleClickAction(ActionListener listener) {
        this.mLeftDoubleClickListener = listener;
    }

    public void addRightClickAction(ActionListener listener) {
        this.mRightClickListener = listener;
    }

    public boolean init(JFrame parent, String tooltip) {
        if (JavaVersion.getVersion() >= 7) {
            try {
                this.mSystemTray = SystemTray.getSystemTray();
                boolean isSupported = SystemTray.isSupported();
                if (isSupported) {
                    try {
                        if (new File("imgs/TrayIcon.png").isFile()) {
                            this.mTrayIcon = new TrayIcon(ImageIO.read(new File("imgs/TrayIcon.png")), tooltip);
                        } else {
                            Dimension trayIconSize = this.getTrayIconSize();
                            BufferedImage trayIconImage = null;
                            Color backgroundColor = null;
                            int widthSub = 0;
                            if (OperatingSystem.isLinux()) {
                                widthSub = 2;
                            }
                            trayIconImage = trayIconSize.height > 16 && trayIconSize.height <= 32 && new File("imgs/tvbrowser32.png").isFile() ? UiUtilities.scaleIconToBufferedImage(ImageIO.read(new File("imgs/tvbrowser32.png")), trayIconSize.width - widthSub, trayIconSize.height, 2, backgroundColor) : (trayIconSize.height > 32 && trayIconSize.height <= 48 && new File("imgs/tvbrowser48.png").isFile() ? UiUtilities.scaleIconToBufferedImage(ImageIO.read(new File("imgs/tvbrowser48.png")), trayIconSize.width - widthSub, trayIconSize.height, 2, backgroundColor) : (trayIconSize.height > 48 && new File("imgs/tvbrowser128.png").isFile() ? UiUtilities.scaleIconToBufferedImage(ImageIO.read(new File("imgs/tvbrowser128.png")), trayIconSize.width - widthSub, trayIconSize.height, 2, backgroundColor) : ImageIO.read(new File("imgs/tvbrowser16.png"))));
                            this.mTrayIcon = new TrayIcon(trayIconImage, tooltip);
                        }
                    }
                    catch (Throwable sizeFault) {
                        this.mTrayIcon = new TrayIcon(ImageIO.read(new File("imgs/tvbrowser16.png")), tooltip);
                    }
                    this.mTrayParent = new JDialog();
                    this.mTrayParent.setTitle("Tray-Menu");
                    this.mTrayParent.setSize(0, 0);
                    this.mTrayParent.setUndecorated(true);
                    this.mTrayParent.setAlwaysOnTop(true);
                    this.mTrayParent.setVisible(false);
                    mLog.info("Java 6 Tray inited.");
                } else {
                    mLog.info("Java 6 Tray is not supported on current platform.");
                }
                return isSupported;
            }
            catch (Exception e) {
                mLog.log(Level.SEVERE, "Java 6 Tray could not be inited.", e);
                this.mSystemTray = null;
                return false;
            }
        }
        mLog.info("Tray not supported: At least Java 6 is needed to get tray support.");
        return false;
    }

    public void setTrayPopUp(JPopupMenu trayMenu) {
        this.mPopupMenu = trayMenu;
        this.mPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Java6Tray.this.mTrayParent.setVisible(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.mTrayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getClickCount() == 1 && Java6Tray.this.mLeftClickListener != null) {
                        Java6Tray.this.mLeftClickListener.actionPerformed(null);
                    } else if (e.getClickCount() == 2 && Java6Tray.this.mLeftDoubleClickListener != null) {
                        Java6Tray.this.mLeftDoubleClickListener.actionPerformed(null);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if (SwingUtilities.isRightMouseButton(e) && Java6Tray.this.mRightClickListener != null) {
                        Java6Tray.this.mRightClickListener.actionPerformed(null);
                    }
                    Java6Tray.this.showPopup(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if (SwingUtilities.isRightMouseButton(e) && Java6Tray.this.mRightClickListener != null) {
                        Java6Tray.this.mRightClickListener.actionPerformed(null);
                    }
                    Java6Tray.this.showPopup(e.getPoint());
                }
            }
        });
    }

    private void showPopup(final Point p) {
        this.mTrayParent.setVisible(true);
        this.mTrayParent.toFront();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Point p2 = Java6Tray.this.computeDisplayPoint(p.x, p.y, Java6Tray.this.mPopupMenu.getPreferredSize());
                Java6Tray.this.mPopupMenu.show(Java6Tray.this.mTrayParent, p2.x - ((Java6Tray)Java6Tray.this).mTrayParent.getLocation().x, p2.y - ((Java6Tray)Java6Tray.this).mTrayParent.getLocation().y);
            }
        });
    }

    private Point computeDisplayPoint(int x, int y, Dimension dim) {
        if (x - dim.width > 0) {
            x -= dim.width;
        }
        if (y - dim.height > 0) {
            y -= dim.height;
        }
        return new Point(x, y);
    }

    public void setVisible(boolean b) {
        if (b) {
            try {
                this.mSystemTray.add(this.mTrayIcon);
            }
            catch (Exception e) {}
        } else {
            try {
                this.mSystemTray.remove(this.mTrayIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Dimension getTrayIconSize() {
        try {
            if (this.mSystemTray != null) {
                return this.mSystemTray.getTrayIconSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean showBalloonTip(String caption, String message, TrayIcon.MessageType messageType) {
        if (this.mSystemTray != null) {
            this.mTrayIcon.displayMessage(caption, message, messageType);
            return true;
        }
        return false;
    }
}

