/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.splashscreen;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;
import tvbrowser.TVBrowser;
import tvbrowser.ui.splashscreen.Splash;
import util.io.IOUtilities;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class SplashScreen
implements Splash {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SplashScreen.class);
    private static final Font MESSAGE_FONT = new Font("Dialog", 1, 15);
    private static final Font VERSION_FONT = new Font("Dialog", 1, 12);
    private static final Font DOMAIN_FONT = new Font("Dialog", 0, 10);
    private static final String DOMAIN = "tvbrowser.org";
    private static final String VERSION = TVBrowser.VERSION.toString();
    private static final String INFO = mLocalizer.msg("info", "The free program guide");
    private String mMessage;
    private int mMsgX;
    private int mMsgY;
    private int mVersionX;
    private int mVersionY;
    private int mDomainX;
    private int mDomainY;
    protected String mImgFileName;
    private java.awt.SplashScreen mSplashScreen = java.awt.SplashScreen.getSplashScreen();
    private Image mImage;
    private JWindow mSplashWindow;

    public SplashScreen() {
        this.mMessage = mLocalizer.ellipsisMsg("loading", "Loading");
        if (this.mSplashScreen == null) {
            try {
                byte[] image = IOUtilities.loadFileFromJar("splash.png", SplashScreen.class);
                this.mImage = new ImageIcon(image).getImage();
                this.mSplashWindow = new JWindow(){

                    @Override
                    public void paint(Graphics g) {
                        ((Graphics2D)g).setBackground(new Color(0, 0, 0, 0));
                        g.clearRect(0, 0, this.getWidth(), this.getHeight());
                        if (SplashScreen.this.mImage != null) {
                            g.drawImage(SplashScreen.this.mImage, 0, 0, null);
                        }
                        SplashScreen.this.paintOnce((Graphics2D)g);
                    }
                };
                this.mSplashWindow.setSize(this.mImage.getWidth(null), this.mImage.getHeight(null));
                this.setTransparentBackground(true);
                ((JPanel)this.mSplashWindow.getContentPane()).setOpaque(false);
                ((JPanel)this.mSplashWindow.getContentPane()).setBackground(new Color(0, 0, 0, 0));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void paintOnce(Graphics2D grp) {
        Graphics2D graphics = grp;
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        grp.setFont(MESSAGE_FONT);
        grp.setColor(Color.white);
        grp.drawString(this.mMessage, this.mMsgX, this.mMsgY + 32);
        grp.drawString(INFO, this.mMsgX, this.mMsgY);
        grp.setFont(VERSION_FONT);
        grp.setColor(Color.darkGray);
        grp.drawString(VERSION, this.mVersionX, this.mVersionY);
        grp.setFont(DOMAIN_FONT);
        grp.setColor(Color.darkGray);
        grp.drawString(DOMAIN, this.mDomainX, this.mDomainY);
        grp.dispose();
    }

    @Override
    public void setMessage(final String msg) {
        new Thread(){

            @Override
            public void run() {
                SplashScreen.this.mMessage = msg;
                if (SplashScreen.this.mSplashScreen != null && SplashScreen.this.mSplashScreen.isVisible()) {
                    Graphics2D g2d2 = SplashScreen.this.mSplashScreen.createGraphics();
                    g2d2.setColor(Color.white);
                    g2d2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    Graphics2D g2d = SplashScreen.this.mSplashScreen.createGraphics();
                    g2d.setComposite(AlphaComposite.Clear);
                    g2d.fillRect(0, 0, SplashScreen.this.getWidth(), SplashScreen.this.getHeight());
                    g2d.dispose();
                    SplashScreen.this.paintOnce(g2d2);
                    g2d2.dispose();
                    SplashScreen.this.mSplashScreen.update();
                } else if (SplashScreen.this.mSplashWindow != null) {
                    SplashScreen.this.mSplashWindow.repaint();
                }
            }
        }.start();
    }

    private int getWidth() {
        if (this.mSplashScreen != null) {
            return this.mSplashScreen.getSize().width;
        }
        if (this.mSplashWindow != null) {
            return this.mSplashWindow.getWidth();
        }
        return 0;
    }

    private int getHeight() {
        if (this.mSplashScreen != null) {
            return this.mSplashScreen.getSize().height;
        }
        if (this.mSplashWindow != null) {
            return this.mSplashWindow.getHeight();
        }
        return 0;
    }

    @Override
    public void hideSplash() {
        if (this.mSplashScreen != null && this.mSplashScreen.isVisible()) {
            this.mSplashScreen.close();
        } else if (this.mSplashWindow != null) {
            this.mSplashWindow.dispose();
        }
    }

    @Override
    public void showSplash() {
        Thread thread = new Thread("Splash screen creation"){

            @Override
            public void run() {
                SplashScreen.this.mMsgY = 93;
                SplashScreen.this.mDomainX = SplashScreen.this.getWidth() - UiUtilities.getStringWidth(DOMAIN_FONT, SplashScreen.DOMAIN) - 15;
                SplashScreen.this.mDomainY = SplashScreen.this.getHeight() - 15;
                SplashScreen.this.mMsgX = 15;
                SplashScreen.this.mVersionX = 15;
                SplashScreen.this.mVersionY = SplashScreen.this.getHeight() - 15;
                if (SplashScreen.this.mSplashWindow != null) {
                    SplashScreen.this.mSplashWindow.setLocationRelativeTo(null);
                    SplashScreen.this.mSplashWindow.setVisible(true);
                    SplashScreen.this.mSplashWindow.toFront();
                }
            }
        };
        thread.setPriority(5);
        thread.start();
    }

    public void setTransparentBackground(boolean value) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsConfiguration config = devices[0].getDefaultConfiguration();
        try {
            Class<?> awtUtilities = Class.forName("com.sun.awt.AWTUtilities");
            Method m = awtUtilities.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            if (((Boolean)m.invoke(awtUtilities, config)).booleanValue()) {
                m = awtUtilities.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                m.invoke(awtUtilities, this.mSplashWindow, !value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Method m = config.getClass().getMethod("isTranslucencyCapable()", GraphicsConfiguration.class);
                if (((Boolean)m.invoke((Object)config, new Object[0])).booleanValue()) {
                    m = this.getClass().getMethod("setOpacity", Float.TYPE);
                    m.invoke((Object)this.mSplashWindow, Float.valueOf(!value ? 1 : 0));
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }
}

