/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.ui.Localizer;

public class SingleColorBackgroundStyle
implements TableBackgroundStyle {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SingleColorBackgroundStyle.class);
    private ColorLabel mColorLabel;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("default,5dlu,default,5dlu,default", "default"));
        this.mColorLabel = new ColorLabel(Settings.propProgramTableBackgroundSingleColor.getColor());
        this.mColorLabel.setStandardColor(Settings.propProgramTableBackgroundSingleColor.getDefaultColor());
        ColorButton colorButton = new ColorButton(this.mColorLabel);
        pb.addLabel(mLocalizer.msg("text", "Background color"), cc.xy(1, 1));
        pb.add((Component)this.mColorLabel, cc.xy(3, 1));
        pb.add((Component)colorButton, cc.xy(5, 1));
        return pb.getPanel();
    }

    @Override
    public void storeSettings() {
        Settings.propProgramTableBackgroundSingleColor.setColor(this.mColorLabel.getColor());
    }

    @Override
    public String getName() {
        return mLocalizer.msg("style", "Single color");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "singleColor";
    }
}

