/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.channel.ChannelUtil;
import util.io.IOUtilities;
import util.ui.CaretPositionCorrector;
import util.ui.ExtensionFileFilter;
import util.ui.ImageUtilities;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ChannelConfigDlg
extends JDialog
implements ActionListener,
WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelConfigDlg.class);
    private Channel mChannel;
    private JButton mCloseBt;
    private JButton mOKBt;
    private JComboBox mCorrectionCB;
    private File mIconFile;
    private JButton mChangeIcon;
    private JTextField mChannelName;
    private JTextField mWebPage;
    private JSpinner mStartTimeLimit;
    private JSpinner mEndTimeLimit;
    private JLabel mIconLabel;
    private JTextField mSortNumber;

    public ChannelConfigDlg(Window parent, Channel channel) {
        super(parent, mLocalizer.msg("configChannel", "Configure Channel"));
        this.setModal(true);
        this.mChannel = channel;
        this.createDialog();
    }

    private void createDialog() {
        JPanel panel = (JPanel)this.getContentPane();
        UiUtilities.registerForClosing(this);
        panel.setLayout(new FormLayout("default, 3dlu, fill:default:grow", "default, 3dlu, default, 3dlu, default, 3dlu, default, 3dlu, default, 3dlu, default, 3dlu, default, 3dlu, default, 5dlu, default, 3dlu, default, 3dlu:grow, default, 5dlu, default"));
        CellConstraints cc = new CellConstraints();
        panel.setBorder(Borders.DLU4);
        int y = 1;
        panel.add((Component)new JLabel(mLocalizer.msg("channelNumber", "Sort number:")), cc.xy(1, y));
        this.mSortNumber = new JTextField(this.mChannel.getSortNumber());
        panel.add((Component)this.mSortNumber, cc.xy(3, y));
        panel.add((Component)new JLabel(mLocalizer.msg("channelName", "Channel Name:")), cc.xy(1, y += 2));
        this.mChannelName = new JTextField(this.mChannel.getName());
        panel.add((Component)this.mChannelName, cc.xy(3, y));
        panel.add((Component)new JLabel(mLocalizer.msg("provider", "Provided by:")), cc.xy(1, y += 2));
        panel.add((Component)new JLabel(ChannelUtil.getProviderName(this.mChannel)), cc.xy(3, y));
        panel.add((Component)new JLabel(mLocalizer.msg("channelLogo", "Channel Logo:")), cc.xy(1, y += 2));
        if (this.mChannel.getUserIconFileName() != null) {
            this.mIconFile = new File(IOUtilities.translateRelativePath(this.mChannel.getUserIconFileName()));
        }
        this.mIconLabel = new JLabel(this.createUserIcon());
        this.mChangeIcon = new JButton(mLocalizer.msg("useIcon", "Select channel icon"));
        this.mChangeIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelConfigDlg.this.changeIcon();
            }
        });
        panel.add((Component)this.mIconLabel, cc.xy(3, y++));
        panel.add((Component)this.mChangeIcon, cc.xy(3, ++y));
        panel.add((Component)new JLabel(mLocalizer.msg("webAddress", "Web Address:")), cc.xy(1, y += 2));
        this.mWebPage = new JTextField(this.mChannel.getWebpage());
        panel.add((Component)this.mWebPage, cc.xy(3, y));
        panel.add((Component)new JLabel(mLocalizer.msg("time", "Time zone correction:")), cc.xy(1, y += 2));
        this.mCorrectionCB = new JComboBox<String>(new String[]{"-1:00", "-0:45", "-0:30", "-0:15", "0:00", "+0:15", "+0:30", "+0:45", "+1:00"});
        this.mCorrectionCB.setSelectedIndex(this.mChannel.getTimeZoneCorrectionMinutes() / 15 + 4);
        panel.add((Component)this.mCorrectionCB, cc.xy(3, y++));
        JTextArea txt = UiUtilities.createHelpTextArea(mLocalizer.msg("DLSTNote", ""));
        txt.setMinimumSize(new Dimension(150, 20));
        panel.add((Component)txt, cc.xy(3, ++y));
        panel.add((Component)DefaultComponentFactory.getInstance().createLabel(mLocalizer.msg("timeLimits", "Time limits:")), cc.xy(1, y += 2));
        String timePattern = mLocalizer.msg("timePattern", "hh:mm a");
        this.mStartTimeLimit = new JSpinner(new SpinnerDateModel());
        this.mStartTimeLimit.setEditor(new JSpinner.DateEditor(this.mStartTimeLimit, timePattern));
        this.setTimeDate(this.mStartTimeLimit, this.mChannel.getStartTimeLimit());
        this.mEndTimeLimit = new JSpinner(new SpinnerDateModel());
        this.mEndTimeLimit.setEditor(new JSpinner.DateEditor(this.mEndTimeLimit, timePattern));
        this.setTimeDate(this.mEndTimeLimit, this.mChannel.getEndTimeLimit());
        ((JSpinner.DateEditor)this.mStartTimeLimit.getEditor()).getTextField().setHorizontalAlignment(2);
        ((JSpinner.DateEditor)this.mEndTimeLimit.getEditor()).getTextField().setHorizontalAlignment(2);
        CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mStartTimeLimit.getEditor()).getTextField(), new char[]{':'}, -1);
        CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mEndTimeLimit.getEditor()).getTextField(), new char[]{':'}, -1);
        PanelBuilder timeLimitPanel = new PanelBuilder(new FormLayout("default:grow,10dlu,default:grow", "default,2dlu,default"));
        timeLimitPanel.addLabel(mLocalizer.msg("startTime", "Start time:"), cc.xy(1, 1));
        timeLimitPanel.addLabel(mLocalizer.msg("endTime", "End time:"), cc.xy(3, 1));
        timeLimitPanel.add((Component)this.mStartTimeLimit, cc.xy(1, 3));
        timeLimitPanel.add((Component)this.mEndTimeLimit, cc.xy(3, 3));
        panel.add((Component)timeLimitPanel.getPanel(), cc.xy(3, y));
        JTextArea txt2 = UiUtilities.createHelpTextArea(mLocalizer.msg("DLSTNote", ""));
        txt2.setMinimumSize(new Dimension(150, 20));
        panel.add((Component)txt2, cc.xy(3, y += 2));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        JButton defaultButton = new JButton(Localizer.getLocalization("i18n_default"));
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelConfigDlg.this.resetToDefaults();
            }
        });
        builder.addButton((JComponent)defaultButton);
        builder.addRelatedGap();
        builder.addGlue();
        this.mOKBt = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOKBt.addActionListener(this);
        this.getRootPane().setDefaultButton(this.mOKBt);
        this.mCloseBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCloseBt.addActionListener(this);
        builder.addButton(this.mOKBt, this.mCloseBt);
        y += 2;
        panel.add((Component)new JSeparator(), cc.xyw(1, y++, 3));
        panel.add((Component)builder.getPanel(), cc.xyw(1, ++y, 3));
        this.pack();
        Settings.layoutWindow("channelConfig", this, new Dimension(420, 420));
    }

    private void setTimeDate(JSpinner toSet, int time) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, time / 60);
        cal.set(12, time % 60);
        toSet.setValue(cal.getTime());
    }

    private int getTimeInMinutes(JSpinner toGet) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)toGet.getValue());
        return cal.get(11) * 60 + cal.get(12);
    }

    private void resetToDefaults() {
        this.mSortNumber.setText("");
        this.mWebPage.setText(this.mChannel.getDefaultWebPage());
        this.mChannelName.setText(this.mChannel.getDefaultName());
        this.mIconFile = null;
        this.mIconLabel.setIcon(this.createUserIcon());
        this.mCorrectionCB.setSelectedIndex(this.mCorrectionCB.getItemCount() / 2);
        this.setTimeDate(this.mStartTimeLimit, 0);
        this.setTimeDate(this.mEndTimeLimit, 0);
    }

    private Icon createUserIcon() {
        Image img;
        ImageIcon icon = this.mIconFile != null && this.mIconFile.exists() ? ((img = ImageUtilities.createImageAsynchronous(this.mIconFile.getAbsolutePath())) != null ? UiUtilities.createChannelIcon(new ImageIcon(img)) : UiUtilities.createChannelIcon(this.mChannel.getIcon())) : UiUtilities.createChannelIcon(this.mChannel.getDefaultIcon());
        return icon;
    }

    private void changeIcon() {
        File selection;
        JFileChooser fileChooser = new JFileChooser(this.mIconFile);
        String[] extArr = new String[]{".jpg", ".jpeg", ".gif", ".png"};
        fileChooser.setFileFilter(new ExtensionFileFilter(extArr, ".jpg, .gif, .png"));
        if (fileChooser.showOpenDialog(this) == 0 && (selection = fileChooser.getSelectedFile()) != null) {
            this.mIconFile = selection;
            this.mIconLabel.setIcon(this.createUserIcon());
        }
    }

    public void centerAndShow() {
        UiUtilities.centerAndShow(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.mOKBt) {
            int minutes = (this.mCorrectionCB.getSelectedIndex() - 4) * 15;
            this.mChannel.setTimeZoneCorrectionMinutes(minutes);
            this.mChannel.useUserIcon(this.mIconFile != null);
            if (this.mIconFile != null) {
                this.mChannel.setUserIconFileName(IOUtilities.checkForRelativePath(this.mIconFile.getAbsolutePath()));
            } else {
                this.mChannel.setUserIconFileName(null);
            }
            this.mChannel.setUserChannelName(this.mChannelName.getText());
            this.mChannel.setUserWebPage(this.mWebPage.getText());
            this.mChannel.setStartTimeLimit(this.getTimeInMinutes(this.mStartTimeLimit));
            this.mChannel.setEndTimeLimit(this.getTimeInMinutes(this.mEndTimeLimit));
            this.mChannel.setSortNumber(this.mSortNumber.getText().trim());
            Settings.updateChannelFilters(ChannelList.getSubscribedChannels());
            this.setVisible(false);
        } else if (o == this.mCloseBt) {
            this.setVisible(false);
        }
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

