/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import util.ui.Localizer;
import util.ui.TabLayout;

public class ProxySettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProxySettingsTab.class);
    private ProxySettingsPanel mHttpProxySettingsPanel;
    private JPanel mSettingsPn;

    @Override
    public JPanel createSettingsPanel() {
        this.mSettingsPn = new JPanel(new BorderLayout());
        this.mSettingsPn.setBorder(Borders.DIALOG);
        JPanel main = new JPanel(new TabLayout(1));
        this.mSettingsPn.add((Component)main, "Center");
        String msgProxy = mLocalizer.msg("httpProxy", "HTTP Proxy");
        String msgUseProxy = mLocalizer.msg("useHttpProxy", "Use proxy for HTTP");
        this.mHttpProxySettingsPanel = new ProxySettingsPanel(msgProxy, msgUseProxy);
        this.mHttpProxySettingsPanel.setUseProxy(Settings.propHttpProxyUseProxy.getBoolean());
        this.mHttpProxySettingsPanel.setHost(Settings.propHttpProxyHost.getString());
        this.mHttpProxySettingsPanel.setPort(Settings.propHttpProxyPort.getString());
        this.mHttpProxySettingsPanel.setAuthentifyAtProxy(Settings.propHttpProxyAuthentifyAtProxy.getBoolean());
        this.mHttpProxySettingsPanel.setUser(Settings.propHttpProxyUser.getString());
        this.mHttpProxySettingsPanel.setPassword(Settings.propHttpProxyPassword.getString());
        main.add(this.mHttpProxySettingsPanel);
        return this.mSettingsPn;
    }

    @Override
    public void saveSettings() {
        Settings.propHttpProxyUseProxy.setBoolean(this.mHttpProxySettingsPanel.getUseProxy());
        Settings.propHttpProxyHost.setString(this.mHttpProxySettingsPanel.getHost());
        Settings.propHttpProxyPort.setString(this.mHttpProxySettingsPanel.getPort());
        Settings.propHttpProxyAuthentifyAtProxy.setBoolean(this.mHttpProxySettingsPanel.getAuthentifyAtProxy());
        Settings.propHttpProxyUser.setString(this.mHttpProxySettingsPanel.getUser());
        Settings.propHttpProxyPassword.setString(this.mHttpProxySettingsPanel.getPassword());
        TVBrowser.updateProxySettings();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "preferences-system-network-proxy", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("name", "Proxy");
    }

    protected static class ProxySettingsPanel
    extends JPanel {
        private JCheckBox mUseProxyChB;
        private JCheckBox mAuthentifyAtProxyChB;
        private JTextField mHostTF;
        private JTextField mPortTF;
        private JTextField mUserTF;
        private JPasswordField mPasswordPF;
        private JLabel mHostLb;
        private JLabel mPortLb;
        private JLabel mUserLb;
        private JLabel mPasswordLb;

        public ProxySettingsPanel(String msgProxy, String msgUseProxy) {
            super(new FormLayout("5dlu, 10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, fill:pref:grow", "pref, 5dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref"));
            ActionListener updateEnabledListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProxySettingsPanel.this.updateEnabled();
                }
            };
            CellConstraints cc = new CellConstraints();
            this.add((Component)DefaultComponentFactory.getInstance().createSeparator(msgProxy), cc.xyw(1, 1, 10));
            this.mUseProxyChB = new JCheckBox(msgUseProxy);
            this.mUseProxyChB.addActionListener(updateEnabledListener);
            this.add((Component)this.mUseProxyChB, cc.xyw(2, 3, 6));
            this.mHostLb = new JLabel(mLocalizer.msg("host", "Host"));
            this.add((Component)this.mHostLb, cc.xyw(3, 5, 1));
            this.mHostTF = new JTextField(20);
            this.add((Component)this.mHostTF, cc.xy(5, 5));
            this.mPortLb = new JLabel(mLocalizer.msg("port", "Port"));
            this.add((Component)this.mPortLb, cc.xy(7, 5));
            this.mPortTF = new JTextField(4);
            this.add((Component)this.mPortTF, cc.xy(9, 5));
            String msg = mLocalizer.msg("authentifyAtProxy", "Authentify at proxy");
            this.mAuthentifyAtProxyChB = new JCheckBox(msg);
            this.mAuthentifyAtProxyChB.addActionListener(updateEnabledListener);
            this.add((Component)this.mAuthentifyAtProxyChB, cc.xyw(3, 7, 5));
            JPanel panel = new JPanel(new FormLayout("10dlu, pref, 3dlu, fill:pref:grow", "pref, 3dlu, pref"));
            this.mUserLb = new JLabel(mLocalizer.msg("user", "User"));
            panel.add((Component)this.mUserLb, cc.xy(2, 1));
            this.mUserTF = new JTextField(10);
            panel.add((Component)this.mUserTF, cc.xy(4, 1));
            this.mPasswordLb = new JLabel(mLocalizer.msg("password", "Password"));
            panel.add((Component)this.mPasswordLb, cc.xy(2, 3));
            this.mPasswordPF = new JPasswordField(10);
            panel.add((Component)this.mPasswordPF, cc.xy(4, 3));
            this.add((Component)panel, cc.xyw(3, 9, 7));
        }

        private void updateEnabled() {
            boolean useProxy = this.mUseProxyChB.isSelected();
            boolean authentify = this.mAuthentifyAtProxyChB.isSelected();
            this.mHostLb.setEnabled(useProxy);
            this.mHostTF.setEnabled(useProxy);
            this.mPortLb.setEnabled(useProxy);
            this.mPortTF.setEnabled(useProxy);
            this.mAuthentifyAtProxyChB.setEnabled(useProxy);
            this.mUserLb.setEnabled(useProxy && authentify);
            this.mUserTF.setEnabled(useProxy && authentify);
            this.mPasswordLb.setEnabled(useProxy && authentify);
            this.mPasswordPF.setEnabled(useProxy && authentify);
        }

        public void setUseProxy(boolean value) {
            this.mUseProxyChB.setSelected(value);
            this.updateEnabled();
        }

        public boolean getUseProxy() {
            return this.mUseProxyChB.isSelected();
        }

        public void setHost(String value) {
            this.mHostTF.setText(value);
        }

        public String getHost() {
            return this.mHostTF.getText();
        }

        public void setPort(String value) {
            this.mPortTF.setText(value);
        }

        public String getPort() {
            return this.mPortTF.getText();
        }

        public void setAuthentifyAtProxy(boolean value) {
            this.mAuthentifyAtProxyChB.setSelected(value);
            this.updateEnabled();
        }

        public boolean getAuthentifyAtProxy() {
            return this.mAuthentifyAtProxyChB.isSelected();
        }

        public void setUser(String value) {
            this.mUserTF.setText(value);
        }

        public String getUser() {
            return this.mUserTF.getText();
        }

        public void setPassword(String value) {
            this.mPasswordPF.setText(value);
        }

        public String getPassword() {
            return new String(this.mPasswordPF.getPassword());
        }
    }
}

