/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.InfoIf;
import devplugin.PluginInfo;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.PluginAndDataServiceComparator;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.ChannelsSettingsTab;
import tvbrowser.ui.settings.PluginInfoDialog;
import tvbrowser.ui.settings.PluginTableCellRenderer;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.update.SoftwareUpdateDlg;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class PluginSettingsTab
implements SettingsTab,
TableModelListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginSettingsTab.class);
    private static final Logger mLog = Logger.getLogger(PluginSettingsTab.class.getName());
    private JTable mTable;
    private JButton mInfo;
    private JButton mRemove;
    private DefaultTableModel mTableModel;
    private SettingsDialog mSettingsDialog;
    private JCheckBox mAutoUpdates;
    private JButton mConfigure;
    private JComboBox mFilterBox;
    private ArrayList<Object> mPluginList;

    public PluginSettingsTab(SettingsDialog settingsDialog) {
        this.mSettingsDialog = settingsDialog;
    }

    @Override
    public JPanel createSettingsPanel() {
        JPanel contentPanel = new JPanel(new FormLayout("default:grow, default", "default, 2dlu, default, 3dlu, fill:100dlu:grow, 3dlu, default"));
        contentPanel.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        JButton update = new JButton(mLocalizer.msg("updateInstallPlugin", "Update/Install Plugins"), IconLoader.getInstance().getIconFromTheme("actions", "web-search", 16));
        update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showUpdatePluginsDlg(false);
            }
        });
        contentPanel.add((Component)update, cc.xy(2, 1));
        this.mAutoUpdates = new JCheckBox(mLocalizer.msg("autoUpdates", "Find plugin updates automatically"), Settings.propAutoUpdatePlugins.getBoolean());
        this.mAutoUpdates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Settings.propAutoUpdatePlugins.setBoolean(e.getStateChange() == 1);
            }
        });
        contentPanel.add((Component)this.mAutoUpdates, cc.xy(1, 1));
        JPanel categorySelection = new JPanel(new FormLayout("default,3dlu,default:grow", "default"));
        JLabel filterLabel = new JLabel(SoftwareUpdateDlg.mLocalizer.msg("filterLabel", "Show only Plugins with the following category:"));
        this.mFilterBox = new JComboBox();
        this.mFilterBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PluginSettingsTab.this.populatePluginList();
            }
        });
        categorySelection.add((Component)filterLabel, cc.xy(1, 1));
        categorySelection.add((Component)this.mFilterBox, cc.xy(3, 1));
        contentPanel.add((Component)categorySelection, cc.xyw(1, 3, 2));
        this.mTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                Object value;
                if (column == 0 && (value = this.getValueAt(row, 1)) instanceof PluginProxy) {
                    return !Settings.propBlockedPluginArray.isBlocked((PluginProxy)value);
                }
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                return super.getColumnClass(columnIndex);
            }
        };
        this.mTableModel.setColumnCount(2);
        this.mTableModel.setColumnIdentifiers(new String[]{mLocalizer.msg("active", "Active"), mLocalizer.msg("plugin", "Plugin")});
        this.mTable = new JTable(this.mTableModel);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(PluginTableCellRenderer.getInstance());
        this.mTable.getColumnModel().getColumn(1).setCellRenderer(PluginTableCellRenderer.getInstance());
        this.mTable.setSelectionMode(0);
        this.mTable.setRowHeight(40);
        this.mTable.setShowVerticalLines(false);
        this.mTable.setShowHorizontalLines(false);
        this.mTable.getModel().addTableModelListener(this);
        int columnWidth = UiUtilities.getStringWidth(this.mTable.getFont(), this.mTableModel.getColumnName(0)) + 16;
        this.mTable.getColumnModel().getColumn(0).setPreferredWidth(columnWidth);
        this.mTable.getColumnModel().getColumn(0).setMaxWidth(columnWidth);
        this.mTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int rowIndex;
                if (e.isPopupTrigger() && (rowIndex = PluginSettingsTab.this.mTable.rowAtPoint(e.getPoint())) >= 0) {
                    PluginSettingsTab.this.mTable.setRowSelectionInterval(rowIndex, rowIndex);
                    Object plugin = PluginSettingsTab.this.mTable.getModel().getValueAt(rowIndex, 1);
                    JPopupMenu menu = plugin instanceof InfoIf ? PluginSettingsTab.this.createContextMenu((InfoIf)plugin) : PluginSettingsTab.this.createContextMenu((InternalPluginProxyIf)plugin);
                    menu.show(PluginSettingsTab.this.mTable, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int rowIndex;
                if (e.isPopupTrigger() && (rowIndex = PluginSettingsTab.this.mTable.rowAtPoint(e.getPoint())) >= 0) {
                    PluginSettingsTab.this.mTable.setRowSelectionInterval(rowIndex, rowIndex);
                    Object plugin = PluginSettingsTab.this.mTable.getModel().getValueAt(rowIndex, 1);
                    JPopupMenu menu = plugin instanceof InfoIf ? PluginSettingsTab.this.createContextMenu((InfoIf)plugin) : PluginSettingsTab.this.createContextMenu((InternalPluginProxyIf)plugin);
                    menu.show(PluginSettingsTab.this.mTable, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int rowIndex;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (rowIndex = PluginSettingsTab.this.mTable.getSelectedRow()) >= 0) {
                    Object proxy = PluginSettingsTab.this.mTableModel.getValueAt(rowIndex, 1);
                    if (proxy instanceof PluginProxy) {
                        PluginSettingsTab.this.showInfoDialog((PluginProxy)proxy);
                    } else if (proxy instanceof InternalPluginProxyIf) {
                        PluginSettingsTab.this.showInfoDialog((InternalPluginProxyIf)proxy);
                    } else if (proxy instanceof TvDataServiceProxy) {
                        PluginSettingsTab.this.showInformation((TvDataServiceProxy)proxy);
                    }
                }
            }
        });
        this.populatePluginList();
        JScrollPane pane = new JScrollPane(this.mTable);
        pane.getViewport().setBackground(this.mTable.getBackground());
        contentPanel.add((Component)pane, cc.xyw(1, 5, 2));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.mInfo = new JButton(mLocalizer.msg("info", "Info"), IconLoader.getInstance().getIconFromTheme("status", "dialog-information", 16));
        this.mInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection = PluginSettingsTab.this.getSelection();
                if (selection instanceof PluginProxy) {
                    PluginSettingsTab.this.showInfoDialog((PluginProxy)selection);
                } else if (selection instanceof InternalPluginProxyIf) {
                    PluginSettingsTab.this.showInfoDialog((InternalPluginProxyIf)selection);
                } else if (selection instanceof TvDataServiceProxy) {
                    PluginSettingsTab.this.showInformation((TvDataServiceProxy)selection);
                }
            }
        });
        this.mConfigure = new JButton(mLocalizer.msg("configure", "Configure"), TVBrowserIcons.preferences(16));
        this.mConfigure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection = PluginSettingsTab.this.getSelection();
                if (selection instanceof PluginProxy) {
                    PluginSettingsTab.this.configurePlugin((PluginProxy)selection);
                } else if (selection instanceof InternalPluginProxyIf) {
                    PluginSettingsTab.this.mSettingsDialog.showSettingsTab(((InternalPluginProxyIf)selection).getSettingsId());
                } else if (selection instanceof TvDataServiceProxy) {
                    PluginSettingsTab.this.configureService((TvDataServiceProxy)selection);
                }
            }
        });
        builder.addButton((JComponent)this.mInfo);
        builder.addRelatedGap();
        builder.addButton((JComponent)this.mConfigure);
        builder.addRelatedGap();
        builder.addGlue();
        builder.addRelatedGap();
        this.mRemove = new JButton(Localizer.getLocalization("i18n_delete"), TVBrowserIcons.delete(16));
        this.mRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PluginSettingsTab.this.getSelection() instanceof PluginProxy) {
                    PluginSettingsTab.this.removePlugin((PluginProxy)PluginSettingsTab.this.getSelection());
                } else {
                    PluginSettingsTab.this.removeService((TvDataServiceProxy)PluginSettingsTab.this.getSelection());
                }
            }
        });
        builder.addButton((JComponent)this.mRemove);
        contentPanel.add((Component)builder.getPanel(), cc.xyw(1, 7, 2));
        this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PluginSettingsTab.this.updateBtns();
            }
        });
        this.updateBtns();
        return contentPanel;
    }

    private Object getSelection() {
        int rowIndex = this.mTable.getSelectedRow();
        if (rowIndex >= 0) {
            Object proxy = this.mTableModel.getValueAt(rowIndex, 1);
            this.mTable.scrollRectToVisible(this.mTable.getCellRect(rowIndex, 0, true));
            return proxy;
        }
        return null;
    }

    private JPopupMenu createContextMenu(final InternalPluginProxyIf plugin) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem configureMI = new JMenuItem(mLocalizer.msg("configure", ""), TVBrowserIcons.preferences(16));
        configureMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginSettingsTab.this.mSettingsDialog.showSettingsTab(plugin.getSettingsId());
            }
        });
        menu.add(configureMI);
        JMenuItem helpMI = new JMenuItem(mLocalizer.msg("pluginHelp", "Online help"), IconLoader.getInstance().getIconFromTheme("apps", "help-browser", 16));
        helpMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = PluginInfo.getHelpUrl(plugin.getId());
                Launch.openURL(url);
            }
        });
        menu.add(helpMI);
        return menu;
    }

    private JPopupMenu createContextMenu(final InfoIf plugin) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem infoMI = new JMenuItem(mLocalizer.msg("info", "Info"), IconLoader.getInstance().getIconFromTheme("status", "dialog-information", 16));
        infoMI.setFont(infoMI.getFont().deriveFont(1));
        infoMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (plugin instanceof PluginProxy) {
                    PluginSettingsTab.this.showInfoDialog((PluginProxy)plugin);
                } else if (plugin instanceof TvDataServiceProxy) {
                    PluginSettingsTab.this.showInformation((TvDataServiceProxy)plugin);
                }
            }
        });
        menu.add(infoMI);
        JMenuItem configureMI = new JMenuItem(mLocalizer.msg("configure", ""), TVBrowserIcons.preferences(16));
        configureMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (plugin instanceof PluginProxy) {
                    PluginSettingsTab.this.configurePlugin((PluginProxy)plugin);
                } else if (plugin instanceof TvDataServiceProxy) {
                    PluginSettingsTab.this.configureService((TvDataServiceProxy)plugin);
                }
            }
        });
        menu.add(configureMI);
        if (plugin instanceof PluginProxy) {
            JMenuItem enableMI;
            if (((PluginProxy)plugin).isActivated()) {
                enableMI = new JMenuItem(mLocalizer.msg("deactivate", ""), IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
            } else {
                enableMI = new JMenuItem(mLocalizer.msg("activate", ""), TVBrowserIcons.refresh(16));
                enableMI.setEnabled(!Settings.propBlockedPluginArray.isBlocked((PluginProxy)plugin));
            }
            enableMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = PluginSettingsTab.this.mTable.getSelectedRow();
                    if (row >= 0) {
                        PluginSettingsTab.this.mTableModel.setValueAt((Boolean)PluginSettingsTab.this.mTableModel.getValueAt(row, 0) == false, row, 0);
                    }
                }
            });
            menu.add(enableMI);
        }
        if (plugin instanceof PluginProxy || plugin instanceof TvDataServiceProxy) {
            JMenuItem deleteMI = new JMenuItem(mLocalizer.msg("remove", "Remove"), TVBrowserIcons.delete(16));
            deleteMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (plugin instanceof PluginProxy) {
                        PluginSettingsTab.this.removePlugin((PluginProxy)plugin);
                    } else {
                        PluginSettingsTab.this.removeService((TvDataServiceProxy)plugin);
                    }
                }
            });
            if (plugin instanceof PluginProxy) {
                deleteMI.setEnabled(PluginLoader.getInstance().isPluginDeletable((PluginProxy)plugin));
            } else if (plugin instanceof TvDataServiceProxy) {
                deleteMI.setEnabled(PluginLoader.getInstance().isDataServiceDeletable((TvDataServiceProxy)plugin));
            }
            menu.add(deleteMI);
        }
        JMenuItem helpMI = new JMenuItem(mLocalizer.msg("pluginHelp", "Online help"), IconLoader.getInstance().getIconFromTheme("apps", "help-browser", 16));
        helpMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = PluginInfo.getHelpUrl(plugin.getId());
                Launch.openURL(url);
            }
        });
        menu.add(helpMI);
        menu.addSeparator();
        JMenuItem refreshMI = new JMenuItem(mLocalizer.msg("updateInstallPlugin", "Update/Install Plugins"), IconLoader.getInstance().getIconFromTheme("actions", "web-search", 16));
        refreshMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showUpdatePluginsDlg(false);
            }
        });
        menu.add(refreshMI);
        return menu;
    }

    private void removePlugin(PluginProxy plugin) {
        if (plugin == null) {
            return;
        }
        String text = mLocalizer.msg("deletePlugin", "Really delete the Plugin \"{0}\" ?", plugin.toString());
        int result = JOptionPane.showConfirmDialog(this.mSettingsDialog.getDialog(), text, Localizer.getLocalization("i18n_delete") + "?", 0);
        if (result == 0) {
            if (PluginLoader.getInstance().deletePlugin(plugin)) {
                JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), mLocalizer.msg("successfully", "Deletion was succesfully"));
            } else {
                JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), mLocalizer.msg("failed", "Deletion failed"));
            }
            this.populatePluginList();
            this.mSettingsDialog.createPluginTreeItems();
            this.mTable.setRowSelectionInterval(0, 0);
        }
    }

    private void removeService(TvDataServiceProxy service) {
        int result;
        if (service == null) {
            return;
        }
        int channelCount = 0;
        Channel[] subscribed = ChannelList.getSubscribedChannels();
        ArrayList<Channel> keepChannels = new ArrayList<Channel>();
        for (Channel element : subscribed) {
            if (!(element instanceof DummyChannel) && element.getDataServiceProxy().equals(service)) {
                ++channelCount;
                continue;
            }
            keepChannels.add(element);
        }
        String text = mLocalizer.msg("deleteService", "Really delete the data service \"{0}\"?", service.getInfo().getName());
        if (channelCount > 0) {
            text = mLocalizer.msg("deleteServiceCount", "Really delete the data service \"{0}\"?\nThis will remove {1} of your subscribed channels.", service.getInfo().getName(), channelCount);
        }
        if ((result = JOptionPane.showConfirmDialog(this.mSettingsDialog.getDialog(), text, Localizer.getLocalization("i18n_delete") + "?", 0)) == 0) {
            if (PluginLoader.getInstance().deleteDataService(service)) {
                JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), mLocalizer.msg("dataservice.successfully", "Deletion was succesfully"));
                ChannelsSettingsTab.saveChannels(keepChannels.toArray(new Channel[keepChannels.size()]), false);
            } else {
                JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), mLocalizer.msg("failed", "Deletion failed"));
            }
            this.populatePluginList();
            this.mTable.setRowSelectionInterval(0, 0);
        }
    }

    private void showInfoDialog(PluginProxy plugin) {
        if (plugin == null) {
            return;
        }
        ActionMenu actionMenu = plugin.getButtonAction();
        Action action = null;
        if (actionMenu != null) {
            action = actionMenu.getAction();
        }
        Icon ico = null;
        if (action != null) {
            ico = (Icon)action.getValue("SmallIcon");
        }
        if (ico == null) {
            ico = plugin.getMarkIcon();
        }
        if (ico == null) {
            ico = new ImageIcon("imgs/Jar16.gif");
        }
        PluginInfoDialog dialog = new PluginInfoDialog(this.mSettingsDialog.getDialog(), ico, plugin.getInfo());
        UiUtilities.centerAndShow(dialog);
    }

    private void showInfoDialog(InternalPluginProxyIf plugin) {
        JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("internalPlugin", "This is an internal plugin which cannot be disabled."), mLocalizer.msg("internalPluginTitle", "Internal plugin"), 1);
    }

    private void showInformation(TvDataServiceProxy service) {
        if (service == null) {
            return;
        }
        PluginInfoDialog dialog = new PluginInfoDialog(this.mSettingsDialog.getDialog(), null, service.getInfo());
        UiUtilities.centerAndShow(dialog);
    }

    private void configurePlugin(PluginProxy plugin) {
        if (plugin == null) {
            return;
        }
        this.mSettingsDialog.showSettingsTab(plugin.getId());
    }

    private void configureService(TvDataServiceProxy service) {
        if (service == null) {
            return;
        }
        this.mSettingsDialog.showSettingsTab(service.getId());
    }

    private void populatePluginList() {
        while (this.mTableModel.getRowCount() > 0) {
            this.mTableModel.removeRow(0);
        }
        Object test = this.mFilterBox.getSelectedItem();
        SoftwareUpdateDlg.FilterItem filterItem = null;
        filterItem = test == null ? new SoftwareUpdateDlg.FilterItem("all") : (SoftwareUpdateDlg.FilterItem)test;
        ArrayList<SoftwareUpdateDlg.FilterItem> filterItemList = new ArrayList<SoftwareUpdateDlg.FilterItem>();
        InternalPluginProxyIf[] internalPluginProxies = InternalPluginProxyList.getInstance().getAvailableProxys();
        Arrays.sort(internalPluginProxies, new InternalPluginProxyIf.Comparator());
        for (InternalPluginProxyIf internalPluginProxy : internalPluginProxies) {
            if (!filterItem.accept(internalPluginProxy)) continue;
            this.mTableModel.addRow(new Object[]{true, internalPluginProxy});
            if (this.mFilterBox.getItemCount() >= 1) continue;
            int index = 0;
            for (int i = 0; i < filterItemList.size(); ++i) {
                int compareValue = ((SoftwareUpdateDlg.FilterItem)filterItemList.get(i)).compareTo(internalPluginProxy.getPluginCategory());
                if (compareValue == 0) {
                    index = -1;
                    break;
                }
                if (compareValue >= 0) continue;
                index = i + 1;
            }
            if (index == -1) continue;
            filterItemList.add(index, new SoftwareUpdateDlg.FilterItem(internalPluginProxy.getPluginCategory()));
        }
        PluginProxy[] pluginList = PluginProxyManager.getInstance().getAllPlugins();
        TvDataServiceProxy[] services = TvDataServiceProxyManager.getInstance().getDataServices();
        InfoIf[] infoArr = new InfoIf[pluginList.length + services.length];
        System.arraycopy(pluginList, 0, infoArr, 0, pluginList.length);
        System.arraycopy(services, 0, infoArr, pluginList.length, services.length);
        Arrays.sort(infoArr, new PluginAndDataServiceComparator());
        for (InfoIf info : infoArr) {
            if (!filterItem.accept(info)) continue;
            this.mTableModel.addRow(new Object[]{info instanceof PluginProxy ? ((PluginProxy)info).isActivated() : true, info});
            if (this.mFilterBox.getItemCount() >= 1) continue;
            int index = 0;
            for (int i = 0; i < filterItemList.size(); ++i) {
                int compareValue = ((SoftwareUpdateDlg.FilterItem)filterItemList.get(i)).compareTo(info.getPluginCategory());
                if (compareValue == 0) {
                    index = -1;
                    break;
                }
                if (compareValue >= 0) continue;
                index = i + 1;
            }
            if (index == -1) continue;
            filterItemList.add(index, new SoftwareUpdateDlg.FilterItem(info.getPluginCategory()));
        }
        if (this.mFilterBox.getItemCount() < 1) {
            if (!filterItemList.contains(new SoftwareUpdateDlg.FilterItem("all"))) {
                filterItemList.add(0, new SoftwareUpdateDlg.FilterItem("all"));
            }
            for (SoftwareUpdateDlg.FilterItem item : filterItemList) {
                this.mFilterBox.addItem(item);
            }
        }
    }

    private void updateBtns() {
        int rowIndex = this.mTable.getSelectedRow();
        Object plugin = null;
        if (rowIndex >= 0) {
            plugin = this.mTable.getValueAt(rowIndex, 1);
        }
        this.mInfo.setEnabled(plugin != null && (plugin instanceof PluginProxy || plugin instanceof TvDataServiceProxy));
        this.mRemove.setEnabled(plugin != null && (plugin instanceof PluginProxy && PluginLoader.getInstance().isPluginDeletable((PluginProxy)plugin) || plugin instanceof TvDataServiceProxy && PluginLoader.getInstance().isDataServiceDeletable((TvDataServiceProxy)plugin)));
        this.mConfigure.setEnabled(plugin != null);
    }

    private void onStartStopBtnClicked(PluginProxy plugin) {
        if (plugin != null) {
            try {
                if (plugin.isActivated()) {
                    PluginProxyManager.getInstance().deactivatePlugin(plugin);
                } else {
                    PluginProxyManager.getInstance().activatePlugin(plugin, true);
                    try {
                        PluginProxyManager.getInstance().fireTvBrowserStartFinished(plugin);
                    }
                    catch (Throwable t) {
                        mLog.log(Level.WARNING, "A not catched error occured in 'fireTvBrowserStartFinishedThread' of Plugin '" + plugin + "'.", t);
                    }
                }
            }
            catch (TvBrowserException exc) {
                ErrorHandler.handle(exc);
            }
            this.mTable.repaint();
            this.updateBtns();
            this.mSettingsDialog.invalidateTree();
            this.mSettingsDialog.createPluginTreeItems();
            MainFrame.getInstance().getToolbar().updatePluginButtons();
        }
        String[] deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds();
        Settings.propDeactivatedPlugins.setStringArray(deactivatedPlugins);
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public Icon getIcon() {
        return TVBrowserIcons.plugin(16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("plugins", "Plugins");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (column == 0) {
            Cursor oldCursor = this.mTable.getCursor();
            this.mTable.setCursor(Cursor.getPredefinedCursor(3));
            Object plugin = this.mTableModel.getValueAt(row, 1);
            if (plugin instanceof PluginProxy) {
                this.onStartStopBtnClicked((PluginProxy)plugin);
            }
            this.mTable.setCursor(oldCursor);
        }
    }
}

