/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import util.io.NetworkUtilities;
import util.ui.EnhancedPanelBuilder;
import util.ui.Localizer;

public class NetworkSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(NetworkSettingsTab.class);
    private JSpinner mConnectionTimeout;
    private JSpinner mNetworkCheckTimeout;
    private JCheckBox mConnectionTest;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder("5dlu, pref, 3dlu, 0dlu:grow");
        pb.border(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        pb.addParagraph(mLocalizer.msg("connectionTestTitle", "Internet connection test"));
        pb.addRow();
        this.mConnectionTest = new JCheckBox(mLocalizer.msg("connectionTestText", "Internet connection test activated"), Settings.propInternetConnectionCheck.getBoolean());
        pb.add((Component)this.mConnectionTest, cc.xyw(2, pb.getRowCount(), 3));
        pb.addRow();
        this.mNetworkCheckTimeout = new JSpinner(new SpinnerNumberModel(Settings.propNetworkCheckTimeout.getInt() / 1000, 10, 90, 5));
        pb.add((Component)this.mNetworkCheckTimeout, cc.xy(2, pb.getRowCount()));
        final JLabel label = pb.addLabel(mLocalizer.msg("waitTime", "Seconds maximum waiting time for connection test"), cc.xy(4, pb.getRowCount()));
        pb.addRow();
        pb.add((Component)new JLabel(mLocalizer.msg("sites", "Websites used for checking")), cc.xyw(2, pb.getRowCount(), 3));
        pb.addRow();
        JList<String> urlList = new JList<String>(NetworkUtilities.getConnectionCheckUrls());
        urlList.setEnabled(false);
        pb.add((Component)new JScrollPane(urlList), cc.xyw(2, pb.getRowCount(), 3));
        this.mConnectionTest.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                NetworkSettingsTab.this.mNetworkCheckTimeout.setEnabled(enabled);
                label.setEnabled(enabled);
            }
        });
        this.mNetworkCheckTimeout.setEnabled(this.mConnectionTest.isSelected());
        label.setEnabled(this.mConnectionTest.isSelected());
        pb.addParagraph(mLocalizer.msg("cancelTime", "Timeout for not responding connections"));
        pb.addRow();
        this.mConnectionTimeout = new JSpinner(new SpinnerNumberModel(Settings.propDefaultNetworkConnectionTimeout.getInt() / 1000, 5, 60, 5));
        pb.add((Component)this.mConnectionTimeout, cc.xy(2, pb.getRowCount()));
        pb.addLabel(mLocalizer.msg("seconds", "Seconds"), cc.xy(4, pb.getRowCount()));
        return pb.getPanel();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("status", "network-transmit-receive", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Network");
    }

    @Override
    public void saveSettings() {
        Settings.propInternetConnectionCheck.setBoolean(this.mConnectionTest.isSelected());
        Settings.propDefaultNetworkConnectionTimeout.setInt((Integer)this.mConnectionTimeout.getValue() * 1000);
        Settings.propNetworkCheckTimeout.setInt((Integer)this.mNetworkCheckTimeout.getValue() * 1000);
    }
}

