/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormating;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormatingManager;
import tvbrowser.ui.mainframe.MainFrame;
import util.program.AbstractPluginProgramFormating;
import util.ui.LocalPluginProgramFormatingSettingsDialog;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.customizableitems.SortableItemList;

public class GlobalPluginProgramFormatingSettings
implements SettingsTab,
ActionListener {
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(GlobalPluginProgramFormatingSettings.class);
    private SortableItemList mConfigurations;
    private JButton mAdd;
    private JButton mEdit;
    private JButton mDelete;

    @Override
    public JPanel createSettingsPanel() {
        try {
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,default:grow,5dlu", "pref,5dlu,fill:default:grow,5dlu,pref,10dlu,pref"));
            pb.border(Borders.DIALOG);
            this.mConfigurations = new SortableItemList("", GlobalPluginProgramFormatingManager.getInstance().getAvailableGlobalPluginProgramFormatings());
            this.mConfigurations.getList().setSelectionMode(0);
            this.mConfigurations.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2) {
                        LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (AbstractPluginProgramFormating)GlobalPluginProgramFormatingSettings.this.mConfigurations.getList().getSelectedValue(), GlobalPluginProgramFormatingManager.getDefaultConfiguration(), true, true);
                        GlobalPluginProgramFormatingSettings.this.mConfigurations.getList().repaint();
                    }
                }
            });
            pb.addSeparator(mLocalizer.msg("title", "Plugin program formating"), cc.xyw(1, 1, 3));
            pb.add((Component)this.mConfigurations, cc.xy(2, 3));
            FormLayout layout = new FormLayout("default,5dlu,default,5dlu,default", "pref");
            layout.setColumnGroups(new int[][]{{1, 3, 5}});
            JPanel buttonPanel = new JPanel(layout);
            this.mAdd = new JButton(Localizer.getLocalization("i18n_add"));
            this.mAdd.setIcon(TVBrowserIcons.newIcon(16));
            this.mAdd.addActionListener(this);
            this.mEdit = new JButton(Localizer.getLocalization("i18n_edit"));
            this.mEdit.setIcon(TVBrowserIcons.edit(16));
            this.mEdit.setEnabled(false);
            this.mEdit.addActionListener(this);
            this.mDelete = new JButton(Localizer.getLocalization("i18n_delete"));
            this.mDelete.setIcon(TVBrowserIcons.delete(16));
            this.mDelete.setEnabled(false);
            this.mDelete.addActionListener(this);
            buttonPanel.add((Component)this.mAdd, cc.xy(1, 1));
            buttonPanel.add((Component)this.mEdit, cc.xy(3, 1));
            buttonPanel.add((Component)this.mDelete, cc.xy(5, 1));
            pb.add((Component)buttonPanel, cc.xy(2, 5));
            pb.addLabel(mLocalizer.msg("help", "<html>This list of formating can be used by several plugins. So a formating don't have to be entered in every plugin that should use the formating. The selection of the formating can be done in the settings of the plugin.</html>"), cc.xy(2, 7));
            this.mConfigurations.getList().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        GlobalPluginProgramFormatingSettings.this.mEdit.setEnabled(GlobalPluginProgramFormatingSettings.this.mConfigurations.getList().getSelectedIndex() != -1);
                        GlobalPluginProgramFormatingSettings.this.mDelete.setEnabled(GlobalPluginProgramFormatingSettings.this.mConfigurations.getList().getSelectedIndex() != -1);
                    }
                }
            });
            return pb.getPanel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Plugin program formating");
    }

    @Override
    public void saveSettings() {
        Object[] o = this.mConfigurations.getItems();
        if (o != null && o.length > 0) {
            GlobalPluginProgramFormating[] p = new GlobalPluginProgramFormating[o.length];
            for (int i = 0; i < o.length; ++i) {
                p[i] = (GlobalPluginProgramFormating)o[i];
            }
            GlobalPluginProgramFormatingManager.getInstance().setAvailableProgramConfigurations(p);
        } else {
            final GlobalPluginProgramFormating[] formating = new GlobalPluginProgramFormating[2];
            formating[0] = GlobalPluginProgramFormatingManager.getDefaultConfiguration();
            Thread t = new Thread("Plugin formating setting"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    formating[1] = GlobalPluginProgramFormatingManager.getTvPearlFormating();
                }
            };
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            GlobalPluginProgramFormatingManager.getInstance().setAvailableProgramConfigurations(formating);
        }
        GlobalPluginProgramFormatingManager.getInstance().store();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mAdd) {
            this.mConfigurations.addElement(GlobalPluginProgramFormatingManager.getDefaultConfiguration());
        } else if (e.getSource() == this.mDelete) {
            this.mConfigurations.removeElementAt(this.mConfigurations.getList().getSelectedIndex());
        } else if (e.getSource() == this.mEdit) {
            LocalPluginProgramFormatingSettingsDialog.createInstance(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), (AbstractPluginProgramFormating)this.mConfigurations.getList().getSelectedValue(), GlobalPluginProgramFormatingManager.getDefaultConfiguration(), true, true);
            this.mConfigurations.getList().repaint();
        }
    }
}

