/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.SettingsDialog;
import util.ui.Localizer;

public class ChannelIconAndNameSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelIconAndNameSettingsTab.class);
    private JRadioButton mShowIconAndNameInProgramTable;
    private JRadioButton mShowOnlyIconInProgramTable;
    private JRadioButton mShowOnlyNameInProgramTable;
    private JRadioButton mShowIconInProgramPanelPlugins;
    private JRadioButton mShowIconInProgramPanelNever;
    private JRadioButton mShowIconAndNameInChannelLists;
    private JRadioButton mShowOnlyIconInChannelLists;
    private JRadioButton mShowOnlyNameInChannelLists;
    private JCheckBox mShowTooltipInProgramTable;
    private JCheckBox mShowSortNumberInProgramTable;
    private JCheckBox mShowSortNumberInChannelLists;
    private static int INDEX_ICONS_PROGRAM_PANEL = -1;
    private SettingsDialog mDialogSettings;

    public ChannelIconAndNameSettingsTab(SettingsDialog dialogSettings) {
        this.mDialogSettings = dialogSettings;
    }

    @Override
    public JPanel createSettingsPanel() {
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, default:grow, default, 5dlu", "default,5dlu,default,default,default,5dlu,default,default,10dlu,default,5dlu,default,default,10dlu,default,5dlu,default,default,default,5dlu,default,fill:0dlu:grow,default"));
        pb.border(Borders.DIALOG);
        int y = 1;
        pb.addSeparator(mLocalizer.msg("programTable", "Program table"), CC.xyw(1, y++, 4));
        this.mShowIconAndNameInProgramTable = new JRadioButton(mLocalizer.msg("showIconAndName", "Show channel icon and channel name"), Settings.propShowChannelIconsInProgramTable.getBoolean() && Settings.propShowChannelNamesInProgramTable.getBoolean());
        pb.add((Component)this.mShowIconAndNameInProgramTable, CC.xyw(2, ++y, 2));
        this.mShowOnlyIconInProgramTable = new JRadioButton(mLocalizer.msg("showOnlyIcon", "Show channel icon"), Settings.propShowChannelIconsInProgramTable.getBoolean() && !Settings.propShowChannelNamesInProgramTable.getBoolean());
        pb.add((Component)this.mShowOnlyIconInProgramTable, CC.xyw(2, ++y, 2));
        this.mShowOnlyNameInProgramTable = new JRadioButton(mLocalizer.msg("showOnlyName", "Show channel name"), Settings.propShowChannelNamesInProgramTable.getBoolean() && !Settings.propShowChannelIconsInProgramTable.getBoolean());
        pb.add((Component)this.mShowOnlyNameInProgramTable, CC.xyw(2, ++y, 2));
        y += 2;
        this.mShowSortNumberInProgramTable = new JCheckBox(mLocalizer.msg("showChannelNumber", "Show sort number"), Settings.propShowSortNumberInProgramTable.getBoolean());
        pb.add((Component)this.mShowSortNumberInProgramTable, CC.xy(2, y++));
        this.mShowTooltipInProgramTable = new JCheckBox(mLocalizer.msg("showToolTip", "Show large channel icons in tooltip"), Settings.propShowChannelTooltipInProgramTable.getBoolean());
        pb.add((Component)this.mShowTooltipInProgramTable, CC.xy(2, y));
        this.mShowTooltipInProgramTable.setEnabled(!this.mShowOnlyNameInProgramTable.isSelected());
        this.mShowOnlyNameInProgramTable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ChannelIconAndNameSettingsTab.this.mShowTooltipInProgramTable.setEnabled(e.getStateChange() == 2);
            }
        });
        ButtonGroup programTable = new ButtonGroup();
        programTable.add(this.mShowIconAndNameInProgramTable);
        programTable.add(this.mShowOnlyIconInProgramTable);
        programTable.add(this.mShowOnlyNameInProgramTable);
        y += 2;
        pb.addSeparator(mLocalizer.msg("programPanels", "Program panels"), CC.xyw(1, y++, 4));
        this.mShowIconInProgramPanelPlugins = new JRadioButton(mLocalizer.msg("showLogoPlugins", "Plugins decide showing of channel logos"), Settings.propShowChannelLogoForProgramPanel.getInt() == 0);
        pb.add((Component)this.mShowIconInProgramPanelPlugins, CC.xyw(2, ++y, 2));
        this.mShowIconInProgramPanelNever = new JRadioButton(mLocalizer.msg("showLogoNever", "Channel logos are never shown"), Settings.propShowChannelLogoForProgramPanel.getInt() == 1);
        pb.add((Component)this.mShowIconInProgramPanelNever, CC.xyw(2, ++y, 2));
        if (INDEX_ICONS_PROGRAM_PANEL == -1) {
            INDEX_ICONS_PROGRAM_PANEL = Settings.propShowChannelLogoForProgramPanel.getInt();
        }
        ButtonGroup programPanels = new ButtonGroup();
        programPanels.add(this.mShowIconInProgramPanelPlugins);
        programPanels.add(this.mShowIconInProgramPanelNever);
        y += 2;
        pb.addSeparator(mLocalizer.msg("channelLists", "Channel lists"), CC.xyw(1, y++, 4));
        this.mShowIconAndNameInChannelLists = new JRadioButton(mLocalizer.msg("showIconAndName", "Show channel icon and channel name"), Settings.propShowChannelIconsInChannellist.getBoolean() && Settings.propShowChannelNamesInChannellist.getBoolean());
        pb.add((Component)this.mShowIconAndNameInChannelLists, CC.xyw(2, ++y, 2));
        this.mShowOnlyIconInChannelLists = new JRadioButton(mLocalizer.msg("showOnlyIcon", "Show channel icon"), Settings.propShowChannelIconsInChannellist.getBoolean() && !Settings.propShowChannelNamesInChannellist.getBoolean());
        pb.add((Component)this.mShowOnlyIconInChannelLists, CC.xyw(2, ++y, 2));
        this.mShowOnlyNameInChannelLists = new JRadioButton(mLocalizer.msg("showOnlyName", "Show channel name"), Settings.propShowChannelNamesInChannellist.getBoolean() && !Settings.propShowChannelIconsInChannellist.getBoolean());
        pb.add((Component)this.mShowOnlyNameInChannelLists, CC.xyw(2, ++y, 2));
        y += 2;
        this.mShowSortNumberInChannelLists = new JCheckBox(mLocalizer.msg("showChannelNumber", "Show sort number"), Settings.propShowSortNumberInProgramLists.getBoolean());
        pb.add((Component)this.mShowSortNumberInChannelLists, CC.xyw(2, y++, 2));
        ButtonGroup channelLists = new ButtonGroup();
        channelLists.add(this.mShowIconAndNameInChannelLists);
        channelLists.add(this.mShowOnlyIconInChannelLists);
        channelLists.add(this.mShowOnlyNameInChannelLists);
        final JLabel restartInfo = new JLabel(mLocalizer.msg("restartNote", "For the changes to take effect TV-Browser has to be restarted."));
        restartInfo.setForeground(Color.red);
        restartInfo.setVisible(INDEX_ICONS_PROGRAM_PANEL != Settings.propShowChannelLogoForProgramPanel.getInt());
        final JButton restart = new JButton(mLocalizer.msg("restart", "Restart now"));
        restart.setVisible(restartInfo.isVisible());
        restart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelIconAndNameSettingsTab.this.mDialogSettings.saveSettings();
                TVBrowser.addRestart();
                MainFrame.getInstance().quit();
            }
        });
        ItemListener pluginProgramPanelLogoListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    boolean showRestart = ChannelIconAndNameSettingsTab.this.mShowIconInProgramPanelPlugins.equals(e.getItem()) && INDEX_ICONS_PROGRAM_PANEL != 0 || ChannelIconAndNameSettingsTab.this.mShowIconInProgramPanelNever.equals(e.getItem()) && INDEX_ICONS_PROGRAM_PANEL != 1;
                    restartInfo.setVisible(showRestart);
                    restart.setVisible(showRestart);
                }
            }
        };
        this.mShowIconInProgramPanelNever.addItemListener(pluginProgramPanelLogoListener);
        this.mShowIconInProgramPanelPlugins.addItemListener(pluginProgramPanelLogoListener);
        pb.add((Component)restartInfo, CC.xyw(1, ++y, 2));
        pb.add((Component)restart, CC.xy(3, y));
        return pb.getPanel();
    }

    @Override
    public void saveSettings() {
        Settings.propShowChannelIconsInProgramTable.setBoolean(this.mShowIconAndNameInProgramTable.isSelected() || this.mShowOnlyIconInProgramTable.isSelected());
        Settings.propShowChannelNamesInProgramTable.setBoolean(this.mShowIconAndNameInProgramTable.isSelected() || this.mShowOnlyNameInProgramTable.isSelected());
        if (this.mShowIconInProgramPanelPlugins.isSelected()) {
            Settings.propShowChannelLogoForProgramPanel.setInt(0);
        } else {
            Settings.propShowChannelLogoForProgramPanel.setInt(1);
        }
        Settings.propShowChannelIconsInChannellist.setBoolean(this.mShowIconAndNameInChannelLists.isSelected() || this.mShowOnlyIconInChannelLists.isSelected());
        Settings.propShowChannelNamesInChannellist.setBoolean(this.mShowIconAndNameInChannelLists.isSelected() || this.mShowOnlyNameInChannelLists.isSelected());
        Settings.propShowSortNumberInProgramTable.setBoolean(this.mShowSortNumberInProgramTable.isSelected());
        Settings.propShowChannelTooltipInProgramTable.setBoolean(this.mShowTooltipInProgramTable.isSelected());
        Settings.propShowSortNumberInProgramLists.setBoolean(this.mShowSortNumberInChannelLists.isSelected());
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Channel icons and names");
    }
}

