/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Plugin;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.settings.TrayOnTimeSettingsTab;
import util.ui.CaretPositionCorrector;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.TabLayout;
import util.ui.UiUtilities;

public class ButtonsSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ButtonsSettingsTab.class);
    private JPanel mSettingsPn;
    private TimesListPanel mTimeButtonsPn;

    @Override
    public JPanel createSettingsPanel() {
        this.mSettingsPn = new JPanel(new FormLayout("5dlu, pref, fill:pref:grow", "pref, 5dlu, fill:pref:grow, pref"));
        this.mSettingsPn.setBorder(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("buttons.time", "Time buttons")), cc.xyw(1, 1, 3));
        this.mTimeButtonsPn = new TimesListPanel(Settings.propTimeButtons.getIntArray());
        JScrollPane pane = new JScrollPane(this.mTimeButtonsPn);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.mSettingsPn.add((Component)pane, cc.xy(2, 3));
        if (TVBrowser.isUsingSystemTray()) {
            JEditorPane helpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("info", "The times of the  buttons are also used for the '<a href=\"#link\">{0}</a>' in the tray menu.", TrayOnTimeSettingsTab.getName()), new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Plugin.getPluginManager().showSettings("#trayOnTime");
                    }
                }
            });
            this.mSettingsPn.add((Component)helpLabel, cc.xyw(1, 4, 3));
        }
        return this.mSettingsPn;
    }

    @Override
    public void saveSettings() {
        int[] times = this.mTimeButtonsPn.getTimes();
        Arrays.sort(times);
        Settings.propTimeButtons.setIntArray(times);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "scroll-to-specific-time", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("buttons", "Buttons");
    }

    private static class Row
    extends JPanel {
        private JButton mRemoveBtn;
        private TimePanel mTimePn;

        public Row(int time) {
            this.setLayout(new BorderLayout());
            this.mRemoveBtn = new JButton(TVBrowserIcons.delete(16));
            this.mRemoveBtn.setToolTipText(Localizer.getLocalization("i18n_delete"));
            JPanel row = new JPanel(new TabLayout(2, 14, 0));
            this.mTimePn = new TimePanel(time);
            row.add(this.mTimePn);
            row.add(this.mRemoveBtn);
            this.add((Component)row, "West");
        }

        public JButton getRemoveButton() {
            return this.mRemoveBtn;
        }

        public int getTime() {
            return this.mTimePn.getTime();
        }
    }

    private static class TimesListPanel
    extends JPanel {
        private ArrayList<Row> mRows = new ArrayList();
        private JPanel mListPn;

        public TimesListPanel(int[] times) {
            this.setLayout(new FormLayout("right:pref, fill:pref:grow", "pref, 3dlu, pref"));
            CellConstraints cc = new CellConstraints();
            this.mListPn = new JPanel();
            this.mListPn.setLayout(new BoxLayout(this.mListPn, 1));
            this.add((Component)this.mListPn, cc.xy(1, 1));
            for (int time : times) {
                final Row row = new Row(time);
                row.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                this.mRows.add(row);
                row.getRemoveButton().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg) {
                        TimesListPanel.this.mRows.remove(row);
                        TimesListPanel.this.updateContent();
                    }
                });
            }
            JButton newBtn = new JButton(mLocalizer.msg("new", "New"), TVBrowserIcons.newIcon(16));
            JPanel southPn = new JPanel(new BorderLayout());
            southPn.add((Component)newBtn, "West");
            this.add((Component)southPn, cc.xyw(1, 3, 2));
            newBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    final Row row = new Row(0);
                    TimesListPanel.this.mRows.add(row);
                    row.getRemoveButton().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg) {
                            TimesListPanel.this.mRows.remove(row);
                            TimesListPanel.this.updateContent();
                        }
                    });
                    TimesListPanel.this.updateContent();
                }
            });
            this.updateContent();
        }

        private void updateContent() {
            this.mListPn.removeAll();
            for (int i = 0; i < this.mRows.size(); ++i) {
                Row row = this.mRows.get(i);
                this.mListPn.add(row);
            }
            this.mListPn.updateUI();
        }

        public int[] getTimes() {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < this.mRows.size(); ++i) {
                int value = this.mRows.get(i).getTime();
                if (list.contains(value)) continue;
                list.add(value);
            }
            int[] result = new int[list.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (Integer)list.get(i);
            }
            return result;
        }
    }

    private static class TimePanel
    extends JPanel {
        private JSpinner mTimeSp;

        public TimePanel(int minutes) {
            this.setLayout(new BorderLayout());
            this.mTimeSp = new JSpinner(new SpinnerDateModel());
            JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.mTimeSp, Settings.getTimePattern());
            this.mTimeSp.setEditor(dateEditor);
            CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
            this.add((Component)this.mTimeSp, "East");
            this.setTime(minutes);
        }

        public void setTime(int minutes) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, minutes / 60);
            cal.set(12, minutes % 60);
            this.mTimeSp.setValue(cal.getTime());
        }

        public int getTime() {
            Date time = (Date)this.mTimeSp.getValue();
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            return cal.get(11) * 60 + cal.get(12);
        }

        @Override
        public void setEnabled(boolean val) {
            this.mTimeSp.setEnabled(val);
        }
    }
}

