/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable.background;

import devplugin.Date;
import devplugin.Program;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.background.AbstractBackPainter;
import util.io.IOUtilities;
import util.ui.ProgramPanel;
import util.ui.TimeFormatter;

public class UiTimeBlockBackPainter
extends AbstractBackPainter {
    private static final Font TABLE_WEST_FONT = new Font("Dialog", 0, 14);
    private static final Color TABLE_WEST_FONT_COLOR = Color.DARK_GRAY;
    private int mBlockSize;
    private TimeBlock[] mBlockArr;
    private JComponent mTableWest;
    private TimeFormatter mFormatter = Settings.propTwelveHourFormat.getBoolean() ? new TimeFormatter("hh a") : new TimeFormatter("HH");
    private Color mLineColor;
    private static final int DEFAULT_ALPHA = 35;
    private static final int EXPIRED_ALPHA = 20;

    public UiTimeBlockBackPainter() {
        this.mTableWest = Settings.propTimeBlockShowWest.getBoolean() ? new TimeBlockTableWest() : null;
        Color c = UIManager.getColor("List.foreground");
        Color c1 = UIManager.getColor("List.background");
        int r = c.getRed() + c1.getRed() >> 1;
        int g = c.getGreen() + c1.getGreen() >> 1;
        int b = c.getBlue() + c1.getBlue() >> 1;
        this.mLineColor = new Color(r, g, b);
        double test2 = 0.2126 * (double)c1.getRed() + 0.7152 * (double)c1.getGreen() + 0.0722 * (double)c1.getBlue();
        double test1 = 0.2126 * (double)this.mLineColor.getRed() + 0.7152 * (double)this.mLineColor.getGreen() + 0.0722 * (double)this.mLineColor.getBlue();
        if (test2 - test1 > 90.0) {
            this.mLineColor = new Color(this.mLineColor.getRed() + 30, this.mLineColor.getGreen() + 30, this.mLineColor.getBlue() + 30);
        } else if (test2 - test1 < -90.0) {
            this.mLineColor = this.mLineColor.darker();
        }
        this.mBlockSize = Settings.propTimeBlockSize.getInt();
    }

    @Override
    public void layoutChanged(ProgramTableLayout layout, ProgramTableModel model) {
        this.mBlockArr = this.createBlockArray(layout, model);
    }

    @Override
    public void paintBackground(Graphics grp, int columnWidth, int tableHeight, int minCol, int maxCol, Rectangle clipBounds, ProgramTableLayout layout, ProgramTableModel model) {
        int minY;
        grp.setColor(UIManager.getColor("List.background"));
        grp.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        TimeBlock[] blockArr = this.createBlockArray(layout, model);
        boolean toggleFlag = true;
        int maxY = -1;
        for (int i = 0; i < blockArr.length; ++i) {
            minY = blockArr[i].mStartY;
            maxY = i + 1 < blockArr.length ? blockArr[i + 1].mStartY : tableHeight;
            int x = minCol * columnWidth;
            for (int col = minCol; col <= maxCol; ++col) {
                Color c;
                int alpha = 35;
                int time = IOUtilities.getMinutesAfterMidnight();
                if (Date.getCurrentDate().compareTo(MainFrame.getInstance().getCurrentSelectedDate()) > 0) {
                    time += 1440;
                }
                if (blockArr[i].mStartTime + this.mBlockSize * 60 < time) {
                    alpha = 20;
                }
                if (toggleFlag) {
                    c = UIManager.getColor("List.background");
                    grp.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                } else {
                    c = UIManager.getColor("List.foreground");
                    grp.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                }
                grp.fillRect(x, minY, columnWidth, maxY - minY);
                grp.setColor(this.mLineColor);
                grp.drawLine(x, minY, x, maxY);
                x += columnWidth;
            }
            toggleFlag = !toggleFlag;
        }
        if (maxY < tableHeight) {
            minY = maxY + 1;
            maxY = tableHeight;
            int x = minCol * columnWidth;
            for (int col = minCol; col <= maxCol; ++col) {
                Color c;
                if (toggleFlag) {
                    c = UIManager.getColor("List.background");
                    grp.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 35));
                } else {
                    c = UIManager.getColor("List.foreground");
                    grp.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 35));
                }
                grp.fillRect(x, minY, columnWidth, maxY - minY);
                grp.setColor(this.mLineColor);
                grp.drawLine(x, minY, x, maxY);
                x += columnWidth;
            }
        }
    }

    private TimeBlock[] createBlockArray(ProgramTableLayout layout, ProgramTableModel model) {
        int blockCount = 48 / this.mBlockSize;
        TimeBlock[] blocks = new TimeBlock[blockCount];
        for (int i = 0; i < blockCount; ++i) {
            blocks[i] = new TimeBlock(i * this.mBlockSize * 60);
        }
        Date mainDate = ((DefaultProgramTableModel)model).getDate();
        int columnCount = model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            int y = layout.getColumnStart(col);
            int rowCount = model.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                int blockIndex;
                TimeBlock block;
                int blockY;
                ProgramPanel panel = model.getProgramPanel(col, row);
                if (panel == null) continue;
                Program prog = panel.getProgram();
                int startTime = prog.getStartTime();
                if (!mainDate.equals(prog.getDate())) {
                    startTime += 1440;
                }
                if ((blockY = (block = blocks[blockIndex = startTime / (this.mBlockSize * 60)]).mStartY) == -1 || y < blockY) {
                    block.mStartY = y;
                }
                y += panel.getHeight();
            }
        }
        ArrayList<TimeBlock> list = new ArrayList<TimeBlock>();
        for (int i = 0; i < blockCount; ++i) {
            if (blocks[i].mStartY == -1) continue;
            list.add(blocks[i]);
        }
        return list.toArray(new TimeBlock[list.size()]);
    }

    @Override
    public JComponent getTableWest() {
        return this.mTableWest;
    }

    class TimeBlockTableWest
    extends JComponent {
        private FontMetrics mFontMetrics = this.getFontMetrics(UiTimeBlockBackPainter.access$200());

        @Override
        public Dimension getPreferredSize() {
            int width = this.mFontMetrics.stringWidth(UiTimeBlockBackPainter.this.mFormatter.formatTime(23, 0)) + 4;
            int height = 1000000;
            return new Dimension(width, height);
        }

        @Override
        public void paintComponent(Graphics grp) {
            TimeBlock[] blockArr = UiTimeBlockBackPainter.this.mBlockArr;
            if (blockArr != null && blockArr.length > 0) {
                grp.setColor(UIManager.getColor("List.background"));
                grp.fillRect(0, 0, this.getWidth(), this.getHeight());
                boolean toggleFlag = false;
                int width = this.getWidth();
                int height = this.getHeight();
                Rectangle clipBounds = grp.getClipBounds();
                grp.setFont(TABLE_WEST_FONT);
                grp.setColor(TABLE_WEST_FONT_COLOR);
                for (int i = 0; i < blockArr.length; ++i) {
                    Color c;
                    int maxY;
                    toggleFlag = !toggleFlag;
                    int minY = blockArr[i].mStartY;
                    if (!clipBounds.intersects(0.0, minY, width, (maxY = i + 1 < blockArr.length ? blockArr[i + 1].mStartY : height) - minY)) continue;
                    int alpha = 35;
                    int time = IOUtilities.getMinutesAfterMidnight();
                    if (Date.getCurrentDate().compareTo(MainFrame.getInstance().getCurrentSelectedDate()) > 0) {
                        time += 1440;
                    }
                    if (blockArr[i].mStartTime + UiTimeBlockBackPainter.this.mBlockSize * 60 < time) {
                        alpha = 20;
                    }
                    if (toggleFlag) {
                        c = UIManager.getColor("List.background");
                        grp.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                    } else {
                        c = UIManager.getColor("List.foreground");
                        grp.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                    }
                    grp.fillRect(0, minY, width, maxY - minY);
                    String msg = UiTimeBlockBackPainter.this.mFormatter.formatTime(blockArr[i].mStartTime / 60 % 24, 0);
                    int msgWidth = this.mFontMetrics.stringWidth(msg);
                    int x = width - msgWidth - 2;
                    if (alpha == 35) {
                        grp.setColor(UIManager.getColor("List.foreground"));
                    } else {
                        grp.setColor(Color.gray);
                    }
                    grp.drawString(msg, x, minY + TABLE_WEST_FONT.getSize());
                }
            }
        }
    }

    private static class TimeBlock {
        private int mStartTime;
        private int mStartY;

        public TimeBlock(int startTime) {
            this.mStartTime = startTime;
            this.mStartY = -1;
        }
    }
}

