/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable.background;

import devplugin.Program;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import tvbrowser.ui.programtable.ProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.background.AbstractBackPainter;
import util.ui.ProgramPanel;

public abstract class AbstractCellBasedBackPainter
extends AbstractBackPainter {
    @Override
    public void paintBackground(Graphics grp, int columnWidth, int tableHeight, int minCol, int maxCol, Rectangle clipBounds, ProgramTableLayout layout, ProgramTableModel model) {
        int x = minCol * columnWidth;
        for (int col = minCol; col <= maxCol; ++col) {
            int y = layout.getColumnStart(col);
            this.fillImage(grp, x, 0, columnWidth, y, this.getOuterBackgroundImage(), clipBounds);
            int rowCount = model.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = model.getProgramPanel(col, row);
                if (panel == null) continue;
                int cellHeight = panel.getHeight();
                Image backImg = this.getBackgroundImageFor(panel.getProgram());
                this.fillImage(grp, x, y, columnWidth, cellHeight, backImg, clipBounds);
                y += cellHeight;
            }
            this.fillImage(grp, x, y, columnWidth, tableHeight - y, this.getOuterBackgroundImage(), clipBounds);
            x += columnWidth;
        }
    }

    protected abstract Image getOuterBackgroundImage();

    protected abstract Image getBackgroundImageFor(Program var1);
}

