/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview.contextmenu;

import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.pluginview.Node;
import tvbrowser.ui.pluginview.PluginTree;
import tvbrowser.ui.pluginview.contextmenu.AbstractContextMenu;
import util.ui.Localizer;
import util.ui.menu.MenuUtil;

public class ProgramContextMenu
extends AbstractContextMenu {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramContextMenu.class);
    private TreePath[] mPaths;
    private Action mDefaultAction;
    private Program[] mPrograms;

    public ProgramContextMenu(PluginTree tree, TreePath[] paths, Plugin plugin, Program[] programs) {
        super(tree);
        this.mPaths = paths;
        this.mPrograms = programs;
        this.mDefaultAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node node = (Node)ProgramContextMenu.this.mPaths[0].getLastPathComponent();
                ProgramItem programItem = (ProgramItem)node.getUserObject();
                MainFrame.getInstance().selectProgram(programItem.getProgram(), true);
                MainFrame.getInstance().showProgramTableTabIfAvailable();
            }
        };
        this.mDefaultAction.putValue("Name", mLocalizer.msg("show", "show"));
    }

    @Override
    public JPopupMenu getPopupMenu() {
        Component[] comps;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem showMI = new JMenuItem(this.mDefaultAction);
        showMI.setFont(MenuUtil.CONTEXT_MENU_BOLDFONT);
        showMI.setEnabled(this.mPaths.length == 1);
        menu.add(showMI);
        menu.add(this.getExportMenu(this.mPaths[0]));
        menu.addSeparator();
        JMenu menus = ContextMenuManager.getInstance().createContextMenuItems(null, this.mPrograms[0], false);
        for (Component comp : comps = menus.getMenuComponents()) {
            menu.add(comp);
            comp.setEnabled(this.mPrograms.length == 1);
        }
        return menu;
    }

    @Override
    public Action getDefaultAction() {
        if (this.mPaths.length == 1) {
            return this.mDefaultAction;
        }
        return null;
    }
}

