/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.ui.mainframe.MainFrame;
import util.browserlauncher.Launch;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class PluginInformationDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginInformationDialog.class);

    public PluginInformationDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.init();
    }

    private void init() {
        this.setTitle(mLocalizer.msg("title", "TV-Browser is able to do much more"));
        UiUtilities.registerForClosing(this);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("default:grow,default,default:grow", "default,fill:default:grow,default"), (JPanel)this.getContentPane());
        JLabel l = pb.addLabel(mLocalizer.msg("header", "Important information about TV-Browser functionality!"), cc.xy(2, 1));
        l.setForeground(new Color(200, 0, 0));
        l.setFont(l.getFont().deriveFont(1, 20.0f));
        l.setBorder(Borders.createEmptyBorder("10dlu,0dlu,5dlu,0dlu"));
        JEditorPane pane = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("text", "<div style=\"font-size:medium;text-align:justify\"><p>TV-Browser can be extended with additional functions (plugins), for instance to control hardware, to load other data sources, to load ratings from IMDb and much more.</p><p>You also can find more plugins <a href=\"http://www.tvbrowser.org/downloads-mainmenu-5/plugins-mainmenu-24.html\">on our website</a>, that are currently not available for download from within TV-Browser, but are mostly already usable.</p><p>Do you want to see the list with the Plugins available through download from TV-Browser?<br>(You also can always open that list over the Plugins menu.)</p></div>"), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Launch.openURL(e.getURL().toString());
                }
            }
        }, UIManager.getColor("EditorPane.background"));
        pane.setPreferredSize(new Dimension(400, 300));
        pane.setBackground(UIManager.getColor("List.background"));
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), Borders.createEmptyBorder("0dlu,10dlu,0dlu,10dlu")));
        pb.add((Component)pane, cc.xyw(1, 2, 3));
        JComponent[] buttons = new JButton[]{new JButton(mLocalizer.msg("showList", "Show the list with the Plugins now")), new JButton(mLocalizer.msg("closeDialog", "Close this dialog"))};
        buttons[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showUpdatePluginsDlg(true);
                PluginInformationDialog.this.close();
            }
        });
        buttons[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginInformationDialog.this.close();
            }
        });
        buttons[0].setFont(buttons[0].getFont().deriveFont(1, 13.0f));
        buttons[1].setFont(buttons[1].getFont().deriveFont(1, 13.0f));
        this.getRootPane().setDefaultButton(buttons[0]);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.getPanel().setOpaque(true);
        bb.addGlue();
        bb.addButton(buttons);
        bb.addGlue();
        bb.setBorder(Borders.createEmptyBorder("6dlu,6dlu,6dlu,6dlu"));
        pb.add((Component)bb.getPanel(), cc.xyw(1, 3, 3));
        pb.getPanel().setBackground(UIManager.getColor("EditorPane.background"));
        pb.getPanel().setOpaque(true);
    }

    @Override
    public void close() {
        this.dispose();
    }
}

