/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

class PanelButton
extends JButton {
    public PanelButton(final JPanel panel, final JDialog dialog) {
        super(panel.isVisible() ? "<<" : ">>");
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.setVisible(!panel.isVisible());
                if (panel.isVisible()) {
                    PanelButton.this.setText("<<");
                } else {
                    PanelButton.this.setText(">>");
                }
                dialog.pack();
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private Thread mWaiting;

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.mWaiting != null && this.mWaiting.isAlive()) {
                    this.mWaiting.interrupt();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.mWaiting != null && this.mWaiting.isAlive()) {
                    this.mWaiting.interrupt();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.mWaiting == null || !this.mWaiting.isAlive()) {
                    this.mWaiting = new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(750L);
                                panel.setVisible(!panel.isVisible());
                                if (panel.isVisible()) {
                                    PanelButton.this.setText("<<");
                                } else {
                                    PanelButton.this.setText(">>");
                                }
                                dialog.pack();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    };
                    this.mWaiting.start();
                }
            }
        });
    }
}

