/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.finder;

import devplugin.Date;
import devplugin.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import tvbrowser.core.DateListener;
import tvbrowser.core.TvDataBase;
import tvbrowser.ui.finder.AbstractDateSelector;
import tvbrowser.ui.finder.DateSelector;
import tvbrowser.ui.finder.FinderItem;
import tvbrowser.ui.finder.FinderItemRenderer;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.Localizer;

public class FinderPanel
extends AbstractDateSelector
implements DateSelector,
MouseMotionListener,
KeyListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FinderPanel.class);
    private DateListener mDateChangedListener;
    private JList mList;
    private DefaultListModel mModel;
    private FinderItemRenderer mRenderer;
    private int mCurMouseItemInx = -1;
    private JScrollPane mScrollPane = new JScrollPane();

    public FinderPanel(KeyListener keyListener) {
        this.mScrollPane.addKeyListener(keyListener);
        this.mScrollPane.getVerticalScrollBar().addKeyListener(keyListener);
        this.mScrollPane.getHorizontalScrollBar().addKeyListener(keyListener);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mScrollPane, "Center");
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mModel = new DefaultListModel();
        this.mList = new JList(this.mModel);
        this.mList.setOpaque(false);
        this.mList.addKeyListener(keyListener);
        this.mRenderer = new FinderItemRenderer();
        this.mList.setCellRenderer(this.mRenderer);
        this.mScrollPane.setViewportView(this.mList);
        this.mScrollPane.getViewport().addKeyListener(keyListener);
        this.updateContent();
        this.mList.addMouseMotionListener(this);
        this.mList.addMouseListener(this);
        this.mList.addKeyListener(this);
        this.markDate(this.mToday, true);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    protected void rebuildControls() {
        Date date = this.getFirstDate();
        this.mToday = Date.getCurrentDate();
        this.mModel.removeAllElements();
        Date maxDate = TvDataBase.getInstance().getMaxSupportedDate();
        while (maxDate.getNumberOfDaysSince(date) >= 0) {
            FinderItem fi = new FinderItem(this.mList, date, this.mToday);
            this.mModel.addElement(fi);
            if (date.equals(this.getSelectedDate())) {
                this.mRenderer.setSelectedItem(fi);
                this.mList.setSelectedValue(fi, false);
            }
            date = date.addDays(1);
        }
        this.mList.repaint();
    }

    @Override
    public void setDateListener(DateListener dateChangedListener) {
        this.mDateChangedListener = dateChangedListener;
    }

    public ProgressMonitor getProgressMonitorForDate(Date date) {
        Object[] objects;
        for (Object object : objects = this.mModel.toArray()) {
            FinderItem item = (FinderItem)object;
            this.mRenderer.setSelectedItem(item);
            if (!item.getDate().equals(date)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void markDate(Date d, boolean informPluginPanels) {
        this.markDate(d, null, informPluginPanels);
    }

    @Override
    public void updateItems() {
        Object[] o;
        for (Object element : o = this.mModel.toArray()) {
            FinderItem item = (FinderItem)element;
            if (item.isEnabled() || !this.isValidDate(item.getDate())) continue;
            item.setEnabled(true);
        }
        this.mList.repaint();
    }

    @Override
    public void markDate(Date d, Runnable callback, boolean informPluginPanels) {
        Object[] objects;
        if (d.equals(this.getSelectedDate())) {
            FinderItem item = (FinderItem)this.mList.getSelectedValue();
            if (item != null && item.isEnabled()) {
                item.startProgress(this.mDateChangedListener, callback, informPluginPanels);
            } else if (callback != null) {
                callback.run();
            }
            return;
        }
        for (Object object : objects = this.mModel.toArray()) {
            FinderItem item = (FinderItem)object;
            if (!item.getDate().equals(d)) continue;
            if (item.isEnabled()) {
                this.setCurrentDate(d);
                this.mRenderer.setSelectedItem(item);
                this.mList.setSelectedValue(item, true);
                item.startProgress(this.mDateChangedListener, callback, informPluginPanels);
            } else {
                this.askForDataUpdate(d);
            }
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.mList.clearSelection();
        this.mCurMouseItemInx = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            int index = this.mList.locationToIndex(e.getPoint());
            this.markDate(((FinderItem)this.mModel.getElementAt(index)).getDate(), true);
            MainFrame.getInstance().addKeyboardAction();
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int index = this.mList.locationToIndex(event.getPoint());
        if (index != this.mCurMouseItemInx) {
            this.mCurMouseItemInx = index;
            this.mList.setSelectedIndex(index);
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        FinderItem item;
        if (event.getKeyCode() == 32 && (item = (FinderItem)this.mList.getSelectedValue()) != null) {
            this.markDate(item.getDate(), true);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

