/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.finder;

import devplugin.Date;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import tvbrowser.core.TvDataBase;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.Localizer;

public abstract class AbstractDateSelector
extends JPanel
implements MouseListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(AbstractDateSelector.class);
    private Date mCurChoosenDate = Date.getCurrentDate();
    protected Date mToday;

    protected abstract void markDate(Date var1, boolean var2);

    protected abstract void markDate(Date var1, Runnable var2, boolean var3);

    protected void setCurrentDate(Date d) {
        this.mCurChoosenDate = d;
    }

    protected boolean isValidDate(Date date) {
        return TvDataBase.getInstance().dataAvailable(date);
    }

    public void markPreviousDate() {
        this.markDate(this.mCurChoosenDate.addDays(-1), true);
    }

    public void markNextDate() {
        this.markDate(this.mCurChoosenDate.addDays(1), true);
    }

    public void markPreviousDate(Runnable callback) {
        this.markDate(this.mCurChoosenDate.addDays(-1), callback, true);
    }

    public void markNextDate(Runnable callback) {
        this.markDate(this.mCurChoosenDate.addDays(1), callback, true);
    }

    public void markNextWeek() {
        this.markDate(this.mCurChoosenDate.addDays(7), true);
    }

    public void markPreviousWeek() {
        this.markDate(this.mCurChoosenDate.addDays(-7), true);
    }

    public Date getSelectedDate() {
        return this.mCurChoosenDate;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    protected void showPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem update = new JMenuItem(mLocalizer.msg("update", "Update"));
        update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().updateTvData();
            }
        });
        menu.add(update);
        int x = e.getX() + ((JComponent)e.getSource()).getX();
        int y = e.getY() + ((JComponent)e.getSource()).getY();
        menu.show(this, x, y);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    public void updateContent() {
        Date date = Date.getCurrentDate();
        if (date.equals(this.mToday)) {
            return;
        }
        this.mToday = date;
        this.rebuildControls();
    }

    protected abstract void rebuildControls();

    protected Date getFirstDate() {
        return Date.getCurrentDate().addDays(-1);
    }

    protected final void askForDataUpdate(Date date) {
        int numberOfDays = date.getNumberOfDaysSince(Date.getCurrentDate());
        if (numberOfDays >= 0) {
            MainFrame.getInstance().askForDataUpdate(mLocalizer.msg("noDataFor", "No TV data available for {0}.", date.toString()), numberOfDays);
        }
    }
}

