/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.Program;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.ui.Localizer;

public class ReminderTableModel
extends AbstractTableModel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderTableModel.class);
    private static String mLastSelectedTitle = mLocalizer.msg("all", "All");
    private ReminderList mList;
    private ReminderListItem[] mProgramItems;
    private JComboBox mTitleFilterBox;
    private boolean mHandleBoxSelection;

    public ReminderTableModel(ReminderList list, JComboBox titleFilterBox) {
        ItemListener[] itemListeners;
        this.mList = list;
        this.mTitleFilterBox = titleFilterBox;
        this.mHandleBoxSelection = true;
        for (ItemListener itemListener : itemListeners = titleFilterBox.getItemListeners()) {
            titleFilterBox.removeItemListener(itemListener);
        }
        this.insertAvailableTitles();
        this.mTitleFilterBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ReminderTableModel.this.mHandleBoxSelection) {
                    mLastSelectedTitle = e.getItem().toString();
                    ReminderTableModel.this.updateTableEntries();
                }
            }
        });
        this.mProgramItems = this.getItemsForTitleSelection();
    }

    public synchronized void updateTableEntries() {
        this.mProgramItems = this.getItemsForTitleSelection();
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAvailableTitles() {
        ReminderList reminderList = this.mList;
        synchronized (reminderList) {
            this.mHandleBoxSelection = false;
            this.mTitleFilterBox.removeAllItems();
            ReminderListItem[] allItems = this.mList.getReminderItems();
            this.mTitleFilterBox.addItem(mLocalizer.msg("all", "All"));
            for (ReminderListItem item : allItems) {
                boolean found = false;
                int index = 0;
                for (int i = 0; i < this.mTitleFilterBox.getItemCount(); ++i) {
                    if (this.mTitleFilterBox.getItemAt(i).toString().compareToIgnoreCase(item.getProgram().getTitle()) < 0) {
                        index = i;
                    }
                    if (this.mTitleFilterBox.getItemAt(i) == null || item.getProgram() == null || !this.mTitleFilterBox.getItemAt(i).equals(item.getProgram().getTitle())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.mTitleFilterBox.insertItemAt(item.getProgram().getTitle(), index + 1);
            }
            this.mHandleBoxSelection = true;
            this.mTitleFilterBox.setSelectedItem(mLastSelectedTitle);
        }
    }

    private ReminderListItem[] getItemsForTitleSelection() {
        ArrayList<ReminderListItem> filteredList = new ArrayList<ReminderListItem>();
        ReminderListItem[] allItems = this.mList.getReminderItems();
        Program previous = null;
        for (ReminderListItem item : allItems) {
            if (item.getProgram().equals(PluginManagerImpl.getInstance().getExampleProgram()) || this.mTitleFilterBox.getSelectedIndex() != 0 && (this.mTitleFilterBox.getSelectedItem() == null || item == null || item.getProgram() == null || !this.mTitleFilterBox.getSelectedItem().equals(item.getProgram().getTitle()))) continue;
            if (ReminderPlugin.getInstance().showDateSeparators() && (previous == null || item.getProgram().getDate().compareTo(previous.getDate()) > 0)) {
                filteredList.add(ReminderListItem.SEPARATOR_ITEM);
            }
            filteredList.add(item);
            previous = item.getProgram();
        }
        return filteredList.toArray(new ReminderListItem[filteredList.size()]);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Localizer.getLocalization("i18n_programs");
            }
            case 1: {
                return mLocalizer.msg("timeMenu", "Reminder time");
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.mProgramItems.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            if (columnIndex == 0) {
                return this.mProgramItems[rowIndex].getProgram();
            }
            if (columnIndex == 1) {
                return this.mProgramItems[rowIndex];
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.mProgramItems[rowIndex].setMinutes((Integer)aValue);
        }
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }
}

