/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPropertyDefaults;
import tvbrowser.ui.mainframe.MainFrame;
import util.misc.PropertyDefaults;
import util.ui.DefaultMarkingPrioritySelectionPanel;
import util.ui.ExecuteSettingsDialog;
import util.ui.ExtensionFileFilter;
import util.ui.FileCheckBox;
import util.ui.Localizer;
import util.ui.PluginChooserDlg;
import util.ui.ScrollableJPanel;
import util.ui.UiUtilities;

public class ReminderSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderSettingsTab.class);
    private Properties mSettings = ReminderPlugin.getInstance().getSettings();
    private JCheckBox mReminderWindowChB;
    private JRadioButton[] mReminderWindowPosition;
    private FileCheckBox mSoundFileChB;
    private JCheckBox mBeep;
    private JCheckBox mExecChB;
    private JCheckBox mShowTimeSelectionDlg;
    private JCheckBox mShowRemovedDlg;
    private JCheckBox mShowTimeCounter;
    private JCheckBox mProvideTab;
    private JCheckBox mShowDateSeparators;
    private JButton mExecFileDialogBtn;
    private JCheckBox mShowAlwaysOnTop;
    private JSpinner mAutoCloseReminderTimeSp;
    private JRadioButton mCloseOnEnd;
    private JRadioButton mCloseNever;
    private JRadioButton mCloseOnTime;
    private JRadioButton mScrollTimeToNext;
    private JRadioButton mScrollTimeOnDay;
    private JComboBox mDefaultReminderEntryList;
    private String mExecFileStr;
    private String mExecParamStr;
    private Object mTestSound;
    private JLabel mPluginLabel;
    private ProgramReceiveTarget[] mClientPluginTargets;
    private DefaultMarkingPrioritySelectionPanel mMarkingsPanel;

    @Override
    public JPanel createSettingsPanel() {
        PropertyDefaults propDefaults = ReminderPropertyDefaults.getPropertyDefaults();
        propDefaults.setProperties(this.mSettings);
        FormLayout layout = new FormLayout("5dlu,pref,5dlu,pref,pref:grow,3dlu,pref,3dlu,pref,5dlu", "pref,5dlu,pref,1dlu,pref,1dlu,pref,1dlu,pref,10dlu,pref,5dlu,pref,10dlu,pref,5dlu,pref,10dlu,pref,5dlu,pref,10dlu,pref,5dlu,pref,3dlu,pref,3dlu,default,3dlu,default,default,10dlu,default,5dlu,pref");
        layout.setColumnGroups(new int[][]{{7, 9}});
        PanelBuilder pb = new PanelBuilder(layout, new ScrollableJPanel());
        pb.border(Borders.DIALOG);
        Object[] extArr = new String[]{".wav", ".aif", ".rmf", ".au", ".mid"};
        String soundFName = propDefaults.getValueFromProperties("soundfile");
        String msg = mLocalizer.msg("soundFileFilter", "Sound file ({0})", "*" + StringUtils.join(extArr, ", *"));
        this.mReminderWindowChB = new JCheckBox(mLocalizer.msg("reminderWindow", "Reminder window"), propDefaults.getValueFromProperties("usemsgbox").equalsIgnoreCase("true"));
        this.mShowAlwaysOnTop = new JCheckBox(mLocalizer.msg("alwaysOnTop", "Show always on top"), propDefaults.getValueFromProperties("alwaysOnTop").equalsIgnoreCase("true"));
        this.mShowAlwaysOnTop.setEnabled(this.mReminderWindowChB.isSelected());
        JPanel reminderWindowCfg = new JPanel(new FormLayout("12dlu,default:grow", "default,1dlu,default,1dlu,default,1dlu,default"));
        reminderWindowCfg.add((Component)this.mReminderWindowChB, CC.xyw(1, 1, 2));
        reminderWindowCfg.add((Component)this.mShowAlwaysOnTop, CC.xy(2, 7));
        JPanel postionPanel = new JPanel(new FormLayout("default,default,default,default,default,default", "default,default,default,default,default,default"));
        int xPos = 1;
        int yPos = 1;
        int selected = Integer.parseInt(propDefaults.getValueFromProperties("reminderWindowPosition"));
        this.mReminderWindowPosition = new JRadioButton[13];
        ButtonGroup positionGroup = new ButtonGroup();
        for (int i = 0; i < 13; ++i) {
            this.mReminderWindowPosition[i] = new JRadioButton();
            this.mReminderWindowPosition[i].setSelected(i == selected);
            this.mReminderWindowPosition[i].setEnabled(this.mReminderWindowChB.isSelected());
            positionGroup.add(this.mReminderWindowPosition[i]);
            if (i == 3 || i == 8) {
                xPos = 2;
                ++yPos;
            } else if (i == 5 || i == 10) {
                xPos = 1;
                ++yPos;
            }
            postionPanel.add((Component)this.mReminderWindowPosition[i], CC.xy(xPos, yPos));
            xPos += 2;
        }
        final JLabel posLabel = new JLabel(mLocalizer.msg("positionOnScreen", "Position on screen"));
        posLabel.setEnabled(this.mReminderWindowChB.isSelected());
        reminderWindowCfg.add((Component)posLabel, CC.xy(2, 3));
        reminderWindowCfg.add((Component)postionPanel, CC.xy(2, 5));
        this.mSoundFileChB = new FileCheckBox(mLocalizer.msg("playlingSound", "Play sound"), new File(soundFName), 0, false);
        JFileChooser soundChooser = new JFileChooser();
        soundChooser.setFileFilter(new ExtensionFileFilter((String[])extArr, msg));
        this.mSoundFileChB.setFileChooser(soundChooser);
        this.mSoundFileChB.setSelected(this.mSettings.getProperty("usesound", "false").equals("true"));
        this.mBeep = new JCheckBox(mLocalizer.msg("beep", "Speaker sound"), this.mSettings.getProperty("usebeep", "true").equalsIgnoreCase("true"));
        this.mExecFileStr = this.mSettings.getProperty("execfile", "");
        this.mExecParamStr = this.mSettings.getProperty("execparam", "");
        final JButton soundTestBt = new JButton(mLocalizer.msg("test", "Test"));
        this.mExecChB = new JCheckBox(mLocalizer.msg("executeProgram", "Execute program"));
        this.mExecChB.setSelected(this.mSettings.getProperty("useexec", "false").equals("true"));
        this.mExecFileDialogBtn = new JButton(mLocalizer.msg("executeConfig", "Configure"));
        this.mExecFileDialogBtn.setEnabled(this.mExecChB.isSelected());
        this.mPluginLabel = new JLabel();
        JButton choose = new JButton(mLocalizer.msg("selectPlugins", "Choose Plugins"));
        this.mClientPluginTargets = ReminderPlugin.getInstance().getClientPluginsTargets();
        this.handlePluginSelection();
        choose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                    PluginChooserDlg chooser = null;
                    chooser = new PluginChooserDlg(parent, ReminderSettingsTab.this.mClientPluginTargets, null, (ProgramReceiveIf)ReminderPluginProxy.getInstance());
                    chooser.setVisible(true);
                    if (chooser.getReceiveTargets() != null) {
                        ReminderSettingsTab.access$002(ReminderSettingsTab.this, chooser.getReceiveTargets());
                    }
                    ReminderSettingsTab.this.handlePluginSelection();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        int autoCloseReminderTime = 10;
        try {
            String asString = this.mSettings.getProperty("autoCloseReminderTime", "10");
            autoCloseReminderTime = Integer.parseInt(asString);
            if (autoCloseReminderTime == 0) {
                autoCloseReminderTime = 10;
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.mCloseOnEnd = new JRadioButton(mLocalizer.msg("autoCloseReminderAtProgramEnd", "Program end"), this.mSettings.getProperty("autoCloseBehaviour", "onEnd").equals("onEnd"));
        this.mCloseOnEnd.setEnabled(this.mReminderWindowChB.isSelected());
        this.mCloseNever = new JRadioButton(mLocalizer.msg("autoCloseNever", "Never close"), this.mSettings.getProperty("autoCloseBehaviour", "onEnd").equals("never"));
        this.mCloseNever.setEnabled(this.mReminderWindowChB.isSelected());
        this.mCloseOnTime = new JRadioButton(mLocalizer.ellipsisMsg("autoCloseAfterTime", "After time"), this.mSettings.getProperty("autoCloseBehaviour", "onEnd").equals("onTime"));
        this.mCloseOnTime.setEnabled(this.mReminderWindowChB.isSelected());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mCloseOnEnd);
        bg.add(this.mCloseNever);
        bg.add(this.mCloseOnTime);
        this.mAutoCloseReminderTimeSp = new JSpinner(new SpinnerNumberModel(autoCloseReminderTime, autoCloseReminderTime < 5 ? 1 : 5, 600, 1));
        this.mAutoCloseReminderTimeSp.setEnabled(this.mCloseOnTime.isSelected() && this.mReminderWindowChB.isSelected());
        this.mShowTimeCounter = new JCheckBox(mLocalizer.msg("showTimeCounter", "Show time counter"), this.mSettings.getProperty("showTimeCounter", "false").compareTo("true") == 0);
        this.mShowTimeCounter.setEnabled(!this.mCloseNever.isSelected() && this.mReminderWindowChB.isSelected());
        PanelBuilder autoClosePanel = new PanelBuilder(new FormLayout("12dlu,default,2dlu,default:grow", "pref,2dlu,pref,2dlu,pref,2dlu,pref,10dlu,pref"));
        autoClosePanel.add((Component)this.mCloseOnEnd, CC.xyw(1, 1, 4));
        autoClosePanel.add((Component)this.mCloseNever, CC.xyw(1, 3, 4));
        autoClosePanel.add((Component)this.mCloseOnTime, CC.xyw(1, 5, 4));
        autoClosePanel.add((Component)this.mAutoCloseReminderTimeSp, CC.xy(2, 7));
        final JLabel secondsLabel = autoClosePanel.addLabel(mLocalizer.msg("seconds", "seconds (0 = off)"), CC.xy(4, 7));
        autoClosePanel.add((Component)this.mShowTimeCounter, CC.xyw(1, 9, 4));
        secondsLabel.setEnabled(this.mCloseOnTime.isSelected() && this.mReminderWindowChB.isSelected());
        String defaultReminderEntryStr = (String)this.mSettings.get("defaultReminderEntry");
        this.mDefaultReminderEntryList = new JComboBox<RemindValue>(ReminderFrame.REMIND_BEFORE_VALUE_ARR);
        if (defaultReminderEntryStr != null) {
            try {
                int inx = Integer.parseInt(defaultReminderEntryStr);
                if (inx < 0) {
                    inx = 0;
                }
                if (inx < ReminderFrame.REMIND_BEFORE_VALUE_ARR.length) {
                    this.mDefaultReminderEntryList.setSelectedIndex(inx);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.mShowTimeSelectionDlg = new JCheckBox(mLocalizer.msg("showTimeSelectionDialog", "Show time selection dialog"));
        this.mShowTimeSelectionDlg.setSelected(this.mSettings.getProperty("showTimeSelectionDialog", "true").compareTo("true") == 0);
        this.mShowRemovedDlg = new JCheckBox(mLocalizer.msg("showRemovedDialog", "Show removed reminders after data update"));
        this.mShowRemovedDlg.setSelected(this.mSettings.getProperty("showRemovedDialog", "true").compareTo("true") == 0);
        this.mShowDateSeparators = new JCheckBox(mLocalizer.msg("showDateSeparators", "Show date separator in program list"));
        this.mShowDateSeparators.setSelected(ReminderPlugin.getInstance().showDateSeparators());
        this.mProvideTab = new JCheckBox(mLocalizer.msg("provideTab", "Provide tab in TV-Browser main window"));
        this.mProvideTab.setSelected(this.mSettings.getProperty("provideTab", "true").equals("true"));
        pb.addSeparator(mLocalizer.msg("remindBy", "Remind me by"), CC.xyw(1, 1, 10));
        pb.add((Component)reminderWindowCfg, CC.xyw(2, 3, 4));
        pb.add((Component)this.mSoundFileChB, CC.xyw(2, 5, 4));
        pb.add((Component)this.mSoundFileChB.getButton(), CC.xy(7, 5));
        pb.add((Component)soundTestBt, CC.xy(9, 5));
        pb.add((Component)this.mBeep, CC.xy(2, 7));
        pb.add((Component)this.mExecChB, CC.xyw(2, 9, 4));
        pb.add((Component)this.mExecFileDialogBtn, CC.xyw(7, 9, 3));
        pb.addSeparator(mLocalizer.msg("sendToPlugin", "Send reminded program to"), CC.xyw(1, 11, 10));
        pb.add((Component)this.mPluginLabel, CC.xyw(2, 13, 4));
        pb.add((Component)choose, CC.xyw(7, 13, 3));
        final JLabel c = (JLabel)pb.addSeparator(mLocalizer.msg("autoCloseReminder", "Automatically close reminder"), CC.xyw(1, 15, 10)).getComponent(0);
        c.setEnabled(this.mReminderWindowChB.isSelected());
        pb.add((Component)autoClosePanel.getPanel(), CC.xyw(2, 17, 5));
        JPanel reminderEntry = new JPanel(new FlowLayout(3, 0, 0));
        reminderEntry.add(this.mDefaultReminderEntryList);
        pb.addSeparator(mLocalizer.msg("defaltReminderEntry", "Default reminder time"), CC.xyw(1, 19, 10));
        pb.add((Component)reminderEntry, CC.xyw(2, 21, 4));
        pb.addSeparator(mLocalizer.msg("miscSettings", "Misc settings"), CC.xyw(1, 23, 10));
        pb.add((Component)this.mShowTimeSelectionDlg, CC.xyw(2, 25, 7));
        pb.add((Component)this.mShowRemovedDlg, CC.xyw(2, 27, 7));
        pb.add((Component)this.mShowDateSeparators, CC.xyw(2, 29, 7));
        pb.add((Component)this.mProvideTab, CC.xyw(2, 31, 7));
        this.mScrollTimeToNext = new JRadioButton(mLocalizer.msg("timeButtonScrollNext", "Scroll to next occurence of time from shown programs onward"), Boolean.parseBoolean(propDefaults.getValueFromProperties("scrollTimeTypeNext")));
        this.mScrollTimeOnDay = new JRadioButton(mLocalizer.msg("timeButtonScrollDay", "Scroll to occurence of time on shown day in list"), !this.mScrollTimeToNext.isSelected());
        final JLabel scrollTimeLabel = new JLabel(mLocalizer.msg("timeButtonBehaviour", "Time buttons behaviour:"));
        this.mScrollTimeToNext.setEnabled(this.mProvideTab.isSelected());
        this.mScrollTimeOnDay.setEnabled(this.mProvideTab.isSelected());
        scrollTimeLabel.setEnabled(this.mProvideTab.isSelected());
        ButtonGroup time = new ButtonGroup();
        time.add(this.mScrollTimeToNext);
        time.add(this.mScrollTimeOnDay);
        JPanel timeButtonBehaviour = new JPanel(new FormLayout("10dlu,default:grow", "5dlu,default,5dlu,default,1dlu,default"));
        timeButtonBehaviour.add((Component)scrollTimeLabel, CC.xy(2, 2));
        timeButtonBehaviour.add((Component)this.mScrollTimeToNext, CC.xy(2, 4));
        timeButtonBehaviour.add((Component)this.mScrollTimeOnDay, CC.xy(2, 6));
        pb.add((Component)timeButtonBehaviour, CC.xyw(2, 32, 7));
        this.mProvideTab.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                scrollTimeLabel.setEnabled(e.getStateChange() == 1);
                ReminderSettingsTab.this.mScrollTimeToNext.setEnabled(scrollTimeLabel.isEnabled());
                ReminderSettingsTab.this.mScrollTimeOnDay.setEnabled(scrollTimeLabel.isEnabled());
            }
        });
        pb.addSeparator(DefaultMarkingPrioritySelectionPanel.getTitle(), CC.xyw(1, 34, 10));
        this.mMarkingsPanel = DefaultMarkingPrioritySelectionPanel.createPanel(ReminderPlugin.getInstance().getMarkPriority(), false, false);
        pb.add((Component)this.mMarkingsPanel, CC.xyw(2, 36, 9));
        this.mReminderWindowChB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReminderSettingsTab.this.mShowAlwaysOnTop.setEnabled(e.getStateChange() == 1);
                for (int i = 0; i < ReminderSettingsTab.this.mReminderWindowPosition.length; ++i) {
                    ReminderSettingsTab.this.mReminderWindowPosition[i].setEnabled(e.getStateChange() == 1);
                }
                posLabel.setEnabled(e.getStateChange() == 1);
                c.setEnabled(e.getStateChange() == 1);
                secondsLabel.setEnabled(e.getStateChange() == 1 && ReminderSettingsTab.this.mCloseOnTime.isSelected());
                ReminderSettingsTab.this.mCloseOnEnd.setEnabled(e.getStateChange() == 1);
                ReminderSettingsTab.this.mCloseNever.setEnabled(e.getStateChange() == 1);
                ReminderSettingsTab.this.mCloseOnTime.setEnabled(e.getStateChange() == 1);
                ReminderSettingsTab.this.mShowTimeCounter.setEnabled(e.getStateChange() == 1 && !ReminderSettingsTab.this.mCloseNever.isSelected());
                ReminderSettingsTab.this.mAutoCloseReminderTimeSp.setEnabled(e.getStateChange() == 1 && ReminderSettingsTab.this.mCloseOnTime.isSelected());
            }
        });
        soundTestBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().compareTo(mLocalizer.msg("test", "Test")) == 0) {
                    ReminderSettingsTab.this.mTestSound = ReminderPlugin.playSound(ReminderSettingsTab.this.mSoundFileChB.getTextField().getText());
                    if (ReminderSettingsTab.this.mTestSound != null) {
                        soundTestBt.setText(mLocalizer.msg("stop", "Stop"));
                    }
                    if (ReminderSettingsTab.this.mTestSound != null) {
                        if (ReminderSettingsTab.this.mTestSound instanceof SourceDataLine) {
                            ((SourceDataLine)ReminderSettingsTab.this.mTestSound).addLineListener(new LineListener(){

                                @Override
                                public void update(LineEvent event) {
                                    if (event.getType() == LineEvent.Type.CLOSE || event.getType() == LineEvent.Type.STOP) {
                                        soundTestBt.setText(mLocalizer.msg("test", "Test"));
                                    }
                                }
                            });
                        } else if (ReminderSettingsTab.this.mTestSound instanceof Sequencer) {
                            new Thread("Test MIDI sound"){

                                @Override
                                public void run() {
                                    this.setPriority(1);
                                    while (((Sequencer)ReminderSettingsTab.this.mTestSound).isRunning()) {
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (Exception exception) {}
                                    }
                                    soundTestBt.setText(mLocalizer.msg("test", "Test"));
                                }
                            }.start();
                        }
                    }
                } else if (ReminderSettingsTab.this.mTestSound != null) {
                    if (ReminderSettingsTab.this.mTestSound instanceof SourceDataLine && ((SourceDataLine)ReminderSettingsTab.this.mTestSound).isRunning()) {
                        ((SourceDataLine)ReminderSettingsTab.this.mTestSound).stop();
                    } else if (ReminderSettingsTab.this.mTestSound instanceof Sequencer && ((Sequencer)ReminderSettingsTab.this.mTestSound).isRunning()) {
                        ((Sequencer)ReminderSettingsTab.this.mTestSound).stop();
                    }
                }
            }
        });
        this.mSoundFileChB.getCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                soundTestBt.setEnabled(ReminderSettingsTab.this.mSoundFileChB.isSelected());
            }
        });
        this.mSoundFileChB.getTextField().addKeyListener(new KeyAdapter((String[])extArr, soundTestBt){
            final /* synthetic */ String[] val$extArr;
            final /* synthetic */ JButton val$soundTestBt;
            {
                this.val$extArr = stringArray;
                this.val$soundTestBt = jButton;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = ReminderSettingsTab.this.mSoundFileChB.getTextField().getText();
                if (new File(text).isFile()) {
                    boolean notFound = true;
                    for (String extension : this.val$extArr) {
                        if (!StringUtils.endsWithIgnoreCase(text, extension)) continue;
                        notFound = false;
                        break;
                    }
                    if (notFound) {
                        this.val$soundTestBt.setEnabled(false);
                    } else {
                        this.val$soundTestBt.setEnabled(true);
                    }
                } else {
                    this.val$soundTestBt.setEnabled(false);
                }
            }
        });
        this.mSoundFileChB.getTextField().getKeyListeners()[0].keyReleased(null);
        this.mExecChB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderSettingsTab.this.mExecFileDialogBtn.setEnabled(ReminderSettingsTab.this.mExecChB.isSelected());
                if (ReminderSettingsTab.this.mExecFileDialogBtn.isEnabled()) {
                    ReminderSettingsTab.this.showFileSettingsDialog();
                }
            }
        });
        this.mExecFileDialogBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderSettingsTab.this.showFileSettingsDialog();
            }
        });
        ItemListener autoCloseListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReminderSettingsTab.this.mAutoCloseReminderTimeSp.setEnabled(ReminderSettingsTab.this.mCloseOnTime.isSelected());
                secondsLabel.setEnabled(ReminderSettingsTab.this.mCloseOnTime.isSelected());
                ReminderSettingsTab.this.mShowTimeCounter.setEnabled(ReminderSettingsTab.this.mCloseOnTime.isSelected() || ReminderSettingsTab.this.mCloseOnEnd.isSelected());
            }
        };
        this.mCloseOnEnd.addItemListener(autoCloseListener);
        this.mCloseOnTime.addItemListener(autoCloseListener);
        this.mCloseOnTime.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReminderSettingsTab.this.mShowTimeCounter.setEnabled(e.getStateChange() == 1);
            }
        });
        return pb.getPanel();
    }

    private void handlePluginSelection() {
        ArrayList<ProgramReceiveIf> plugins = new ArrayList<ProgramReceiveIf>();
        if (this.mClientPluginTargets != null) {
            for (ProgramReceiveTarget target : this.mClientPluginTargets) {
                if (plugins.contains(target.getReceifeIfForIdOfTarget())) continue;
                plugins.add(target.getReceifeIfForIdOfTarget());
            }
            ProgramReceiveIf[] mClientPlugins = plugins.toArray(new ProgramReceiveIf[plugins.size()]);
            if (mClientPlugins.length > 0) {
                this.mPluginLabel.setText(mClientPlugins[0].toString());
                this.mPluginLabel.setEnabled(true);
            } else {
                this.mPluginLabel.setText(mLocalizer.msg("noPlugins", "No Plugins choosen"));
                this.mPluginLabel.setEnabled(false);
            }
            for (int i = 1; i < (mClientPlugins.length > 4 ? 3 : mClientPlugins.length); ++i) {
                this.mPluginLabel.setText(this.mPluginLabel.getText() + ", " + mClientPlugins[i]);
            }
            if (mClientPlugins.length > 4) {
                this.mPluginLabel.setText(this.mPluginLabel.getText() + " (" + (mClientPlugins.length - 3) + " " + mLocalizer.ellipsisMsg("otherPlugins", "others") + ")");
            }
        }
    }

    private void showFileSettingsDialog() {
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        ExecuteSettingsDialog execSettingsDialog = new ExecuteSettingsDialog(parent, this.mExecFileStr, this.mExecParamStr);
        execSettingsDialog.setVisible(true);
        if (execSettingsDialog.wasOKPressed()) {
            this.mExecFileStr = execSettingsDialog.getExecutable();
            this.mExecParamStr = execSettingsDialog.getParameters();
        }
    }

    @Override
    public void saveSettings() {
        this.mSettings.setProperty("soundfile", this.mSoundFileChB.getTextField().getText());
        this.mSettings.setProperty("execfile", this.mExecFileStr);
        this.mSettings.setProperty("execparam", this.mExecParamStr);
        this.mSettings.setProperty("usemsgbox", String.valueOf(this.mReminderWindowChB.isSelected()));
        this.mSettings.setProperty("usesound", String.valueOf(this.mSoundFileChB.isSelected()));
        this.mSettings.setProperty("usebeep", String.valueOf(this.mBeep.isSelected()));
        this.mSettings.setProperty("useexec", String.valueOf(this.mExecChB.isSelected()));
        ReminderPlugin.getInstance().setClientPluginsTargets(this.mClientPluginTargets);
        this.mSettings.setProperty("autoCloseBehaviour", this.mCloseOnEnd.isSelected() ? "onEnd" : (this.mCloseNever.isSelected() ? "never" : "onTime"));
        this.mSettings.setProperty("autoCloseReminderTime", this.mAutoCloseReminderTimeSp.getValue().toString());
        this.mSettings.setProperty("defaultReminderEntry", String.valueOf(this.mDefaultReminderEntryList.getSelectedIndex()));
        this.mSettings.setProperty("showTimeSelectionDialog", String.valueOf(this.mShowTimeSelectionDlg.isSelected()));
        this.mSettings.setProperty("showRemovedDialog", String.valueOf(this.mShowRemovedDlg.isSelected()));
        this.mSettings.setProperty("showTimeCounter", String.valueOf(!this.mCloseNever.isSelected() && this.mShowTimeCounter.isSelected()));
        this.mSettings.setProperty("alwaysOnTop", String.valueOf(this.mShowAlwaysOnTop.isSelected()));
        this.mSettings.setProperty("provideTab", String.valueOf(this.mProvideTab.isSelected()));
        this.mSettings.setProperty("scrollTimeTypeNext", String.valueOf(this.mScrollTimeToNext.isSelected()));
        for (int i = 0; i < this.mReminderWindowPosition.length; ++i) {
            if (!this.mReminderWindowPosition[i].isSelected()) continue;
            this.mSettings.setProperty("reminderWindowPosition", String.valueOf(i));
            break;
        }
        ReminderPlugin.getInstance().setShowDateSeparators(this.mShowDateSeparators.isSelected());
        ReminderPlugin.getInstance().setMarkPriority(this.mMarkingsPanel.getSelectedPriority());
        ReminderPlugin.getInstance().addPanel();
        Thread saveThread = new Thread("Save reminders"){

            @Override
            public void run() {
                ReminderPlugin.getInstance().store();
            }
        };
        saveThread.setPriority(1);
        saveThread.start();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("tabName", "Reminder");
    }

    static /* synthetic */ ProgramReceiveTarget[] access$002(ReminderSettingsTab x0, ProgramReceiveTarget[] x1) {
        x0.mClientPluginTargets = x1;
        return x1;
    }
}

