/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.ContextMenuIf;
import devplugin.Marker;
import devplugin.PluginCenterPanelWrapper;
import devplugin.Program;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import javax.swing.Icon;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.extras.common.AbstractInternalPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderSettingsTab;
import util.ui.Localizer;

public class ReminderPluginProxy
extends AbstractInternalPluginProxy
implements ButtonActionIf,
ContextMenuIf,
Marker {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderPluginProxy.class);
    private static final String PROGRAM_TARGET_REMIND = "target_remind";
    private static ReminderPluginProxy mInstance;
    private Icon mMarkIcon;

    private ReminderPluginProxy() {
        mInstance = this;
    }

    public static ReminderPluginProxy getInstance() {
        if (mInstance == null) {
            new ReminderPluginProxy();
        }
        return mInstance;
    }

    @Override
    public ActionMenu getContextMenuActions(Program program) {
        return ReminderPluginProxy.getReminderInstance().getContextMenuActions(program);
    }

    @Override
    public String getId() {
        return ReminderPlugin.getReminderPluginId();
    }

    public String toString() {
        return ReminderPlugin.getName();
    }

    @Override
    public boolean canReceiveProgramsWithTarget() {
        return true;
    }

    @Override
    public boolean receivePrograms(Program[] programArr, ProgramReceiveTarget receiveTarget) {
        ReminderPluginProxy.getReminderInstance().addPrograms(programArr);
        return true;
    }

    @Override
    public ProgramReceiveTarget[] getProgramReceiveTargets() {
        return new ProgramReceiveTarget[]{new ProgramReceiveTarget(this, mLocalizer.msg("programTarget", "Remind"), PROGRAM_TARGET_REMIND)};
    }

    @Override
    public Icon getMarkIcon() {
        if (this.mMarkIcon == null) {
            this.mMarkIcon = IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16);
        }
        return this.mMarkIcon;
    }

    @Override
    public Icon[] getMarkIcons(Program p) {
        return new Icon[]{this.getMarkIcon()};
    }

    @Override
    public int getMarkPriorityForProgram(Program p) {
        return ReminderPluginProxy.getReminderInstance().getMarkPriority();
    }

    @Override
    public String getButtonActionDescription() {
        return ReminderPlugin.mLocalizer.msg("description", "The reminder function of TV-Browser.");
    }

    @Override
    public Icon getIcon() {
        return this.getMarkIcon();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public SettingsTab getSettingsTab() {
        return new ReminderSettingsTab();
    }

    @Override
    public String getSettingsId() {
        return "#reminder";
    }

    @Override
    public ActionMenu getButtonAction() {
        return ReminderPlugin.getInstance().getButtonAction();
    }

    @Override
    public boolean receiveValues(String[] values, ProgramReceiveTarget receiveTarget) {
        return false;
    }

    @Override
    public void handleTvDataUpdateFinished() {
        ReminderPluginProxy.getReminderInstance().handleTvDataUpdateFinished();
    }

    private static ReminderPlugin getReminderInstance() {
        return ReminderPlugin.getInstance();
    }

    @Override
    public String getPluginCategory() {
        return "misc";
    }

    @Override
    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return ReminderPlugin.getInstance().getPluginCenterPanelWrapper();
    }

    @Override
    public AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        return ReminderPlugin.getInstance().getAfterDataUpdateInfoPanel();
    }

    @Override
    public void handleTvBrowserStartFinished() {
        ReminderPlugin.getInstance().handleTvBrowserStartFinished();
    }
}

