/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.PluginAccess;
import devplugin.Program;
import devplugin.ProgramReceiveTarget;
import devplugin.ProgramSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ConfigMenuItem;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.search.booleansearch.BooleanSearcher;
import tvbrowser.core.search.regexsearch.RegexSearcher;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.programinfo.ProgramEditorPane;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.programinfo.ProgramInfoProxy;
import tvbrowser.extras.programinfo.ProgramInfoToolBar;
import tvbrowser.extras.programinfo.TaskMenuAction;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import util.browserlauncher.Launch;
import util.exc.TvBrowserException;
import util.program.ProgramTextCreator;
import util.settings.ProgramPanelSettings;
import util.ui.Localizer;
import util.ui.SearchFormSettings;
import util.ui.SearchHelper;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.findasyoutype.TextComponentFindAction;
import util.ui.html.ExtendedHTMLDocument;
import util.ui.html.ExtendedHTMLEditorKit;
import util.ui.textcomponentpopup.TextComponentPopupEventQueue;

class ProgramInfoDialog {
    private static final long serialVersionUID = 1L;
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramInfoDialog.class);
    private static JDialog mDialog;
    private JPanel mMainPanel;
    private JEditorPane mInfoEP;
    private JTaskPane mPluginsPane;
    private JTaskPaneGroup mFunctionGroup;
    private Program mProgram;
    private ExtendedHTMLDocument mDoc;
    private JScrollPane mActionsPane;
    private TextComponentFindAction mFindAsYouType;
    private ActionMenu mSearchMenu;
    private TaskMenuAction mTextSearch;
    private boolean mShowSettings;
    private static long mLastClosed;
    private static ProgramInfoDialog instance;
    private Action mUpAction;
    private Action mDownAction;
    private JButton mCloseBtn;
    private JButton mConfigBtn;
    private JCheckBox mHighlight;
    private ProgramInfoToolBar mToolBar;

    private ProgramInfoDialog(Dimension pluginsSize, boolean showSettings) {
        this.init(pluginsSize, showSettings);
    }

    public static synchronized ProgramInfoDialog getInstance(Program program, Dimension pluginsSize, boolean showSettings) {
        if (instance == null) {
            instance = new ProgramInfoDialog(pluginsSize, showSettings);
        }
        instance.setProgram(program, showSettings);
        return instance;
    }

    private synchronized void setProgram(Program program, boolean showSettings) {
        this.mProgram = program;
        this.addPluginActions(false);
        if (this.mToolBar != null) {
            this.mToolBar.update();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgramInfoDialog.this.setProgramText();
                ProgramInfoDialog.this.mInfoEP.setCaretPosition(0);
                if (ProgramInfoDialog.this.mFindAsYouType.getSearchBar().isVisible()) {
                    ProgramInfoDialog.this.mFindAsYouType.next();
                }
            }
        });
        this.mConfigBtn.setVisible(showSettings);
    }

    static Program getCurrentProgram() {
        if (instance != null) {
            return ProgramInfoDialog.instance.mProgram;
        }
        return null;
    }

    protected void highlightFavorites() {
        Favorite[] favorites = FavoriteTreeModel.getInstance().getFavoritesContainingProgram(this.mProgram);
        boolean hasFavorites = favorites != null && favorites.length > 0;
        this.mHighlight.setEnabled(hasFavorites);
        Highlighter highlighter = this.mInfoEP.getHighlighter();
        HTMLDocument document = (HTMLDocument)this.mInfoEP.getDocument();
        highlighter.removeAllHighlights();
        if (!hasFavorites || !ProgramInfo.getInstance().getSettings().getHighlightFavorite()) {
            return;
        }
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(ProgramInfo.getInstance().getSettings().getHighlightColor());
        for (Favorite favorite : favorites) {
            String patternString;
            ProgramSearcher searcher = null;
            try {
                searcher = favorite.getSearcher();
            }
            catch (TvBrowserException e) {
                e.printStackTrace();
            }
            Pattern pattern = null;
            if (searcher instanceof RegexSearcher) {
                pattern = ((RegexSearcher)searcher).getPattern();
                if (pattern != null) {
                    if (pattern.pattern().startsWith(".*?")) {
                        pattern = Pattern.compile(pattern.pattern().substring(3), pattern.flags());
                    } else if (pattern.pattern().startsWith(".*")) {
                        pattern = Pattern.compile(pattern.pattern().substring(2), pattern.flags());
                    }
                    if (pattern.pattern().endsWith(".*")) {
                        pattern = Pattern.compile(pattern.pattern().substring(0, pattern.pattern().length() - 2), pattern.flags());
                    }
                }
            } else if (searcher instanceof BooleanSearcher && (patternString = ((BooleanSearcher)searcher).getPattern()).indexOf("NOT") == -1) {
                patternString = patternString.replaceAll("(\\(|\\))", " ").replaceAll("\\s+(AND|OR|NOT|\\&\\&|\\|\\|)\\s+", "|").trim();
                int flag = 0;
                if (!((BooleanSearcher)searcher).isCaseSensitive()) {
                    flag = 2;
                }
                pattern = Pattern.compile(patternString, flag);
            }
            if (pattern == null) continue;
            HTMLDocument.Iterator it = document.getIterator(HTML.Tag.CONTENT);
            while (it.isValid()) {
                try {
                    String fragment = document.getText(it.getStartOffset(), it.getEndOffset() - it.getStartOffset());
                    Matcher matcher = pattern.matcher(fragment);
                    while (matcher.find()) {
                        if (matcher.start() == matcher.end()) continue;
                        highlighter.addHighlight(it.getStartOffset() + matcher.start(), it.getStartOffset() + matcher.end(), painter);
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
                it.next();
            }
        }
    }

    private void setProgramText() {
        if (mDialog != null) {
            mDialog.setTitle(this.mProgram.getTitle());
        }
        this.mInfoEP.setText(ProgramTextCreator.createInfoText(this.mProgram, this.mDoc, ProgramInfo.getInstance().getOrder(), ProgramInfo.getInstance().getSettings().getUsedTitleFont(), ProgramInfo.getInstance().getSettings().getUsedBodyFont(), new ProgramPanelSettings(ProgramInfo.getInstance().getPictureSettings(), false), true, ProgramInfo.getInstance().getSettings().getZoomEnabled() ? ProgramInfo.getInstance().getSettings().getZoomValue() : 100, true, ProgramInfo.getInstance().getSettings().getEnableSearch(), Settings.propTableBackgroundStyle.getString().equals("uiTimeBlock") || Settings.propTableBackgroundStyle.getString().equals("uiColor")));
        this.mHighlight.setSelected(ProgramInfo.getInstance().getSettings().getHighlightFavorite());
        this.highlightFavorites();
    }

    private void init(Dimension pluginsSize, boolean showSettings) {
        mLastClosed = 0L;
        this.mShowSettings = showSettings;
        this.mFunctionGroup = new JTaskPaneGroup();
        this.mFunctionGroup.setTitle(mLocalizer.msg("functions", "Functions"));
        this.mFunctionGroup.setDoubleBuffered(true);
        this.mToolBar = new ProgramInfoToolBar();
        this.mMainPanel = new JPanel(new BorderLayout());
        this.mMainPanel.setPreferredSize(new Dimension(750, 500));
        this.mMainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mMainPanel.add((Component)this.mToolBar, "North");
        this.mInfoEP = new ProgramEditorPane();
        ExtendedHTMLEditorKit kit = new ExtendedHTMLEditorKit();
        kit.setLinkCursor(Cursor.getPredefinedCursor(12));
        this.mInfoEP.setEditorKit(kit);
        this.mInfoEP.setDoubleBuffered(true);
        this.mDoc = (ExtendedHTMLDocument)this.mInfoEP.getDocument();
        this.mInfoEP.setEditable(false);
        this.mInfoEP.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && e.getModifiersEx() == 0) {
                    this.handleEvent(e, false);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handleEvent(e, true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handleEvent(e, true);
                }
            }

            private JPopupMenu getPopupMenu(String search, boolean actorFavorite) {
                if (search != null) {
                    search = search.trim();
                }
                final String searchText = search;
                JPopupMenu popupMenu = new JPopupMenu();
                if (searchText != null && searchText.length() > 0) {
                    ProgramReceiveTarget[] targets;
                    String value = ProgramInfo.getInstance().getSettings().getActorSearch();
                    JMenuItem item = this.searchTextMenuItem(searchText);
                    if (value.equals("internalSearch")) {
                        item.setFont(item.getFont().deriveFont(1));
                    }
                    popupMenu.add(item);
                    item = new JMenuItem(mLocalizer.msg("searchWikipedia", "Search in Wikipedia"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.searchWikipedia(searchText);
                        }
                    });
                    if (value.equals("internalWikipedia")) {
                        item.setFont(item.getFont().deriveFont(1));
                    }
                    popupMenu.add(item);
                    PluginAccess webPlugin = PluginManagerImpl.getInstance().getActivatedPluginForId("java.webplugin.WebPlugin");
                    if (webPlugin != null && webPlugin.canReceiveProgramsWithTarget() && (targets = webPlugin.getProgramReceiveTargets()) != null && targets.length > 0) {
                        JMenu subMenu = new JMenu(webPlugin.getInfo().getName());
                        subMenu.setIcon(webPlugin.getMarkIcon());
                        popupMenu.add(subMenu);
                        for (final ProgramReceiveTarget target : targets) {
                            item = new JMenuItem(target.toString());
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    this.searchWebPlugin(searchText, target);
                                }
                            });
                            if (value.endsWith(target.getTargetId())) {
                                item.setFont(item.getFont().deriveFont(1));
                            }
                            subMenu.add(item);
                        }
                    }
                    popupMenu.addSeparator();
                    popupMenu.add(this.addFavoriteMenuItem(searchText, actorFavorite));
                    popupMenu.addSeparator();
                }
                JMenu subMenu = ContextMenuManager.getInstance().createContextMenuItems(ProgramInfoProxy.getInstance(), ProgramInfoDialog.this.mProgram, true);
                subMenu.setText(Localizer.getLocalization("i18n_program"));
                popupMenu.add(subMenu);
                TextComponentPopupEventQueue.addStandardContextMenu(ProgramInfoDialog.this.mInfoEP, popupMenu);
                return popupMenu;
            }

            private void handleEvent(MouseEvent e, boolean popupEvent) {
                Point pt;
                JEditorPane editor = (JEditorPane)e.getSource();
                int pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()));
                if (pos >= 0) {
                    String link = this.getLink(pos, editor);
                    if (link != null && link.startsWith("tvbrowser://")) {
                        String searchText = link.substring("tvbrowser://".length());
                        if (popupEvent) {
                            JPopupMenu popupMenu = this.getPopupMenu(searchText, true);
                            popupMenu.show(e.getComponent(), e.getX(), e.getY());
                        } else {
                            String value = ProgramInfo.getInstance().getSettings().getActorSearch();
                            boolean found = false;
                            if (value.contains("#_#_#")) {
                                ProgramReceiveTarget[] targets;
                                String[] keys = value.split("#_#_#");
                                PluginAccess webPlugin = PluginManagerImpl.getInstance().getActivatedPluginForId(keys[0]);
                                if (webPlugin != null && webPlugin.canReceiveProgramsWithTarget() && (targets = webPlugin.getProgramReceiveTargets()) != null) {
                                    for (ProgramReceiveTarget target : targets) {
                                        if (!target.getTargetId().equals(keys[1])) continue;
                                        this.searchWebPlugin(searchText, target);
                                        found = true;
                                    }
                                }
                            }
                            if (!found) {
                                if (value.equals("internalSearch")) {
                                    this.internalSearch(searchText);
                                } else {
                                    this.searchWikipedia(searchText);
                                }
                            }
                        }
                    } else if (popupEvent) {
                        String selection = this.getSelection(pos, editor);
                        JPopupMenu popupMenu = this.getPopupMenu(selection, false);
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            private JMenuItem searchTextMenuItem(final String desc) {
                JMenuItem item = new JMenuItem(mLocalizer.msg("searchTvBrowser", "Search in TV-Browser"), IconLoader.getInstance().getIconFromTheme("actions", "edit-find"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.internalSearch(desc);
                    }
                });
                return item;
            }

            private JMenuItem addFavoriteMenuItem(final String desc, final boolean actor) {
                JMenuItem item = new JMenuItem(mLocalizer.ellipsisMsg("addFavorite", "Create favorite"), IconLoader.getInstance().getIconFromTheme("emblems", "emblem-favorite"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (actor) {
                            FavoritesPlugin.getInstance().showCreateActorFavoriteWizard(ProgramInfoDialog.this.mProgram, desc);
                        } else {
                            FavoritesPlugin.getInstance().showCreateTopicFavoriteWizard(ProgramInfoDialog.this.mProgram, desc);
                        }
                    }
                });
                return item;
            }

            private void searchWebPlugin(String desc, ProgramReceiveTarget target) {
                target.getReceifeIfForIdOfTarget().receiveValues(new String[]{desc}, target);
            }

            private void searchWikipedia(String desc) {
                DontShowAgainOptionBox.showOptionDialog("programInfoDialog.newActorSearch", mDialog, ProgramInfo.mLocalizer.msg("newActorSearchText", "This function was changed for TV-Browser 2.7. The search type is now\nchangeable in the settings of the Program details, additional now available\nis a context menu for the actor search."), ProgramInfo.mLocalizer.msg("newActorSearch", "New actor search"));
                try {
                    String url = URLEncoder.encode(desc, "UTF-8").replace("+", "%20");
                    url = mLocalizer.msg("wikipediaLink", "http://en.wikipedia.org/wiki/{0}", url);
                    Launch.openURL(url);
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
            }

            private void internalSearch(String desc) {
                desc = desc.replaceAll("  ", " ").replaceAll(" ", " AND ");
                SearchFormSettings settings = new SearchFormSettings(desc);
                settings.setSearchIn(2);
                settings.setSearcherType(4);
                settings.setNrDays(-1);
                SearchHelper.search((Component)ProgramInfoDialog.this.mInfoEP, settings, null, true);
            }

            private String getLink(int pos, JEditorPane html) {
                HTMLDocument hdoc;
                Element e;
                AttributeSet a;
                AttributeSet anchor;
                Document doc = html.getDocument();
                if (doc instanceof HTMLDocument && (anchor = (AttributeSet)(a = (e = (hdoc = (HTMLDocument)doc).getCharacterElement(pos)).getAttributes()).getAttribute(HTML.Tag.A)) != null) {
                    return (String)anchor.getAttribute(HTML.Attribute.HREF);
                }
                return null;
            }

            private String getSelection(int pos, JEditorPane html) {
                Caret caret = html.getCaret();
                if (caret != null) {
                    try {
                        int start = Math.min(caret.getDot(), caret.getMark());
                        int length = Math.abs(caret.getDot() - caret.getMark());
                        return html.getDocument().getText(start, length);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
        this.mInfoEP.addHyperlinkListener(new HyperlinkListener(){
            private String mTooltip;

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                URL url;
                if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    this.mTooltip = ProgramInfoDialog.this.mInfoEP.getToolTipText();
                    ProgramInfoDialog.this.mInfoEP.setToolTipText(ProgramInfoDialog.this.getLinkTooltip(evt));
                }
                if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    ProgramInfoDialog.this.mInfoEP.setToolTipText(this.mTooltip);
                }
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = evt.getURL()) != null) {
                    Launch.openURL(url.toString());
                }
            }
        });
        this.mFindAsYouType = new TextComponentFindAction(this.mInfoEP, true);
        final JScrollPane scrollPane = new JScrollPane(this.mInfoEP);
        scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.mUpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getValue() - scrollPane.getVerticalScrollBar().getUnitIncrement());
            }
        };
        this.mDownAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getValue() + scrollPane.getVerticalScrollBar().getUnitIncrement());
            }
        };
        this.mPluginsPane = new JTaskPane();
        this.mPluginsPane.add(this.mFunctionGroup);
        this.mActionsPane = new JScrollPane(this.mPluginsPane);
        this.mConfigBtn = new JButton(mLocalizer.msg("config", "Configure view"));
        this.mConfigBtn.setIcon(TVBrowserIcons.preferences(16));
        ButtonBarBuilder buttonBuilder = new ButtonBarBuilder();
        buttonBuilder.addButton((JComponent)this.mConfigBtn);
        this.mConfigBtn.setVisible(showSettings);
        if (pluginsSize == null) {
            this.mActionsPane.setPreferredSize(new Dimension(250, 500));
        } else {
            this.mActionsPane.setPreferredSize(pluginsSize);
        }
        if (ProgramInfo.getInstance().getSettings().getShowFunctions()) {
            JSplitPane split = new JSplitPane(1);
            split.setDividerSize(5);
            split.setContinuousLayout(true);
            split.setDividerLocation(this.mActionsPane.getPreferredSize().width + 1);
            split.setLeftComponent(this.mActionsPane);
            split.setRightComponent(scrollPane);
            this.mMainPanel.add((Component)split, "Center");
            this.mFindAsYouType.installKeyListener(split);
        } else {
            final JButton functions = new JButton(mLocalizer.msg("functions", "Functions"));
            functions.setFocusable(false);
            functions.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        JPopupMenu popupMenu = PluginProxyManager.createPluginContextMenu(ProgramInfoDialog.this.mProgram, ProgramInfoProxy.getInstance());
                        popupMenu.show(functions, e.getX(), e.getY() - popupMenu.getPreferredSize().height);
                    }
                }
            });
            buttonBuilder.addUnrelatedGap();
            buttonBuilder.addButton((JComponent)functions);
            this.mMainPanel.add((Component)scrollPane, "Center");
        }
        JPanel buttonPn = new JPanel(new BorderLayout(0, 5));
        buttonPn.add((Component)this.mFindAsYouType.getSearchBar(), "North");
        buttonPn.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.mMainPanel.add((Component)buttonPn, "South");
        this.mConfigBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramInfoDialog.this.exit();
                MainFrame.getInstance().showSettingsDialog("#programinfo");
            }
        });
        this.mHighlight = new JCheckBox(mLocalizer.msg("highlight", "Highlight favorite"), ProgramInfo.getInstance().getSettings().getHighlightFavorite());
        this.mHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramInfo.getInstance().getSettings().setHighlightFavorite(ProgramInfoDialog.this.mHighlight.isSelected());
                ProgramInfoDialog.this.highlightFavorites();
            }
        });
        buttonBuilder.addUnrelatedGap();
        buttonBuilder.addFixed(this.mHighlight);
        this.mCloseBtn = new JButton(Localizer.getLocalization("i18n_close"));
        this.mCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramInfoDialog.this.exit();
            }
        });
        buttonBuilder.addGlue();
        buttonBuilder.addButton((JComponent)this.mCloseBtn);
        buttonPn.add((Component)buttonBuilder.getPanel(), "South");
        final AbstractAction searchAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgramInfoDialog.this.mFindAsYouType.getCloseButton().isVisible()) {
                    ProgramInfoDialog.this.mFindAsYouType.interrupt();
                    ProgramInfoDialog.this.mFindAsYouType.getSearchBar().setVisible(false);
                    ProgramInfoDialog.this.mFindAsYouType.getCloseButton().setVisible(false);
                } else {
                    ProgramInfoDialog.this.mFindAsYouType.showSearchBar();
                }
            }
        };
        searchAction.putValue("SmallIcon", TVBrowserIcons.search(16));
        searchAction.putValue("ActionCommandKey", "action");
        searchAction.putValue("Name", mLocalizer.msg("search", "Search Text"));
        this.mSearchMenu = new ActionMenu(searchAction);
        this.mFindAsYouType.installKeyListener(scrollPane);
        this.mFindAsYouType.installKeyListener(this.mMainPanel);
        this.mFindAsYouType.installKeyListener(this.mConfigBtn);
        this.mFindAsYouType.installKeyListener(this.mCloseBtn);
        this.mFindAsYouType.installKeyListener(buttonPn);
        this.mFindAsYouType.installKeyListener(this.mPluginsPane);
        this.mFindAsYouType.installKeyListener(this.mActionsPane);
        this.mFindAsYouType.installKeyListener(this.mFunctionGroup);
        this.mFindAsYouType.installKeyListener(this.mActionsPane.getVerticalScrollBar());
        this.mFindAsYouType.installKeyListener(scrollPane.getVerticalScrollBar());
        this.mFindAsYouType.getCloseButton().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (ProgramInfoDialog.this.mTextSearch != null) {
                    ProgramInfoDialog.this.mTextSearch.setText(mLocalizer.msg("search", "Search Text"));
                }
                searchAction.putValue("Name", mLocalizer.msg("search", "Search Text"));
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (ProgramInfoDialog.this.mTextSearch != null) {
                    ProgramInfoDialog.this.mTextSearch.setText(mLocalizer.msg("closeSearch", "Close search bar"));
                }
                searchAction.putValue("Name", mLocalizer.msg("closeSearch", "Close search bar"));
            }
        });
        if (Settings.propTableBackgroundStyle.getString().equals("uiTimeBlock") || Settings.propTableBackgroundStyle.getString().equals("uiColor")) {
            ((JComponent)((JComponent)((JComponent)this.mFunctionGroup.getComponent(0)).getComponent(0)).getComponent(0)).setBackground(UIManager.getColor("List.background"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                scrollPane.getVerticalScrollBar().setValue(0);
            }
        };
        SwingUtilities.invokeLater(runnable);
        if (ProgramInfo.getInstance().getSettings().getShowSearch()) {
            this.mFindAsYouType.showSearchBar();
            if (this.mTextSearch != null) {
                this.mTextSearch.setText(mLocalizer.msg("closeSearch", "Close search bar"));
            }
        }
    }

    protected static void recreateInstance() {
        instance = new ProgramInfoDialog(ProgramInfoDialog.instance.mActionsPane.getPreferredSize(), ProgramInfoDialog.instance.mShowSettings);
    }

    protected void addPluginActions(boolean rebuild) {
        final Rectangle oldVisibleRect = this.mInfoEP.getVisibleRect();
        this.mFunctionGroup.removeAll();
        if (Settings.propTableBackgroundStyle.getString().equals("uiTimeBlock") || Settings.propTableBackgroundStyle.getString().equals("uiColor")) {
            ((JComponent)((JComponent)((JComponent)this.mFunctionGroup.getComponent(0)).getComponent(0)).getComponent(0)).setBackground(UIManager.getColor("List.background"));
        }
        if (ProgramInfo.getInstance().getSettings().getShowSearchButton()) {
            this.mTextSearch = new TaskMenuAction(this.mFunctionGroup, this.mProgram, this.mSearchMenu, this, "id_sea", this.mFindAsYouType);
        }
        ContextMenuIf lastEntry = null;
        for (ContextMenuIf contextMenuIf : ContextMenuManager.getInstance().getAvailableContextMenuIfs(false, true)) {
            ActionMenu menu;
            if (contextMenuIf.getId().compareTo("######SEPARATOR######") == 0) {
                if (lastEntry != null && lastEntry.getId().compareTo("######SEPARATOR######") == 0) continue;
                this.mFunctionGroup.add(Box.createRigidArea(new Dimension(0, 2)));
                this.mFunctionGroup.add(new JSeparator());
                this.mFunctionGroup.add(Box.createRigidArea(new Dimension(0, 2)));
                lastEntry = contextMenuIf;
                continue;
            }
            if (contextMenuIf.getId().compareTo("######CONFIG######") == 0 && this.mShowSettings) {
                AbstractAction action = new AbstractAction(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainFrame.getInstance().showSettingsDialog("#contextmenu");
                    }
                };
                action.putValue("SmallIcon", TVBrowserIcons.preferences(16));
                action.putValue("Name", ConfigMenuItem.getInstance().toString());
                ActionMenu configure = new ActionMenu(action);
                new TaskMenuAction(this.mFunctionGroup, this.mProgram, configure, this, "id_configure", this.mFindAsYouType);
                lastEntry = contextMenuIf;
                continue;
            }
            if (contextMenuIf.getId().compareTo(ProgramInfo.getProgramInfoPluginId()) == 0 || (menu = contextMenuIf.getContextMenuActions(this.mProgram)) == null) continue;
            new TaskMenuAction(this.mFunctionGroup, this.mProgram, menu, this, contextMenuIf.getId(), this.mFindAsYouType);
            lastEntry = contextMenuIf;
        }
        if (rebuild) {
            this.setProgramText();
            this.mInfoEP.scrollRectToVisible(oldVisibleRect);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgramInfoDialog.this.mInfoEP.scrollRectToVisible(oldVisibleRect);
                }
            });
        }
        this.mPluginsPane.revalidate();
    }

    private void exit() {
        ProgramInfo.getInstance().setSettings(this.mActionsPane.getSize());
        ProgramInfo.getInstance().getSettings().setShowSearch(this.mFindAsYouType.isAlwaysVisible());
        mDialog.dispose();
        mLastClosed = System.currentTimeMillis();
    }

    private void addActionsToRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(38, 0);
        this.mInfoEP.getInputMap(2).put(stroke, "SCROLL_UP");
        this.mInfoEP.getInputMap(0).put(stroke, "SCROLL_UP");
        this.mInfoEP.getActionMap().put("SCROLL_UP", this.mUpAction);
        mDialog.getRootPane().getInputMap(2).put(stroke, "SCROLL_UP");
        mDialog.getRootPane().getInputMap(0).put(stroke, "SCROLL_UP");
        mDialog.getRootPane().getActionMap().put("SCROLL_UP", this.mUpAction);
        stroke = KeyStroke.getKeyStroke(40, 0);
        this.mInfoEP.getInputMap(2).put(stroke, "SCROLL_DOWN");
        this.mInfoEP.getInputMap(0).put(stroke, "SCROLL_DOWN");
        this.mInfoEP.getActionMap().put("SCROLL_DOWN", this.mDownAction);
        mDialog.getRootPane().getInputMap(2).put(stroke, "SCROLL_DOWN");
        mDialog.getRootPane().getInputMap(0).put(stroke, "SCROLL_DOWN");
        mDialog.getRootPane().getActionMap().put("SCROLL_DOWN", this.mDownAction);
        if (ProgramInfo.getInstance().getSettings().getShowFunctions()) {
            mDialog.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ProgramInfoDialog.this.mActionsPane.getVerticalScrollBar().setBlockIncrement(((ProgramInfoDialog)ProgramInfoDialog.this).mActionsPane.getVisibleRect().height);
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    ProgramInfoDialog.this.mActionsPane.getVerticalScrollBar().setBlockIncrement(((ProgramInfoDialog)ProgramInfoDialog.this).mActionsPane.getVisibleRect().height);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }
            });
        }
        mDialog.getRootPane().setDefaultButton(this.mCloseBtn);
        this.mFindAsYouType.installKeyListener(mDialog.getRootPane());
        mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgramInfoDialog.this.exit();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgramInfoDialog.this.mMainPanel.repaint();
                        ProgramInfoDialog.this.mInfoEP.scrollRectToVisible(new Rectangle(0, 0));
                    }
                });
            }
        });
    }

    public void show() {
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        mDialog = new JDialog(parent);
        mDialog.setModal(true);
        mDialog.setTitle(this.mProgram.getTitle());
        mDialog.setContentPane(this.mMainPanel);
        UiUtilities.registerForClosing(new WindowClosingIf(){

            @Override
            public void close() {
                ProgramInfoDialog.this.exit();
            }

            @Override
            public JRootPane getRootPane() {
                return mDialog.getRootPane();
            }
        });
        this.addActionsToRootPane();
        try {
            UIThreadRunner.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Settings.layoutWindow("extras.programInfoDlg", mDialog);
                    mDialog.setVisible(true);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void resetFunctionGroup() {
        if (instance != null) {
            instance.resetFunctionGroupInternal();
        }
    }

    private void resetFunctionGroupInternal() {
        this.mFunctionGroup = new JTaskPaneGroup();
        this.mFunctionGroup.setTitle(mLocalizer.msg("functions", "Functions"));
        this.mPluginsPane = new JTaskPane();
        this.mPluginsPane.add(this.mFunctionGroup);
        this.mActionsPane.setViewportView(this.mPluginsPane);
        this.mFindAsYouType.installKeyListener(this.mPluginsPane);
        this.mFindAsYouType.installKeyListener(this.mFunctionGroup);
        this.mPluginsPane.updateUI();
    }

    public static boolean closeDialog() {
        return instance != null && instance.closeDialogInternal();
    }

    private boolean closeDialogInternal() {
        if (mDialog == null) {
            return false;
        }
        if (!mDialog.isVisible()) {
            return false;
        }
        mDialog.setVisible(false);
        mLastClosed = System.currentTimeMillis();
        return true;
    }

    private String getLinkTooltip(HyperlinkEvent evt) {
        String link = evt.getDescription();
        if (link != null && link.startsWith("tvbrowser://")) {
            link = link.substring("tvbrowser://".length());
            return mLocalizer.msg("searchFor", "Search for \"{0}\"", link);
        }
        return evt.getURL().toExternalForm();
    }

    protected static boolean isShowing() {
        return mDialog != null && mDialog.isVisible();
    }

    static boolean wasClosedRecently() {
        return System.currentTimeMillis() - mLastClosed < 100L;
    }

    static {
        mLastClosed = 0L;
    }
}

