/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.Program;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.extras.common.DayListCellRenderer;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.RenameWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import util.ui.ChannelChooserDlg;
import util.ui.Localizer;
import util.ui.TimePeriodChooser;
import util.ui.UiUtilities;

public class LimitationsWizardStep
extends AbstractWizardStep {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(LimitationsWizardStep.class);
    private JCheckBox mChannelCb;
    private JCheckBox mDayOfWeekCb;
    private JCheckBox mTimeCb;
    private JButton mChooseChannelsBtn;
    private JComboBox mDayOfWeekCombo;
    private TimePeriodChooser mTimePeriodChooser;
    private Program mProgram;
    private Channel[] mChannelArr;
    private WizardStep mCaller;
    private JPanel mContent;

    public LimitationsWizardStep(WizardStep caller, Program program) {
        this.mProgram = program;
        this.mCaller = caller;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Limitations");
    }

    @Override
    public JPanel createContent(WizardHandler handler) {
        int upBnd;
        int lowBnd;
        this.mChannelArr = this.mProgram != null ? new Channel[]{this.mProgram.getChannel()} : new Channel[0];
        this.mDayOfWeekCombo = new JComboBox<Object>(new Object[]{-1, -3, -2, 2, 3, 4, 5, 6, 7, 1});
        this.mDayOfWeekCombo.setRenderer(new DayListCellRenderer());
        if (this.mProgram != null) {
            lowBnd = (this.mProgram.getHours() - 1) * 60;
            if (lowBnd < 0) {
                lowBnd = 0;
            }
            if ((upBnd = lowBnd + 120) >= 1440) {
                upBnd = 1439;
            }
        } else {
            lowBnd = 0;
            upBnd = 1439;
        }
        this.mTimePeriodChooser = new TimePeriodChooser(lowBnd, upBnd, 1);
        CellConstraints cc = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, default:grow, pref", "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref"));
        panelBuilder.border(Borders.DLU4);
        panelBuilder.add((Component)new JLabel(mLocalizer.msg("mainQuestion", "Are there any limitations?")), cc.xy(1, 1));
        this.mChannelCb = new JCheckBox(mLocalizer.msg("limitByChannel", "Certain channels only:"));
        panelBuilder.add((Component)this.mChannelCb, cc.xy(1, 3));
        this.mDayOfWeekCb = new JCheckBox(mLocalizer.msg("limitByDayOfWeek", "Certain day of week only:"));
        panelBuilder.add((Component)this.mDayOfWeekCb, cc.xy(1, 5));
        this.mTimeCb = new JCheckBox(mLocalizer.msg("limitByTime", "Certain start times only:"));
        panelBuilder.add((Component)this.mTimeCb, cc.xy(1, 7));
        this.mChooseChannelsBtn = new JButton(mLocalizer.msg("selectChannels", "Select channels"));
        panelBuilder.add((Component)this.mChooseChannelsBtn, cc.xy(3, 3));
        panelBuilder.add((Component)this.mDayOfWeekCombo, cc.xy(3, 5));
        panelBuilder.add((Component)this.mTimePeriodChooser, cc.xy(3, 7));
        this.updateControls();
        this.mChannelCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LimitationsWizardStep.this.updateControls();
            }
        });
        this.mDayOfWeekCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LimitationsWizardStep.this.updateControls();
            }
        });
        this.mTimeCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LimitationsWizardStep.this.updateControls();
            }
        });
        this.mChooseChannelsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window parent = UiUtilities.getBestDialogParent(LimitationsWizardStep.this.mContent);
                ChannelChooserDlg dlg = new ChannelChooserDlg(parent, LimitationsWizardStep.this.mChannelArr, null, 1);
                UiUtilities.centerAndShow(dlg);
                Channel[] chArr = dlg.getChannels();
                if (chArr != null) {
                    LimitationsWizardStep.access$202(LimitationsWizardStep.this, dlg.getChannels());
                    if (LimitationsWizardStep.this.mChannelArr.length == 0) {
                        LimitationsWizardStep.this.mChannelCb.setSelected(false);
                        LimitationsWizardStep.this.updateControls();
                    }
                }
            }
        });
        this.mContent = panelBuilder.getPanel();
        this.mContent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LimitationsWizardStep.this.mChannelCb.requestFocusInWindow();
            }
        });
        return this.mContent;
    }

    private void updateControls() {
        this.mChooseChannelsBtn.setEnabled(this.mChannelCb.isSelected());
        this.mDayOfWeekCombo.setEnabled(this.mDayOfWeekCb.isSelected());
        this.mTimePeriodChooser.setEnabled(this.mTimeCb.isSelected());
    }

    @Override
    public Object createDataObject(Object obj) {
        Favorite fav = (Favorite)obj;
        if (this.mChannelCb.isSelected()) {
            fav.getLimitationConfiguration().setChannels(this.mChannelArr);
        }
        if (this.mTimeCb.isSelected()) {
            fav.getLimitationConfiguration().setTime(this.mTimePeriodChooser.getFromTime(), this.mTimePeriodChooser.getToTime());
        }
        if (this.mDayOfWeekCb.isSelected()) {
            int dayOfWeek = (Integer)this.mDayOfWeekCombo.getSelectedItem();
            fav.getLimitationConfiguration().setDayLimit(dayOfWeek);
            if (!this.mTimeCb.isSelected()) {
                fav.getLimitationConfiguration().setTime(0, 1439);
            }
        }
        return obj;
    }

    @Override
    public WizardStep next() {
        return new RenameWizardStep(this);
    }

    @Override
    public WizardStep back() {
        return this.mCaller;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4, 3, 1};
    }

    static /* synthetic */ Channel[] access$202(LimitationsWizardStep x0, Channel[] x1) {
        x0.mChannelArr = x1;
        return x1;
    }
}

