/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNodeComparator;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNodeCountComparator;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.favoritesplugin.dlgs.ManageFavoritesDialog;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.Localizer;
import util.ui.OverlayListener;
import util.ui.SingleAndDoubleClickTreeUI;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class FavoriteTree
extends JTree
implements DragGestureListener,
DropTargetListener {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(FavoriteTree.class);
    private FavoriteNode mTransferNode;
    private Rectangle2D mCueLine = new Rectangle2D.Float();
    private FavoriteNode mRootNode;
    private FavoriteNode mTargetNode;
    private int mTarget;
    private long mDragOverStart;
    private boolean mExpandListenerIsEnabled;
    private static final DataFlavor FAVORITE_FLAVOR = new DataFlavor(TreePath.class, "FavoriteNodeExport");

    public FavoriteTree() {
        this.init();
    }

    @Override
    public void updateUI() {
        this.setUI(new FavoriteTreeUI(0, this.getSelectionPath()));
        this.invalidate();
    }

    private void init() {
        this.setModel(FavoriteTreeModel.getInstance());
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.mRootNode = (FavoriteNode)FavoriteTreeModel.getInstance().getRoot();
        FavoriteTreeCellRenderer renderer = new FavoriteTreeCellRenderer();
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
        this.mExpandListenerIsEnabled = false;
        this.expand(this.mRootNode);
        this.mExpandListenerIsEnabled = true;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    if (FavoriteTree.this.getSelectionPath() != null) {
                        FavoriteNode node = (FavoriteNode)FavoriteTree.this.getSelectionPath().getLastPathComponent();
                        FavoriteNode parent = (FavoriteNode)node.getParent();
                        int n = parent.getIndex(node);
                        FavoriteTree.this.delete((FavoriteNode)FavoriteTree.this.getSelectionPath().getLastPathComponent());
                        if (n >= parent.getChildCount()) {
                            --n;
                        }
                        if (n > 0) {
                            FavoriteTree.this.setSelectionPath(new TreePath(((FavoriteNode)parent.getChildAt(n)).getPath()));
                        } else {
                            FavoriteTree.this.setSelectionPath(new TreePath(parent.getPath()));
                        }
                    }
                } else if (e.getKeyCode() == 525) {
                    if (FavoriteTree.this.getSelectionPath() != null) {
                        Rectangle pathBounds = FavoriteTree.this.getRowBounds(FavoriteTree.this.getRowForPath(FavoriteTree.this.getSelectionPath()));
                        FavoriteTree.this.showContextMenu(new Point(pathBounds.x + pathBounds.width - 10, pathBounds.y + pathBounds.height - 5));
                    }
                } else if (e.getKeyCode() == 113 && FavoriteTree.this.getSelectionPath() != null) {
                    FavoriteNode node = (FavoriteNode)FavoriteTree.this.getSelectionPath().getLastPathComponent();
                    if (node.isDirectoryNode()) {
                        FavoriteTree.this.renameFolder(node);
                    } else {
                        FavoritesPlugin.getInstance().editSelectedFavorite();
                    }
                }
            }
        });
        this.mExpandListenerIsEnabled = true;
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                if (e.getPath() != null && FavoriteTree.this.mExpandListenerIsEnabled) {
                    ((FavoriteNode)e.getPath().getLastPathComponent()).setWasExpanded(false);
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                if (e.getPath() != null && FavoriteTree.this.mExpandListenerIsEnabled) {
                    ((FavoriteNode)e.getPath().getLastPathComponent()).setWasExpanded(true);
                }
            }
        });
        this.getSelectionModel().setSelectionMode(1);
        new OverlayListener(this);
        new DragSource().createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    protected void reload(FavoriteNode node) {
        this.mExpandListenerIsEnabled = false;
        this.getModel().reload(this, node);
        this.mExpandListenerIsEnabled = true;
    }

    private void showContextMenu(Point p) {
        try {
            JMenuItem item;
            JPopupMenu menu = new JPopupMenu();
            int row = this.getClosestRowForLocation(p.x, p.y);
            if (row >= 0 && row < this.getRowCount()) {
                this.setSelectionRow(row);
            }
            TreePath path1 = null;
            int[] selectionRows = this.getSelectionRows();
            if (selectionRows.length > 0) {
                path1 = this.getPathForRow(selectionRows[0]);
            }
            if (path1 == null) {
                path1 = new TreePath(this.mRootNode);
            }
            final TreePath path = path1;
            final FavoriteNode last = (FavoriteNode)path.getLastPathComponent();
            this.setSelectionPath(path);
            if (last.isDirectoryNode() && last.getChildCount() > 0) {
                item = new JMenuItem(this.isExpanded(path) ? LOCALIZER.msg("collapse", "Collapse") : LOCALIZER.msg("expand", "Expand"));
                item.setFont(item.getFont().deriveFont(1));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (FavoriteTree.this.isExpanded(path)) {
                            FavoriteTree.this.collapsePath(path);
                        } else {
                            FavoriteTree.this.expandPath(path);
                        }
                    }
                });
                if (!last.equals(this.mRootNode)) {
                    menu.add(item);
                }
                item = new JMenuItem(LOCALIZER.msg("expandAll", "Expand all"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoriteTree.this.expandAll(last);
                    }
                });
                menu.add(item);
                item = new JMenuItem(LOCALIZER.msg("collapseAll", "Collapse all"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoriteTree.this.collapseAll(last);
                    }
                });
                menu.add(item);
                menu.addSeparator();
            }
            if (!last.isDirectoryNode()) {
                item = new JMenuItem(LOCALIZER.ellipsisMsg("editFavorite", "Edit favorite '{0}'", last.getFavorite().getName()), TVBrowserIcons.edit(16));
                item.setFont(item.getFont().deriveFont(1));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoritesPlugin.getInstance().editSelectedFavorite();
                    }
                });
                menu.add(item);
                menu.addSeparator();
            }
            item = new JMenuItem(LOCALIZER.msg("newFolder", "New folder"), IconLoader.getInstance().getIconFromTheme("actions", "folder-new", 16));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FavoritesPlugin.getInstance().newFolder(last);
                }
            });
            menu.add(item);
            item = new JMenuItem(LOCALIZER.ellipsisMsg("newFavorite", "New Favorite"), TVBrowserIcons.newIcon(16));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FavoritesPlugin.getInstance().newFavorite(last.isDirectoryNode() ? last : (FavoriteNode)last.getParent());
                }
            });
            menu.add(item);
            if (last.isDirectoryNode()) {
                Favorite[] favorites;
                if (!last.equals(this.mRootNode)) {
                    item = new JMenuItem(LOCALIZER.msg("renameFolder", "Rename folder"), TVBrowserIcons.edit(16));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FavoriteTree.this.renameFolder(last);
                        }
                    });
                    menu.add(item);
                }
                if ((favorites = FavoriteTreeModel.getInstance().getFavoriteArr(last, false)).length > 0) {
                    menu.addSeparator();
                    item = new JMenuItem(LOCALIZER.msg("enableReminder", "Enable reminder window for all favorites in folder"), IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (Favorite favorite : favorites) {
                                boolean isReminderEnabled = favorite.getReminderConfiguration().containsService("window");
                                if (isReminderEnabled) continue;
                                favorite.getReminderConfiguration().setReminderServices(new String[]{"window"});
                                ReminderPlugin.getInstance().addPrograms(favorite.getPrograms());
                            }
                            FavoritesPlugin.getInstance().saveFavorites();
                            ReminderPlugin.getInstance().updateRootNode(true);
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem(LOCALIZER.msg("disableReminder", "Disable reminder window for all favorites in folder"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (Favorite favorite : favorites) {
                                boolean isReminderEnabled = favorite.getReminderConfiguration().containsService("window");
                                if (!isReminderEnabled) continue;
                                ReminderPlugin.getInstance().removePrograms(favorite.getPrograms());
                                favorite.getReminderConfiguration().setReminderServices(new String[0]);
                            }
                            FavoritesPlugin.getInstance().saveFavorites();
                            ReminderPlugin.getInstance().updateRootNode(true);
                        }
                    });
                    menu.add(item);
                    menu.addSeparator();
                    item = new JMenuItem(LOCALIZER.msg("enableAlert", "Enable alert for new found programs for all favorites in folder"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (Favorite favorite : favorites) {
                                favorite.setRemindAfterDownload(true);
                            }
                            FavoritesPlugin.getInstance().saveFavorites();
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem(LOCALIZER.msg("disableAlert", "Disable alert for new found programs for all favorites in folder"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (Favorite favorite : favorites) {
                                favorite.setRemindAfterDownload(false);
                            }
                            FavoritesPlugin.getInstance().saveFavorites();
                        }
                    });
                    menu.add(item);
                    menu.addSeparator();
                    item = new JMenuItem(LOCALIZER.msg("deleteAllFavoritesInFolder", "Delete all Favorites in folder"), TVBrowserIcons.delete(16));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("deleteAllFavoritesInFolder.warningMessage", "You are about to delete all favorites in this folder.\n\nAre you sure, you want to delete all favorites in this folder (this cannot be undone)?"), LOCALIZER.msg("deleteAllFavoritesInFolder.warningTitle", "Delete all Favorites in folder?"), 0, 2) == 0) {
                                for (Favorite favorite : favorites) {
                                    FavoriteTreeModel.getInstance().deleteFavorite(favorite, false);
                                }
                                FavoritesPlugin.getInstance().updateRootNode(true);
                            }
                        }
                    });
                    menu.add(item);
                }
            }
            FavoriteNode parentSort = null;
            if (!last.isDirectoryNode() && last.getParent().equals(this.mRootNode) && this.mRootNode.getChildCount() > 1) {
                parentSort = (FavoriteNode)last.getParent();
            }
            final FavoriteNode sortNode = parentSort == null ? last : parentSort;
            System.out.println(last + " " + last.getParent());
            if (last.getChildCount() > 1 || this.mRootNode.equals(last.getParent()) && this.mRootNode.getChildCount() > 1) {
                menu.addSeparator();
                item = new JMenuItem(LOCALIZER.msg("sort", "Sort alphabetically"), IconLoader.getInstance().getIconFromTheme("actions", "sort-list", 16));
                final String titleAlpha = item.getText();
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoriteTreeModel.getInstance().sort(sortNode, FavoriteNodeComparator.getInstance(), titleAlpha);
                        FavoriteTree.this.reload(sortNode);
                    }
                });
                menu.add(item);
                item = new JMenuItem(LOCALIZER.msg("sortCount", "Sort by number of programs"), IconLoader.getInstance().getIconFromTheme("actions", "sort-list-numerical", 16));
                final String titleCount = item.getText();
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoriteTreeModel.getInstance().sort(sortNode, FavoriteNodeCountComparator.getInstance(), titleCount);
                        FavoriteTree.this.reload(sortNode);
                    }
                });
                menu.add(item);
            }
            if (parentSort != null) {
                menu.addSeparator();
            }
            item = new JMenuItem(Localizer.getLocalization("i18n_delete"), TVBrowserIcons.delete(16));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FavoriteTree.this.delete(last);
                }
            });
            if (!last.equals(this.mRootNode) && last.getChildCount() < 1) {
                menu.add(item);
            }
            if (!FavoritesPlugin.getInstance().programListIsEmpty()) {
                menu.addSeparator();
                item = new JMenuItem(ManageFavoritesDialog.mLocalizer.msg("send", "Send Programs to another Plugin"), TVBrowserIcons.copy(16));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        FavoritesPlugin.getInstance().showSendDialog();
                    }
                });
                menu.add(item);
            }
            menu.show(this, p.x, p.y);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void delete(FavoriteNode node) {
        if (node.isDirectoryNode() && node.getChildCount() < 1) {
            FavoriteNode parent = (FavoriteNode)node.getParent();
            parent.remove(node);
            this.getModel().reload(parent);
        } else if (node.containsFavorite()) {
            FavoritesPlugin.getInstance().deleteSelectedFavorite();
        }
    }

    private void expandAll(FavoriteNode node) {
        if (node.isDirectoryNode()) {
            this.expandPath(new TreePath(node.getPath()));
            for (int i = 0; i < node.getChildCount(); ++i) {
                FavoriteNode child = (FavoriteNode)node.getChildAt(i);
                if (!child.isDirectoryNode()) continue;
                this.expandPath(new TreePath(child.getPath()));
                this.expandAll(child);
            }
        }
    }

    private void collapseAll(FavoriteNode node) {
        if (node.isDirectoryNode()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                FavoriteNode child = (FavoriteNode)node.getChildAt(i);
                if (!child.isDirectoryNode()) continue;
                this.collapseAll(child);
                this.collapsePath(new TreePath(child.getPath()));
            }
            if (!node.equals(this.mRootNode)) {
                this.collapsePath(new TreePath(node.getPath()));
            }
        }
    }

    private void expand(FavoriteNode node) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            FavoriteNode child = (FavoriteNode)e.nextElement();
            if (!child.isDirectoryNode()) continue;
            this.expand(child);
        }
        if (node.wasExpanded()) {
            this.expandPath(new TreePath(this.getModel().getPathToRoot(node)));
        } else {
            this.collapsePath(new TreePath(this.getModel().getPathToRoot(node)));
        }
    }

    @Override
    public FavoriteTreeModel getModel() {
        return (FavoriteTreeModel)super.getModel();
    }

    public FavoriteNode getRoot() {
        return this.mRootNode;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        this.mTransferNode = (FavoriteNode)this.getLastSelectedPathComponent();
        if (this.mTransferNode != null) {
            e.startDrag(null, new FavoriteTransferNode());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.getCurrentDataFlavors().length > 1 || e.getCurrentDataFlavors().length < 1 || !e.getCurrentDataFlavors()[0].equals(FAVORITE_FLAVOR)) {
            e.rejectDrag();
        } else if (this.calculateCueLine(e.getLocation())) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.paintImmediately(this.mCueLine.getBounds());
        this.mCueLine.setRect(0.0, 0.0, 0.0, 0.0);
        this.mTarget = -2;
    }

    private int getTargetFor(FavoriteNode node, Point p, int row) {
        Rectangle location = this.getRowBounds(this.getClosestRowForLocation(p.x, p.y));
        if (node.isDirectoryNode()) {
            if (row != this.getRowCount() && p.y - location.y <= location.height / 4) {
                return -1;
            }
            if (row != this.getRowCount() && p.y - location.y <= location.height - location.height / 4) {
                return 0;
            }
            return 1;
        }
        if (p.y - location.y <= location.height / 2) {
            return -1;
        }
        return 1;
    }

    private boolean calculateCueLine(Point p) {
        TreePath path;
        int row = this.getClosestRowForLocation(p.x, p.y);
        Rectangle rowBounds = this.getRowBounds(row);
        if (rowBounds.y + rowBounds.height < p.y) {
            row = this.getRowCount();
        }
        if ((path = this.getPathForRow(row)) == null) {
            path = new TreePath(this.mRootNode);
        }
        if (this.mTransferNode != null && !new TreePath(this.mTransferNode.getPath()).isDescendant(path)) {
            FavoriteNode last = (FavoriteNode)path.getLastPathComponent();
            FavoriteNode pointed = last;
            int target = this.getTargetFor(pointed, p, row);
            if ((target == -1 || target == 1 && !this.isExpanded(new TreePath(pointed.getPath()))) && !last.isRoot()) {
                last = (FavoriteNode)last.getParent();
            }
            if (this.mTarget == 0 && System.currentTimeMillis() - this.mDragOverStart > 1000L && this.isCollapsed(new TreePath(last.getPath())) && last.getChildCount() > 0) {
                this.expandPath(new TreePath(last.getPath()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FavoriteTree.this.mTarget = -2;
                    }
                });
            }
            if (this.mTargetNode != last || this.mTarget != target) {
                Rectangle rect;
                int y;
                this.mTargetNode = last;
                this.mTarget = target;
                this.mDragOverStart = System.currentTimeMillis();
                this.paintImmediately(this.mCueLine.getBounds());
                int n = y = row != this.getRowCount() ? rowBounds.y : rowBounds.y + rowBounds.height;
                if (target == -1) {
                    rect = new Rectangle(rowBounds.x, y - 1, rowBounds.width, 2);
                    this.mCueLine.setRect(rect);
                } else if (target == 0) {
                    rect = new Rectangle(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
                    this.mCueLine.setRect(rect);
                } else if (target == 1) {
                    rect = new Rectangle(rowBounds.x, y + rowBounds.height - 1, rowBounds.width, 2);
                    if (row == this.getRowCount()) {
                        rect = new Rectangle(0, y - 1, this.getWidth(), 2);
                    }
                    this.mCueLine.setRect(rect);
                }
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                Color c = new Color(255, 0, 0, this.mCueLine.getHeight() > 2.0 ? 40 : 180);
                g2.setColor(c);
                g2.fill(this.mCueLine);
            }
            return true;
        }
        return false;
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.getCurrentDataFlavors().length > 1 || e.getCurrentDataFlavors().length < 1 || !e.getCurrentDataFlavors()[0].equals(FAVORITE_FLAVOR)) {
            this.paintImmediately(this.mCueLine.getBounds());
            e.rejectDrag();
        } else if (this.calculateCueLine(e.getLocation())) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
        if (this.getVisibleRect().width < this.getSize().width || this.getVisibleRect().height < this.getSize().height) {
            int scroll = 20;
            if (e.getLocation().y + scroll + 5 > this.getVisibleRect().height) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x, e.getLocation().y + scroll + 5, 1, 1));
            }
            if (e.getLocation().y - scroll < this.getVisibleRect().y) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x, e.getLocation().y - scroll, 1, 1));
            }
            if (e.getLocation().x - scroll < this.getVisibleRect().x) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x - scroll, e.getLocation().y, 1, 1));
            }
            if (e.getLocation().x + scroll + 5 > this.getVisibleRect().width) {
                this.scrollRectToVisible(new Rectangle(e.getLocation().x + scroll + 5, e.getLocation().y, 1, 1));
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(e.getDropAction());
        this.paintImmediately(this.mCueLine.getBounds());
        Transferable transfer = e.getTransferable();
        if (transfer.isDataFlavorSupported(new DataFlavor(TreePath.class, "FavoriteNodeExport"))) {
            try {
                FavoriteNode last;
                FavoriteNode node = this.mTransferNode;
                FavoriteNode parent = (FavoriteNode)node.getParent();
                int row = this.getClosestRowForLocation(e.getLocation().x, e.getLocation().y);
                TreePath path = new TreePath(this.mRootNode);
                if (this.getRowBounds((int)row).y + this.getRowBounds((int)row).height < e.getLocation().y) {
                    row = this.getRowCount();
                } else {
                    path = this.getPathForRow(row);
                }
                if (path == null) {
                    path = new TreePath(this.mRootNode);
                }
                FavoriteNode pointed = last = (FavoriteNode)path.getLastPathComponent();
                int target = this.getTargetFor(pointed, e.getLocation(), row);
                if (!new TreePath(node.getPath()).isDescendant(path)) {
                    this.setSelectionPath(null);
                    parent.remove(node);
                    int n = -1;
                    if (target == -1 || target == 1 && !this.isExpanded(new TreePath(pointed.getPath()))) {
                        if (last.isRoot()) {
                            n = 0;
                        } else {
                            n = last.getParent().getIndex(last);
                            last = (FavoriteNode)last.getParent();
                        }
                    }
                    if (target == -1) {
                        last.insert(node, n);
                    } else if (target == 0) {
                        if (this.isExpanded(new TreePath(last))) {
                            last.insert(node, 0);
                        } else {
                            last.add(node);
                        }
                    } else if (row != this.getRowCount()) {
                        last.insert(node, n + 1);
                    } else {
                        last.add(node);
                    }
                    this.expandPath(new TreePath(last.getPath()));
                    this.mExpandListenerIsEnabled = false;
                    this.expand(last);
                    this.mExpandListenerIsEnabled = true;
                }
                this.updateUI();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        e.dropComplete(true);
        FavoritesPlugin.getInstance().updateRootNode(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void newFolder(FavoriteNode parent, Window partenWindow) {
        String value = JOptionPane.showInputDialog(partenWindow, LOCALIZER.msg("folderName", "Folder name:"), LOCALIZER.msg("newFolder", "New folder"));
        if (value != null && value.length() > 0) {
            FavoriteNode node = new FavoriteNode(value);
            if (parent.equals(this.mRootNode) || parent.isDirectoryNode()) {
                parent.add(node);
                this.expandPath(new TreePath(parent.getPath()));
            } else {
                ((FavoriteNode)parent.getParent()).insert(node, parent.getParent().getIndex(parent));
            }
            this.reload((FavoriteNode)node.getParent());
        }
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        int[] count;
        StringBuilder text = new StringBuilder(value.toString());
        if (value instanceof FavoriteNode && (count = FavoriteTreeModel.getProgramsCount((FavoriteNode)value))[0] > 0) {
            if (count[1] < 1) {
                text.append(" [").append(count[0]).append(']');
            } else {
                text.append(" [").append(count[0]).append(", ").append(Localizer.getLocalization("i18n_today")).append(": ").append(count[1]).append(']');
            }
        }
        return text.toString();
    }

    protected void moveSelectedFavorite(int rowCount) {
        TreePath path;
        int row;
        FavoriteNode src = (FavoriteNode)this.getSelectionPath().getLastPathComponent();
        if (src.isDirectoryNode()) {
            this.collapseAll(src);
        }
        if ((row = this.getRowForPath(this.getSelectionPath())) != -1 && (path = this.getPathForRow(row + rowCount)) != null) {
            FavoriteNode srcParent = (FavoriteNode)src.getParent();
            FavoriteNode target = (FavoriteNode)path.getLastPathComponent();
            FavoriteNode tarParent = target.equals(this.mRootNode) ? this.mRootNode : (FavoriteNode)target.getParent();
            int n = tarParent.getIndex(target);
            srcParent.remove(src);
            if (n > -1) {
                tarParent.insert(src, n);
            } else {
                tarParent.add(src);
            }
            this.reload(srcParent);
            this.reload(tarParent);
            this.setSelectionPath(new TreePath(src.getPath()));
            this.expandPath(new TreePath(tarParent.getPath()));
            this.mExpandListenerIsEnabled = false;
            this.expand(tarParent);
            this.mExpandListenerIsEnabled = true;
        }
    }

    protected void renameFolder(FavoriteNode node) {
        String value;
        if (node != null && node.isDirectoryNode() && (value = JOptionPane.showInputDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("folderName", "Folder name:"), node.getUserObject())) != null) {
            node.setUserObject(value);
            this.updateUI();
        }
    }

    protected FavoriteNode findFavorite(Favorite favorite) {
        return this.findFavorite(favorite, this.getRoot());
    }

    private FavoriteNode findFavorite(Favorite favorite, FavoriteNode root) {
        if (root.isDirectoryNode()) {
            Enumeration<TreeNode> e = root.children();
            while (e.hasMoreElements()) {
                FavoriteNode child = (FavoriteNode)e.nextElement();
                if (child.isDirectoryNode()) {
                    FavoriteNode result = this.findFavorite(favorite, child);
                    if (result == null) continue;
                    return result;
                }
                if (!child.getFavorite().equals(favorite)) continue;
                return child;
            }
        }
        return null;
    }

    private static class FavoriteTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private FavoriteTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, cellHasFocus);
            if (label != null && UiUtilities.isGTKLookAndFeel()) {
                label.setBackground(tree.getBackground());
                label.setOpaque(!sel && !cellHasFocus);
            }
            if (value instanceof FavoriteNode) {
                Favorite fav;
                FavoriteNode node = (FavoriteNode)value;
                if (leaf && node.isDirectoryNode()) {
                    label.setIcon(this.getClosedIcon());
                }
                if ((fav = node.getFavorite()) != null && !fav.isValidSearch()) {
                    label.setForeground(Color.orange);
                    label.setText("<html><strike>" + label.getText() + "</strike></html>");
                }
            }
            if (UiUtilities.isNimbusLookAndFeel()) {
                if (sel) {
                    label.setOpaque(true);
                    label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    label.setOpaque(false);
                }
            }
            return label;
        }
    }

    private class FavoriteTreeUI
    extends SingleAndDoubleClickTreeUI
    implements MouseListener {
        public FavoriteTreeUI(int type, TreePath selectedPath) {
            super(type, selectedPath);
        }

        @Override
        protected MouseListener createMouseListener() {
            return this;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            System.out.println("mousePressed " + e.isConsumed() + " " + e.isPopupTrigger());
            if (!e.isConsumed() && e.isPopupTrigger()) {
                FavoriteTree.this.showContextMenu(e.getPoint());
            }
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            System.out.println("mouseReleased " + e.isConsumed() + " " + e.isPopupTrigger());
            if (!e.isConsumed()) {
                if (e.isPopupTrigger()) {
                    FavoriteTree.this.showContextMenu(e.getPoint());
                }
                super.mouseReleased(e);
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2) {
                    FavoritesPlugin.getInstance().editSelectedFavorite();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static class FavoriteTransferNode
    implements Transferable {
        private FavoriteTransferNode() {
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FAVORITE_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.getMimeType().equals(FAVORITE_FLAVOR.getMimeType()) && df.getHumanPresentableName().equals(FAVORITE_FLAVOR.getHumanPresentableName());
        }
    }
}

