/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.ContextMenuIf;
import devplugin.Marker;
import devplugin.PluginCenterPanelWrapper;
import devplugin.Program;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.extras.common.AbstractInternalPluginProxy;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesSettingTab;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;

public class FavoritesPluginProxy
extends AbstractInternalPluginProxy
implements ButtonActionIf,
ContextMenuIf,
Marker {
    private static final String PROGRAM_TARGET_TITLE_FAVORITE = "target_favorite_title";
    private static FavoritesPluginProxy mInstance;
    private Icon mMarkIcon;
    private Icon[] mMarkIconArr;
    private Icon[] mMultipleIconArr;

    private FavoritesPluginProxy() {
        mInstance = this;
    }

    public static FavoritesPluginProxy getInstance() {
        if (mInstance == null) {
            new FavoritesPluginProxy();
        }
        return mInstance;
    }

    @Override
    public ActionMenu getContextMenuActions(Program program) {
        return FavoritesPluginProxy.getFavoritesInstance().getContextMenuActions(program);
    }

    @Override
    public String getId() {
        return FavoritesPlugin.getFavoritesPluginId();
    }

    public String toString() {
        return FavoritesPlugin.getInstance().getName();
    }

    @Override
    public Icon getMarkIcon() {
        this.createIcons();
        return this.mMarkIcon;
    }

    private void createIcons() {
        if (this.mMarkIcon == null) {
            this.mMarkIcon = FavoritesPlugin.getFavoritesIcon(16);
            this.mMultipleIconArr = new Icon[]{this.getDoubleIcon(this.mMarkIcon, 12)};
            this.mMarkIconArr = new Icon[]{this.mMarkIcon};
        }
    }

    @Override
    public Icon[] getMarkIcons(Program program) {
        this.createIcons();
        if (FavoriteTreeModel.getInstance().isInMultipleFavorites(program)) {
            return this.mMultipleIconArr;
        }
        return this.mMarkIconArr;
    }

    @Override
    public int getMarkPriorityForProgram(Program p) {
        return FavoritesPluginProxy.getFavoritesInstance().getMarkPriority();
    }

    @Override
    public Icon getIcon() {
        return this.getMarkIcon();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public String getButtonActionDescription() {
        return FavoritesPlugin.mLocalizer.msg("description", "Automatically marks your favorite programs and passes them to other plugins.");
    }

    @Override
    public SettingsTab getSettingsTab() {
        return new FavoritesSettingTab();
    }

    @Override
    public String getSettingsId() {
        return "#favorite";
    }

    @Override
    public ActionMenu getButtonAction() {
        return FavoritesPlugin.getInstance().getButtonAction();
    }

    private Icon getDoubleIcon(Icon icon, int width) {
        try {
            if (icon == null) {
                return null;
            }
            BufferedImage iconimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g2 = iconimage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            AffineTransform z = g2.getTransform();
            double scale = (double)width / (double)icon.getIconWidth();
            z.scale(scale, scale);
            g2.setTransform(z);
            icon.paintIcon(null, g2, 0, 0);
            icon.paintIcon(null, g2, icon.getIconWidth() - width, icon.getIconHeight() - width);
            g2.dispose();
            return new ImageIcon(iconimage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return icon;
        }
    }

    @Override
    public void handleTvDataUpdateFinished() {
        FavoritesPluginProxy.getFavoritesInstance().handleTvDataUpdateFinished();
    }

    private static FavoritesPlugin getFavoritesInstance() {
        return FavoritesPlugin.getInstance();
    }

    @Override
    public boolean canReceiveProgramsWithTarget() {
        return true;
    }

    @Override
    public boolean receivePrograms(Program[] programArr, ProgramReceiveTarget receiveTarget) {
        FavoritesPluginProxy.getFavoritesInstance().addTitleFavorites(programArr);
        return true;
    }

    @Override
    public ProgramReceiveTarget[] getProgramReceiveTargets() {
        return new ProgramReceiveTarget[]{new ProgramReceiveTarget(this, FavoritesPlugin.mLocalizer.msg("programTarget", "Create favorite from title"), PROGRAM_TARGET_TITLE_FAVORITE)};
    }

    @Override
    public String getPluginCategory() {
        return "misc";
    }

    @Override
    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return FavoritesPlugin.getInstance().getPluginCenterPanelWrapper();
    }

    @Override
    public AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        return FavoritesPlugin.getInstance().getAfterDataUpdateInfoPanel();
    }

    @Override
    public void handleTvBrowserStartFinished() {
        FavoritesPlugin.getInstance().handleTvBrowserStartFinished();
    }
}

