/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.common;

import devplugin.Date;
import java.util.ArrayList;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.programinfo.ProgramInfoProxy;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.searchplugin.SearchPluginProxy;

public class InternalPluginProxyList {
    private ArrayList<InternalPluginProxyIf> mList;
    private static InternalPluginProxyList mInstance;

    private InternalPluginProxyList() {
        mInstance = this;
        this.mList = new ArrayList();
        this.mList.add(ProgramInfoProxy.getInstance());
        this.mList.add(ReminderPluginProxy.getInstance());
        this.mList.add(FavoritesPluginProxy.getInstance());
        this.mList.add(SearchPluginProxy.getInstance());
        TvDataUpdater.getInstance().addTvDataUpdateListener(new TvDataUpdateListener(){

            @Override
            public void tvDataUpdateStarted(Date until) {
            }

            @Override
            public void tvDataUpdateFinished() {
                for (InternalPluginProxyIf proxy : InternalPluginProxyList.this.mList) {
                    proxy.handleTvDataUpdateFinished();
                }
            }
        });
    }

    public static InternalPluginProxyList getInstance() {
        if (mInstance == null) {
            new InternalPluginProxyList();
        }
        return mInstance;
    }

    public InternalPluginProxyIf[] getAvailableProxys() {
        return this.mList.toArray(new InternalPluginProxyIf[this.mList.size()]);
    }

    public InternalPluginProxyIf getProxyForId(String id) {
        for (InternalPluginProxyIf internalPluginProxy : this.mList) {
            if (!internalPluginProxy.getId().equals(id)) continue;
            return internalPluginProxy;
        }
        return null;
    }
}

