/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.InfoIconTheme;

public class InfoThemeLoader {
    private static final Logger LOGGER = Logger.getLogger(InfoThemeLoader.class.getName());
    private static InfoThemeLoader INSTANCE;
    public static final File USER_ICON_DIR;
    public static final String DOWNLOAD_SPEC_URL = "http://www.tvbrowser.org/downloads/infothemes/infothemes.txt";
    private static final FileFilter THEME_FILE_FILTER;
    private HashMap<String, InfoIconTheme> mInfoIconThemeMap = new HashMap();

    private InfoThemeLoader() {
        File[] iconThemes;
        File[] iconThemes2;
        LOGGER.info("Try to load user info icon themes from: " + USER_ICON_DIR.getAbsolutePath());
        if (USER_ICON_DIR.isDirectory() && (iconThemes2 = USER_ICON_DIR.listFiles(THEME_FILE_FILTER)) != null) {
            for (File iconTheme : iconThemes2) {
                this.addIconTheme(iconTheme);
            }
        }
        File globalThemes = new File(Settings.getDefaultSettings().getProperty("infothemedirectory", "infothemes"));
        LOGGER.info("Try to load global info icon themes from: " + globalThemes.getAbsolutePath());
        if (globalThemes.isDirectory() && (iconThemes = globalThemes.listFiles(THEME_FILE_FILTER)) != null) {
            for (File iconTheme : iconThemes) {
                this.addIconTheme(iconTheme);
            }
        }
    }

    public void addIconTheme(File iconTheme) {
        InfoIconTheme theme = new InfoIconTheme(iconTheme);
        if (theme.toString() != null && !this.mInfoIconThemeMap.containsKey(theme.getID())) {
            this.mInfoIconThemeMap.put(theme.getID(), theme);
        }
    }

    public static synchronized InfoThemeLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InfoThemeLoader();
        }
        return INSTANCE;
    }

    public InfoIconTheme getIconThemeForID(String id) {
        return this.mInfoIconThemeMap.get(id);
    }

    public InfoIconTheme getIconThemeForIDOrDefault(String id) {
        InfoIconTheme theme = this.mInfoIconThemeMap.get(id);
        if (theme == null) {
            theme = this.getDefaultTheme();
        }
        return theme;
    }

    public InfoIconTheme getDefaultTheme() {
        InfoIconTheme test = this.mInfoIconThemeMap.get(Settings.propInfoIconThemeID.getDefault());
        if (test == null && !this.mInfoIconThemeMap.isEmpty()) {
            test = this.getAvailableInfoIconThemes()[0];
        }
        return test;
    }

    public InfoIconTheme[] getAvailableInfoIconThemes() {
        Object[] iconThemes = this.mInfoIconThemeMap.values().toArray(new InfoIconTheme[this.mInfoIconThemeMap.size()]);
        Arrays.sort(iconThemes);
        return iconThemes;
    }

    static {
        USER_ICON_DIR = new File(Settings.getUserDirectoryName(), "infothemes");
        THEME_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.isFile() && pathname.getName().toLowerCase().endsWith(".zip");
            }
        };
    }
}

