/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import devplugin.Plugin;
import devplugin.ThemeIcon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.DirectoryIconTheme;
import tvbrowser.core.icontheme.IconTheme;
import tvbrowser.core.icontheme.ZipIconTheme;
import util.misc.OperatingSystem;
import util.misc.SoftReferenceCache;
import util.ui.ImageUtilities;

public class IconLoader {
    private static final Logger mLog = Logger.getLogger(IconLoader.class.getName());
    private static IconLoader mInstance;
    private IconTheme mDefaultIconTheme;
    private IconTheme mIconTheme;
    private File mDefaultIconDir = new File(Settings.getDefaultSettings().getProperty("icontheme", "icons/tango.zip"));
    private SoftReferenceCache<ThemeIcon, ImageIcon> mIconCache;
    private HashMap<Plugin, SoftReferenceCache<ThemeIcon, ImageIcon>> mPluginIconCache;
    public static final File USER_ICON_DIR;
    public static final String DOWNLOAD_SPEC_URL = "http://www.tvbrowser.org/downloads/themes/themes.txt";

    private IconLoader() {
        File[] list;
        File iconDir;
        mLog.info("Try to load default icon theme from: " + this.mDefaultIconDir.getAbsolutePath());
        if (!this.mDefaultIconDir.exists() && (iconDir = new File("icons")).exists() && (list = iconDir.listFiles()).length > 0) {
            this.mDefaultIconDir = list[0];
        }
        this.mDefaultIconTheme = this.getIconTheme(this.mDefaultIconDir);
        this.mDefaultIconTheme.loadTheme();
        String iconTheme = Settings.propIcontheme.getString();
        if (iconTheme != null) {
            if (iconTheme != null && !iconTheme.endsWith(".zip") && new File(iconTheme + ".zip").canRead()) {
                Settings.propIcontheme.setString(iconTheme + ".zip");
            }
            File themeFile = this.getIconThemeFile(iconTheme);
            mLog.info("Loading Icon from " + themeFile.getAbsolutePath());
            this.loadIconTheme(themeFile);
        } else {
            this.mIconCache = new SoftReferenceCache();
            this.mPluginIconCache = new HashMap();
            this.mIconTheme = this.mDefaultIconTheme;
        }
    }

    public File getIconThemeFile(String theme) {
        File themeFile = new File(theme);
        if (!themeFile.exists()) {
            themeFile = new File(Settings.getUserDirectoryName(), theme);
        }
        if (!themeFile.exists() && OperatingSystem.isMacOs()) {
            themeFile = new File("/Library/Application Support/TV-Browser/", theme);
        }
        return themeFile;
    }

    public IconTheme[] getAvailableThemes() {
        ArrayList<IconTheme> list = new ArrayList<IconTheme>();
        list.addAll(this.getThemesInDirectory(USER_ICON_DIR));
        ArrayList<IconTheme> globalThemes = this.getThemesInDirectory(new File("icons"));
        for (IconTheme test : list) {
            for (int i = globalThemes.size() - 1; i >= 0; --i) {
                if (!test.getName().equals(globalThemes.get(i).getName())) continue;
                globalThemes.remove(i);
            }
        }
        list.addAll(globalThemes);
        if (OperatingSystem.isMacOs()) {
            list.addAll(this.getThemesInDirectory(new File(Settings.getOSLibraryDirectoryName() + "icons")));
        }
        ArrayList<String> zipThemes = new ArrayList<String>(list.size());
        for (IconTheme iconTheme : list) {
            if (!(iconTheme instanceof ZipIconTheme)) continue;
            zipThemes.add(iconTheme.getName());
        }
        block3: for (int i = list.size() - 1; i >= 0; --i) {
            for (String zipName : zipThemes) {
                IconTheme test = (IconTheme)list.get(i);
                if (!test.getName().equalsIgnoreCase(zipName) || test instanceof ZipIconTheme) continue;
                list.remove(i);
                continue block3;
            }
        }
        return list.toArray(new IconTheme[list.size()]);
    }

    private ArrayList<IconTheme> getThemesInDirectory(File directory) {
        File[] files;
        ArrayList<IconTheme> list = new ArrayList<IconTheme>();
        if (directory != null && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                IconTheme theme = this.getIconTheme(file);
                if (!theme.loadTheme()) continue;
                list.add(theme);
            }
        }
        return list;
    }

    private void loadIconTheme(File iconset) {
        this.mIconCache = new SoftReferenceCache();
        this.mPluginIconCache = new HashMap();
        if (!iconset.exists()) {
            iconset = this.mDefaultIconDir;
        }
        if (!this.mDefaultIconDir.getPath().equals(iconset.getPath())) {
            this.mIconTheme = this.getIconTheme(iconset);
            if (!this.mIconTheme.loadTheme()) {
                this.mIconTheme = this.mDefaultIconTheme;
            }
        } else {
            this.mIconTheme = this.mDefaultIconTheme;
        }
    }

    public IconTheme getIconTheme(File icon) {
        if (!icon.exists()) {
            return new DirectoryIconTheme(icon);
        }
        if (icon.isDirectory()) {
            return new DirectoryIconTheme(icon);
        }
        if (icon.getName().toLowerCase().endsWith(".zip")) {
            return new ZipIconTheme(icon);
        }
        return new DirectoryIconTheme(icon);
    }

    public static IconLoader getInstance() {
        if (mInstance == null) {
            mInstance = new IconLoader();
        }
        return mInstance;
    }

    public ImageIcon getIconFromTheme(Plugin plugin, String category, String icon, int size) {
        return this.getIconFromTheme(plugin, new ThemeIcon(category, icon, size));
    }

    public ImageIcon getIconFromTheme(String category, String icon, int size) {
        return this.getIconFromTheme(null, new ThemeIcon(category, icon, size));
    }

    public ImageIcon getIconFromTheme(String category, String icon) {
        return this.getIconFromTheme(null, new ThemeIcon(category, icon, 16));
    }

    public ImageIcon getIconFromTheme(Plugin plugin, ThemeIcon icon) {
        ImageIcon imageIcon = this.mIconCache.get(icon);
        if (imageIcon != null) {
            return imageIcon;
        }
        imageIcon = this.mIconTheme.getIcon(icon);
        if (imageIcon != null) {
            this.mIconCache.put(icon, imageIcon);
            return imageIcon;
        }
        if (this.mIconTheme != this.mDefaultIconTheme && (imageIcon = this.mDefaultIconTheme.getIcon(icon)) != null) {
            this.mIconCache.put(icon, imageIcon);
            return imageIcon;
        }
        if (plugin != null) {
            SoftReferenceCache<ThemeIcon, ImageIcon> pluginCache = this.mPluginIconCache.get(plugin);
            if (pluginCache != null && (imageIcon = pluginCache.get(icon)) != null) {
                return imageIcon;
            }
            StringBuilder buffer = new StringBuilder("/").append(plugin.getClass().getPackage().getName()).append("/icons/").append(icon.getSize()).append("x").append(icon.getSize()).append("/").append(icon.getCategory()).append("/").append(icon.getName()).append(".png");
            icon.setAddress(buffer.toString());
            InputStream stream = plugin.getClass().getResourceAsStream(buffer.toString());
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    imageIcon = ImageUtilities.createImageIconFromJar(buffer.toString(), plugin.getClass());
                    if (imageIcon != null) {
                        if (pluginCache == null) {
                            pluginCache = new SoftReferenceCache();
                            this.mPluginIconCache.put(plugin, pluginCache);
                        }
                        pluginCache.put(icon, imageIcon);
                        return imageIcon;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        StringBuilder buffer = new StringBuilder("/icons/").append(icon.getSize()).append("x").append(icon.getSize()).append("/").append(icon.getCategory()).append("/").append(icon.getName()).append(".png");
        InputStream stream = this.getClass().getResourceAsStream(buffer.toString());
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            imageIcon = ImageUtilities.createImageIconFromJar(buffer.toString(), this.getClass());
            return imageIcon;
        }
        mLog.warning("Missing theme icon " + icon.getCategory() + "/" + icon.getName() + " for size " + Integer.toString(icon.getSize()));
        return null;
    }

    public IconTheme getDefaultTheme() {
        return this.mDefaultIconTheme;
    }

    static {
        USER_ICON_DIR = new File(Settings.getUserDirectoryName(), "icons");
    }
}

