/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Channel;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.ui.Localizer;
import util.ui.customizableitems.SelectableItemList;

public class ProgramTypeFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramTypeFilterComponent.class);
    private static final int[] CATEGORIES = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private SelectableItemList mList;
    private int mCategories;

    public ProgramTypeFilterComponent(String name, String description) {
        super(name, description);
    }

    public ProgramTypeFilterComponent() {
        this("", "");
    }

    @Override
    public boolean accept(Program program) {
        return (program.getChannel().getCategories() & this.mCategories) == this.mCategories;
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        ArrayList<String> allCategories = new ArrayList<String>(CATEGORIES.length);
        ArrayList<String> checkedCategories = new ArrayList<String>();
        for (int category : CATEGORIES) {
            String name = Channel.getLocalizedCategory(category);
            allCategories.add(name);
            if ((category & this.mCategories) != category) continue;
            checkedCategories.add(name);
        }
        this.mList = new SelectableItemList(checkedCategories.toArray(), allCategories.toArray());
        panel.add((Component)this.mList, "Center");
        return panel;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        try {
            this.mCategories = in.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveSettings() {
        this.mCategories = 0;
        for (Object object : this.mList.getSelection()) {
            String name = (String)object;
            for (int category : CATEGORIES) {
                if (!Channel.getLocalizedCategory(category).equals(name)) continue;
                this.mCategories |= category;
            }
        }
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mCategories);
    }

    public String toString() {
        return mLocalizer.msg("name", "Program type");
    }
}

