/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import tvbrowser.ui.settings.MarkingsSettingsTab;
import util.ui.Localizer;
import util.ui.MarkPriorityComboBoxRenderer;

public class ProgramMarkingPriorityFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramMarkingPriorityFilterComponent.class);
    private int mMarkPriority = 0;
    private JComboBox mValueSelection;

    public ProgramMarkingPriorityFilterComponent() {
        this("", "");
    }

    public ProgramMarkingPriorityFilterComponent(String name, String desc) {
        super(name, desc);
    }

    @Override
    public boolean accept(Program program) {
        return program.getMarkPriority() == this.mMarkPriority;
    }

    @Override
    public JPanel getSettingsPanel() {
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel(new FormLayout("default", "pref"));
        Localizer localizer = MarkingsSettingsTab.mLocalizer;
        String[] values = new String[]{localizer.msg("color.minPriority", "1. Color (minimum priority)"), localizer.msg("color.lowerMediumPriority", "2. Color (lower medium priority)"), localizer.msg("color.mediumPriority", "3. Color (Medium priority)"), localizer.msg("color.higherMediumPriority", "4. Color (higher medium priority)"), localizer.msg("color.maxPriority", "5. Color (maximum priority)")};
        this.mValueSelection = new JComboBox<String>(values);
        this.mValueSelection.setSelectedIndex(this.mMarkPriority);
        this.mValueSelection.setRenderer(new MarkPriorityComboBoxRenderer());
        p.add((Component)this.mValueSelection, cc.xy(1, 1));
        return p;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mMarkPriority = in.readInt();
    }

    @Override
    public void saveSettings() {
        if (this.mValueSelection != null) {
            this.mMarkPriority = this.mValueSelection.getSelectedIndex();
        }
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mMarkPriority);
    }

    public String toString() {
        return mLocalizer.msg("name", "Marking priority");
    }
}

