/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramSearcher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.ui.Localizer;
import util.ui.SearchForm;
import util.ui.SearchFormSettings;

public class KeywordFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(KeywordFilterComponent.class);
    private SearchForm mSearchForm;
    private ProgramSearcher mSearcher;
    private ProgramFieldType[] mSearchFieldArr;
    private SearchFormSettings mSearchFormSettings;

    public KeywordFilterComponent(String name, String desc) {
        super(name, desc);
        this.setSearchFormSettings(new SearchFormSettings(""));
    }

    public KeywordFilterComponent() {
        this("", "");
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.setSearchFormSettings(new SearchFormSettings(in));
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        this.mSearchFormSettings.writeData(out);
    }

    private void setSearchFormSettings(SearchFormSettings settings) {
        this.mSearchFormSettings = settings;
        try {
            this.mSearcher = this.mSearchFormSettings.createSearcher();
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle(exc);
        }
        this.mSearchFieldArr = this.mSearchFormSettings.getFieldTypes();
    }

    @Override
    public void saveSettings() {
        this.mSearchFormSettings = this.mSearchForm.getSearchFormSettings();
        this.setSearchFormSettings(this.mSearchFormSettings);
    }

    @Override
    public boolean accept(Program program) {
        return this.mSearcher.matches(program, this.mSearchFieldArr);
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("description", "Accept all programs containing the following keyword:");
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        this.mSearchForm = new SearchForm(false, false);
        this.mSearchForm.setSearchFormSettings(this.mSearchFormSettings);
        content.add(this.mSearchForm);
        return content;
    }

    public String toString() {
        return mLocalizer.msg("keyword", "keyword");
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

