/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Marker;
import devplugin.Program;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import util.ui.Localizer;

public class FavoritesFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FavoritesFilterComponent.class);

    public FavoritesFilterComponent(String name, String description) {
        super(name, description);
    }

    public FavoritesFilterComponent() {
        this("", "");
    }

    public String toString() {
        return mLocalizer.msg("name", "Favorites");
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean accept(Program program) {
        String favPluginId = FavoritesPlugin.getFavoritesPluginId();
        for (Marker marker : program.getMarkerArr()) {
            if (!favPluginId.equals(marker.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("desc", "Accepts all programs that are marked as Favorite.");
    }

    @Override
    public JPanel getSettingsPanel() {
        return null;
    }

    @Override
    public void saveSettings() {
    }
}

