/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.data;

import devplugin.Channel;
import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramFieldType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import tvbrowser.core.data.OnDemandProgram;
import tvdataservice.MutableChannelDayProgram;
import util.io.BufferedRandomAccessFile;

public class OnDemandDayProgramFile {
    private static final int LARGE_FIELD_SIZE_LIMIT = 50;
    private File mFile;
    private MutableChannelDayProgram mDayProgram;
    private boolean mValid;
    private boolean mTimeLimitationlData;

    public OnDemandDayProgramFile(File file, Date date, Channel channel) {
        this(file, new MutableChannelDayProgram(date, channel));
    }

    public OnDemandDayProgramFile(File file, MutableChannelDayProgram dayProgram) {
        this.mFile = file;
        this.mDayProgram = dayProgram;
        this.mValid = true;
        this.mTimeLimitationlData = false;
    }

    public synchronized void setValid(boolean valid) {
        this.mValid = valid;
    }

    public MutableChannelDayProgram getDayProgram() {
        return this.mDayProgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadDayProgram(boolean update) throws IOException, ClassNotFoundException {
        this.checkValid();
        this.mTimeLimitationlData = !update;
        BufferedRandomAccessFile dataFile = null;
        try {
            Program prog;
            dataFile = new BufferedRandomAccessFile(this.mFile, "rw");
            int version = dataFile.readInt();
            if (version < 2) {
                dataFile.close();
                this.updateToVersion2();
                dataFile = new BufferedRandomAccessFile(this.mFile, "rw");
                int ver2 = dataFile.readInt();
                if (ver2 < 2) {
                    this.mValid = false;
                    this.checkValid();
                }
            }
            this.mDayProgram.setLastProgramHadEndOnUpdate(dataFile.readBoolean());
            Date date = Date.readData(dataFile);
            Channel channel = Channel.readData(dataFile, false);
            boolean timeLimited = channel.isTimeLimited();
            int startTimeLimit = channel.getStartTimeLimit();
            int endTimeLimit = channel.getEndTimeLimit();
            int size = dataFile.readInt();
            this.mDayProgram.removeAllPrograms();
            for (int i = 0; i < size && (prog = this.loadProgram(dataFile, date, channel)) != null; ++i) {
                int time = prog.getHours() * 60 + prog.getMinutes();
                if (timeLimited && !update) {
                    if ((startTimeLimit >= endTimeLimit || time < startTimeLimit || time >= endTimeLimit) && (endTimeLimit >= startTimeLimit || time >= endTimeLimit && time < startTimeLimit)) continue;
                    this.mDayProgram.addProgram(prog);
                    continue;
                }
                this.mDayProgram.addProgram(prog);
            }
            dataFile.close();
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToVersion2() throws IOException, ClassNotFoundException {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(this.mFile), 65536);
            ObjectInputStream objIn = new ObjectInputStream(stream);
            objIn.readInt();
            Date date = Date.readData(objIn);
            Channel channel = Channel.readData(objIn, false);
            int size = objIn.readInt();
            this.mDayProgram.removeAllPrograms();
            for (int i = 0; i < size; ++i) {
                Program prog = this.loadProgram(objIn, date, channel);
                this.mDayProgram.addProgram(prog);
            }
            stream.close();
            this.saveDayProgram(true);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException exc) {}
            }
            File newFile = new File(this.mFile.getPath() + "_to_ver_2_update");
            this.mFile.delete();
            newFile.renameTo(this.mFile);
            this.mValid = true;
        }
    }

    private Program loadProgram(ObjectInputStream objIn, Date date, Channel channel) throws IOException, ClassNotFoundException {
        int version = objIn.readInt();
        OnDemandProgram prog = new OnDemandProgram(channel, date, this);
        if (version == 1) {
            prog.setTitle((String)objIn.readObject());
            prog.setShortInfo((String)objIn.readObject());
            prog.setDescription((String)objIn.readObject());
            prog.setTextField(ProgramFieldType.ACTOR_LIST_TYPE, (String)objIn.readObject());
            prog.setTextField(ProgramFieldType.URL_TYPE, (String)objIn.readObject());
            int minutes = objIn.readInt();
            int localHours = objIn.readInt();
            int localStartTime = localHours * 60 + minutes;
            prog.setTimeField(ProgramFieldType.START_TIME_TYPE, localStartTime);
            prog.setLength(objIn.readInt());
            prog.setInfo(objIn.readInt());
            Channel.readData(objIn, false);
            Date.readData(objIn);
            prog.setBinaryField(ProgramFieldType.PICTURE_TYPE, (byte[])objIn.readObject());
        } else {
            Channel.readData(objIn, false);
            Date.readData(objIn);
            int fieldCount = objIn.readInt();
            for (int i = 0; i < fieldCount; ++i) {
                Object value;
                int typeId = objIn.readInt();
                ProgramFieldType type = ProgramFieldType.getTypeForId(typeId);
                if (type.getFormat() == 2) {
                    value = (byte[])objIn.readObject();
                    prog.setBinaryField(type, (byte[])value);
                    continue;
                }
                if (type.getFormat() == 3) {
                    value = (String)objIn.readObject();
                    prog.setTextField(type, (String)value);
                    continue;
                }
                if (type.getFormat() == 4) {
                    prog.setIntField(type, objIn.readInt());
                    continue;
                }
                if (type.getFormat() != 5) continue;
                prog.setTimeField(type, objIn.readInt());
            }
        }
        prog.setProgramLoadingIsComplete();
        return prog;
    }

    public synchronized void saveDayProgram() throws IOException {
        this.saveDayProgram(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDayProgram(boolean update) throws IOException {
        this.checkValid();
        Date date = this.mDayProgram.getDate();
        Channel channel = this.mDayProgram.getChannel();
        RandomAccessFile dataFile = null;
        try {
            dataFile = update ? new RandomAccessFile(this.mFile + "_to_ver_2_update", "rw") : new RandomAccessFile(this.mFile, "rw");
            dataFile.writeInt(2);
            dataFile.writeBoolean(this.mDayProgram.getLastProgramHadEndOnUpdate());
            date.writeData(dataFile);
            channel.writeToDataFile(dataFile);
            int programCount = this.mDayProgram.getProgramCount();
            dataFile.writeInt(programCount);
            for (int i = 0; i < programCount; ++i) {
                Program program = this.mDayProgram.getProgramAt(i);
                this.saveProgram(program, dataFile);
            }
            dataFile.close();
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    private Program loadProgram(RandomAccessFile dataFile, Date date, Channel channel) throws IOException, ClassNotFoundException {
        int version = dataFile.readInt();
        OnDemandProgram prog = new OnDemandProgram(channel, date, this);
        if (version == 3) {
            int fieldCount = dataFile.readInt();
            for (int i = 0; i < fieldCount; ++i) {
                long position;
                int typeId = dataFile.readInt();
                ProgramFieldType type = ProgramFieldType.getTypeForId(typeId);
                if (type.getFormat() == 1) {
                    return null;
                }
                if (type.getFormat() == 2) {
                    position = dataFile.getFilePointer();
                    int n = dataFile.readInt();
                    byte[] value = new byte[n];
                    dataFile.readFully(value);
                    if (value != null && n >= 50) {
                        prog.setLargeField(type, position);
                        continue;
                    }
                    prog.setBinaryField(type, value);
                    continue;
                }
                if (type.getFormat() == 3) {
                    position = dataFile.getFilePointer();
                    String value = dataFile.readUTF();
                    if (value == null) continue;
                    if (value.length() >= 50) {
                        prog.setLargeField(type, position);
                        continue;
                    }
                    if (value.length() <= 0) continue;
                    prog.setTextField(type, value);
                    continue;
                }
                if (type.getFormat() == 4) {
                    prog.setIntField(type, dataFile.readInt());
                    continue;
                }
                if (type.getFormat() != 5) continue;
                prog.setTimeField(type, dataFile.readInt());
            }
        }
        prog.setProgramLoadingIsComplete();
        return prog;
    }

    private void saveProgram(Program program, RandomAccessFile dataFile) throws IOException {
        dataFile.writeInt(3);
        int fieldCount = program.getFieldCount();
        dataFile.writeInt(fieldCount);
        Iterator<ProgramFieldType> iter = program.getFieldIterator();
        for (int i = 0; i < fieldCount; ++i) {
            ProgramFieldType type = iter.next();
            dataFile.writeInt(type.getTypeId());
            if (type.getFormat() == 2) {
                byte[] b = program.getBinaryField(type);
                dataFile.writeInt(b.length);
                dataFile.write(b);
                continue;
            }
            if (type.getFormat() == 3) {
                dataFile.writeUTF(program.getTextField(type));
                continue;
            }
            if (type.getFormat() == 4) {
                dataFile.writeInt(program.getIntField(type));
                continue;
            }
            if (type.getFormat() != 5) continue;
            dataFile.writeInt(program.getTimeField(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Object loadFieldValue(long position, ProgramFieldType type) throws IOException, ClassNotFoundException {
        this.checkValid();
        RandomAccessFile dataFile = null;
        try {
            Object value;
            dataFile = new RandomAccessFile(this.mFile, "r");
            dataFile.seek(position);
            if (type.getFormat() == 3) {
                value = dataFile.readUTF();
            } else {
                int n = dataFile.readInt();
                byte[] b = new byte[n];
                dataFile.readFully(b);
                value = b;
            }
            dataFile.close();
            String string = value;
            return string;
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    private void checkValid() throws IOException {
        if (!this.mValid) {
            throw new IOException("The day program file is invalid. Maybe it was replaced.");
        }
    }

    public boolean isTimeLimitationData() {
        return this.mTimeLimitationlData;
    }

    public void calculateTimeLimits() {
        if (this.mDayProgram.getChannel().isTimeLimited()) {
            ArrayList<Program> programs = new ArrayList<Program>();
            for (int i = 0; i < this.mDayProgram.getProgramCount(); ++i) {
                programs.add(this.mDayProgram.getProgramAt(i));
            }
            this.mDayProgram.removeAllPrograms();
            Channel channel = this.mDayProgram.getChannel();
            for (Program prog : programs) {
                int endTimeLimit;
                int time = prog.getHours() * 60 + prog.getMinutes();
                int startTimeLimit = channel.getStartTimeLimit();
                if ((startTimeLimit >= (endTimeLimit = channel.getEndTimeLimit()) || time < startTimeLimit || time >= endTimeLimit) && (endTimeLimit >= startTimeLimit || time >= endTimeLimit && time < startTimeLimit)) continue;
                this.mDayProgram.addProgram(prog);
            }
        }
        this.mTimeLimitationlData = true;
    }
}

