/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.Program;
import devplugin.ProgramFieldType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBaseListener;
import tvbrowser.core.TvDataInventory;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.data.OnDemandDayProgramFile;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MutableChannelDayProgram;
import tvdataservice.MutableProgram;
import util.misc.SoftReferenceCache;

public class TvDataBase {
    private static final Logger mLog = Logger.getLogger(TvDataBase.class.getName());
    private static final String INVENTORY_FILE = "tv-data-inventory.dat";
    private static TvDataBase mSingleton;
    private SoftReferenceCache<String, OnDemandDayProgramFile> mTvDataHash = new SoftReferenceCache();
    private ArrayList<TvDataBaseListener> mListenerList = new ArrayList();
    private HashSet<devplugin.Date> mAvailableDateSet = new HashSet();
    private Hashtable<String, UpdateData> mNewDayProgramsAfterUpdate = new Hashtable();
    private TvDataInventory mTvDataInventory;
    private boolean mPendingPluginInformationAboutChangedData = false;
    private Hashtable<ChannelDayKey, UpdateData> mSendToTvDataListener = new Hashtable();
    private MutableChannelDayProgram mCurrentAddedDayProgram;
    public static final int DEFAULT_DATA_LIFESPAN = 1;

    private TvDataBase() {
        this.updateAvailableDateSet();
        this.mTvDataInventory = new TvDataInventory();
        File file = new File(Settings.getUserSettingsDirName(), INVENTORY_FILE);
        if (file.exists()) {
            try {
                this.mTvDataInventory.readData(file);
            }
            catch (Exception exc) {
                mLog.log(Level.WARNING, "Loading TV data inventory failed", exc);
            }
        }
    }

    public static TvDataBase getInstance() {
        if (mSingleton == null) {
            mSingleton = new TvDataBase();
        }
        return mSingleton;
    }

    protected void updateTvDataBase() {
        this.updateAvailableDateSet();
    }

    public void checkTvDataInventory(int lifespan) {
        Channel channel;
        Channel[] channelArr = ChannelList.getSubscribedChannels();
        String[] channelIdArr = new String[channelArr.length];
        for (int i = 0; i < channelArr.length; ++i) {
            channelIdArr[i] = TvDataBase.getChannelKey(channelArr[i]);
        }
        devplugin.Date cutoff = devplugin.Date.getCurrentDate().addDays(-lifespan);
        boolean somethingChanged = false;
        File tvDataDir = new File(Settings.propTVDataDirectory.getString());
        File[] tvDataArr = tvDataDir.listFiles();
        if (tvDataArr == null) {
            return;
        }
        HashMap<String, File> tvDataFiles = new HashMap<String, File>();
        for (File file : tvDataArr) {
            tvDataFiles.put(file.getName(), file);
        }
        String[] knownProgArr = this.mTvDataInventory.getKnownDayPrograms();
        devplugin.Date expireDate = devplugin.Date.getCurrentDate().addDays(-1);
        for (String key : knownProgArr) {
            devplugin.Date date = this.getDateFromFileName(key);
            if (tvDataFiles.containsKey(key) && (date == null || date.compareTo(expireDate) >= 0)) continue;
            channel = this.getChannelFromFileName(key, channelArr, channelIdArr);
            if (channel != null && date != null) {
                if (date.compareTo(cutoff) >= 0) {
                    mLog.info("Day program was deleted by third party: " + date + " on " + channel.getName());
                }
                MutableChannelDayProgram dummyProg = new MutableChannelDayProgram(date, channel);
                this.fireDayProgramTouched(dummyProg, null);
                this.fireDayProgramDeleted(dummyProg);
                this.mTvDataInventory.setUnknown(date, channel);
                continue;
            }
            this.mTvDataInventory.setUnknown(key);
        }
        for (File tvDataFile : tvDataArr) {
            int version;
            int knownStatus;
            String fileName = tvDataFile.getName();
            channel = this.getChannelFromFileName(fileName, channelArr, channelIdArr);
            devplugin.Date date = this.getDateFromFileName(fileName);
            if (channel == null || date == null || (knownStatus = this.mTvDataInventory.getKnownStatus(date, channel, version = (int)tvDataFile.length())) != 1 && knownStatus != 2 || !this.isValidDate(date)) continue;
            if (!somethingChanged) {
                TvDataUpdater.getInstance().fireTvDataUpdateStarted(devplugin.Date.getCurrentDate().addDays(28));
            }
            mLog.info("Day program was changed by third party: " + date + " on " + channel.getName());
            OnDemandDayProgramFile newDayProg = this.getCacheEntry(date, channel, true, false);
            if (newDayProg != null && newDayProg.getDayProgram() != null) {
                this.handleKnownStatus(knownStatus, newDayProg, version);
            }
            somethingChanged = true;
        }
        if (somethingChanged) {
            if (!MainFrame.isStarting()) {
                TvDataUpdater.getInstance().fireTvDataUpdateFinished();
            } else {
                this.mPendingPluginInformationAboutChangedData = true;
            }
        }
    }

    public void handleTvBrowserStartFinished() {
        if (this.mPendingPluginInformationAboutChangedData) {
            this.mPendingPluginInformationAboutChangedData = false;
            Collection<UpdateData> dayPrograms = this.mNewDayProgramsAfterUpdate.values();
            for (UpdateData dayProgram : dayPrograms) {
                if (!(dayProgram instanceof ChannelDayProgram)) continue;
                this.fireDayProgramTouched(dayProgram.getRemoved(), dayProgram.getAdded().getDayProgram());
                this.fireDayProgramAdded(dayProgram.getAdded().getDayProgram());
            }
            this.mNewDayProgramsAfterUpdate.clear();
            TvDataUpdater.getInstance().fireTvDataUpdateFinished();
        }
    }

    public void close(boolean log) {
        block3: {
            if (log) {
                mLog.info("Closing TV data base");
            }
            try {
                File file = new File(Settings.getUserSettingsDirName(), INVENTORY_FILE);
                this.mTvDataInventory.writeData(file);
            }
            catch (Exception exc) {
                if (!log) break block3;
                mLog.log(Level.WARNING, "Closing database failed", exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTvDataListener(TvDataBaseListener listener) {
        ArrayList<TvDataBaseListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            this.mListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTvDataListener(TvDataBaseListener listener) {
        ArrayList<TvDataBaseListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            this.mListenerList.remove(listener);
        }
    }

    public ChannelDayProgram getDayProgram(devplugin.Date date, Channel channel) {
        return this.getDayProgram(date, channel, false);
    }

    public void setDayProgramWasChangedByPlugin(devplugin.Date date, Channel channel) {
        if (this.mCurrentAddedDayProgram != null && this.mCurrentAddedDayProgram.getDate().equals(date) && this.mCurrentAddedDayProgram.getChannel().equals(channel)) {
            this.mCurrentAddedDayProgram.setWasChangedByPlugin();
        }
    }

    private ChannelDayProgram getDayProgram(devplugin.Date date, Channel channel, boolean update) {
        OnDemandDayProgramFile progFile = this.getCacheEntry(date, channel, true, update);
        if (progFile != null) {
            return progFile.getDayProgram();
        }
        return null;
    }

    public synchronized void reCalculateTvData(Channel channel, devplugin.Date date) {
        this.correctDayProgramFile(date, channel);
    }

    public synchronized void setDayProgram(MutableChannelDayProgram prog) {
        devplugin.Date date = prog.getDate();
        Channel channel = prog.getChannel();
        String key = TvDataBase.getDayProgramKey(date, channel);
        if (prog.getProgramCount() > 0) {
            prog.setLastProgramHadEndOnUpdate(prog.getProgramAt(prog.getProgramCount() - 1).getLength() > 0);
        }
        OnDemandDayProgramFile oldProgFile = this.getCacheEntry(date, channel, true, false);
        File file = this.getDayProgramFile(date, channel);
        File backupFile = null;
        if (file.exists() && !file.renameTo(backupFile = new File(file.getAbsolutePath() + ".backup"))) {
            backupFile = null;
        }
        if (oldProgFile != null) {
            oldProgFile.setValid(false);
            this.removeCacheEntry(key);
        }
        OnDemandDayProgramFile newProgFile = new OnDemandDayProgramFile(file, prog);
        this.addCacheEntry(key, newProgFile);
        try {
            newProgFile.saveDayProgram();
            if (backupFile != null) {
                backupFile.delete();
            }
            if (oldProgFile != null) {
                this.mNewDayProgramsAfterUpdate.put(key, new UpdateData(newProgFile, oldProgFile.getDayProgram()));
            } else {
                this.mNewDayProgramsAfterUpdate.put(key, new UpdateData(newProgFile, null));
            }
            int version = (int)file.length();
            this.mTvDataInventory.setKnown(date, channel, version);
        }
        catch (IOException exc) {
            this.removeCacheEntry(key);
            this.mNewDayProgramsAfterUpdate.remove(key);
            this.fireDayProgramTouched(prog, null);
            this.fireDayProgramDeleted(prog);
            boolean restoredBackup = false;
            if (backupFile != null) {
                if (backupFile.renameTo(file)) {
                    restoredBackup = true;
                } else {
                    backupFile.delete();
                }
            }
            String msg = "Saving program for " + channel + " from " + date + " failed.";
            if (restoredBackup) {
                msg = msg + " The old version was restored.";
            }
            mLog.log(Level.WARNING, msg, exc);
        }
    }

    private OnDemandDayProgramFile getCacheEntry(devplugin.Date date, Channel channel, boolean loadFromDisk, boolean update) {
        String key;
        OnDemandDayProgramFile progFile;
        if (!loadFromDisk && (progFile = this.mTvDataHash.get(key = TvDataBase.getDayProgramKey(date, channel))) != null) {
            return progFile;
        }
        return this.getCacheEntryBlocking(date, channel, loadFromDisk, update);
    }

    private synchronized OnDemandDayProgramFile getCacheEntryBlocking(devplugin.Date date, Channel channel, boolean loadFromDisk, boolean update) {
        String key = TvDataBase.getDayProgramKey(date, channel);
        OnDemandDayProgramFile progFile = this.mTvDataHash.get(key);
        if (loadFromDisk && (progFile == null || update && progFile.isTimeLimitationData()) && (progFile = this.loadDayProgram(date, channel, update)) != null && !update) {
            this.addCacheEntry(key, progFile);
        }
        return progFile;
    }

    private synchronized void addCacheEntry(String key, OnDemandDayProgramFile progFile) {
        this.mTvDataHash.put(key, progFile);
    }

    private synchronized void removeCacheEntry(String key) {
        this.mTvDataHash.remove(key);
    }

    protected static String getDayProgramKey(devplugin.Date date, Channel channel) {
        if (date == null) {
            throw new NullPointerException("date is null");
        }
        return TvDataBase.getChannelKey(channel) + '.' + date.getDateString();
    }

    private static String getChannelKey(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        return channel.getBaseCountry() + '_' + channel.getId() + '_' + channel.getDataServicePackageName();
    }

    public boolean isDayProgramAvailable(devplugin.Date date, Channel channel) {
        File file = this.getDayProgramFile(date, channel);
        return file.exists();
    }

    public void deleteExpiredFiles(int lifespan, boolean informPlugins) {
        if (lifespan < 0) {
            return;
        }
        Channel[] channelArr = ChannelList.getSubscribedChannels();
        devplugin.Date date = devplugin.Date.getCurrentDate().addDays(-lifespan);
        while (this.dataAvailable(date)) {
            this.mAvailableDateSet.remove(date);
            date = date.addDays(-1);
        }
        final devplugin.Date d = devplugin.Date.getCurrentDate().addDays(-lifespan);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                int val;
                int p = name.lastIndexOf(46);
                String s = name.substring(p + 1, name.length());
                for (int i = 0; i < s.length(); ++i) {
                    if (Character.isDigit(s.charAt(i))) continue;
                    return false;
                }
                try {
                    val = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                int year = val / 10000;
                int r = val % 10000;
                int month = r / 100;
                int day = r % 100;
                devplugin.Date curDate = new devplugin.Date(year, month, day);
                return curDate.getValue() < d.getValue();
            }
        };
        String[] channelIdArr = new String[channelArr.length];
        for (int i = 0; i < channelArr.length; ++i) {
            channelIdArr[i] = TvDataBase.getChannelKey(channelArr[i]);
        }
        this.deleteFiles(informPlugins, filter, channelArr, channelIdArr);
        this.updateAvailableDateSet();
    }

    private boolean deleteFiles(boolean informPlugins, FilenameFilter filter, Channel[] channelArr, String[] channelIdArr) {
        File[] fileList = new File(Settings.propTVDataDirectory.getString()).listFiles(filter);
        boolean somethingDeleted = false;
        if (fileList != null && fileList.length > 0) {
            somethingDeleted = true;
            for (File deleteFile : fileList) {
                Channel ch = this.getChannelFromFileName(deleteFile.getName(), channelArr, channelIdArr);
                devplugin.Date date = this.getDateFromFileName(deleteFile.getName());
                if (ch != null && date != null) {
                    ChannelDayProgram dayProgram;
                    if (informPlugins && (dayProgram = this.getDayProgram(date, ch)) != null) {
                        this.fireDayProgramTouched(dayProgram, null);
                        this.fireDayProgramDeleted(dayProgram);
                    }
                    this.removeCacheEntry(TvDataBase.getDayProgramKey(date, ch));
                }
                deleteFile.delete();
            }
        }
        if (informPlugins && somethingDeleted) {
            TvDataUpdater.getInstance().fireTvDataUpdateFinished();
            return true;
        }
        return false;
    }

    private synchronized void correctDayProgramFile(devplugin.Date date, Channel channel) {
        boolean verbose = Settings.propVerboseLogging.getBoolean();
        if (verbose) {
            mLog.info(new Date(System.currentTimeMillis()) + ": CorrectDayProgramFile " + date + " " + channel);
        }
        File file = this.getDayProgramFile(date, channel);
        String key = TvDataBase.getDayProgramKey(date, channel);
        if (!file.exists()) {
            return;
        }
        try {
            int version = (int)file.length();
            int knownStatus = this.mTvDataInventory.getKnownStatus(date, channel, version);
            UpdateData updateData = this.mNewDayProgramsAfterUpdate.remove(key);
            OnDemandDayProgramFile checkProg = null;
            checkProg = updateData != null ? updateData.getAdded() : this.getCacheEntry(date, channel, true, true);
            this.mCurrentAddedDayProgram = checkProg.getDayProgram();
            if (verbose) {
                mLog.info(new Date(System.currentTimeMillis()) + ": START calculate missing length");
            }
            boolean somethingChanged = this.calculateMissingLengths(this.mCurrentAddedDayProgram);
            if (verbose) {
                mLog.info(new Date(System.currentTimeMillis()) + ": END calculate missing length");
                mLog.info(new Date(System.currentTimeMillis()) + ": FIRE DAY PROGRAM ADDED");
            }
            this.fireDayProgramAdded(this.mCurrentAddedDayProgram);
            if (verbose) {
                mLog.info(new Date(System.currentTimeMillis()) + ": SOMETHING CHANGED: " + somethingChanged);
            }
            if (this.mCurrentAddedDayProgram.getAndResetChangedByPluginState() || somethingChanged) {
                File tempFile = new File(file.getAbsolutePath() + ".changed");
                try {
                    OnDemandDayProgramFile newProgFile = new OnDemandDayProgramFile(tempFile, this.mCurrentAddedDayProgram);
                    newProgFile.saveDayProgram();
                    file.delete();
                    tempFile.renameTo(file);
                    if (knownStatus == 3) {
                        version = (int)file.length();
                        this.mTvDataInventory.setKnown(date, channel, version);
                    }
                }
                catch (Exception exc) {
                    tempFile.delete();
                }
                OnDemandDayProgramFile progFile = new OnDemandDayProgramFile(file, date, channel);
                progFile.loadDayProgram(false);
                if (checkProg != null) {
                    checkProg.setValid(false);
                    this.removeCacheEntry(key);
                }
                updateData = new UpdateData(progFile, updateData != null ? updateData.getRemoved() : null);
                this.addCacheEntry(key, progFile);
            } else if (checkProg != null) {
                checkProg.calculateTimeLimits();
            }
            if (updateData != null || somethingChanged) {
                ChannelDayKey dayKey = new ChannelDayKey(channel, date);
                this.mSendToTvDataListener.put(dayKey, updateData);
            }
        }
        catch (Exception exc) {
            mLog.log(Level.WARNING, "Loading program for " + channel + " from " + date + " failed. The file will be deleted...", exc);
            file.delete();
        }
        this.mCurrentAddedDayProgram = null;
    }

    private synchronized OnDemandDayProgramFile loadDayProgram(devplugin.Date date, Channel channel, boolean update) {
        File file = this.getDayProgramFile(date, channel);
        if (!file.exists()) {
            return null;
        }
        try {
            OnDemandDayProgramFile progFile = new OnDemandDayProgramFile(file, date, channel);
            progFile.loadDayProgram(update);
            return progFile;
        }
        catch (Exception exc) {
            mLog.log(Level.WARNING, "Loading program for " + channel + " from " + date + " failed. The file will be deleted...", exc);
            file.delete();
            return null;
        }
    }

    private File getDayProgramFile(devplugin.Date date, Channel channel) {
        String fileName = TvDataBase.getDayProgramKey(date, channel);
        String tvDataDir = Settings.propTVDataDirectory.getString();
        return new File(tvDataDir, fileName);
    }

    private Channel getChannelFromFileName(String fileName, Channel[] channelArr, String[] channelIdArr) {
        for (int i = 0; i < channelIdArr.length; ++i) {
            if (!fileName.startsWith(channelIdArr[i])) continue;
            return channelArr[i];
        }
        return null;
    }

    private devplugin.Date getDateFromFileName(String fileName) {
        int dotIdx = fileName.lastIndexOf(46);
        if (dotIdx == -1) {
            return null;
        }
        String valueAsString = fileName.substring(dotIdx + 1);
        for (int i = 0; i < valueAsString.length(); ++i) {
            if (Character.isDigit(valueAsString.charAt(i))) continue;
            return null;
        }
        try {
            long value = Long.parseLong(valueAsString);
            return devplugin.Date.createDateFromValue(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public boolean dataAvailable(devplugin.Date date) {
        if (date == null) {
            return false;
        }
        return this.mAvailableDateSet.contains(date);
    }

    private void updateAvailableDateSet() {
        String tvDataDirStr = Settings.propTVDataDirectory.getString();
        File tvDataDir = new File(tvDataDirStr);
        if (!tvDataDir.exists()) {
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                if (name.length() < 8) {
                    return false;
                }
                String dateStr = name.substring(name.length() - 8);
                for (int i = 0; i < dateStr.length(); ++i) {
                    if (Character.isDigit(dateStr.charAt(i))) continue;
                    return false;
                }
                try {
                    Integer.parseInt(dateStr.substring(0, 4));
                    Integer.parseInt(dateStr.substring(4, 6));
                    Integer.parseInt(dateStr.substring(6, 8));
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
        };
        String[] fileNameList = tvDataDir.list(filter);
        if (fileNameList != null) {
            for (String fileName : fileNameList) {
                if (fileName.length() <= 8) continue;
                String dateStr = fileName.substring(fileName.length() - 8);
                try {
                    int year = Integer.parseInt(dateStr.substring(0, 4));
                    int month = Integer.parseInt(dateStr.substring(4, 6));
                    int day = Integer.parseInt(dateStr.substring(6, 8));
                    this.mAvailableDateSet.add(new devplugin.Date(year, month, day));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDayProgramAdded(MutableChannelDayProgram prog) {
        ArrayList<TvDataBaseListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            for (int i = 0; i < this.mListenerList.size(); ++i) {
                TvDataBaseListener lst = this.mListenerList.get(i);
                lst.dayProgramAdded(prog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDayProgramTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
        ArrayList<TvDataBaseListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            for (int i = 0; i < this.mListenerList.size(); ++i) {
                TvDataBaseListener lst = this.mListenerList.get(i);
                lst.dayProgramTouched(removedDayProgram, addedDayProgram);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDayProgramAdded(ChannelDayProgram prog) {
        ArrayList<TvDataBaseListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            for (int i = 0; i < this.mListenerList.size(); ++i) {
                TvDataBaseListener lst = this.mListenerList.get(i);
                lst.dayProgramAdded(prog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDayProgramDeleted(ChannelDayProgram prog) {
        ArrayList<TvDataBaseListener> arrayList = this.mListenerList;
        synchronized (arrayList) {
            for (int i = 0; i < this.mListenerList.size(); ++i) {
                TvDataBaseListener lst = this.mListenerList.get(i);
                lst.dayProgramDeleted(prog);
            }
        }
    }

    private void handleKnownStatus(int knownStatus, OnDemandDayProgramFile newDayProgFile, int version) {
        if (knownStatus != 3) {
            MutableChannelDayProgram newDayProg = newDayProgFile.getDayProgram();
            devplugin.Date date = newDayProg.getDate();
            Channel channel = newDayProg.getChannel();
            if (knownStatus == 2) {
                MutableChannelDayProgram dayProg = new MutableChannelDayProgram(date, channel);
                this.fireDayProgramTouched(dayProg, null);
                this.fireDayProgramDeleted(dayProg);
            }
            this.mTvDataInventory.setKnown(date, channel, version);
            if (this.isValidDate(date)) {
                this.mNewDayProgramsAfterUpdate.put(TvDataBase.getDayProgramKey(date, channel), new UpdateData(newDayProgFile, null));
            }
        }
    }

    private boolean isValidDate(devplugin.Date date) {
        return devplugin.Date.getCurrentDate().getNumberOfDaysSince(date) <= 1;
    }

    private boolean calculateMissingLengths(ChannelDayProgram channelProg) {
        boolean somethingChanged = false;
        for (int progIdx = 0; progIdx < channelProg.getProgramCount(); ++progIdx) {
            Program program = channelProg.getProgramAt(progIdx);
            if (!(program instanceof MutableProgram)) continue;
            MutableProgram prog = (MutableProgram)program;
            if (prog.getLength() <= 0) {
                Program nextProgram = null;
                int addCount = 1;
                do {
                    if (progIdx + addCount >= channelProg.getProgramCount()) {
                        nextProgram = this.getFirstNextDayProgram(channelProg);
                        break;
                    }
                    nextProgram = channelProg.getProgramAt(progIdx + addCount++);
                } while (nextProgram != null && nextProgram.getStartTime() == prog.getStartTime());
                somethingChanged = this.calculateLength(prog, nextProgram) || somethingChanged;
                continue;
            }
            if (progIdx + 1 != channelProg.getProgramCount() || channelProg.getLastProgramHadEndOnUpdate()) continue;
            somethingChanged = this.calculateLength(prog, this.getFirstNextDayProgram(channelProg)) || somethingChanged;
        }
        return somethingChanged;
    }

    private Program getFirstNextDayProgram(ChannelDayProgram channelProg) {
        devplugin.Date nextDate = channelProg.getDate().addDays(1);
        Channel channel = channelProg.getChannel();
        TvDataBase db = TvDataBase.getInstance();
        ChannelDayProgram nextDayProg = db.getDayProgram(nextDate, channel, true);
        if (nextDayProg != null && nextDayProg.getProgramCount() > 0) {
            return nextDayProg.getProgramAt(0);
        }
        return null;
    }

    private boolean calculateLength(MutableProgram first, Program second) {
        if (second != null) {
            int startTime = first.getHours() * 60 + first.getMinutes();
            int endTime = second.getHours() * 60 + second.getMinutes();
            if (endTime < startTime) {
                endTime += 1440;
            }
            if (startTime + first.getLength() != endTime) {
                int length = endTime - startTime;
                if (first.hasFieldValue(ProgramFieldType.NET_PLAYING_TIME_TYPE) && first.getIntField(ProgramFieldType.NET_PLAYING_TIME_TYPE) > length) {
                    length = first.getIntField(ProgramFieldType.NET_PLAYING_TIME_TYPE);
                }
                if (length < 900) {
                    first.setLength(length);
                    return true;
                }
            }
        }
        return false;
    }

    public void unsubscribeChannels(Channel[] channels) {
        boolean callback = false;
        for (Channel channel : channels) {
            if (!this.unsubscribeChannel(channel, channel == channels[channels.length - 1])) continue;
            callback = true;
        }
        if (!callback) {
            TvDataUpdater.getInstance().fireTvDataUpdateFinished();
        }
    }

    private boolean unsubscribeChannel(Channel channel, boolean informPlugins) {
        if (channel == null) {
            return false;
        }
        final Channel[] channelArr = new Channel[]{channel};
        final String[] channelIdArr = new String[]{TvDataBase.getChannelKey(channel)};
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                Channel ch = TvDataBase.this.getChannelFromFileName(name, channelArr, channelIdArr);
                devplugin.Date date = TvDataBase.this.getDateFromFileName(name);
                return ch != null && date != null;
            }
        };
        return this.deleteFiles(informPlugins, filter, channelArr, channelIdArr);
    }

    public devplugin.Date getMaxSupportedDate() {
        return devplugin.Date.getCurrentDate().addDays(28);
    }

    void sendNewProgramsToTvDataListener() {
        boolean verbose = Settings.propVerboseLogging.getBoolean();
        Enumeration<ChannelDayKey> keys = this.mSendToTvDataListener.keys();
        while (keys.hasMoreElements()) {
            UpdateData updateData;
            ChannelDayKey key = keys.nextElement();
            if (verbose) {
                mLog.info(new Date(System.currentTimeMillis()) + ": SEND TO PLUGINS " + key);
            }
            if ((updateData = this.mSendToTvDataListener.remove(key)).getRemoved() != null) {
                this.fireDayProgramTouched(updateData.getRemoved(), updateData.getAdded().getDayProgram());
                this.fireDayProgramDeleted(updateData.getRemoved());
            } else {
                this.fireDayProgramTouched(null, updateData.getAdded().getDayProgram());
            }
            this.fireDayProgramAdded((ChannelDayProgram)updateData.getAdded().getDayProgram());
        }
    }

    private static class UpdateData {
        private OnDemandDayProgramFile mAdded;
        private ChannelDayProgram mRemoved;

        public UpdateData(OnDemandDayProgramFile added, ChannelDayProgram removed) {
            this.mAdded = added;
            this.mRemoved = removed;
        }

        public OnDemandDayProgramFile getAdded() {
            return this.mAdded;
        }

        public ChannelDayProgram getRemoved() {
            return this.mRemoved;
        }
    }

    private class ChannelDayKey {
        private Channel mChannel;
        private devplugin.Date mDate;

        public ChannelDayKey(Channel channel, devplugin.Date date) {
            this.mChannel = channel;
            this.mDate = date;
        }

        public Channel getChannel() {
            return this.mChannel;
        }

        public devplugin.Date getDate() {
            return this.mDate;
        }

        public String toString() {
            return this.mDate + " " + this.mChannel;
        }
    }
}

