/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import devplugin.Date;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.Version;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;
import tvbrowser.core.plugin.DefaultSettings;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.settings.DeferredFontProperty;
import tvbrowser.core.settings.JGoodiesThemeProperty;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ChannelPanel;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableScrollPane;
import tvbrowser.ui.settings.BlockedPluginArrayProperty;
import tvbrowser.ui.waiting.dlgs.CopyWaitingDlg;
import util.browserlauncher.Launch;
import util.exc.TvBrowserException;
import util.io.IOUtilities;
import util.io.stream.InputStreamProcessor;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.misc.OperatingSystem;
import util.misc.TextLineBreakerStringWidth;
import util.settings.BooleanProperty;
import util.settings.ByteProperty;
import util.settings.ChannelArrayProperty;
import util.settings.ChoiceProperty;
import util.settings.ColorProperty;
import util.settings.ContextMenuMouseActionArrayProperty;
import util.settings.ContextMenuMouseActionSetting;
import util.settings.DateProperty;
import util.settings.EncodedStringProperty;
import util.settings.FontProperty;
import util.settings.IntArrayProperty;
import util.settings.IntProperty;
import util.settings.ProgramFieldTypeArrayProperty;
import util.settings.Property;
import util.settings.PropertyManager;
import util.settings.ShortProperty;
import util.settings.StringArrayProperty;
import util.settings.StringProperty;
import util.settings.VariableIntProperty;
import util.settings.VersionProperty;
import util.settings.WindowSetting;
import util.ui.Localizer;
import util.ui.ProgramPanel;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.view.SplitViewProperty;

public class Settings {
    public static final String LAYOUT_OPTIMIZED_COMPACT_TIME_BLOCK = "optimizedCompactTimeBlock";
    public static final String LAYOUT_COMPACT_TIME_BLOCK = "compactTimeBlock";
    public static final String LAYOUT_TIME_BLOCK = "timeBlock";
    public static final String LAYOUT_REAL_COMPACT = "realCompact";
    public static final String LAYOUT_REAL_SYNCHRONOUS = "realSynchronous";
    public static final String LAYOUT_COMPACT = "compact";
    public static final String LAYOUT_TIME_SYNCHRONOUS = "timeSynchronous";
    public static final String INFO_ID = "info.id";
    public static final String PICTURE_ID = "picture.id";
    private static final short INFO_DIALOG_WAITING_TIME = 1500;
    private static final Logger mLog = Logger.getLogger(Settings.class.getName());
    private static DefaultSettings mDefaultSettings = new DefaultSettings();
    private static final long PROXY_PASSWORD_SEED = 6528587292713416704L;
    private static final String SETTINGS_FILE = "settings.prop";
    private static final String DEFAULT_USER_DIR = ".tvbrowser";
    private static final String WINDOW_SETTINGS_FILE = "window.settings.dat";
    private static String DEFAULT_FONT_NAME = "Dialog";
    private static Font DEFAULT_PROGRAMTITLEFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 1, 0);
    private static Font DEFAULT_PROGRAMINFOFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 0, -1);
    private static final Font DEFAULT_CHANNELNAMEFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 1, 0);
    private static Font DEFAULT_PROGRAMTIMEFONT = new VariableFontSizeFont(DEFAULT_FONT_NAME, 1, 0);
    private static PropertyManager mProp = new PropertyManager();
    private static boolean mShowWaiting;
    private static boolean mShowSettingsCopyWaiting;
    private static HashMap<String, WindowSetting> mWindowSettings;
    private static boolean mCopyToSystem;
    public static final VersionProperty propTVBrowserVersion;
    public static final BooleanProperty propTVBrowserVersionIsStable;
    public static final BooleanProperty propUseDefaultFonts;
    public static final BooleanProperty propEnableAntialiasing;
    public static final StringProperty propTVDataDirectory;
    public static final StringProperty propPluginsDirectory;
    public static final StringProperty propSelectedChannelCountry;
    public static final StringProperty propSelectedChannelPlugin;
    public static final ChannelArrayProperty propSubscribedChannels;
    public static final StringArrayProperty propSubscribedChannelsSeparators;
    public static final ChoiceProperty propTableLayout;
    public static final ChoiceProperty propTableBackgroundStyle;
    public static final StringProperty propOneImageBackground;
    public static final IntProperty propTimeBlockSize;
    public static final StringProperty propTimeBlockBackground1;
    public static final StringProperty propTimeBlockBackground2;
    public static final StringProperty propTimeBlockWestImage1;
    public static final StringProperty propTimeBlockWestImage2;
    public static final BooleanProperty propTimeBlockShowWest;
    public static final StringProperty propTimeOfDayBackgroundEdge;
    public static final StringProperty propTimeOfDayBackgroundEarly;
    public static final StringProperty propTimeOfDayBackgroundMidday;
    public static final StringProperty propTimeOfDayBackgroundAfternoon;
    public static final StringProperty propTimeOfDayBackgroundEvening;
    public static final BooleanProperty propShowAssistant;
    public static final StringProperty propUserDefinedWebbrowser;
    public static final StringProperty propUserDefinedWebbrowserParams;
    public static final ColorProperty propProgramTableBackgroundSingleColor;
    public static final BooleanProperty propTrayIsEnabled;
    public static final BooleanProperty propTrayIsAntialiasing;
    public static final BooleanProperty propTrayMinimizeTo;
    public static final BooleanProperty propOnlyMinimizeWhenWindowClosing;
    public static final BooleanProperty propNowOnRestore;
    public static final BooleanProperty propTrayFilterNotMarked;
    public static final BooleanProperty propTrayFilterNot;
    public static final BooleanProperty propTrayUseSpecialChannels;
    public static final ChannelArrayProperty propTraySpecialChannels;
    public static final IntProperty propTrayChannelWidth;
    public static final BooleanProperty propTrayOnTimeProgramsEnabled;
    public static final BooleanProperty propTrayOnTimeProgramsInSubMenu;
    public static final BooleanProperty propTrayOnTimeProgramsContainsTime;
    public static final BooleanProperty propTrayOnTimeProgramsContainsIcon;
    public static final BooleanProperty propTrayOnTimeProgramsContainsName;
    public static final BooleanProperty propTrayOnTimeProgramsShowingSortNumber;
    public static final BooleanProperty propTrayOnTimeProgramsContainsToolTip;
    public static final BooleanProperty propTrayOnTimeProgramsShowProgress;
    public static final ColorProperty propTrayOnTimeProgramsDarkBackground;
    public static final ColorProperty propTrayOnTimeProgramsLightBackground;
    public static final BooleanProperty propScrollToTimeMarkingActivated;
    public static final ColorProperty propScrollToTimeProgramsDarkBackground;
    public static final ColorProperty propScrollToTimeProgramsLightBackground;
    public static final BooleanProperty propTrayNowProgramsEnabled;
    public static final BooleanProperty propTrayNowProgramsInSubMenu;
    public static final BooleanProperty propTrayNowProgramsContainsTime;
    public static final BooleanProperty propTrayNowProgramsContainsIcon;
    public static final BooleanProperty propTrayNowProgramsContainsName;
    public static final BooleanProperty propTrayNowProgramsContainsToolTip;
    public static final BooleanProperty propTrayNowProgramsShowingSortNumber;
    public static final BooleanProperty propTraySoonProgramsEnabled;
    public static final BooleanProperty propTraySoonProgramsContainsTime;
    public static final BooleanProperty propTraySoonProgramsContainsIcon;
    public static final BooleanProperty propTraySoonProgramsContainsName;
    public static final BooleanProperty propTraySoonProgramsContainsToolTip;
    public static final BooleanProperty propTraySoonProgramsShowingSortNumber;
    public static final IntProperty propTrayImportantProgramsPriority;
    public static final BooleanProperty propTrayImportantProgramsEnabled;
    public static final BooleanProperty propTrayImportantProgramsInSubMenu;
    public static final IntProperty propTrayImportantProgramsSize;
    public static final BooleanProperty propTrayImportantProgramsContainsIcon;
    public static final BooleanProperty propTrayImportantProgramsContainsName;
    public static final BooleanProperty propTrayImportantProgramsContainsDate;
    public static final BooleanProperty propTrayImportantProgramsContainsTime;
    public static final BooleanProperty propTrayImportantProgramsContainsToolTip;
    public static final BooleanProperty propTrayImportantProgramsShowingSortNumber;
    public static final ChoiceProperty propToolbarButtonStyle;
    public static final BooleanProperty propIsToolbarVisible;
    public static final BooleanProperty propIsMenubarVisible;
    public static final BooleanProperty propIsToolbarAdditonalTopSpace;
    public static final BooleanProperty propIsToolbarAdditonalBottomSpace;
    public static final BooleanProperty propIsStatusbarVisible;
    public static final StringProperty propSkinLFThemepack;
    public static final StringProperty propJGoodiesTheme;
    public static final BooleanProperty propJGoodiesShadow;
    public static final StringProperty propLookAndFeel;
    public static final IntProperty propColumnWidth;
    public static final IntArrayProperty propTimeButtons;
    public static final StringArrayProperty propToolbarButtons;
    public static final BooleanProperty propToolbarUseBigIcons;
    public static final StringProperty propToolbarLocation;
    public static final ContextMenuMouseActionArrayProperty propLeftSingleClickIfArray;
    public static final ContextMenuMouseActionArrayProperty propLeftDoubleClickIfArray;
    public static final ContextMenuMouseActionArrayProperty propMiddleSingleClickIfArray;
    public static final ContextMenuMouseActionArrayProperty propMiddleDoubleClickIfArray;
    public static final StringProperty propLastUsedFilter;
    public static final StringProperty propLastUsedChannelGroup;
    public static final StringArrayProperty propPluginOrder;
    public static final StringArrayProperty propContextMenuOrder;
    public static final StringArrayProperty propContextMenuDisabledItems;
    private static final String[] DEFAULT_DISABLED_PLUGINS;
    public static final StringArrayProperty propDeactivatedPlugins;
    public static final IntProperty propDownloadPeriod;
    public static final ChoiceProperty propAutoDownloadType;
    public static final IntProperty propAutoDownloadPeriod;
    public static final BooleanProperty propAskForAutoDownload;
    public static final BooleanProperty propSaveDefaultDataUpdateValuesDefault;
    public static final DateProperty propLastDownloadDate;
    public static final FontProperty propProgramTitleFont;
    public static final FontProperty propProgramInfoFont;
    public static final FontProperty propChannelNameFont;
    public static final FontProperty propProgramTimeFont;
    public static final ProgramFieldTypeArrayProperty propProgramInfoFields;
    public static final StringArrayProperty propProgramInfoFieldsSeparators;
    public static final StringArrayProperty propProgramTableIconPlugins;
    public static final BooleanProperty propProgramTableOnAirProgramsShowingBorder;
    public static final ColorProperty propProgramTableColorOnAirDark;
    public static final ColorProperty propProgramTableColorOnAirLight;
    public static final BooleanProperty propProgramPanelUsesExtraSpaceForMarkIcons;
    public static final BooleanProperty propProgramPanelWithMarkingsShowingBoder;
    public static final IntProperty propProgramPanelUsedDefaultMarkPriority;
    public static final ColorProperty propProgramPanelMarkedMinPriorityColor;
    public static final ColorProperty propProgramPanelMarkedLowerMediumPriorityColor;
    public static final ColorProperty propProgramPanelMarkedMediumPriorityColor;
    public static final ColorProperty propProgramPanelMarkedHigherMediumPriorityColor;
    public static final ColorProperty propProgramPanelMarkedMaxPriorityColor;
    public static final ColorProperty propProgramPanelForegroundColor;
    public static final BooleanProperty propProgramPanelAllowTransparency;
    public static final BooleanProperty propProgramPanelHyphenation;
    public static final IntProperty propProgramPanelMaxLines;
    public static final BooleanProperty propProgramPanelShortDurationActive;
    public static final IntProperty propProgramPanelShortDurationMinutes;
    public static final BooleanProperty propProgramTableMouseOver;
    public static final ColorProperty propProgramTableMouseOverColor;
    public static final ColorProperty propKeyboardSelectedColor;
    public static final BooleanProperty propIsWindowMaximized;
    public static final BooleanProperty propIsUsingFullscreen;
    public static final IntProperty propWindowWidth;
    public static final IntProperty propWindowHeight;
    public static final IntProperty propWindowX;
    public static final IntProperty propWindowY;
    public static final IntProperty propSettingsDialogDividerLocation;
    public static final IntProperty propProgramTableStartOfDay;
    public static final IntProperty propProgramTableEndOfDay;
    public static final BooleanProperty propHttpProxyUseProxy;
    public static final IntProperty propDefaultNetworkConnectionTimeout;
    public static final IntProperty propNetworkCheckTimeout;
    public static final IntProperty propPictureType;
    public static final IntProperty propPictureDescriptionLines;
    public static final StringArrayProperty propPicturePluginIds;
    public static final IntProperty propPictureStartTime;
    public static final IntProperty propPictureEndTime;
    public static final IntProperty propPictureDuration;
    public static final BooleanProperty propIsPictureShowingDescription;
    public static final StringProperty propHttpProxyHost;
    public static final StringProperty propHttpProxyPort;
    public static final BooleanProperty propHttpProxyAuthentifyAtProxy;
    public static final StringProperty propHttpProxyUser;
    public static final EncodedStringProperty propHttpProxyPassword;
    public static final StringArrayProperty propDataServicesForUpdate;
    public static final BooleanProperty propShowPluginView;
    public static final BooleanProperty propShowTimeButtons;
    public static final BooleanProperty propShowChannels;
    public static final BooleanProperty propShowDatelist;
    public static final BooleanProperty propShowFilterBar;
    public static final SplitViewProperty propViewRoot;
    public static final SplitViewProperty propViewMainframe;
    public static final SplitViewProperty propViewNavigation;
    public static final SplitViewProperty propViewDateChannel;
    public static final BooleanProperty propStartScreenShow;
    public static final StringProperty propLanguage;
    public static final StringProperty propCountry;
    public static final StringProperty propVariant;
    public static final StringProperty propTimezone;
    public static final BooleanProperty propMinimizeAfterStartup;
    public static final StringProperty propLogdirectory;
    public static final BooleanProperty propShowChannelIconsInProgramTable;
    public static final BooleanProperty propShowChannelNamesInProgramTable;
    public static final BooleanProperty propShowChannelIconsInChannellist;
    public static final BooleanProperty propShowChannelNamesInChannellist;
    public static final StringArrayProperty propUsedChannelGroups;
    public static final StringArrayProperty propDeleteFilesAtStart;
    public static final StringProperty propIcontheme;
    public static final BooleanProperty propShowBrowserOpenDialog;
    public static final BooleanProperty propIsSearchFieldVisible;
    public static final BooleanProperty propTwelveHourFormat;
    public static final IntProperty propFirstDayOfWeek;
    public static final StringArrayProperty propAcceptedLicenseArrForServiceIds;
    public static final StringProperty propLastUsedSettingsPath;
    public static final int MAX_COLUMN_WIDTH = 600;
    public static final int MIN_COLUMN_WIDTH = 120;
    public static final IntProperty propPluginsPictureSetting;
    public static final StringProperty propDefaultFilter;
    public static final BooleanProperty propAutoUpdatePlugins;
    public static final DateProperty propLastPluginsUpdate;
    public static final BooleanProperty propNTPTimeCheck;
    public static final DateProperty propLastNTPCheck;
    public static final BooleanProperty propInternetConnectionCheck;
    public static final BooleanProperty propPluginViewIsLeft;
    public static final IntProperty propViewDateLayout;
    public static final IntProperty propDataServiceAutoUpdateTime;
    public static final StringArrayProperty propHiddenMessageBoxes;
    public static final BooleanProperty propShowSortNumberInProgramTable;
    public static final BooleanProperty propShowSortNumberInProgramLists;
    public static final BooleanProperty propShowChannelTooltipInProgramTable;
    public static final DateProperty propFirstStartDate;
    public static final BooleanProperty propPluginInfoDialogWasShown;
    public static final ByteProperty propSelectedChannelCategoryIndex;
    public static final BooleanProperty propAutoDataDownloadEnabled;
    public static final ShortProperty propAutoDownloadWaitingTime;
    public static final BooleanProperty propAutoDownloadWaitingEnabled;
    public static final IntProperty propAutoChannelUpdatePeriod;
    public static final DateProperty propLastChannelUpdate;
    public static final BooleanProperty propProgramTableCutTitle;
    public static final IntProperty propProgramTableCutTitleLines;
    public static final BooleanProperty propProgramTableMouseAutoScroll;
    public static final StringArrayProperty propCurrentlyUsedDataServiceIds;
    public static final BlockedPluginArrayProperty propBlockedPluginArray;
    public static final StringProperty propLastUsedReceivePlugin;
    public static final StringProperty propLastUsedReceiveTarget;
    public static final BooleanProperty propChannelsWereConfigured;
    public static final BooleanProperty propPluginBetaWarning;
    public static final StringProperty propSelectedPersona;
    public static final BooleanProperty propRandomPersona;
    public static final BooleanProperty propShowProgramTablePictureBorder;
    public static final BooleanProperty propTypeAsYouFindEnabled;
    public static final BooleanProperty propAlwaysShowTabBarForCenterPanel;
    public static final StringArrayProperty propCenterPanelArr;
    public static final StringArrayProperty propDisabledCenterPanelArr;
    public static final BooleanProperty propProgramTableAutoChangeDate;
    public static final StringProperty propInfoIconThemeID;
    public static final BooleanProperty propVerboseLogging;
    public static final StringArrayProperty propKnownContextMenuPlugins;
    public static final StringArrayProperty propAccessControl;
    public static final IntProperty propShowChannelLogoForProgramPanel;
    public static final StringProperty propLastChannelExportFile;
    public static final StringArrayProperty propDataPluginPostProcessingOrder;

    public static DefaultSettings getDefaultSettings() {
        return mDefaultSettings;
    }

    public static void copyToSystem() {
        final File currentSettingsDir = new File(Settings.getUserSettingsDirName());
        final File currentTvDataDir = new File(Settings.getDefaultTvDataDir());
        mCopyToSystem = MainFrame.getInstance().getUserRequestCopyToSystem();
        if (mCopyToSystem) {
            Properties prop = new Properties();
            if (OperatingSystem.isMacOs()) {
                prop.setProperty("userdir", "${user.home}/Library/Preferences/TV-Browser");
                prop.setProperty("tvdatadir", "${user.home}/Library/Application Support/TV-Browser/tvdata");
                prop.setProperty("pluginsdir", "${user.home}/Library/Application Support/TV-Browser/plugins");
            } else if (OperatingSystem.isLinux()) {
                prop.setProperty("userdir", "${user.home}/.tvbrowser");
                prop.setProperty("tvdatadir", "${user.home}/.tvbrowser/tvdata");
            } else if (OperatingSystem.isWindows()) {
                prop.setProperty("userdir", "${user.appdata}/TV-Browser");
                prop.setProperty("tvdatadir", "${user.appdata}/TV-Browser/tvdata");
            }
            mDefaultSettings = new DefaultSettings(prop);
            final File targetSettingsDir = new File(Settings.getUserSettingsDirName());
            final File targetTvDataDir = new File(Settings.getDefaultTvDataDir());
            if (new File(Settings.getUserSettingsDirName(), SETTINGS_FILE).isFile()) {
                Object[] options = new String[]{MainFrame.mLocalizer.msg("continue", "Continue"), MainFrame.mLocalizer.msg("stop", "Cancel copying now")};
                String title = MainFrame.mLocalizer.msg("copyToSystemTitleWarning", "Settings already exists");
                String msg = MainFrame.mLocalizer.msg("copyToSystemWarningMsg", "Settings already exist in the system settings directory!\nIf you continue the current settings will be overwritten!");
                mCopyToSystem = JOptionPane.showOptionDialog(MainFrame.getInstance(), msg, title, 0, 2, null, options, options[1]) == 0;
            } else if (!targetSettingsDir.isDirectory()) {
                mCopyToSystem = targetSettingsDir.mkdirs();
            }
            if (!targetTvDataDir.isDirectory()) {
                mCopyToSystem = targetTvDataDir.mkdirs();
            }
            if (mCopyToSystem) {
                try {
                    final CopyWaitingDlg waiting = new CopyWaitingDlg((Window)new JFrame(), 4);
                    mLog.info("Copy settings and TV data from TV-Browser transportable to system");
                    mShowWaiting = true;
                    Thread copyDataThread = new Thread("Copy TV data directory"){

                        @Override
                        public void run() {
                            try {
                                IOUtilities.copy(currentSettingsDir.listFiles(new FilenameFilter(){

                                    @Override
                                    public boolean accept(File dir2, String name) {
                                        return !name.equalsIgnoreCase("tvdata") && !name.equals(targetSettingsDir.getName()) && !name.equalsIgnoreCase("backup") && !name.equalsIgnoreCase("lang") && !name.equals(".lock");
                                    }
                                }), targetSettingsDir);
                                1.sleep(5000L);
                                IOUtilities.copy(currentTvDataDir.listFiles(), targetTvDataDir, true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            mShowWaiting = false;
                            waiting.setVisible(false);
                        }
                    };
                    copyDataThread.start();
                    waiting.setVisible(mShowWaiting);
                }
                catch (Exception e) {
                    mCopyToSystem = false;
                }
            }
        }
    }

    public static String getUserDirectoryName() {
        String dir2 = System.getProperty("user.home") + File.separator + DEFAULT_USER_DIR;
        return TVBrowser.isTransportable() && !mCopyToSystem ? new File("settings").getAbsolutePath() : mDefaultSettings.getProperty("userdir", dir2);
    }

    public static String getOSLibraryDirectoryName() {
        if (OperatingSystem.isMacOs()) {
            return "/Library/Application Support/TV-Browser/";
        }
        return "";
    }

    public static String getUserSettingsDirName() {
        String version = TVBrowser.getCurrentVersionString();
        if (version.toLowerCase().indexOf("nightly") != -1) {
            version = StringUtils.substringBefore(version, "-");
        }
        return Settings.getUserDirectoryName() + File.separator + version;
    }

    public static void storeSettings(boolean log) throws TvBrowserException {
        File f = new File(Settings.getUserSettingsDirName());
        if (!f.exists()) {
            f.mkdirs();
        }
        File settingsFile = new File(Settings.getUserSettingsDirName(), SETTINGS_FILE);
        File firstSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup1");
        File secondSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup2");
        try {
            if (firstSettingsBackupFile.isFile()) {
                secondSettingsBackupFile.delete();
                firstSettingsBackupFile.renameTo(secondSettingsBackupFile);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            mProp.writeToFile(settingsFile);
            try {
                if (settingsFile.isFile()) {
                    IOUtilities.copy(settingsFile, firstSettingsBackupFile);
                }
            }
            catch (Exception e) {}
        }
        catch (IOException exc) {
            throw new TvBrowserException(Settings.class, "error.1", "Error when saving settings!\n({0})", (Object)settingsFile.getAbsolutePath(), (Throwable)exc);
        }
        Settings.storeWindowSettings(log);
    }

    private static void storeWindowSettings(boolean log) {
        if (log) {
            mLog.info("Storing window settings");
        }
        File windowSettingsFile = new File(Settings.getUserSettingsDirName(), WINDOW_SETTINGS_FILE);
        StreamUtilities.objectOutputStreamIgnoringExceptions(windowSettingsFile, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                out.writeInt(1);
                out.writeInt(mWindowSettings.size());
                for (String key : mWindowSettings.keySet()) {
                    WindowSetting setting = (WindowSetting)mWindowSettings.get(key);
                    if (setting == null) continue;
                    out.writeUTF(key);
                    ((WindowSetting)mWindowSettings.get(key)).saveSettings(out);
                }
                out.close();
            }
        });
    }

    private static void startImportWaitingDlg() {
        mShowSettingsCopyWaiting = true;
        new Thread("settings import info thread"){

            @Override
            public void run() {
                try {
                    3.sleep(1500L);
                    if (mShowSettingsCopyWaiting) {
                        final CopyWaitingDlg waiting = new CopyWaitingDlg((Window)new JFrame(), 3);
                        new Thread("settings import waiting thread"){

                            @Override
                            public void run() {
                                while (mShowSettingsCopyWaiting) {
                                    try {
                                        1.sleep(200L);
                                    }
                                    catch (InterruptedException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                waiting.setVisible(false);
                            }
                        }.start();
                        waiting.setVisible(mShowSettingsCopyWaiting);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    /*
     * Unable to fully structure code
     */
    public static void loadSettings() {
        block75: {
            oldDirectoryName = System.getProperty("user.home", "") + File.separator + ".tvbrowser";
            newDirectoryName = Settings.getUserSettingsDirName();
            settingsFile = new File(newDirectoryName, "settings.prop");
            firstSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup1");
            secondSettingsBackupFile = new File(Settings.getUserSettingsDirName(), "settings.prop_backup2");
            if (settingsFile.exists() || firstSettingsBackupFile.exists() || secondSettingsBackupFile.exists()) {
                try {
                    Settings.mProp.readFromFile(settingsFile);
                    if ((Settings.mProp.getProperty("subscribedchannels") == null || Settings.mProp.getProperty("subscribedchannels").trim().length() < 1) && Settings.mProp.getProperty("channelsWereConfigured") != null && Settings.mProp.getProperty("channelsWereConfigured").equals("true") && (firstSettingsBackupFile.isFile() || secondSettingsBackupFile.isFile())) {
                        throw new IOException();
                    }
                    Settings.mLog.info("Using settings from file " + settingsFile.getAbsolutePath());
                }
                catch (IOException evt) {
                    if (firstSettingsBackupFile.isFile() || secondSettingsBackupFile.isFile()) {
                        localizer = Localizer.getLocalizerFor(Settings.class);
                        if (JOptionPane.showConfirmDialog(null, localizer.msg("settingBroken", "Settings file broken.\nWould you like to load the backup file?\n\n(If you select No, the\ndefault settings are used)"), Localizer.getLocalization("i18n_error"), 0, 3) != 0) break block75;
                        v0 = loadSecondBackup = firstSettingsBackupFile.isFile() == false;
                        if (firstSettingsBackupFile.isFile()) {
                            try {
                                Settings.mProp.readFromFile(firstSettingsBackupFile);
                                if ((Settings.mProp.getProperty("subscribedchannels") == null || Settings.mProp.getProperty("subscribedchannels").trim().length() < 1) && secondSettingsBackupFile.isFile()) {
                                    loadSecondBackup = true;
                                } else {
                                    Settings.mLog.info("Using settings from file " + firstSettingsBackupFile.getAbsolutePath());
                                    loadSecondBackup = false;
                                }
                            }
                            catch (Exception e) {
                                loadSecondBackup = true;
                            }
                        }
                        if (loadSecondBackup && secondSettingsBackupFile.isFile()) {
                            try {
                                Settings.mProp.readFromFile(secondSettingsBackupFile);
                                Settings.mLog.info("Using settings from file " + secondSettingsBackupFile.getAbsolutePath());
                                loadSecondBackup = false;
                            }
                            catch (Exception e) {
                                loadSecondBackup = true;
                            }
                        }
                        if (loadSecondBackup) {
                            Settings.mLog.info("Could not read settings - using default user settings");
                        } else {
                            try {
                                Settings.loadWindowSettings();
                                Settings.storeSettings(true);
                            }
                            catch (Exception e) {}
                        }
                        break block75;
                    }
                    Settings.mLog.info("Could not read settings - using default user settings");
                }
            } else if (!oldDirectoryName.equals(newDirectoryName)) {
                oldDir = null;
                countValue = 1;
                firstDir = System.getProperty("user.home") + "/TV-Browser";
                if (Launch.isOsWindowsNtBranch()) {
                    countValue = 3;
                }
                if (OperatingSystem.isWindows() && (test = new File(System.getenv("appdata"), "TV-Browser")).isDirectory()) {
                    firstDir = test.getAbsolutePath();
                }
                directories = new String[]{Settings.getUserDirectoryName(), firstDir, System.getProperty("user.home") + "/TV-Browser", System.getProperty("user.home") + "/Library/Preferences/TV-Browser", System.getProperty("user.home") + "/.tvbrowser"};
                for (j = 0; j < (TVBrowser.isTransportable() != false ? directories.length : countValue); ++j) {
                    Settings.mLog.info("Search for settings import in: '" + directories[j] + "'");
                    oldDir = Settings.findNewestOldVersionDir(directories[j], oldDirectoryName, j != 0);
                    if (oldDir != null) break;
                }
                pluginsDir = null;
                if (TVBrowser.isTransportable()) {
                    Settings.mLog.info("TV-Browser ist transportable version, show import dialog: '" + (oldDir != null && oldDir.isDirectory() != false && oldDir.exists() != false && oldDir.getAbsolutePath().startsWith(new File("settings").getAbsolutePath()) == false) + "', show import directory selection dialog: '" + (oldDir == null || oldDir.isDirectory() == false || oldDir.exists() == false) + "'");
                    if (oldDir != null && oldDir.isDirectory() && oldDir.exists() && !oldDir.getAbsolutePath().startsWith(new File("settings").getAbsolutePath())) {
                        try {
                            UIManager.setLookAndFeel(UiUtilities.getDefaultLookAndFeelClassName(false));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        options = new String[]{MainFrame.mLocalizer.msg("import", "Import settings"), MainFrame.mLocalizer.msg("importTransportable", "Select import directory"), MainFrame.mLocalizer.msg("configureNew", "Create new configuration")};
                        title = MainFrame.mLocalizer.msg("importInfoTitle", "Import settings?");
                        msg = MainFrame.mLocalizer.msg("importInfoMsg", "TV-Browser has found settings for import.\nShould the settings be imported now?");
                        answer = JOptionPane.showOptionDialog(null, msg, title, 1, 2, null, options, options[0]);
                        if (answer == 2) {
                            oldDir = null;
                        } else if (answer == 1) {
                            oldDir = Settings.loadExternalSettings();
                            if (oldDir != null) {
                                oldDir = Settings.findNewestOldVersionDir(oldDir.getAbsolutePath(), oldDirectoryName, true);
                            }
                        } else if (OperatingSystem.isMacOs()) {
                            pluginsDir = new File(System.getProperty("user.home"), "Library/Application Support/TV-Browser/plugins");
                        }
                    } else if (oldDir == null || !oldDir.isDirectory() || !oldDir.exists()) {
                        try {
                            UIManager.setLookAndFeel(UiUtilities.getDefaultLookAndFeelClassName(false));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        options = new String[]{MainFrame.mLocalizer.msg("importTransportable", "Select import directory"), MainFrame.mLocalizer.msg("configureNew", "Create new configuration")};
                        title = MainFrame.mLocalizer.msg("importInfoTitle", "Import settings?");
                        msg = MainFrame.mLocalizer.msg("importInfoMsgTransportable", "No settings were found on the system.\nDo you want to select the directory of another\ntransportable version for import of settings?");
                        if (JOptionPane.showOptionDialog(null, msg, title, 0, 2, null, options, options[1]) == 0) {
                            oldDir = Settings.loadExternalSettings();
                            if (oldDir != null) {
                                oldDir = Settings.findNewestOldVersionDir(oldDir.getAbsolutePath(), oldDirectoryName, true);
                            }
                        } else {
                            oldDir = null;
                        }
                    }
                }
                if (oldDir != null && oldDir.isDirectory() && oldDir.exists()) {
                    testFile = new File(oldDir, "settings.prop");
                    Settings.startImportWaitingDlg();
                    Settings.mLog.info("Try to load settings from a previous version of TV-Browser: " + oldDir);
                    newDir = new File(Settings.getUserSettingsDirName());
                    oldTvDataDir = null;
                    oldIconsDir = null;
                    oldInfoIconsDir = null;
                    prop = new Properties();
                    try {
                        StreamUtilities.inputStream(testFile, new InputStreamProcessor(){

                            @Override
                            public void process(InputStream input) throws IOException {
                                prop.load(input);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    versionString = prop.getProperty("version", null);
                    testVersion = null;
                    if (versionString != null) {
                        try {
                            asInt = Integer.parseInt(versionString);
                            major = asInt / 100;
                            minor = asInt % 100;
                            testVersion = new Version(major, minor);
                        }
                        catch (NumberFormatException exc) {
                            // empty catch block
                        }
                    }
                    temp = prop.getProperty("dir.tvdata", null);
                    v1 = versionTest = TVBrowser.isTransportable() == false && Launch.isOsWindowsNtBranch() != false && testVersion != null && testVersion.compareTo(new Version(3, 0, true)) < 0 && (temp == null || temp.replace("/", "\\").equals(System.getProperty("user.home") + "\\TV-Browser\\tvdata") != false);
                    if ((TVBrowser.isTransportable() || versionTest) && !new File(Settings.getUserDirectoryName(), "tvdata").isDirectory()) {
                        try {
                            if (temp != null) {
                                oldTvDataDir = new File(temp);
                            } else if (new File(oldDir, "tvdata").isDirectory()) {
                                oldTvDataDir = new File(oldDir, "tvdata");
                            } else if (new File(oldDir.getParent(), "tvdata").isDirectory()) {
                                oldTvDataDir = new File(oldDir.getParent(), "tvdata");
                            } else if (OperatingSystem.isMacOs() && (test = new File(System.getProperty("user.home"), "Library/Application Support/TV-Browser/tvdata")).isDirectory()) {
                                oldTvDataDir = test;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (TVBrowser.isTransportable()) {
                        if (!new File(Settings.getUserDirectoryName(), "icons").isDirectory() && new File(oldDir.getParent(), "icons").isDirectory()) {
                            oldIconsDir = new File(oldDir.getParent(), "icons");
                        }
                        if (!new File(Settings.getUserDirectoryName(), "infothemes").isDirectory() && new File(oldDir.getParent(), "infothemes").isDirectory()) {
                            oldInfoIconsDir = new File(oldDir.getParent(), "infothemes");
                        }
                    }
                    if (newDir.mkdirs()) {
                        try {
                            IOUtilities.copy(oldDir.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir2, String name) {
                                    return !name.equalsIgnoreCase("tvdata") && !name.equals(newDir.getName()) && !name.equalsIgnoreCase("backup") && !name.equalsIgnoreCase("lang");
                                }
                            }), newDir);
                            if (pluginsDir != null && pluginsDir.isDirectory()) {
                                target = new File(newDir, "plugins");
                                if (!target.isDirectory()) {
                                    target.mkdirs();
                                }
                                IOUtilities.copy(pluginsDir.listFiles(new FileFilter(){

                                    @Override
                                    public boolean accept(File f) {
                                        return f.isFile() && f.getName().toLowerCase().endsWith(".jar");
                                    }
                                }), target);
                            }
                            Settings.mShowSettingsCopyWaiting = false;
                            Settings.mLog.info("settings from previous version copied successfully");
                            newSettingsFile = new File(newDir, "settings.prop");
                            Settings.mProp.readFromFile(newSettingsFile);
                            Settings.mLog.info("settings from previous version read successfully");
                            if (oldDirectoryName.equals(oldDir.getAbsolutePath())) {
                                settings = newDir.listFiles(new FilenameFilter(){

                                    @Override
                                    public boolean accept(File dir2, String name) {
                                        return name.toLowerCase().endsWith(".prop") && name.toLowerCase().indexOf("settings") == -1 || name.toLowerCase().endsWith(".dat") && name.toLowerCase().indexOf("tv-data-inventory") == -1;
                                    }
                                });
                                version1 = false;
                                if (settings != null) {
                                    for (i = 0; i < settings.length; ++i) {
                                        name = "java." + settings[i].getName();
                                        if (settings[i].getName().toLowerCase().startsWith("java.")) continue;
                                        version1 = true;
                                        settings[i].renameTo(new File(settings[i].getParent(), name));
                                    }
                                }
                                if (version1 && !new File(oldDirectoryName, newDir.getName()).isDirectory()) {
                                    oldDir.renameTo(new File(System.getProperty("user.home", "") + File.separator + "tvbrowser_BACKUP"));
                                }
                            }
                            if (oldTvDataDir != null && oldTvDataDir.isDirectory() && !oldTvDataDir.equals(targetDir = new File(Settings.getUserDirectoryName(), "tvdata"))) {
                                targetDir.mkdirs();
                                waiting = new CopyWaitingDlg((Window)new JFrame(), versionTest != false ? 2 : 1);
                                Settings.mShowWaiting = true;
                                srcDir = oldTvDataDir;
                                copyDataThread = new Thread("Copy TV data directory"){

                                    @Override
                                    public void run() {
                                        try {
                                            IOUtilities.copy(srcDir.listFiles(), targetDir, true);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        mShowWaiting = false;
                                        waiting.setVisible(false);
                                    }
                                };
                                copyDataThread.start();
                                waiting.setVisible(Settings.mShowWaiting);
                            }
                            if (oldIconsDir != null && oldIconsDir.isDirectory() && !oldIconsDir.equals(targetDir = new File(Settings.getUserDirectoryName(), "icons"))) {
                                targetDir.mkdirs();
                                waiting = new CopyWaitingDlg((Window)new JFrame(), versionTest != false ? 2 : 1);
                                Settings.mShowWaiting = true;
                                srcDir = oldIconsDir;
                                copyIconsThread = new Thread("Copy icons directory"){

                                    @Override
                                    public void run() {
                                        try {
                                            IOUtilities.copy(srcDir.listFiles(), targetDir, true);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        mShowWaiting = false;
                                        waiting.setVisible(false);
                                    }
                                };
                                copyIconsThread.start();
                                waiting.setVisible(Settings.mShowWaiting);
                            }
                            if (oldInfoIconsDir != null && oldInfoIconsDir.isDirectory() && !oldInfoIconsDir.equals(targetDir = new File(Settings.getUserDirectoryName(), "infothemes"))) {
                                targetDir.mkdirs();
                                waiting = new CopyWaitingDlg((Window)new JFrame(), versionTest != false ? 2 : 1);
                                Settings.mShowWaiting = true;
                                srcDir = oldInfoIconsDir;
                                copyInfoIconsThread = new Thread("Copy info icons directory"){

                                    @Override
                                    public void run() {
                                        try {
                                            IOUtilities.copy(srcDir.listFiles(), targetDir, true);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        mShowWaiting = false;
                                        waiting.setVisible(false);
                                    }
                                };
                                copyInfoIconsThread.start();
                                waiting.setVisible(Settings.mShowWaiting);
                            }
                            if (!new File(Settings.getUserDirectoryName(), "settings.prop").isFile() || !(backupDir = new File(Settings.getUserDirectoryName(), "BACKUP")).mkdirs()) ** GOTO lbl219
                            Settings.mLog.info("moving the settings of old settings dir to backup");
                            files = oldDir.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File pathname) {
                                    return pathname.compareTo(newDir) != 0 && pathname.getName().compareToIgnoreCase("tvdata") != 0 && pathname.compareTo(backupDir) != 0;
                                }
                            });
                            if (files == null) ** GOTO lbl219
                            for (File file : files) {
                                file.renameTo(new File(backupDir, file.getName()));
                            }
                        }
                        catch (IOException e) {
                            Settings.mLog.log(Level.WARNING, "Could not import user settings from '" + oldDir.getAbsolutePath() + "' to '" + newDir.getAbsolutePath() + "'", e);
                        }
                    } else {
                        Settings.mLog.info("Could not create directory '" + newDir.getAbsolutePath() + "' - using default user settings");
                    }
                } else {
                    Settings.mLog.info("No previous version of TV-Browser found - using default user settings");
                }
            }
        }
        Settings.mShowSettingsCopyWaiting = false;
        settingsDir = new File(newDirectoryName);
        if (!settingsDir.exists()) {
            Settings.mLog.info("Creating " + newDirectoryName);
            settingsDir.mkdir();
        }
        Settings.loadWindowSettings();
        ((DeferredFontProperty)Settings.propProgramTitleFont).resetDefault();
        ((DeferredFontProperty)Settings.propProgramInfoFont).resetDefault();
        ((DeferredFontProperty)Settings.propChannelNameFont).resetDefault();
        ((DeferredFontProperty)Settings.propProgramTimeFont).resetDefault();
        if (Settings.propColumnWidth.getInt() < 120) {
            Settings.propColumnWidth.setInt(120);
        }
    }

    public static void updateContextMenuSettings() {
        ArrayList<ContextMenuMouseActionSetting> leftSingleList = new ArrayList<ContextMenuMouseActionSetting>(2);
        if (mProp.getProperty("leftSingleClickIf") != null) {
            StringProperty propLeftSingleClickIf = new StringProperty(mProp, "leftSingleClickIf", ProgramInfo.getProgramInfoPluginId());
            leftSingleList.add(new ContextMenuMouseActionSetting(0, propLeftSingleClickIf.getString()));
            propLeftSingleClickIf.setString(propLeftSingleClickIf.getDefault());
        }
        if (mProp.getProperty("contextmenudefaultplugin") != null) {
            StringProperty propDoubleClickIf = new StringProperty(mProp, "contextmenudefaultplugin", ProgramInfo.getProgramInfoPluginId());
            propLeftDoubleClickIfArray.setContextMenuMouseActionArray(new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, propDoubleClickIf.getString())});
            propDoubleClickIf.setString(propDoubleClickIf.getDefault());
        }
        if (mProp.getProperty("middleclickplugin") != null) {
            StringProperty propMiddleClickIf = new StringProperty(mProp, "middleclickplugin", ReminderPlugin.getReminderPluginId());
            propMiddleSingleClickIfArray.setContextMenuMouseActionArray(new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, propMiddleClickIf.getString())});
            propMiddleClickIf.setString(propMiddleClickIf.getDefault());
        }
        if (mProp.getProperty("middledoubleclickplugin") != null) {
            StringProperty propMiddleDoubleClickIf = new StringProperty(mProp, "middledoubleclickplugin", FavoritesPlugin.getFavoritesPluginId());
            propMiddleDoubleClickIfArray.setContextMenuMouseActionArray(new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, propMiddleDoubleClickIf.getString())});
            propMiddleDoubleClickIf.setString(propMiddleDoubleClickIf.getDefault());
        }
        if (mProp.getProperty("leftSingleCtrlClickIf") != null) {
            StringProperty propLeftSingleCtrlClickIf = new StringProperty(mProp, "leftSingleCtrlClickIf", null);
            leftSingleList.add(new ContextMenuMouseActionSetting(128, propLeftSingleCtrlClickIf.getString()));
            propLeftSingleCtrlClickIf.setString(propLeftSingleCtrlClickIf.getDefault());
        }
        if (!leftSingleList.isEmpty()) {
            propLeftSingleClickIfArray.setContextMenuMouseActionArray(leftSingleList.toArray(new ContextMenuMouseActionSetting[leftSingleList.size()]));
        }
        try {
            Settings.storeSettings(true);
        }
        catch (TvBrowserException e) {
            e.printStackTrace();
        }
        ContextMenuManager.getInstance().init();
    }

    private static File findNewestOldVersionDir(String directory, String oldDirectoryName, boolean includeCurrent) {
        int i;
        File oldDir = null;
        File testFile = null;
        String[] allVersions = TVBrowser.getAllVersionStrings();
        int n = i = includeCurrent ? 0 : 1;
        while (i < allVersions.length) {
            testFile = new File(directory + File.separator + allVersions[i], SETTINGS_FILE);
            if (testFile.isFile()) {
                oldDir = new File(directory, allVersions[i]);
                break;
            }
            ++i;
        }
        if (oldDir == null) {
            testFile = new File(directory, SETTINGS_FILE);
            if (testFile.isFile()) {
                oldDir = new File(directory);
            } else {
                testFile = new File(oldDirectoryName, SETTINGS_FILE);
                if (testFile.isFile()) {
                    oldDir = new File(oldDirectoryName);
                }
            }
        }
        return oldDir;
    }

    private static File loadExternalSettings() {
        String msg = MainFrame.mLocalizer.msg("importTransportableInfo", "To import settings of another transportable version select the program\ndirectory of that other transportable version in the next setp.");
        String title = MainFrame.mLocalizer.msg("importTransportableTitle", "Import settings from transportable version");
        JOptionPane.showMessageDialog(null, msg, title, 1);
        JFileChooser chooseDir = new JFileChooser(System.getProperty("user.home"));
        chooseDir.setFileSelectionMode(1);
        chooseDir.setDialogTitle(title);
        chooseDir.setMultiSelectionEnabled(false);
        int selection = 1;
        do {
            String title2;
            String msg2;
            if (selection != 0 || JOptionPane.showConfirmDialog(null, msg2 = MainFrame.mLocalizer.msg("importTransportableError", "You've selected a directory that don't contains a transportable TV-Browser.\nWould you like to try again?"), title2 = MainFrame.mLocalizer.msg("importTransportableErrorTitle", "Wrong directory selected"), 0) != 1) continue;
            selection = 1;
            break;
        } while ((selection = chooseDir.showDialog(null, Localizer.getLocalization("i18n_select"))) != 1 && (chooseDir.getSelectedFile() == null || !chooseDir.getSelectedFile().isDirectory() || !new File(chooseDir.getSelectedFile(), "settings").isDirectory() || !new File(chooseDir.getSelectedFile(), "tvbrowser.jar").isFile()));
        if (selection == 0 && chooseDir.getSelectedFile() != null) {
            return new File(chooseDir.getSelectedFile(), "settings");
        }
        return null;
    }

    private static void loadWindowSettings() {
        File windowSettingsFile = new File(Settings.getUserSettingsDirName(), WINDOW_SETTINGS_FILE);
        if (windowSettingsFile.isFile() && windowSettingsFile.canRead()) {
            try {
                StreamUtilities.objectInputStream(windowSettingsFile, new ObjectInputStreamProcessor(){

                    @Override
                    public void process(ObjectInputStream in) throws IOException {
                        if (in.available() > 0) {
                            in.readInt();
                            int n = in.readInt();
                            mWindowSettings = new HashMap(n);
                            for (int i = 0; i < n; ++i) {
                                mWindowSettings.put(in.readUTF(), new WindowSetting(in));
                            }
                        }
                        in.close();
                    }
                });
            }
            catch (Exception e) {
                mWindowSettings = null;
            }
        }
        if (mWindowSettings == null) {
            mWindowSettings = new HashMap(1);
        }
    }

    public static void handleChangedSettings() {
        DefaultProgramTableModel model;
        ProgramTableScrollPane scrollPane;
        MainFrame mainFrame = MainFrame.getInstance();
        Property[] propArr = new Property[]{propProgramTitleFont, propProgramInfoFont, propProgramTimeFont, propChannelNameFont, propUseDefaultFonts, propEnableAntialiasing, propProgramTableOnAirProgramsShowingBorder, propProgramPanelUsesExtraSpaceForMarkIcons, propProgramPanelWithMarkingsShowingBoder, propProgramPanelUsedDefaultMarkPriority, propProgramPanelMarkedLowerMediumPriorityColor, propProgramPanelMarkedMinPriorityColor, propProgramPanelMarkedMediumPriorityColor, propProgramPanelMarkedMaxPriorityColor, propProgramTableColorOnAirLight, propProgramTableColorOnAirDark, propProgramPanelForegroundColor, propProgramTableBackgroundSingleColor, propProgramPanelAllowTransparency, propAlwaysShowTabBarForCenterPanel};
        mainFrame.updateCenterPanels();
        if (mProp.hasChanged(propArr)) {
            ProgramPanel.updateFonts();
            ChannelPanel.fontChanged();
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.forceRepaintAll();
        }
        if (mProp.hasChanged(propArr = new Property[]{propPictureType, propPictureStartTime, propPictureEndTime, propIsPictureShowingDescription, propPicturePluginIds, propPictureDuration, propProgramTableCutTitle, propProgramTableCutTitleLines, propPictureDescriptionLines, propProgramPanelMaxLines, propProgramPanelShortDurationActive, propProgramPanelShortDurationMinutes, propShowProgramTablePictureBorder})) {
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (mProp.hasChanged(propProgramPanelHyphenation)) {
            TextLineBreakerStringWidth.resetHyphenator();
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (mProp.hasChanged(propColumnWidth)) {
            ProgramPanel.updateColumnWidth();
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.setColumnWidth(propColumnWidth.getInt());
            scrollPane.forceRepaintAll();
        }
        if (mProp.hasChanged(propTableLayout)) {
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.getProgramTable().setProgramTableLayout(null);
            scrollPane.getProgramTable().updateBackground();
            scrollPane.forceRepaintAll();
        }
        if (mProp.hasChanged(propDeactivatedPlugins)) {
            mainFrame.updatePluginsMenu();
            mainFrame.updateToolbar();
        }
        if (mProp.hasChanged(propArr = new Property[]{propTableBackgroundStyle, propOneImageBackground, propTimeBlockSize, propTimeBlockBackground1, propTimeBlockBackground2, propTimeBlockShowWest, propTimeBlockWestImage1, propTimeBlockWestImage2, propTimeOfDayBackgroundEdge, propTimeOfDayBackgroundEarly, propTimeOfDayBackgroundMidday, propTimeOfDayBackgroundAfternoon, propTimeOfDayBackgroundEvening})) {
            scrollPane = mainFrame.getProgramTableScrollPane();
            scrollPane.getProgramTable().updateBackground();
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (mProp.hasChanged(propTimeBlockSize)) {
            mainFrame.getProgramTableScrollPane().forceRepaintAll();
        }
        if (mProp.hasChanged(propArr = new Property[]{propToolbarButtonStyle, propToolbarButtons, propToolbarLocation, propIsToolbarVisible, propToolbarUseBigIcons})) {
            mainFrame.updateToolbar();
        }
        if (mProp.hasChanged(propTimeButtons)) {
            mainFrame.updateTimeButtons();
        }
        if (mProp.hasChanged(propSubscribedChannels)) {
            ChannelList.reload();
            model = mainFrame.getProgramTableModel();
            model.setChannels(ChannelList.getSubscribedChannels());
            mainFrame.updateChannellist();
        }
        if (mProp.hasChanged(propRandomPersona) && !mProp.hasChanged(propSelectedPersona)) {
            Persona.getInstance().applyPersona();
        }
        if (mProp.hasChanged(propSelectedPersona)) {
            Persona.getInstance().applyPersona();
        }
        if (mProp.hasChanged(propArr = new Property[]{propProgramTableStartOfDay, propProgramTableEndOfDay})) {
            model = mainFrame.getProgramTableModel();
            int startOfDay = propProgramTableStartOfDay.getInt();
            int endOfDay = propProgramTableEndOfDay.getInt();
            model.setTimeRange(startOfDay, endOfDay);
            model.setDate(mainFrame.getCurrentSelectedDate(), null, null);
        }
        if (mProp.hasChanged(propArr = new Property[]{propProgramTableIconPlugins, propProgramInfoFields, propProgramInfoFieldsSeparators})) {
            model = mainFrame.getProgramTableModel();
            model.setDate(mainFrame.getCurrentSelectedDate(), null, null);
        }
        if (mProp.hasChanged(propArr = new Property[]{propShowChannelIconsInProgramTable, propShowChannelIconsInChannellist, propShowChannelNamesInProgramTable, propShowChannelNamesInChannellist, propShowSortNumberInProgramTable, propShowSortNumberInProgramLists})) {
            mainFrame.getProgramTableScrollPane().updateChannelPanel();
            mainFrame.updateChannelChooser();
        }
        if (mProp.hasChanged(propTVDataDirectory)) {
            TvDataServiceProxyManager.getInstance().setTvDataDir(new File(propTVDataDirectory.getString()));
            TvDataBase.getInstance().updateTvDataBase();
            TvDataBase.getInstance().checkTvDataInventory(1);
            MainFrame.getInstance().handleChangedTvDataDir();
        }
        if (mProp.hasChanged(propViewDateLayout)) {
            MainFrame.getInstance().createDateSelector();
            MainFrame.getInstance().setShowDatelist(true, true);
        }
        mProp.clearChanges();
        try {
            Settings.storeSettings(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PluginProxyManager.getInstance().fireTvBrowserSettingsChanged();
    }

    public static String getTimePattern() {
        if (propTwelveHourFormat.getBoolean()) {
            return "hh:mm a";
        }
        return "HH:mm";
    }

    private static String getDefaultTvDataDir() {
        return TVBrowser.isTransportable() && !mCopyToSystem ? "./settings/tvdata" : Settings.getUserDirectoryName() + File.separator + "tvdata";
    }

    private static String getDefaultPluginsDir() {
        return Settings.getUserSettingsDirName() + "/plugins";
    }

    public static final String getCountry() {
        String country = Locale.getDefault().getCountry();
        String result = Locale.getDefault().getLanguage();
        if (country.equals(new Locale("de_AT", "AT").getCountry()) || result.toLowerCase().equals(new Locale("de_AT", "AT").getLanguage().toLowerCase())) {
            result = "at";
        } else if (country.equals(new Locale("de_CH", "CH").getCountry()) || result.toLowerCase().equals(new Locale("de_CH", "CH").getLanguage().toLowerCase())) {
            result = "ch";
        } else if (country.equals(new Locale("de_DE", "DE").getCountry()) || result.toLowerCase().equals(new Locale("de_DE", "DE").getLanguage().toLowerCase())) {
            result = "de";
        }
        return result.toLowerCase();
    }

    public static final void layoutWindow(String windowId, Window window) {
        Settings.layoutWindow(windowId, window, null);
    }

    public static final void layoutWindow(String windowId, Window window, Dimension defaultSize) {
        Settings.layoutWindow(windowId, window, defaultSize, null);
    }

    public static final void layoutWindow(String windowId, Window window, Dimension defaultSize, Window parent) {
        WindowSetting setting = mWindowSettings.get(windowId);
        if (setting == null) {
            setting = new WindowSetting(defaultSize);
            mWindowSettings.put(windowId, setting);
        }
        setting.layout(window, parent);
    }

    public static void updateChannelFilters(Channel[] channelArr) {
        Settings.updateChannelFilters(channelArr, true);
    }

    public static void updateChannelFilters(Channel[] channelArr, boolean updateAll) {
        ArrayList<SingleChannelFilterComponent> channelNameUpdateList = FilterComponentList.getInstance().updateChannels(channelArr);
        if (!channelNameUpdateList.isEmpty()) {
            ProgramFilter[] filters = FilterList.getInstance().getFilterArr();
            for (SingleChannelFilterComponent scFilter : channelNameUpdateList) {
                for (ProgramFilter filter : filters) {
                    if (!(filter instanceof UserFilter)) continue;
                    String rule = ((UserFilter)filter).getRule();
                    try {
                        ((UserFilter)filter).setRule(rule.replace(scFilter.getLoadName(), scFilter.getName()));
                    }
                    catch (ParserException e) {
                        e.printStackTrace();
                    }
                }
                scFilter.updateName();
            }
        }
        if (!channelNameUpdateList.isEmpty() || updateAll) {
            FilterComponentList.getInstance().store();
            FilterList.getInstance().updateAvailableChannels(channelArr);
            FilterList.getInstance().store();
        }
        MainFrame.updateFilterPanelLabel();
    }

    static {
        mCopyToSystem = false;
        propTVBrowserVersion = new VersionProperty(mProp, "version", null);
        propTVBrowserVersionIsStable = new BooleanProperty(mProp, "versionIsStable", false);
        propUseDefaultFonts = new BooleanProperty(mProp, "usedefaultfonts", true);
        propEnableAntialiasing = new BooleanProperty(mProp, "enableantialiasing", true);
        propTVDataDirectory = new StringProperty(mProp, "dir.tvdata", mDefaultSettings.getProperty("tvdatadir", Settings.getDefaultTvDataDir()));
        propPluginsDirectory = new StringProperty(mProp, "dir.plugins", mDefaultSettings.getProperty("pluginsdir", Settings.getDefaultPluginsDir()));
        propSelectedChannelCountry = new StringProperty(mProp, "selectedChannelCountry", "");
        propSelectedChannelPlugin = new StringProperty(mProp, "selectedChannelPlugin", "");
        propSubscribedChannels = new ChannelArrayProperty(mProp, "subscribedchannels", new Channel[0]);
        propSubscribedChannelsSeparators = new StringArrayProperty(mProp, "subscribedChannelsSeparators", new String[0]);
        propTableLayout = new ChoiceProperty(mProp, "table.layout", LAYOUT_OPTIMIZED_COMPACT_TIME_BLOCK, new String[]{LAYOUT_TIME_SYNCHRONOUS, LAYOUT_COMPACT, LAYOUT_REAL_SYNCHRONOUS, LAYOUT_REAL_COMPACT, LAYOUT_TIME_BLOCK, LAYOUT_COMPACT_TIME_BLOCK, LAYOUT_OPTIMIZED_COMPACT_TIME_BLOCK});
        propTableBackgroundStyle = new ChoiceProperty(mProp, "tablebackground.style", "uiTimeBlock", new String[]{"singleColor", "oneImage", LAYOUT_TIME_BLOCK, "timeOfDay", "uiColor", "uiTimeBlock"});
        propOneImageBackground = new StringProperty(mProp, "tablebackground.oneImage.image", "imgs/columns_evening.jpg");
        propTimeBlockSize = new IntProperty(mProp, "tablebackground.timeBlock.size", 2);
        propTimeBlockBackground1 = new StringProperty(mProp, "tablebackground.timeBlock.image1", "imgs/time_block_white.png");
        propTimeBlockBackground2 = new StringProperty(mProp, "tablebackground.timeBlock.image2", "imgs/time_block_gray.png");
        propTimeBlockWestImage1 = new StringProperty(mProp, "tablebackground.timeBlock.west1", "imgs/time_block_white.png");
        propTimeBlockWestImage2 = new StringProperty(mProp, "tablebackground.timeBlock.west2", "imgs/time_block_gray.png");
        propTimeBlockShowWest = new BooleanProperty(mProp, "tablebackground.timeBlock.showWest", true);
        propTimeOfDayBackgroundEdge = new StringProperty(mProp, "tablebackground.timeofday.edge", "imgs/columns_edge.jpg");
        propTimeOfDayBackgroundEarly = new StringProperty(mProp, "tablebackground.timeofday.early", "imgs/columns_early.jpg");
        propTimeOfDayBackgroundMidday = new StringProperty(mProp, "tablebackground.timeofday.midday", "imgs/columns_midday.jpg");
        propTimeOfDayBackgroundAfternoon = new StringProperty(mProp, "tablebackground.timeofday.afternoon", "imgs/columns_afternoon.jpg");
        propTimeOfDayBackgroundEvening = new StringProperty(mProp, "tablebackground.timeofday.evening", "imgs/columns_evening.jpg");
        propShowAssistant = new BooleanProperty(mProp, "showassistant", true);
        propUserDefinedWebbrowser = new StringProperty(mProp, "webbrowser", null);
        propUserDefinedWebbrowserParams = new StringProperty(mProp, "webbrowserParams", "{0}");
        propProgramTableBackgroundSingleColor = new ColorProperty(mProp, "backgroundSingleColor", Color.white);
        propTrayIsEnabled = new BooleanProperty(mProp, "trayIsEnabled", true);
        propTrayIsAntialiasing = new BooleanProperty(mProp, "trayIsAntialiasing", true);
        propTrayMinimizeTo = new BooleanProperty(mProp, "MinimizeToTray", false);
        propOnlyMinimizeWhenWindowClosing = new BooleanProperty(mProp, "onlyMinimizeWhenWindowClosing", false);
        propNowOnRestore = new BooleanProperty(mProp, "jumpNowOnRestore", true);
        propTrayFilterNotMarked = new BooleanProperty(mProp, "trayFilterNotMarked", false);
        propTrayFilterNot = new BooleanProperty(mProp, "trayFilterAll", false);
        propTrayUseSpecialChannels = new BooleanProperty(mProp, "trayUseSpecialChannels", false);
        propTraySpecialChannels = new ChannelArrayProperty(mProp, "traySpecialChannels", new Channel[0]);
        propTrayChannelWidth = new IntProperty(mProp, "trayChannelWidth", 78);
        propTrayOnTimeProgramsEnabled = new BooleanProperty(mProp, "trayOnTimeProgramsEnabled", true);
        propTrayOnTimeProgramsInSubMenu = new BooleanProperty(mProp, "trayOnTimeProgramsInSubMenus", true);
        propTrayOnTimeProgramsContainsTime = new BooleanProperty(mProp, "trayOnTimeProgramsContainsTime", false);
        propTrayOnTimeProgramsContainsIcon = new BooleanProperty(mProp, "trayOnTimeProgramsContainsIcon", true);
        propTrayOnTimeProgramsContainsName = new BooleanProperty(mProp, "trayOnTimeProgramsContainsName", true);
        propTrayOnTimeProgramsShowingSortNumber = new BooleanProperty(mProp, "trayOnTimeProgramsShowingSortNumber", true);
        propTrayOnTimeProgramsContainsToolTip = new BooleanProperty(mProp, "trayOnTimeProgramsContainsToolTip", true);
        propTrayOnTimeProgramsShowProgress = new BooleanProperty(mProp, "trayOnTimeProgramsShowProgress", true);
        propTrayOnTimeProgramsDarkBackground = new ColorProperty(mProp, "trayOnTimeProgramsDarkBackground", new Color(255, 150, 0, 80));
        propTrayOnTimeProgramsLightBackground = new ColorProperty(mProp, "trayOnTimeProgramsLightBackground", new Color(255, 150, 0, 40));
        propScrollToTimeMarkingActivated = new BooleanProperty(mProp, "scrollToTimeMarkingActivated", true);
        propScrollToTimeProgramsDarkBackground = new ColorProperty(mProp, "scrollToTimeProgramsDarkBackground", new Color(255, 150, 0, 80));
        propScrollToTimeProgramsLightBackground = new ColorProperty(mProp, "scrollToTimeProgramsLightBackground", new Color(255, 150, 0, 40));
        propTrayNowProgramsEnabled = new BooleanProperty(mProp, "trayNowProgramsEnabled", true);
        propTrayNowProgramsInSubMenu = new BooleanProperty(mProp, "trayNowProgramsInSubMenus", false);
        propTrayNowProgramsContainsTime = new BooleanProperty(mProp, "trayNowProgramsContainsTime", false);
        propTrayNowProgramsContainsIcon = new BooleanProperty(mProp, "trayNowProgramsContainsIcon", true);
        propTrayNowProgramsContainsName = new BooleanProperty(mProp, "trayNowProgramsContainsName", true);
        propTrayNowProgramsContainsToolTip = new BooleanProperty(mProp, "trayNowProgramsContainsToolTip", true);
        propTrayNowProgramsShowingSortNumber = new BooleanProperty(mProp, "trayNowProgramsShowingSortNumber", true);
        propTraySoonProgramsEnabled = new BooleanProperty(mProp, "traySoonProgramsEnabled", true);
        propTraySoonProgramsContainsTime = new BooleanProperty(mProp, "traySoonProgramsContainsTime", true);
        propTraySoonProgramsContainsIcon = new BooleanProperty(mProp, "traySoonProgramsContainsIcon", true);
        propTraySoonProgramsContainsName = new BooleanProperty(mProp, "traySoonProgramsContainsName", true);
        propTraySoonProgramsContainsToolTip = new BooleanProperty(mProp, "traySoonProgramsContainsToolTip", true);
        propTraySoonProgramsShowingSortNumber = new BooleanProperty(mProp, "traySoonProgramsShowingSortNumber", true);
        propTrayImportantProgramsPriority = new IntProperty(mProp, "trayImportantProgramsPriority", 0);
        propTrayImportantProgramsEnabled = new BooleanProperty(mProp, "trayImportantProgramsEnabled", true);
        propTrayImportantProgramsInSubMenu = new BooleanProperty(mProp, "trayImportantProgramsInSubMenu", false);
        propTrayImportantProgramsSize = new IntProperty(mProp, "trayImportantProgramsSize", 5);
        propTrayImportantProgramsContainsIcon = new BooleanProperty(mProp, "trayImportantProgramsContainsIcon", true);
        propTrayImportantProgramsContainsName = new BooleanProperty(mProp, "trayImportantProgramsContainsName", true);
        propTrayImportantProgramsContainsDate = new BooleanProperty(mProp, "trayImportantProgramsContainsDate", true);
        propTrayImportantProgramsContainsTime = new BooleanProperty(mProp, "trayImportantProgramsContainsTime", true);
        propTrayImportantProgramsContainsToolTip = new BooleanProperty(mProp, "trayImportantProgramsContainsToolTip", true);
        propTrayImportantProgramsShowingSortNumber = new BooleanProperty(mProp, "trayImportantProgramsShowingSortNumber", true);
        propToolbarButtonStyle = new ChoiceProperty(mProp, "buttontype", "icon", new String[]{"text&icon", "text", "icon"});
        propIsToolbarVisible = new BooleanProperty(mProp, "isToolbarVisible", true);
        propIsMenubarVisible = new BooleanProperty(mProp, "isMenubarVisible", true);
        propIsToolbarAdditonalTopSpace = new BooleanProperty(mProp, "isToolbarAdditonalTopSpace", false);
        propIsToolbarAdditonalBottomSpace = new BooleanProperty(mProp, "isToolbarAddtionalBottomSpace", false);
        propIsStatusbarVisible = new BooleanProperty(mProp, "isStatusbarVisible", true);
        propSkinLFThemepack = new StringProperty(mProp, "skinLF.themepack", "themepacks/themepack.zip");
        propJGoodiesTheme = new JGoodiesThemeProperty(mProp, "jgoodies.theme");
        propJGoodiesShadow = new BooleanProperty(mProp, "jgoodies.dropshadow", false);
        propLookAndFeel = new StringProperty(mProp, "lookandfeel1_1", mDefaultSettings.getProperty("lookandfeel", UiUtilities.getDefaultLookAndFeelClassName(false)));
        propColumnWidth = new VariableIntProperty(mProp, "columnwidth", 200);
        propTimeButtons = new IntArrayProperty(mProp, "timeButtons", new int[]{360, 720, 1080, 1215});
        propToolbarButtons = new StringArrayProperty(mProp, "toolbarButtons_2.0", null);
        propToolbarUseBigIcons = new BooleanProperty(mProp, "toolbarUseBigIcons", true);
        propToolbarLocation = new StringProperty(mProp, "toolbarLocation", "north");
        propLeftSingleClickIfArray = new ContextMenuMouseActionArrayProperty(mProp, "leftSingleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, ProgramInfo.getProgramInfoPluginId())});
        propLeftDoubleClickIfArray = new ContextMenuMouseActionArrayProperty(mProp, "leftDoubleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, ProgramInfo.getProgramInfoPluginId())});
        propMiddleSingleClickIfArray = new ContextMenuMouseActionArrayProperty(mProp, "middleSingleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, ReminderPlugin.getReminderPluginId())});
        propMiddleDoubleClickIfArray = new ContextMenuMouseActionArrayProperty(mProp, "middleDoubleClickIfArray", new ContextMenuMouseActionSetting[]{new ContextMenuMouseActionSetting(0, FavoritesPlugin.getFavoritesPluginId())});
        propLastUsedFilter = new StringProperty(mProp, "lastusedfilter", null);
        propLastUsedChannelGroup = new StringProperty(mProp, "lastchannelgroup", null);
        propPluginOrder = new StringArrayProperty(mProp, "plugins", null);
        propContextMenuOrder = new StringArrayProperty(mProp, "contextMenuOrder", new String[]{"programinfo.ProgramInfo", "searchplugin.SearchPlugin", "reminderplugin.ReminderPlugin", "favoritesplugin.FavoritesPlugin", "######SEPARATOR######", "java.webplugin.WebPlugin", "java.simplemarkerplugin.SimpleMarkerPlugin", "java.captureplugin.CapturePlugin"});
        propContextMenuDisabledItems = new StringArrayProperty(mProp, "contextMenuDisabledItems", null);
        ArrayList<String> plugins = new ArrayList<String>();
        plugins.add("java.showviewplugin.ShowviewPlugin");
        plugins.add("java.i18nplugin.I18NPlugin");
        if (!OperatingSystem.isMacOs()) {
            plugins.add("java.growlplugin.GrowlPlugin");
        }
        plugins.add("java.blogthisplugin.BlogThisPlugin");
        DEFAULT_DISABLED_PLUGINS = plugins.toArray(new String[plugins.size()]);
        propDeactivatedPlugins = new StringArrayProperty(mProp, "deactivatedPlugins", DEFAULT_DISABLED_PLUGINS);
        propDownloadPeriod = new IntProperty(mProp, "downloadperiod", 1);
        propAutoDownloadType = new ChoiceProperty(mProp, "autodownload", "daily", new String[]{"startup", "daily", "every3days", "weekly", "never"});
        propAutoDownloadPeriod = new IntProperty(mProp, "autodownloadperiod", 0);
        propAskForAutoDownload = new BooleanProperty(mProp, "askForAutoDownload", false);
        propSaveDefaultDataUpdateValuesDefault = new BooleanProperty(mProp, "saveDefaultDataUpdateValuesDefault", true);
        propLastDownloadDate = new DateProperty(mProp, "lastdownload", Date.getCurrentDate().addDays(-100));
        propProgramTitleFont = new DeferredFontProperty(mProp, "font.programtitle", DEFAULT_PROGRAMTITLEFONT);
        propProgramInfoFont = new DeferredFontProperty(mProp, "font.programinfo", DEFAULT_PROGRAMINFOFONT);
        propChannelNameFont = new DeferredFontProperty(mProp, "font.channelname", DEFAULT_CHANNELNAMEFONT);
        propProgramTimeFont = new DeferredFontProperty(mProp, "font.programtime", DEFAULT_PROGRAMTIMEFONT);
        propProgramInfoFields = new ProgramFieldTypeArrayProperty(mProp, "programpanel.infoFields", new ProgramFieldType[]{ProgramFieldType.GENRE_TYPE, ProgramFieldType.EPISODE_TYPE, ProgramFieldType.ORIGIN_TYPE, ProgramFieldType.PRODUCTION_YEAR_TYPE, ProgramFieldType.SHORT_DESCRIPTION_TYPE});
        propProgramInfoFieldsSeparators = new StringArrayProperty(mProp, "programpanel.infoFieldsSeparators", new String[]{" - ", " - ", " - ", " - "});
        propProgramTableIconPlugins = new StringArrayProperty(mProp, "programpanel.iconPlugins", new String[]{PICTURE_ID, INFO_ID, "tvraterplugin.TVRaterPlugin"});
        propProgramTableOnAirProgramsShowingBorder = new BooleanProperty(mProp, "programpanel.onAirProgramsShowingBorder", false);
        propProgramTableColorOnAirDark = new ColorProperty(mProp, "programpanel.ColorOnAirDark", new Color(0, 0, 255, 60));
        propProgramTableColorOnAirLight = new ColorProperty(mProp, "programpanel.ColorOnAirLight", new Color(0, 0, 255, 30));
        propProgramPanelUsesExtraSpaceForMarkIcons = new BooleanProperty(mProp, "programpanel.usesExtraSpaceForMarkIcons", true);
        propProgramPanelWithMarkingsShowingBoder = new BooleanProperty(mProp, "programpanel.markingsShowingBorder", false);
        propProgramPanelUsedDefaultMarkPriority = new IntProperty(mProp, "programpanel.defaultMarkPriority", 0);
        propProgramPanelMarkedMinPriorityColor = new ColorProperty(mProp, "programpanel.ColorMarked", new Color(140, 255, 0, 60));
        propProgramPanelMarkedLowerMediumPriorityColor = new ColorProperty(mProp, "programpanel.ColorMarkedLowerMedium", new Color(0, 255, 255, 50));
        propProgramPanelMarkedMediumPriorityColor = new ColorProperty(mProp, "programpanel.ColorMarkedMedium", new Color(255, 255, 0, 60));
        propProgramPanelMarkedHigherMediumPriorityColor = new ColorProperty(mProp, "programpanel.ColorMarkedHigherMedium", new Color(255, 180, 0, 110));
        propProgramPanelMarkedMaxPriorityColor = new ColorProperty(mProp, "programpanel.ColorMarkedMax", new Color(255, 0, 0, 30));
        propProgramPanelForegroundColor = new ColorProperty(mProp, "programpanel.ColorForeground", Color.black);
        propProgramPanelAllowTransparency = new BooleanProperty(mProp, "programpanel.AllowTransparency", true);
        propProgramPanelHyphenation = new BooleanProperty(mProp, "programpanel.Hyphenation", false);
        propProgramPanelMaxLines = new IntProperty(mProp, "programpanel.MaxLines", 3);
        propProgramPanelShortDurationActive = new BooleanProperty(mProp, "programpanel.ShortActive", true);
        propProgramPanelShortDurationMinutes = new IntProperty(mProp, "programpanel.ShortMinutes", 10);
        propProgramTableMouseOver = new BooleanProperty(mProp, "programpanel.MouseOver", true);
        propProgramTableMouseOverColor = new ColorProperty(mProp, "programpanel.MouseOverColor", new Color(200, 200, 0, 60));
        propKeyboardSelectedColor = new ColorProperty(mProp, "programpanel.KeyboardSelectedColor", new Color(130, 255, 0, 120));
        propIsWindowMaximized = new BooleanProperty(mProp, "window.isMaximized", false);
        propIsUsingFullscreen = new BooleanProperty(mProp, "isUsingFullscreen", false);
        propWindowWidth = new IntProperty(mProp, "window.width", 770);
        propWindowHeight = new IntProperty(mProp, "window.height", 550);
        propWindowX = new IntProperty(mProp, "window.x", -1);
        propWindowY = new IntProperty(mProp, "window.y", -1);
        propSettingsDialogDividerLocation = new IntProperty(mProp, "settingsDialogDividerLocation", 200);
        propProgramTableStartOfDay = new IntProperty(mProp, "programtable.startofday", 0);
        propProgramTableEndOfDay = new IntProperty(mProp, "programtable.endofday", 300);
        propHttpProxyUseProxy = new BooleanProperty(mProp, "proxy.http.useProxy", false);
        propDefaultNetworkConnectionTimeout = new IntProperty(mProp, "network.defaultConnectionTimeout", 60000);
        propNetworkCheckTimeout = new IntProperty(mProp, "network.checkTimeout", 10000);
        propPictureType = new IntProperty(mProp, "pictures.type", 4);
        propPictureDescriptionLines = new IntProperty(mProp, "pictures.lines", 6);
        propPicturePluginIds = new StringArrayProperty(mProp, "pictures.pluginIds", new String[0]);
        propPictureStartTime = new IntProperty(mProp, "pictures.startTime", 1080);
        propPictureEndTime = new IntProperty(mProp, "pictures.endTime", 1380);
        propPictureDuration = new IntProperty(mProp, "pictures.duration", 90);
        propIsPictureShowingDescription = new BooleanProperty(mProp, "pictures.showDescription", true);
        propHttpProxyHost = new StringProperty(mProp, "proxy.http.host", "");
        propHttpProxyPort = new StringProperty(mProp, "proxy.http.port", "");
        propHttpProxyAuthentifyAtProxy = new BooleanProperty(mProp, "proxy.http.authentifyAtProxy", false);
        propHttpProxyUser = new StringProperty(mProp, "proxy.http.user", "");
        propHttpProxyPassword = new EncodedStringProperty(mProp, "proxy.http.password", "", 6528587292713416704L);
        propDataServicesForUpdate = new StringArrayProperty(mProp, "tvdataservices.update", null);
        propShowPluginView = new BooleanProperty(mProp, "show.pluginview", false);
        propShowTimeButtons = new BooleanProperty(mProp, "show.timebuttons", true);
        propShowChannels = new BooleanProperty(mProp, "show.channels", true);
        propShowDatelist = new BooleanProperty(mProp, "show.datelist", true);
        propShowFilterBar = new BooleanProperty(mProp, "show.filterbar", true);
        propViewRoot = new SplitViewProperty(mProp, "view.root", false, true, 200);
        propViewMainframe = new SplitViewProperty(mProp, "view.mainframe", false, false, 150);
        propViewNavigation = new SplitViewProperty(mProp, "view.navigation", true, true, 150);
        propViewDateChannel = new SplitViewProperty(mProp, "view.date_channel", true, true, 150);
        propStartScreenShow = new BooleanProperty(mProp, "splash.show", true);
        propLanguage = new StringProperty(mProp, "language", System.getProperty("user.language"));
        propCountry = new StringProperty(mProp, "country", System.getProperty("user.country", ""));
        propVariant = new StringProperty(mProp, "variant", System.getProperty("user.variant", ""));
        propTimezone = new StringProperty(mProp, "timeZone", null);
        propMinimizeAfterStartup = new BooleanProperty(mProp, "minimizeAfterStartup", false);
        propLogdirectory = new StringProperty(mProp, "logdirectory", mDefaultSettings.getProperty("logdirectory", null));
        propShowChannelIconsInProgramTable = new BooleanProperty(mProp, "showChannelIconsInProgramtable", true);
        propShowChannelNamesInProgramTable = new BooleanProperty(mProp, "showChannelNamesInProgramtable", true);
        propShowChannelIconsInChannellist = new BooleanProperty(mProp, "showChannelIconsInChannellist", true);
        propShowChannelNamesInChannellist = new BooleanProperty(mProp, "showChannelNamesInChannellist", true);
        propUsedChannelGroups = new StringArrayProperty(mProp, "usedChannelGroups", null);
        propDeleteFilesAtStart = new StringArrayProperty(mProp, "deleteFilesAtStart", new String[0]);
        propIcontheme = new StringProperty(mProp, "icontheme", mDefaultSettings.getProperty("icontheme", null));
        propShowBrowserOpenDialog = new BooleanProperty(mProp, "showBrowserOpenDialog", true);
        propIsSearchFieldVisible = new BooleanProperty(mProp, "isSearchFieldVisible", true);
        propTwelveHourFormat = new BooleanProperty(mProp, "uswTwelveHourFormat", false);
        propFirstDayOfWeek = new IntProperty(mProp, "firstDayOfWeek", Calendar.getInstance().getFirstDayOfWeek());
        propAcceptedLicenseArrForServiceIds = new StringArrayProperty(mProp, "licnseIds", new String[0]);
        propLastUsedSettingsPath = new StringProperty(mProp, "lastUsedSettingsTabClassName", "#channels");
        propPluginsPictureSetting = new IntProperty(mProp, "pluginsPictureSetting", 1);
        propDefaultFilter = new StringProperty(mProp, "defaultFilter", "");
        propAutoUpdatePlugins = new BooleanProperty(mProp, "autoUpdatePlugins", true);
        propLastPluginsUpdate = new DateProperty(mProp, "lastPluginsUpdate", null);
        propNTPTimeCheck = new BooleanProperty(mProp, "ntpTimeCheckEnabled", true);
        propLastNTPCheck = new DateProperty(mProp, "lastNTPCheck", null);
        propInternetConnectionCheck = new BooleanProperty(mProp, "internetConnectionCheck", true);
        propPluginViewIsLeft = new BooleanProperty(mProp, "pluginViewIsLeft", true);
        propViewDateLayout = new IntProperty(mProp, "propViewDateLayout", 1);
        propDataServiceAutoUpdateTime = new IntProperty(mProp, "dataServiceAutoUpdateTime", 30);
        propHiddenMessageBoxes = new StringArrayProperty(mProp, "hideMessageBox", new String[0]);
        propShowSortNumberInProgramTable = new BooleanProperty(mProp, "showSortNumberInProgramTable", true);
        propShowSortNumberInProgramLists = new BooleanProperty(mProp, "showSortNumberInProgramLists", true);
        propShowChannelTooltipInProgramTable = new BooleanProperty(mProp, "showChannelTooltipInProgramtable", true);
        propFirstStartDate = new DateProperty(mProp, "firstStartDate", null);
        propPluginInfoDialogWasShown = new BooleanProperty(mProp, "pluginInfoDialogWasShown", false);
        propSelectedChannelCategoryIndex = new ByteProperty(mProp, "selectedChannelCategoryIndex", 1);
        propAutoDataDownloadEnabled = new BooleanProperty(mProp, "autoDataDownloadEnabled", true);
        propAutoDownloadWaitingTime = new ShortProperty(mProp, "autoDownloadWaitingTime", 5);
        propAutoDownloadWaitingEnabled = new BooleanProperty(mProp, "autoDownloadWaitingEnabled", true);
        propAutoChannelUpdatePeriod = new IntProperty(mProp, "autoChannelUpdatePeriod", 14);
        propLastChannelUpdate = new DateProperty(mProp, "lastChannelUpdate", null);
        propProgramTableCutTitle = new BooleanProperty(mProp, "programTableCutTitle", true);
        propProgramTableCutTitleLines = new IntProperty(mProp, "programTableCutTitleLines", 2);
        propProgramTableMouseAutoScroll = new BooleanProperty(mProp, "programTableMouseAutoScroll", true);
        propCurrentlyUsedDataServiceIds = new StringArrayProperty(mProp, "currentDataServices", new String[0]);
        propBlockedPluginArray = new BlockedPluginArrayProperty(mProp, "blockedPlugins");
        propLastUsedReceivePlugin = new StringProperty(mProp, "lastusedreceiveplugin", null);
        propLastUsedReceiveTarget = new StringProperty(mProp, "lastusedreceivetarget", null);
        propChannelsWereConfigured = new BooleanProperty(mProp, "channelsWereConfigured", false);
        propPluginBetaWarning = new BooleanProperty(mProp, "pluginBetaWarning", true);
        propSelectedPersona = new StringProperty(mProp, "persona", "51b73c81-7d61-4626-b230-89627c9f5ce7");
        propRandomPersona = new BooleanProperty(mProp, "randomPersona", false);
        propShowProgramTablePictureBorder = new BooleanProperty(mProp, "showPictureBorder", true);
        propTypeAsYouFindEnabled = new BooleanProperty(mProp, "typeAsYouFindEnabled", true);
        propAlwaysShowTabBarForCenterPanel = new BooleanProperty(mProp, "alwaysShowTabBarForCenterPanel", true);
        propCenterPanelArr = new StringArrayProperty(mProp, "centerPanelArr", new String[]{"tvbrowser.ui.programtable.ProgramTableScrollPaneWrapper"});
        propDisabledCenterPanelArr = new StringArrayProperty(mProp, "disabledCenterPanelArr", new String[0]);
        propProgramTableAutoChangeDate = new BooleanProperty(mProp, "autoScrollToNextDay", true);
        propInfoIconThemeID = new StringProperty(mProp, "infoIconThemeName", "tvb_default.zip");
        propVerboseLogging = new BooleanProperty(mProp, "verboseLogging", false);
        propKnownContextMenuPlugins = new StringArrayProperty(mProp, "knownContextMenuPlugins", new String[0]);
        propAccessControl = new StringArrayProperty(mProp, "accessControl", new String[0]);
        propShowChannelLogoForProgramPanel = new IntProperty(mProp, "showChannelLogoForProgramPanel", 0);
        propLastChannelExportFile = new StringProperty(mProp, "lastChannelExportFile", System.getProperty("user.home") + "/TVB-channel-export.txt");
        propDataPluginPostProcessingOrder = new StringArrayProperty(mProp, "dataPluginPostProcessingOrder", new String[0]);
    }

    private static final class VariableFontSizeFont
    extends Font {
        private int mOffset;

        public VariableFontSizeFont(String name, int style, int offset) {
            super(name, style, UIManager.getFont("MenuItem.font").getSize() + offset);
            this.mOffset = offset;
        }

        @Override
        public int getSize() {
            return UIManager.getFont("MenuItem.font").getSize() + this.mOffset;
        }
    }
}

