/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import java.util.HashMap;

public class ChannelUserSettings {
    private String mChannelName;
    private String mIconFileName;
    private String mSortNumber;
    private boolean mUseUserIconFile;
    private String mWebPage;
    private int mStartTimeLimit;
    private int mEndTimeLimit;
    private int mTimeZoneOffsetMinutes = 0;
    private static HashMap<String, ChannelUserSettings> mChannelUserSettings = new HashMap();

    public static ChannelUserSettings getSettings(Channel ch) {
        if (ch == null || ch.getDataServiceId() == null || ch.getGroup() == null) {
            ChannelUserSettings settings = mChannelUserSettings.get(null);
            if (settings == null) {
                settings = new ChannelUserSettings();
                mChannelUserSettings.put(null, settings);
            }
            return settings;
        }
        String channelId = ch.getUniqueId();
        ChannelUserSettings settings = mChannelUserSettings.get(channelId);
        if (settings == null) {
            settings = new ChannelUserSettings();
            mChannelUserSettings.put(channelId, settings);
        }
        return settings;
    }

    public void setTimeZoneCorrectionMinutes(int offset) {
        this.mTimeZoneOffsetMinutes = offset;
    }

    public void setChannelName(String channelName) {
        this.mChannelName = channelName;
    }

    public void setIconFileName(String iconFileName) {
        this.mIconFileName = iconFileName;
    }

    public void useUserIconFile(boolean b) {
        this.mUseUserIconFile = b;
    }

    public int getTimeZoneCorrectionMinutes() {
        return this.mTimeZoneOffsetMinutes;
    }

    public String getChannelName() {
        return this.mChannelName;
    }

    public String getIconFileName() {
        return this.mIconFileName;
    }

    public boolean useUserIconFile() {
        return this.mUseUserIconFile;
    }

    public String getWebPage() {
        return this.mWebPage;
    }

    public void setWebPage(String webpage) {
        this.mWebPage = webpage;
    }

    public int getStartTimeLimit() {
        return this.mStartTimeLimit;
    }

    public void setStartTimeLimit(int startTimeLimit) {
        this.mStartTimeLimit = startTimeLimit;
    }

    public int getEndTimeLimit() {
        return this.mEndTimeLimit;
    }

    public void setEndTimeLimit(int endTimeLimit) {
        this.mEndTimeLimit = endTimeLimit;
    }

    public boolean isTimeLimited() {
        return this.mStartTimeLimit != this.mEndTimeLimit;
    }

    public String getSortNumber() {
        return this.mSortNumber == null ? "" : this.mSortNumber;
    }

    public void setSortNumber(String number) {
        this.mSortNumber = number;
    }
}

