/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import util.misc.HashCodeUtilities;

public final class Version
implements Comparable<Version> {
    private int mMajor;
    private int mMinor;
    private int mSubMinor;
    private boolean mIsStable;
    private String mName;

    public Version(int major, int minor) {
        this(major, minor, 0, true, null);
    }

    public Version(int major, int minor, boolean isStable) {
        this(major, minor, 0, isStable, null);
    }

    public Version(int major, int minor, boolean isStable, String name) {
        this(major, minor, 0, isStable, name);
    }

    public Version(int major, int minor, int subMinor) {
        this(major, minor, subMinor, true, null);
    }

    public Version(int major, int minor, int subMinor, boolean isStable) {
        this(major, minor, subMinor, isStable, null);
    }

    public Version(int major, int minor, int subMinor, boolean isStable, String name) {
        this.mMajor = major;
        this.mMinor = minor;
        this.mSubMinor = subMinor;
        this.mIsStable = isStable;
        this.mName = name;
    }

    public String toString() {
        if (this.mName == null) {
            return this.mMajor + "." + this.mMinor / 10 + "." + this.mMinor % 10 + "." + this.mSubMinor + (this.mIsStable ? "" : " beta");
        }
        return this.mName;
    }

    public boolean isStable() {
        return this.mIsStable;
    }

    public int getMajor() {
        return this.mMajor;
    }

    public int getMinor() {
        return this.mMinor;
    }

    public int getSubMinor() {
        return this.mSubMinor;
    }

    @Override
    public int compareTo(Version v) throws ClassCastException {
        if (this.mMajor > v.mMajor) {
            return 1;
        }
        if (this.mMajor < v.mMajor) {
            return -1;
        }
        if (this.mMinor > v.mMinor) {
            return 1;
        }
        if (this.mMinor < v.mMinor) {
            return -1;
        }
        if (this.mSubMinor > v.mSubMinor) {
            return 1;
        }
        if (this.mSubMinor < v.mSubMinor) {
            return -1;
        }
        if (this.mIsStable && !v.mIsStable) {
            return 1;
        }
        if (!this.mIsStable && v.mIsStable) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version ver = (Version)obj;
            return this.mMajor == ver.mMajor && this.mMinor == ver.mMinor && this.mSubMinor == ver.mSubMinor && this.mIsStable == ver.mIsStable;
        }
        return false;
    }

    public int hashCode() {
        int result = HashCodeUtilities.hash(this.mMajor);
        result = HashCodeUtilities.hash(result, this.mMinor);
        result = HashCodeUtilities.hash(result, this.mSubMinor);
        result = HashCodeUtilities.hash(result, this.mIsStable);
        return result;
    }

    public void writeData(DataOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.mMajor);
        out.writeInt(this.mMinor);
        out.writeInt(this.mSubMinor);
        out.writeBoolean(this.mIsStable);
        out.writeBoolean(this.mName != null);
        if (this.mName != null) {
            out.writeUTF(this.mName);
        }
    }

    public Version(DataInputStream in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.mMajor = in.readInt();
        this.mMinor = in.readInt();
        this.mSubMinor = in.readInt();
        this.mIsStable = in.readBoolean();
        if (in.readBoolean()) {
            this.mName = in.readUTF();
        }
    }
}

