/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import java.util.ArrayList;
import java.util.Iterator;
import util.ui.Localizer;

public class ProgramFieldType {
    private static Localizer mLocalizer = Localizer.getLocalizerFor(ProgramFieldType.class);
    private static final ArrayList<ProgramFieldType> mKnownTypeList = new ArrayList();
    private static ProgramFieldType[] mKnownTypeArray;
    public static final int UNKNOWN_FORMAT = 1;
    @Deprecated
    public static final int UNKOWN_FORMAT = 1;
    public static final int BINARY_FORMAT = 2;
    public static final int TEXT_FORMAT = 3;
    public static final int INT_FORMAT = 4;
    public static final int TIME_FORMAT = 5;
    private static final int OBJECT_FIELDS_COUNT = 28;
    private static final int INT_FIELDS_COUNT = 14;
    private static final boolean[] usedIntField;
    private static final boolean[] usedObjectField;
    public static final ProgramFieldType START_TIME_TYPE;
    public static final ProgramFieldType END_TIME_TYPE;
    public static final ProgramFieldType TITLE_TYPE;
    public static final ProgramFieldType ORIGINAL_TITLE_TYPE;
    public static final ProgramFieldType EPISODE_TYPE;
    public static final ProgramFieldType ORIGINAL_EPISODE_TYPE;
    public static final ProgramFieldType SHORT_DESCRIPTION_TYPE;
    public static final ProgramFieldType DESCRIPTION_TYPE;
    public static final ProgramFieldType ACTOR_LIST_TYPE;
    public static final ProgramFieldType DIRECTOR_TYPE;
    public static final ProgramFieldType CUSTOM_TYPE;
    public static final ProgramFieldType INFO_TYPE;
    public static final ProgramFieldType AGE_LIMIT_TYPE;
    public static final ProgramFieldType URL_TYPE;
    public static final ProgramFieldType GENRE_TYPE;
    public static final ProgramFieldType ORIGIN_TYPE;
    public static final ProgramFieldType NET_PLAYING_TIME_TYPE;
    public static final ProgramFieldType VPS_TYPE;
    public static final ProgramFieldType SCRIPT_TYPE;
    public static final ProgramFieldType REPETITION_OF_TYPE;
    public static final ProgramFieldType MUSIC_TYPE;
    public static final ProgramFieldType MODERATION_TYPE;
    public static final ProgramFieldType PRODUCTION_YEAR_TYPE;
    public static final ProgramFieldType REPETITION_ON_TYPE;
    public static final ProgramFieldType PICTURE_TYPE;
    public static final ProgramFieldType PICTURE_COPYRIGHT_TYPE;
    public static final ProgramFieldType PICTURE_DESCRIPTION_TYPE;
    public static final ProgramFieldType EPISODE_NUMBER_TYPE;
    public static final ProgramFieldType EPISODE_TOTAL_NUMBER_TYPE;
    public static final ProgramFieldType SEASON_NUMBER_TYPE;
    public static final ProgramFieldType PRODUCER_TYPE;
    public static final ProgramFieldType CAMERA_TYPE;
    public static final ProgramFieldType CUTTER_TYPE;
    public static final ProgramFieldType ADDITIONAL_PERSONS_TYPE;
    public static final ProgramFieldType RATING_TYPE;
    public static final ProgramFieldType PRODUCTION_COMPANY_TYPE;
    public static final ProgramFieldType AGE_RATING_TYPE;
    public static final ProgramFieldType LAST_PRODUCTION_YEAR_TYPE;
    public static final ProgramFieldType ADDITIONAL_INFORMATION_TYPE;
    public static final ProgramFieldType SERIES_TYPE;
    public static final ProgramFieldType PART_NUMBER_TYPE;
    public static final ProgramFieldType PART_NUMBER_TOTAL_TYPE;
    private int mTypeId;
    private String mName;
    private String mLocalizedName;
    private String mLocalizerKey;
    private String mLocalizerDefaultMsg;
    private int mFormat;
    private int mStorageIndex;
    private static boolean mNameWasSet;

    private ProgramFieldType(int typeId, int format, boolean isKnownType, String name, String localizerKey, String localizerDefaultMsg, int storageIndex) {
        this.mTypeId = typeId;
        this.mFormat = format;
        this.mName = name;
        this.mLocalizedName = null;
        this.mLocalizerKey = localizerKey;
        this.mLocalizerDefaultMsg = localizerDefaultMsg;
        this.mStorageIndex = storageIndex;
        if (isKnownType) {
            int i;
            mKnownTypeList.add(this);
            int maxTypeId = 0;
            for (i = 0; i < mKnownTypeList.size(); ++i) {
                maxTypeId = Math.max(maxTypeId, mKnownTypeList.get(i).getTypeId());
            }
            mKnownTypeArray = new ProgramFieldType[maxTypeId + 1];
            for (i = 0; i < mKnownTypeList.size(); ++i) {
                ProgramFieldType type;
                ProgramFieldType.mKnownTypeArray[type.getTypeId()] = type = mKnownTypeList.get(i);
            }
            if ((format == 3 || format == 2) && storageIndex >= 28 || (format == 4 || format == 5) && storageIndex >= 14) {
                System.err.println("ProgramFieldType " + name + " cannot use storage index " + storageIndex + ".");
                System.err.println("Increase either OBJECT_FIELDS_COUNT or INT_FIELDS_COUNT (depending on the format).");
                System.exit(1);
            }
            if ((format == 3 || format == 2) && usedObjectField[storageIndex] || (format == 4 || format == 5) && usedIntField[storageIndex]) {
                System.err.println("ProgramFieldType " + name + " cannot use storage index " + storageIndex + ".");
                System.err.println("Another program field already uses that index. Use another number.");
                System.exit(1);
            }
            if (format == 3 || format == 2) {
                ProgramFieldType.usedObjectField[storageIndex] = true;
            }
            if (format == 4 || format == 5) {
                ProgramFieldType.usedIntField[storageIndex] = true;
            }
        }
    }

    public static ProgramFieldType getTypeForId(int typeId) {
        if (typeId < mKnownTypeArray.length) {
            return mKnownTypeArray[typeId];
        }
        return new ProgramFieldType(typeId, 1, false, "unknown (" + typeId + ")", "unknown", "Unknown", -1);
    }

    public static String getFormatName(int format) {
        switch (format) {
            case 2: {
                return "binary format";
            }
            case 3: {
                return "text format";
            }
            case 4: {
                return "int format";
            }
            case 5: {
                return "time format";
            }
        }
        return "unknown format";
    }

    public static Iterator<ProgramFieldType> getTypeIterator() {
        return mKnownTypeList.iterator();
    }

    public int getTypeId() {
        return this.mTypeId;
    }

    public String getName() {
        return this.mName;
    }

    public String getLocalizedName() {
        if (this.mLocalizedName == null) {
            this.mLocalizedName = mLocalizer.msg(this.mLocalizerKey, this.mLocalizerDefaultMsg);
        }
        return this.mLocalizedName;
    }

    public int getFormat() {
        return this.mFormat;
    }

    public boolean isRightFormat(int format) {
        return this.mFormat == format || format == 1 || this.mFormat == 1;
    }

    public String toString() {
        return this.getLocalizedName();
    }

    public int getStorageIndex() {
        return this.mStorageIndex;
    }

    public static int getIntFieldCount() {
        return 14;
    }

    public static int getObjectFieldCount() {
        return 28;
    }

    public static void resetLocalizer() {
        mLocalizer = Localizer.getLocalizerFor(ProgramFieldType.class);
    }

    public static boolean setLocalizedCustomFieldName(String name) {
        if (!mNameWasSet) {
            ProgramFieldType.CUSTOM_TYPE.mLocalizedName = name;
            mNameWasSet = true;
            return true;
        }
        return false;
    }

    static {
        usedIntField = new boolean[14];
        usedObjectField = new boolean[28];
        START_TIME_TYPE = new ProgramFieldType(1, 5, true, "start time", "startTime", "Start time", 0);
        END_TIME_TYPE = new ProgramFieldType(2, 5, true, "end time", "endTime", "End time", 1);
        TITLE_TYPE = new ProgramFieldType(3, 3, true, "title", "title", "Title", 0);
        ORIGINAL_TITLE_TYPE = new ProgramFieldType(4, 3, true, "original title", "originalTitle", "Original title", 1);
        EPISODE_TYPE = new ProgramFieldType(5, 3, true, "episode", "episode", "Episode", 2);
        ORIGINAL_EPISODE_TYPE = new ProgramFieldType(6, 3, true, "original episode", "originalEpisode", "Original episode", 3);
        SHORT_DESCRIPTION_TYPE = new ProgramFieldType(7, 3, true, "short description", "shortDescription", "Short description", 4);
        DESCRIPTION_TYPE = new ProgramFieldType(8, 3, true, "description", "description", "Description", 5);
        ACTOR_LIST_TYPE = new ProgramFieldType(10, 3, true, "actor list", "actors", "Actors", 6);
        DIRECTOR_TYPE = new ProgramFieldType(11, 3, true, "director", "director", "Director", 7);
        CUSTOM_TYPE = new ProgramFieldType(12, 3, true, "custom field", "custom", "Custom information", 8);
        INFO_TYPE = new ProgramFieldType(13, 4, true, "info bits", "formatInfo", "Format information", 2);
        AGE_LIMIT_TYPE = new ProgramFieldType(14, 4, true, "age limit", "ageLimit", "Age limit", 3);
        URL_TYPE = new ProgramFieldType(15, 3, true, "film URL", "filmUrl", "Website", 9);
        GENRE_TYPE = new ProgramFieldType(16, 3, true, "genre", "genre", "Genre", 10);
        ORIGIN_TYPE = new ProgramFieldType(17, 3, true, "origin", "origin", "Origin", 11);
        NET_PLAYING_TIME_TYPE = new ProgramFieldType(18, 4, true, "net playing time", "netPlayingTime", "Net playing time", 4);
        VPS_TYPE = new ProgramFieldType(19, 5, true, "vps", "vps", "VPS", 5);
        SCRIPT_TYPE = new ProgramFieldType(20, 3, true, "script", "script", "Script", 12);
        REPETITION_OF_TYPE = new ProgramFieldType(21, 3, true, "repetition of", "repetitionOf", "Repetition of", 13);
        MUSIC_TYPE = new ProgramFieldType(22, 3, true, "music", "music", "Music", 14);
        MODERATION_TYPE = new ProgramFieldType(23, 3, true, "moderation", "moderation", "Moderation", 15);
        PRODUCTION_YEAR_TYPE = new ProgramFieldType(24, 4, true, "production year", "productionYear", "Production year", 6);
        REPETITION_ON_TYPE = new ProgramFieldType(25, 3, true, "repetition on", "repetitionOn", "Repetition on", 16);
        PICTURE_TYPE = new ProgramFieldType(26, 2, true, "picture", "picture", "Picture", 17);
        PICTURE_COPYRIGHT_TYPE = new ProgramFieldType(27, 3, true, "picture copyright", "pictureCopyright", "Picture copyright", 18);
        PICTURE_DESCRIPTION_TYPE = new ProgramFieldType(28, 3, true, "picture description", "pictureDescription", "Picture description", 19);
        EPISODE_NUMBER_TYPE = new ProgramFieldType(29, 4, true, "number of episode", "episodeNumber", "Number of Episode", 7);
        EPISODE_TOTAL_NUMBER_TYPE = new ProgramFieldType(30, 4, true, "total number of episodes", "episodeNumberTotal", "Total number of Episodes", 8);
        SEASON_NUMBER_TYPE = new ProgramFieldType(31, 4, true, "number of season", "seasonNumber", "Number of Season", 9);
        PRODUCER_TYPE = new ProgramFieldType(32, 3, true, "producer", "producer", "Producer", 20);
        CAMERA_TYPE = new ProgramFieldType(33, 3, true, "camera", "camera", "Camera", 21);
        CUTTER_TYPE = new ProgramFieldType(34, 3, true, "cutter", "cutter", "Cutter", 22);
        ADDITIONAL_PERSONS_TYPE = new ProgramFieldType(35, 3, true, "additional persons", "additionalPersons", "additional persons", 23);
        RATING_TYPE = new ProgramFieldType(36, 4, true, "rating", "rating", "Rating", 10);
        PRODUCTION_COMPANY_TYPE = new ProgramFieldType(37, 3, true, "production company", "productionCompany", "Production company", 24);
        AGE_RATING_TYPE = new ProgramFieldType(38, 3, true, "age rating", "ageRating", "Age rating", 25);
        LAST_PRODUCTION_YEAR_TYPE = new ProgramFieldType(39, 4, true, "last production year", "lastProductionYear", "Last production year", 11);
        ADDITIONAL_INFORMATION_TYPE = new ProgramFieldType(40, 3, true, "additional information", "additionalInformation", "Additional information", 26);
        SERIES_TYPE = new ProgramFieldType(41, 3, true, "series", "series", "Series", 27);
        PART_NUMBER_TYPE = new ProgramFieldType(42, 4, true, "part number", "partNumber", "Part number", 12);
        PART_NUMBER_TOTAL_TYPE = new ProgramFieldType(43, 4, true, "total number of parts", "totalPartNumber", "Total number of parts", 13);
        mNameWasSet = false;
    }
}

