/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.AbstractTvDataService;
import devplugin.ChannelGroup;
import devplugin.Plugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tvbrowser.core.ChannelList;
import tvbrowser.core.ChannelUserSettings;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import util.io.IOUtilities;
import util.misc.StringPool;
import util.ui.ImageUtilities;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;

public class Channel
implements Comparable<Channel> {
    public static final String SEPARATOR = "##SEPARATOR##";
    public static final int CATEGORY_NONE = 0;
    public static final int CATEGORY_TV = 1;
    public static final int CATEGORY_RADIO = 2;
    public static final int CATEGORY_CINEMA = 4;
    public static final int CATEGORY_EVENTS = 8;
    public static final int CATEGORY_DIGITAL = 16;
    public static final int CATEGORY_SPECIAL_MUSIC = 32;
    public static final int CATEGORY_SPECIAL_SPORT = 64;
    public static final int CATEGORY_SPECIAL_NEWS = 128;
    public static final int CATEGORY_SPECIAL_OTHER = 256;
    public static final int CATEGORY_PAY_TV = 512;
    public static final int CATEGORY_PAYED_DATA_TV = 1024;
    private static HashMap<Integer, String> categoryName;
    private static final Localizer mLocalizer;
    private String mDataServiceID;
    private String mName;
    private String mUnescapedName;
    private String mId;
    private TimeZone mTimeZone;
    private String mBaseCountry;
    private String[] mAllCountries;
    private String mCopyrightNotice;
    private String mWebpage;
    private ChannelGroup mGroup;
    private int mCategories;
    private Icon mIcon;
    private Icon mDefaultIcon;
    private TvDataServiceProxy mProxy;
    private String mUniqueId;
    private String mSharedChannelId;
    private Channel mJointChannel;
    private Channel mBaseChannel;
    private Icon mJointChannelIcon;
    private boolean mAccessControl;

    private static final String getDataServiceIDFromDataService(AbstractTvDataService dataService) {
        if (dataService != null) {
            return dataService.getId();
        }
        return null;
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String baseCountry, String copyrightNotice, String webpage, ChannelGroup group, Icon icon, int categories, String unescapedName, String[] allCountries, String sharedChannelId) {
        this(dataService, name, id, timeZone, baseCountry, copyrightNotice, webpage, group, icon, categories, unescapedName, allCountries, sharedChannelId, false);
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String baseCountry, String copyrightNotice, String webpage, ChannelGroup group, Icon icon, int categories, String unescapedName, String[] allCountries, String sharedChannelId, boolean accessControl) {
        this(Channel.getDataServiceIDFromDataService(dataService), name, id, timeZone, baseCountry, copyrightNotice, webpage, group, icon, categories, unescapedName, allCountries, sharedChannelId, accessControl);
    }

    public Channel(String dataServiceID, String name, String id, TimeZone timeZone, String baseCountry, String copyrightNotice, String webpage, ChannelGroup group, Icon icon, int categories, String unescapedName, String[] allCountries, String sharedChannelId, boolean accessControl) {
        if (allCountries != null) {
            for (String testCountry : allCountries) {
                if (testCountry.length() == 2) continue;
                throw new IllegalArgumentException("all contries must be a two character ISO country code (as used in top level domains, e.g. 'de' or 'us'): '" + testCountry + "'");
            }
        }
        if (baseCountry.length() != 2) {
            throw new IllegalArgumentException("country must be a two character ISO country code (as used in top level domains, e.g. 'de' or 'us'): '" + baseCountry + "'");
        }
        this.mDataServiceID = dataServiceID;
        this.mName = name;
        this.mId = id;
        this.mTimeZone = timeZone;
        this.mBaseCountry = StringPool.getString(baseCountry);
        if (allCountries != null) {
            this.mAllCountries = new String[allCountries.length];
            for (int i = 0; i < this.mAllCountries.length; ++i) {
                this.mAllCountries[i] = StringPool.getString(allCountries[i]);
            }
        } else {
            this.mAllCountries = new String[]{this.mBaseCountry};
        }
        if (copyrightNotice != null && copyrightNotice.toLowerCase().startsWith("(c)")) {
            copyrightNotice = "\u00a9" + copyrightNotice.substring(3);
        }
        this.mCopyrightNotice = StringPool.getString(copyrightNotice);
        this.mWebpage = StringPool.getString(webpage);
        this.mGroup = group;
        this.mDefaultIcon = icon;
        this.mCategories = categories;
        this.mUnescapedName = unescapedName;
        this.mSharedChannelId = sharedChannelId;
        this.mAccessControl = false;
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String baseCountry, String copyrightNotice, String webpage, ChannelGroup group, Icon icon, int categories, String unescapedName, String[] allCountries) {
        this(dataService, name, id, timeZone, baseCountry, copyrightNotice, webpage, group, icon, categories, unescapedName, allCountries, null);
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String country, String copyrightNotice, String webpage, ChannelGroup group, Icon icon, int categories, String unescapedName) {
        this(dataService, name, id, timeZone, country, copyrightNotice, webpage, group, icon, categories, unescapedName, null);
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String country, String copyrightNotice, String webpage, ChannelGroup group, Icon icon, int categories) {
        this(dataService, name, id, timeZone, country, copyrightNotice, webpage, group, icon, categories, null);
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String country, String copyrightNotice, String webpage, ChannelGroup group, Icon icon) {
        this(dataService, name, id, timeZone, country, copyrightNotice, webpage, group, icon, 0);
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String country, String copyrightNotice, String webpage, ChannelGroup group) {
        this(dataService, name, id, timeZone, country, copyrightNotice, webpage, group, null);
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String country, String copyrightNotice, String webpage) {
        this(dataService, name, id, timeZone, country, copyrightNotice, webpage, null);
    }

    public Channel(AbstractTvDataService dataService, String name, String id, TimeZone timeZone, String country, String copyrightNotice) {
        this(dataService, name, id, timeZone, country, copyrightNotice, null);
    }

    public Channel(AbstractTvDataService dataService, String name, TimeZone timeZone, String country, String copyrightNotice) {
        this(dataService, name, name, timeZone, country, copyrightNotice, null);
    }

    public Channel(String id, TimeZone timeZone, String country) {
        this(null, id, id, timeZone, country, "(no copyright notice)", null);
    }

    public Channel(String name, String id, String country) {
        this(null, name, id, TimeZone.getDefault(), country, "(no copyright notice)", null);
    }

    public Channel(String id, String country) {
        this(null, id, id, TimeZone.getDefault(), country, "(no copyright notice)", null);
    }

    public static Channel readData(ObjectInputStream in, boolean allowNull) throws IOException, ClassNotFoundException {
        String channelId;
        int version = in.readInt();
        String dataServiceId = null;
        String groupId = null;
        String baseCountry = null;
        if (version == 1) {
            dataServiceId = (String)in.readObject();
            channelId = Integer.toString(in.readInt());
        } else if (version < 3) {
            dataServiceId = (String)in.readObject();
            channelId = (String)in.readObject();
        } else if (version == 3) {
            dataServiceId = in.readUTF();
            groupId = in.readUTF();
            channelId = in.readUTF();
        } else {
            dataServiceId = in.readUTF();
            groupId = in.readUTF();
            baseCountry = in.readUTF();
            channelId = in.readUTF();
        }
        Channel channel = Channel.getChannel(dataServiceId, groupId, baseCountry, channelId);
        if (channel == null && !allowNull) {
            throw new IOException("Channel with id " + channelId + " of data service " + dataServiceId + " not found!");
        }
        return channel;
    }

    public static Channel readData(DataInput in, boolean allowNull) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        Channel channel = null;
        String dataServiceId = null;
        String groupId = null;
        String baseCountry = null;
        String channelId = null;
        if (version < 3) {
            throw new IOException();
        }
        if (version == 3) {
            int length = in.readInt();
            byte[] b = new byte[length];
            in.readFully(b);
            dataServiceId = new String(b);
            length = in.readInt();
            b = new byte[length];
            in.readFully(b);
            channelId = new String(b);
        } else if (version == 4) {
            dataServiceId = in.readUTF();
            groupId = in.readUTF();
            channelId = in.readUTF();
        } else {
            dataServiceId = in.readUTF();
            groupId = in.readUTF();
            baseCountry = in.readUTF();
            channelId = in.readUTF();
        }
        channel = Channel.getChannel(dataServiceId, groupId, baseCountry, channelId);
        if (channel == null && !allowNull) {
            throw new IOException("Channel with id " + channelId + " of data service " + dataServiceId + " not found!");
        }
        return channel;
    }

    public void writeToDataFile(RandomAccessFile out) throws IOException {
        out.writeInt(5);
        out.writeUTF(this.mDataServiceID);
        out.writeUTF(this.getGroup().getId());
        out.writeUTF(this.getBaseCountry());
        out.writeUTF(this.mId);
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(5);
        out.writeUTF(this.mDataServiceID);
        out.writeUTF(this.getGroup().getId());
        out.writeUTF(this.getBaseCountry());
        out.writeUTF(this.mId);
    }

    public String getCopyrightNotice() {
        return this.mCopyrightNotice != null ? this.mCopyrightNotice : "";
    }

    public String getWebpage() {
        if (this.getUserWebPage() != null) {
            return this.getUserWebPage();
        }
        return this.mWebpage;
    }

    public ChannelGroup getGroup() {
        return this.mGroup;
    }

    public int getCategories() {
        return this.mCategories;
    }

    public static Channel getChannel(String dataServiceId, String groupId, String country, String channelId) {
        Channel[] channelArr;
        if (dataServiceId == null) {
            return null;
        }
        for (Channel channel : channelArr = Plugin.getPluginManager().getSubscribedChannels()) {
            String chDataServiceId = channel.getDataServiceId();
            String chGroupId = channel.getGroup().getId();
            String chChannelId = channel.getId();
            String chCountry = channel.getBaseCountry();
            if (dataServiceId.compareTo(chDataServiceId) != 0 || (groupId == null || groupId.compareTo(chGroupId) != 0) && groupId != null || (country == null || country.compareTo(chCountry) != 0) && country != null || channelId.compareTo(chChannelId) != 0) continue;
            return channel;
        }
        return null;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public String getCountry() {
        return this.getBaseCountry();
    }

    public String getBaseCountry() {
        return this.mBaseCountry;
    }

    public String[] getAllCountries() {
        return this.mAllCountries;
    }

    public void setTimeZoneCorrectionMinutes(int minutes) {
        ChannelUserSettings.getSettings(this).setTimeZoneCorrectionMinutes(minutes);
    }

    public int getTimeZoneCorrectionMinutes() {
        return ChannelUserSettings.getSettings(this).getTimeZoneCorrectionMinutes();
    }

    public TvDataServiceProxy getDataServiceProxy() {
        if (this.mDataServiceID != null) {
            if (this.mProxy == null) {
                this.mProxy = TvDataServiceProxyManager.getInstance().findDataServiceById(this.mDataServiceID);
            }
            return this.mProxy;
        }
        return null;
    }

    public void setDefaultIcon(Icon icon) {
        this.mDefaultIcon = icon;
    }

    public void setIcon(Icon icon) {
        this.mIcon = icon;
    }

    public String toString() {
        return (this.getSortNumber().trim().length() > 0 ? this.getSortNumber() + ". " : "") + this.getName();
    }

    public String getName() {
        if (this.getUserChannelName() != null) {
            return this.getUserChannelName();
        }
        return this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public Icon getIcon() {
        Image img;
        if (this.isUsingUserIcon() && this.mIcon == null && this.getUserIconFileName() != null && (img = ImageUtilities.createImageAsynchronous(this.getUserIconFileName())) != null) {
            this.mIcon = new ImageIcon(img);
        }
        if (this.mIcon == null) {
            return this.mDefaultIcon;
        }
        return this.mIcon;
    }

    public boolean hasIcon() {
        if (this.isUsingUserIcon() && this.mIcon == null && this.getUserIconFileName() != null) {
            this.getIcon();
        }
        return this.mIcon != null || this.mDefaultIcon != null;
    }

    public void setUserIconFileName(String filename) {
        ChannelUserSettings.getSettings(this).setIconFileName(filename);
        this.mIcon = null;
    }

    public String getUserIconFileName() {
        return IOUtilities.translateRelativePath(ChannelUserSettings.getSettings(this).getIconFileName());
    }

    public void useUserIcon(boolean use) {
        ChannelUserSettings.getSettings(this).useUserIconFile(use);
    }

    public boolean isUsingUserIcon() {
        return ChannelUserSettings.getSettings(this).useUserIconFile();
    }

    public Icon getDefaultIcon() {
        return this.mDefaultIcon;
    }

    public void setUserChannelName(String name) {
        ChannelUserSettings.getSettings(this).setChannelName(name);
    }

    public String getUserChannelName() {
        return ChannelUserSettings.getSettings(this).getChannelName();
    }

    public String getDefaultName() {
        return this.mName;
    }

    public void setUserWebPage(String url) {
        ChannelUserSettings.getSettings(this).setWebPage(url);
    }

    public String getUserWebPage() {
        return ChannelUserSettings.getSettings(this).getWebPage();
    }

    public String getDefaultWebPage() {
        return this.mWebpage;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Channel) {
            Channel cmp = (Channel)obj;
            if (this.mDataServiceID == null && cmp.getDataServiceProxy() == null && this.getGroup() == null && cmp.getGroup() == null && this.getId().compareTo(cmp.getId()) == 0) {
                return true;
            }
            try {
                String cmpCountry;
                String cmpGroupId;
                String channelId = this.getId();
                String cmpChannelId = cmp.getId();
                if (channelId.compareTo(cmpChannelId) != 0) {
                    return false;
                }
                String groupId = this.getGroup().getId();
                if (groupId.compareTo(cmpGroupId = cmp.getGroup().getId()) != 0) {
                    return false;
                }
                String dataServiceId = this.mDataServiceID;
                String cmpDataServiceId = cmp.getDataServiceId();
                if (dataServiceId.compareTo(cmpDataServiceId) != 0) {
                    return false;
                }
                String country = this.getBaseCountry();
                return country.compareTo(cmpCountry = cmp.getBaseCountry()) == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isTimeLimited() {
        return ChannelUserSettings.getSettings(this).isTimeLimited();
    }

    public int getStartTimeLimit() {
        return ChannelUserSettings.getSettings(this).getStartTimeLimit();
    }

    public void setStartTimeLimit(int startTimeLimit) {
        ChannelUserSettings.getSettings(this).setStartTimeLimit(startTimeLimit);
    }

    public int getEndTimeLimit() {
        return ChannelUserSettings.getSettings(this).getEndTimeLimit();
    }

    public void setEndTimeLimit(int endTimeLimit) {
        ChannelUserSettings.getSettings(this).setEndTimeLimit(endTimeLimit);
    }

    @Override
    public int compareTo(Channel other) {
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public void setChannelName(String name) {
        if (ChannelList.hasCalledChannelValueChangeForChannel(this)) {
            this.mName = name;
        }
    }

    public void setChannelCopyrightNotice(String copyrightNotice) {
        if (ChannelList.hasCalledChannelValueChangeForChannel(this)) {
            this.mCopyrightNotice = copyrightNotice;
        }
    }

    public void setChannelWebpage(String webpage) {
        if (ChannelList.hasCalledChannelValueChangeForChannel(this)) {
            this.mWebpage = webpage;
        }
    }

    public String getUnescapedName() {
        if (this.mUnescapedName != null) {
            return this.mUnescapedName;
        }
        return this.mName;
    }

    public String getUniqueId() {
        if (this.mUniqueId == null) {
            this.mUniqueId = (this.mDataServiceID != null ? this.mDataServiceID : "UnknownDataService") + '_' + (this.getGroup() != null ? this.getGroup().getId() : "UnknownChannelGroup") + '_' + (this.getBaseCountry() != null ? this.getBaseCountry() : "UnknownCountry") + '_' + (this.getId() != null ? this.getId() : "UnknownChannelId");
        }
        return this.mUniqueId;
    }

    public static String getLocalizedCategory(int category) {
        if (categoryName == null) {
            HashMap<Integer, String> catName = new HashMap<Integer, String>(12);
            catName.put(0, mLocalizer.msg("categoryNone", "Not categorized"));
            catName.put(1, mLocalizer.msg("categoryTVAll", "TV"));
            catName.put(2, mLocalizer.msg("categoryRadio", "Radio"));
            catName.put(4, mLocalizer.msg("categoryCinema", "Cinema"));
            catName.put(8, mLocalizer.msg("categoryEvents", "Events"));
            catName.put(16, mLocalizer.msg("categoryDigital", "Digitale"));
            catName.put(32, mLocalizer.msg("categoryMusic", "Musik"));
            catName.put(64, mLocalizer.msg("categorySport", "Sport"));
            catName.put(128, mLocalizer.msg("categoryNews", "Nachrichten"));
            catName.put(256, mLocalizer.msg("categoryOthers", "Sonstige Sparten"));
            catName.put(512, mLocalizer.msg("categoryPayTV", "Pay TV"));
            catName.put(1024, mLocalizer.msg("categoryPayedData", "Payed Data"));
            categoryName = catName;
        }
        return categoryName.get(category);
    }

    public String getDataServicePackageName() {
        return this.mDataServiceID.substring(0, this.mDataServiceID.indexOf("."));
    }

    public String getDataServiceId() {
        return this.mDataServiceID;
    }

    public String getCountriesString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mAllCountries.length; ++i) {
            builder.append(this.mAllCountries[i]);
            if (i >= this.mAllCountries.length - 1) continue;
            builder.append("$");
        }
        return builder.toString();
    }

    public void setJointChannel(Channel ch) {
        if (ch == null && this.mJointChannel != null) {
            this.mJointChannel.mBaseChannel = null;
        }
        this.mJointChannel = ch;
        if (this.mJointChannel != null) {
            this.mJointChannel.mBaseChannel = this;
            this.mJointChannelIcon = new Icon(){

                private Icon getIcon() {
                    Icon icon = Channel.this.getIcon();
                    if (icon == null) {
                        icon = TVBrowserIcons.defaultChannelLogo();
                    }
                    return icon;
                }

                private Icon getJointChannelIcon() {
                    Icon icon = Channel.this.mJointChannel.getIcon();
                    if (icon == null) {
                        icon = TVBrowserIcons.defaultChannelLogo();
                    }
                    return icon;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int y1 = y + this.getIconHeight() / 2 - this.getIcon().getIconHeight() / 2;
                    this.getIcon().paintIcon(c, g, x, y1);
                    g.setColor(Color.black);
                    g.drawLine(x + this.getIcon().getIconWidth() + 3, y, x + this.getIcon().getIconWidth() + 3, this.getIconHeight());
                    g.drawLine(x + this.getIcon().getIconWidth() + 4, y, x + this.getIcon().getIconWidth() + 4, this.getIconHeight());
                    y1 = y + this.getIconHeight() / 2 - this.getJointChannelIcon().getIconHeight() / 2;
                    this.getJointChannelIcon().paintIcon(c, g, x + 7 + this.getIcon().getIconWidth(), y1);
                }

                @Override
                public int getIconWidth() {
                    return this.getIcon().getIconWidth() + this.getJointChannelIcon().getIconWidth() + 7;
                }

                @Override
                public int getIconHeight() {
                    return Math.max(this.getIcon().getIconHeight(), this.getJointChannelIcon().getIconHeight());
                }
            };
        } else {
            this.mJointChannelIcon = null;
        }
    }

    public String getJointChannelName() {
        if (this.mJointChannel != null) {
            return this.getName() + "/" + this.mJointChannel.getName();
        }
        return null;
    }

    public Icon getJointChannelIcon() {
        return this.mJointChannelIcon;
    }

    public Channel getJointChannel() {
        return this.mJointChannel;
    }

    public Channel getBaseChannel() {
        return this.mBaseChannel;
    }

    public String getSharedChannelId() {
        return this.mSharedChannelId;
    }

    public static Channel getChannelForChannel(Channel ch) {
        if (ch.getBaseChannel() != null) {
            return ch.getBaseChannel();
        }
        return ch;
    }

    public String getSortNumber() {
        return ChannelUserSettings.getSettings(this).getSortNumber();
    }

    public void setSortNumber(String number) {
        ChannelUserSettings.getSettings(this).setSortNumber(number);
    }

    public boolean isAccessControl() {
        return this.mAccessControl;
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    static {
        mLocalizer = Localizer.getLocalizerFor(Channel.class);
    }
}

