/*
 * Decompiled with CFR 0.152.
 */
package ca.beq.util.win32.registry;

import ca.beq.util.win32.registry.RegistryException;
import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.ValueType;
import java.io.Serializable;

public class RegistryValue
implements Serializable {
    private static final long serialVersionUID = (class$ca$beq$util$win32$registry$RegistryValue == null ? (class$ca$beq$util$win32$registry$RegistryValue = RegistryValue.class$("ca.beq.util.win32.registry.RegistryValue")) : class$ca$beq$util$win32$registry$RegistryValue).hashCode() * "1.4.5".hashCode();
    String m_name = "";
    ValueType m_type = ValueType.REG_SZ;
    Object m_data = null;
    static /* synthetic */ Class class$ca$beq$util$win32$registry$RegistryValue;

    public RegistryValue() {
    }

    public RegistryValue(Object data) {
        this();
        this.m_data = data;
    }

    public RegistryValue(String name, Object data) {
        this();
        this.m_name = name;
        this.m_data = data;
    }

    public RegistryValue(String name, ValueType type, Object data) {
        this();
        if (type == null) {
            throw new NullPointerException("ValueType cannot be null");
        }
        this.m_name = name;
        this.m_type = type;
        this.m_data = data;
    }

    public RegistryValue(String name, byte[] data) {
        this(name, ValueType.REG_BINARY, data);
    }

    public RegistryValue(String name, boolean data) {
        this(name, ValueType.REG_DWORD, new Boolean(data));
    }

    public RegistryValue(String name, byte data) {
        this(name, ValueType.REG_BINARY, new Byte(data));
    }

    public RegistryValue(String name, int data) {
        this(name, ValueType.REG_DWORD, new Integer(data));
    }

    public RegistryValue(String name, long data) {
        this(name, ValueType.REG_QWORD, new Long(data));
    }

    public RegistryValue(String name, float data) {
        this(name, ValueType.REG_BINARY, new Float(data));
    }

    public RegistryValue(String name, double data) {
        this(name, ValueType.REG_BINARY, new Double(data));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public ValueType getType() {
        return this.m_type;
    }

    public void setType(ValueType type) {
        if (type == null) {
            throw new NullPointerException("ValueType cannot be a null");
        }
        this.m_type = type;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public void setData(byte data) {
        this.setData(new Byte(data));
    }

    public void setData(boolean data) {
        this.setData(new Boolean(data));
    }

    public void setData(int data) {
        this.setData(new Integer(data));
    }

    public void setData(long data) {
        this.setData(new Long(data));
    }

    public void setData(float data) {
        this.setData(new Float(data));
    }

    public void setData(double data) {
        this.setData(new Double(data));
    }

    public boolean equals(RegistryValue other) {
        if (this.m_type != other.getType()) {
            return false;
        }
        if (this.m_type == ValueType.REG_SZ || this.m_type == ValueType.REG_EXPAND_SZ) {
            return this.m_data.toString().equals(other.getData().toString());
        }
        if (this.m_type == ValueType.REG_DWORD_LITTLE_ENDIAN || this.m_type == ValueType.REG_DWORD_BIG_ENDIAN || this.m_type == ValueType.REG_DWORD || this.m_type == ValueType.REG_QWORD) {
            return this.m_data.equals(other.getData());
        }
        if (this.m_type == ValueType.REG_MULTI_SZ) {
            String[] wMyStrings = (String[])this.m_data;
            String[] wOtherStrings = (String[])other.getData();
            if (wMyStrings.length != wOtherStrings.length) {
                return false;
            }
            for (int wCnt = 0; wCnt < wMyStrings.length; ++wCnt) {
                if (wMyStrings[wCnt].equals(wOtherStrings[wCnt])) continue;
                return false;
            }
            return true;
        }
        if (this.m_type == ValueType.REG_NONE || this.m_type == ValueType.REG_BINARY || this.m_type == ValueType.REG_LINK || this.m_type == ValueType.REG_RESOURCE_LIST || this.m_type == ValueType.REG_RESOURCE_REQUIREMENTS_LIST || this.m_type == ValueType.REG_FULL_RESOURCE_DESCRIPTOR) {
            byte[] wMyData = (byte[])this.m_data;
            byte[] wOtherData = (byte[])other.getData();
            if (wMyData.length != wOtherData.length) {
                return false;
            }
            for (int wCnt = 0; wCnt < wMyData.length; ++wCnt) {
                if (wMyData[wCnt] == wOtherData[wCnt]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getStringValue() {
        String stringValue;
        if (this.m_name == null || this.m_data == null) {
            throw new NullPointerException("Neither name nor data may be null");
        }
        if (this.m_type == ValueType.REG_SZ || this.m_type == ValueType.REG_EXPAND_SZ) {
            stringValue = this.m_data.toString();
        } else if (this.m_type == ValueType.REG_DWORD_LITTLE_ENDIAN || this.m_type == ValueType.REG_DWORD_BIG_ENDIAN || this.m_type == ValueType.REG_DWORD) {
            stringValue = ((Integer)this.m_data).toString();
        } else if (this.m_type == ValueType.REG_QWORD) {
            stringValue = ((Long)this.m_data).toString();
        } else if (this.m_type == ValueType.REG_MULTI_SZ) {
            String[] strings = (String[])this.m_data;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < strings.length; ++i) {
                sb.append('\n').append(strings[i]);
            }
            stringValue = sb.toString();
        } else if (this.m_type == ValueType.REG_NONE || this.m_type == ValueType.REG_BINARY || this.m_type == ValueType.REG_LINK || this.m_type == ValueType.REG_RESOURCE_LIST || this.m_type == ValueType.REG_RESOURCE_REQUIREMENTS_LIST || this.m_type == ValueType.REG_FULL_RESOURCE_DESCRIPTOR) {
            StringBuffer sb = new StringBuffer();
            byte[] b = (byte[])this.m_data;
            for (int index = 0; index < b.length; ++index) {
                sb.append(' ').append(Byte.toString(b[index]));
            }
            stringValue = sb.toString();
        } else {
            throw new RegistryException("Unrecognized data type: " + this.m_type);
        }
        return stringValue;
    }

    public String toString() {
        return this.m_name + ':' + this.m_type.toString() + ':' + this.getStringValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            RegistryKey.initialize();
        }
        catch (RegistryException re) {
            re.printStackTrace();
        }
    }
}

